/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagEnd;

public class CompressedStreamTools {
    public static NBTTagCompound func_74796_a(InputStream inputStream) throws IOException {
        try (DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(inputStream)));){
            NBTTagCompound nBTTagCompound = CompressedStreamTools.func_152456_a(dataInputStream, NBTSizeTracker.field_152451_a);
            return nBTTagCompound;
        }
    }

    public static void func_74799_a(NBTTagCompound nBTTagCompound, OutputStream outputStream) throws IOException {
        try (DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(outputStream)));){
            CompressedStreamTools.func_74800_a(nBTTagCompound, dataOutputStream);
        }
    }

    public static void func_74793_a(NBTTagCompound nBTTagCompound, File file) throws IOException {
        \u2603 = new File(file.getAbsolutePath() + "_tmp");
        if (\u2603.exists()) {
            \u2603.delete();
        }
        CompressedStreamTools.func_74795_b(nBTTagCompound, \u2603);
        if (file.exists()) {
            file.delete();
        }
        if (file.exists()) {
            throw new IOException("Failed to delete " + file);
        }
        \u2603.renameTo(file);
    }

    public static void func_74795_b(NBTTagCompound nBTTagCompound, File file) throws IOException {
        try (DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));){
            CompressedStreamTools.func_74800_a(nBTTagCompound, dataOutputStream);
        }
    }

    @Nullable
    public static NBTTagCompound func_74797_a(File file) throws IOException {
        if (!file.exists()) {
            return null;
        }
        try (DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));){
            NBTTagCompound nBTTagCompound = CompressedStreamTools.func_152456_a(dataInputStream, NBTSizeTracker.field_152451_a);
            return nBTTagCompound;
        }
    }

    public static NBTTagCompound func_74794_a(DataInputStream dataInputStream) throws IOException {
        return CompressedStreamTools.func_152456_a(dataInputStream, NBTSizeTracker.field_152451_a);
    }

    public static NBTTagCompound func_152456_a(DataInput dataInput, NBTSizeTracker nBTSizeTracker) throws IOException {
        INBTBase iNBTBase = CompressedStreamTools.func_152455_a(dataInput, 0, nBTSizeTracker);
        if (iNBTBase instanceof NBTTagCompound) {
            return (NBTTagCompound)iNBTBase;
        }
        throw new IOException("Root tag must be a named compound tag");
    }

    public static void func_74800_a(NBTTagCompound nBTTagCompound, DataOutput dataOutput) throws IOException {
        CompressedStreamTools.func_150663_a(nBTTagCompound, dataOutput);
    }

    private static void func_150663_a(INBTBase iNBTBase, DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(iNBTBase.func_74732_a());
        if (iNBTBase.func_74732_a() == 0) {
            return;
        }
        dataOutput.writeUTF("");
        iNBTBase.func_74734_a(dataOutput);
    }

    private static INBTBase func_152455_a(DataInput dataInput, int n, NBTSizeTracker nBTSizeTracker) throws IOException {
        byte by = dataInput.readByte();
        if (by == 0) {
            return new NBTTagEnd();
        }
        dataInput.readUTF();
        INBTBase \u26032 = INBTBase.func_150284_a(by);
        try {
            \u26032.func_152446_a(dataInput, n, nBTSizeTracker);
        }
        catch (IOException \u26033) {
            CrashReport crashReport = CrashReport.func_85055_a(\u26033, "Loading NBT data");
            CrashReportCategory \u26034 = crashReport.func_85058_a("NBT Tag");
            \u26034.func_71507_a("Tag type", by);
            throw new ReportedException(crashReport);
        }
        return \u26032;
    }
}

