/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.google.common.collect.Queues;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.TimeoutException;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.util.Queue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import net.minecraft.network.EnumConnectionState;
import net.minecraft.network.EnumPacketDirection;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NettyCompressionDecoder;
import net.minecraft.network.NettyCompressionEncoder;
import net.minecraft.network.NettyEncryptingDecoder;
import net.minecraft.network.NettyEncryptingEncoder;
import net.minecraft.network.NettyPacketDecoder;
import net.minecraft.network.NettyPacketEncoder;
import net.minecraft.network.NettyVarint21FrameDecoder;
import net.minecraft.network.NettyVarint21FrameEncoder;
import net.minecraft.network.Packet;
import net.minecraft.network.SkipableEncoderException;
import net.minecraft.network.ThreadQuickExitException;
import net.minecraft.network.play.server.SPacketDisconnect;
import net.minecraft.util.CryptManager;
import net.minecraft.util.ITickable;
import net.minecraft.util.LazyLoadBase;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class NetworkManager
extends SimpleChannelInboundHandler<Packet<?>> {
    private static final Logger field_150735_g = LogManager.getLogger();
    public static final Marker field_150740_a = MarkerManager.getMarker((String)"NETWORK");
    public static final Marker field_150738_b = MarkerManager.getMarker((String)"NETWORK_PACKETS", (Marker)field_150740_a);
    public static final AttributeKey<EnumConnectionState> field_150739_c = AttributeKey.valueOf((String)"protocol");
    public static final LazyLoadBase<NioEventLoopGroup> field_179295_d = new LazyLoadBase<NioEventLoopGroup>(() -> new NioEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Client IO #%d").setDaemon(true).build()));
    public static final LazyLoadBase<EpollEventLoopGroup> field_181125_e = new LazyLoadBase<EpollEventLoopGroup>(() -> new EpollEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Epoll Client IO #%d").setDaemon(true).build()));
    public static final LazyLoadBase<DefaultEventLoopGroup> field_179296_e = new LazyLoadBase<DefaultEventLoopGroup>(() -> new DefaultEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Local Client IO #%d").setDaemon(true).build()));
    private final EnumPacketDirection field_179294_g;
    private final Queue<QueuedPacket> field_150745_j = Queues.newConcurrentLinkedQueue();
    private final ReentrantReadWriteLock field_181680_j = new ReentrantReadWriteLock();
    private Channel field_150746_k;
    private SocketAddress field_150743_l;
    private INetHandler field_150744_m;
    private ITextComponent field_150742_o;
    private boolean field_152463_r;
    private boolean field_179297_n;
    private int field_211394_q;
    private int field_211395_r;
    private float field_211396_s;
    private float field_211397_t;
    private int field_211398_u;
    private boolean field_211399_v;

    public NetworkManager(EnumPacketDirection enumPacketDirection) {
        this.field_179294_g = enumPacketDirection;
    }

    public void channelActive(ChannelHandlerContext channelHandlerContext) throws Exception {
        super.channelActive(channelHandlerContext);
        this.field_150746_k = channelHandlerContext.channel();
        this.field_150743_l = this.field_150746_k.remoteAddress();
        try {
            this.func_150723_a(EnumConnectionState.HANDSHAKING);
        }
        catch (Throwable throwable) {
            field_150735_g.fatal((Object)throwable);
        }
    }

    public void func_150723_a(EnumConnectionState enumConnectionState) {
        this.field_150746_k.attr(field_150739_c).set((Object)enumConnectionState);
        this.field_150746_k.config().setAutoRead(true);
        field_150735_g.debug("Enabled auto read");
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.func_150718_a(new TextComponentTranslation("disconnect.endOfStream", new Object[0]));
    }

    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        if (throwable instanceof SkipableEncoderException) {
            field_150735_g.debug("Skipping packet due to errors", throwable.getCause());
            return;
        }
        boolean bl = !this.field_211399_v;
        this.field_211399_v = true;
        if (!this.field_150746_k.isOpen()) {
            return;
        }
        if (throwable instanceof TimeoutException) {
            field_150735_g.debug("Timeout", throwable);
            this.func_150718_a(new TextComponentTranslation("disconnect.timeout", new Object[0]));
        } else {
            TextComponentTranslation textComponentTranslation = new TextComponentTranslation("disconnect.genericReason", "Internal Exception: " + throwable);
            if (bl) {
                field_150735_g.debug("Failed to sent packet", throwable);
                this.func_201058_a(new SPacketDisconnect(textComponentTranslation), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)future -> this.func_150718_a(textComponentTranslation)));
                this.func_150721_g();
            } else {
                field_150735_g.debug("Double fault", throwable);
                this.func_150718_a(textComponentTranslation);
            }
        }
    }

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, Packet<?> packet) throws Exception {
        if (this.field_150746_k.isOpen()) {
            try {
                NetworkManager.func_197664_a(packet, this.field_150744_m);
            }
            catch (ThreadQuickExitException threadQuickExitException) {
                // empty catch block
            }
            ++this.field_211394_q;
        }
    }

    private static <T extends INetHandler> void func_197664_a(Packet<T> packet, INetHandler iNetHandler) {
        packet.func_148833_a(iNetHandler);
    }

    public void func_150719_a(INetHandler iNetHandler) {
        Validate.notNull((Object)iNetHandler, (String)"packetListener", (Object[])new Object[0]);
        field_150735_g.debug("Set listener of {} to {}", (Object)this, (Object)iNetHandler);
        this.field_150744_m = iNetHandler;
    }

    public void func_179290_a(Packet<?> packet) {
        this.func_201058_a(packet, null);
    }

    public void func_201058_a(Packet<?> packet, @Nullable GenericFutureListener<? extends Future<? super Void>> genericFutureListener) {
        if (this.func_150724_d()) {
            this.func_150733_h();
            this.func_150732_b(packet, genericFutureListener);
        } else {
            this.field_181680_j.writeLock().lock();
            try {
                this.field_150745_j.add(new QueuedPacket(packet, genericFutureListener));
            }
            finally {
                this.field_181680_j.writeLock().unlock();
            }
        }
    }

    private void func_150732_b(Packet<?> packet, @Nullable GenericFutureListener<? extends Future<? super Void>> genericFutureListener) {
        EnumConnectionState enumConnectionState = EnumConnectionState.func_150752_a(packet);
        \u2603 = (EnumConnectionState)((Object)this.field_150746_k.attr(field_150739_c).get());
        ++this.field_211395_r;
        if (\u2603 != enumConnectionState) {
            field_150735_g.debug("Disabled auto read");
            this.field_150746_k.config().setAutoRead(false);
        }
        if (this.field_150746_k.eventLoop().inEventLoop()) {
            if (enumConnectionState != \u2603) {
                this.func_150723_a(enumConnectionState);
            }
            ChannelFuture channelFuture = this.field_150746_k.writeAndFlush(packet);
            if (genericFutureListener != null) {
                channelFuture.addListener(genericFutureListener);
            }
            channelFuture.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        } else {
            this.field_150746_k.eventLoop().execute(() -> {
                if (enumConnectionState != \u2603) {
                    this.func_150723_a(enumConnectionState);
                }
                ChannelFuture channelFuture = this.field_150746_k.writeAndFlush((Object)packet);
                if (genericFutureListener != null) {
                    channelFuture.addListener(genericFutureListener);
                }
                channelFuture.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            });
        }
    }

    private void func_150733_h() {
        if (this.field_150746_k == null || !this.field_150746_k.isOpen()) {
            return;
        }
        this.field_181680_j.readLock().lock();
        try {
            while (!this.field_150745_j.isEmpty()) {
                QueuedPacket queuedPacket = this.field_150745_j.poll();
                this.func_150732_b(queuedPacket.field_150774_a, (GenericFutureListener<? extends Future<? super Void>>)queuedPacket.field_201049_b);
            }
        }
        finally {
            this.field_181680_j.readLock().unlock();
        }
    }

    public void func_74428_b() {
        this.func_150733_h();
        if (this.field_150744_m instanceof ITickable) {
            ((ITickable)((Object)this.field_150744_m)).func_73660_a();
        }
        if (this.field_150746_k != null) {
            this.field_150746_k.flush();
        }
        if (this.field_211398_u++ % 20 == 0) {
            this.field_211397_t = this.field_211397_t * 0.75f + (float)this.field_211395_r * 0.25f;
            this.field_211396_s = this.field_211396_s * 0.75f + (float)this.field_211394_q * 0.25f;
            this.field_211395_r = 0;
            this.field_211394_q = 0;
        }
    }

    public SocketAddress func_74430_c() {
        return this.field_150743_l;
    }

    public void func_150718_a(ITextComponent iTextComponent) {
        if (this.field_150746_k.isOpen()) {
            this.field_150746_k.close().awaitUninterruptibly();
            this.field_150742_o = iTextComponent;
        }
    }

    public boolean func_150731_c() {
        return this.field_150746_k instanceof LocalChannel || this.field_150746_k instanceof LocalServerChannel;
    }

    public static NetworkManager func_181124_a(InetAddress inetAddress, int n, boolean bl) {
        LazyLoadBase<NioEventLoopGroup> \u26032;
        final NetworkManager networkManager = new NetworkManager(EnumPacketDirection.CLIENTBOUND);
        if (Epoll.isAvailable() && bl) {
            Class<NioSocketChannel> clazz = EpollSocketChannel.class;
            \u26032 = field_181125_e;
        } else {
            clazz = NioSocketChannel.class;
            \u26032 = field_179295_d;
        }
        ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)\u26032.func_179281_c())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) throws Exception {
                try {
                    channel.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                }
                catch (ChannelException channelException) {
                    // empty catch block
                }
                channel.pipeline().addLast("timeout", (ChannelHandler)new ReadTimeoutHandler(30)).addLast("splitter", (ChannelHandler)new NettyVarint21FrameDecoder()).addLast("decoder", (ChannelHandler)new NettyPacketDecoder(EnumPacketDirection.CLIENTBOUND)).addLast("prepender", (ChannelHandler)new NettyVarint21FrameEncoder()).addLast("encoder", (ChannelHandler)new NettyPacketEncoder(EnumPacketDirection.SERVERBOUND)).addLast("packet_handler", (ChannelHandler)networkManager);
            }
        })).channel(clazz)).connect(inetAddress, n).syncUninterruptibly();
        return networkManager;
    }

    public static NetworkManager func_150722_a(SocketAddress socketAddress) {
        final NetworkManager networkManager = new NetworkManager(EnumPacketDirection.CLIENTBOUND);
        ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)field_179296_e.func_179281_c())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) throws Exception {
                channel.pipeline().addLast("packet_handler", (ChannelHandler)networkManager);
            }
        })).channel(LocalChannel.class)).connect(socketAddress).syncUninterruptibly();
        return networkManager;
    }

    public void func_150727_a(SecretKey secretKey) {
        this.field_152463_r = true;
        this.field_150746_k.pipeline().addBefore("splitter", "decrypt", (ChannelHandler)new NettyEncryptingDecoder(CryptManager.func_151229_a(2, secretKey)));
        this.field_150746_k.pipeline().addBefore("prepender", "encrypt", (ChannelHandler)new NettyEncryptingEncoder(CryptManager.func_151229_a(1, secretKey)));
    }

    public boolean func_179292_f() {
        return this.field_152463_r;
    }

    public boolean func_150724_d() {
        return this.field_150746_k != null && this.field_150746_k.isOpen();
    }

    public boolean func_179291_h() {
        return this.field_150746_k == null;
    }

    public INetHandler func_150729_e() {
        return this.field_150744_m;
    }

    @Nullable
    public ITextComponent func_150730_f() {
        return this.field_150742_o;
    }

    public void func_150721_g() {
        this.field_150746_k.config().setAutoRead(false);
    }

    public void func_179289_a(int n) {
        if (n >= 0) {
            if (this.field_150746_k.pipeline().get("decompress") instanceof NettyCompressionDecoder) {
                ((NettyCompressionDecoder)this.field_150746_k.pipeline().get("decompress")).func_179303_a(n);
            } else {
                this.field_150746_k.pipeline().addBefore("decoder", "decompress", (ChannelHandler)new NettyCompressionDecoder(n));
            }
            if (this.field_150746_k.pipeline().get("compress") instanceof NettyCompressionEncoder) {
                ((NettyCompressionEncoder)this.field_150746_k.pipeline().get("compress")).func_179299_a(n);
            } else {
                this.field_150746_k.pipeline().addBefore("encoder", "compress", (ChannelHandler)new NettyCompressionEncoder(n));
            }
        } else {
            if (this.field_150746_k.pipeline().get("decompress") instanceof NettyCompressionDecoder) {
                this.field_150746_k.pipeline().remove("decompress");
            }
            if (this.field_150746_k.pipeline().get("compress") instanceof NettyCompressionEncoder) {
                this.field_150746_k.pipeline().remove("compress");
            }
        }
    }

    public void func_179293_l() {
        if (this.field_150746_k == null || this.field_150746_k.isOpen()) {
            return;
        }
        if (this.field_179297_n) {
            field_150735_g.warn("handleDisconnection() called twice");
        } else {
            this.field_179297_n = true;
            if (this.func_150730_f() != null) {
                this.func_150729_e().func_147231_a(this.func_150730_f());
            } else if (this.func_150729_e() != null) {
                this.func_150729_e().func_147231_a(new TextComponentTranslation("multiplayer.disconnect.generic", new Object[0]));
            }
        }
    }

    public float func_211393_m() {
        return this.field_211396_s;
    }

    public float func_211390_n() {
        return this.field_211397_t;
    }

    protected /* synthetic */ void channelRead0(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        this.channelRead0(channelHandlerContext, (Packet)object);
    }

    static class QueuedPacket {
        private final Packet<?> field_150774_a;
        @Nullable
        private final GenericFutureListener<? extends Future<? super Void>> field_201049_b;

        public QueuedPacket(Packet<?> packet, @Nullable GenericFutureListener<? extends Future<? super Void>> genericFutureListener) {
            this.field_150774_a = packet;
            this.field_201049_b = genericFutureListener;
        }
    }
}

