/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.datasync;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IntIdentityHashBiMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.ITextComponent;

public class DataSerializers {
    private static final IntIdentityHashBiMap<DataSerializer<?>> field_187204_n = new IntIdentityHashBiMap(16);
    public static final DataSerializer<Byte> field_187191_a = new DataSerializer<Byte>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, Byte by) {
            packetBuffer.writeByte(by.byteValue());
        }

        @Override
        public Byte func_187159_a(PacketBuffer packetBuffer) {
            return packetBuffer.readByte();
        }

        @Override
        public DataParameter<Byte> func_187161_a(int n) {
            return new DataParameter<Byte>(n, this);
        }

        @Override
        public Byte func_192717_a(Byte by) {
            return by;
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };
    public static final DataSerializer<Integer> field_187192_b = new DataSerializer<Integer>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, Integer n) {
            packetBuffer.func_150787_b(n);
        }

        @Override
        public Integer func_187159_a(PacketBuffer packetBuffer) {
            return packetBuffer.func_150792_a();
        }

        @Override
        public DataParameter<Integer> func_187161_a(int n) {
            return new DataParameter<Integer>(n, this);
        }

        @Override
        public Integer func_192717_a(Integer n) {
            return n;
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };
    public static final DataSerializer<Float> field_187193_c = new DataSerializer<Float>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, Float f) {
            packetBuffer.writeFloat(f.floatValue());
        }

        @Override
        public Float func_187159_a(PacketBuffer packetBuffer) {
            return Float.valueOf(packetBuffer.readFloat());
        }

        @Override
        public DataParameter<Float> func_187161_a(int n) {
            return new DataParameter<Float>(n, this);
        }

        @Override
        public Float func_192717_a(Float f) {
            return f;
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };
    public static final DataSerializer<String> field_187194_d = new DataSerializer<String>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, String string) {
            packetBuffer.func_180714_a(string);
        }

        @Override
        public String func_187159_a(PacketBuffer packetBuffer) {
            return packetBuffer.func_150789_c(Short.MAX_VALUE);
        }

        @Override
        public DataParameter<String> func_187161_a(int n) {
            return new DataParameter<String>(n, this);
        }

        @Override
        public String func_192717_a(String string) {
            return string;
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };
    public static final DataSerializer<ITextComponent> field_187195_e = new DataSerializer<ITextComponent>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, ITextComponent iTextComponent) {
            packetBuffer.func_179256_a(iTextComponent);
        }

        @Override
        public ITextComponent func_187159_a(PacketBuffer packetBuffer) {
            return packetBuffer.func_179258_d();
        }

        @Override
        public DataParameter<ITextComponent> func_187161_a(int n) {
            return new DataParameter<ITextComponent>(n, this);
        }

        @Override
        public ITextComponent func_192717_a(ITextComponent iTextComponent) {
            return iTextComponent.func_212638_h();
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };
    public static final DataSerializer<Optional<ITextComponent>> field_200544_f = new DataSerializer<Optional<ITextComponent>>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, Optional<ITextComponent> optional) {
            if (optional.isPresent()) {
                packetBuffer.writeBoolean(true);
                packetBuffer.func_179256_a(optional.get());
            } else {
                packetBuffer.writeBoolean(false);
            }
        }

        @Override
        public Optional<ITextComponent> func_187159_a(PacketBuffer packetBuffer) {
            return packetBuffer.readBoolean() ? Optional.of(packetBuffer.func_179258_d()) : Optional.empty();
        }

        @Override
        public DataParameter<Optional<ITextComponent>> func_187161_a(int n) {
            return new DataParameter<Optional<ITextComponent>>(n, this);
        }

        @Override
        public Optional<ITextComponent> func_192717_a(Optional<ITextComponent> optional) {
            return optional.isPresent() ? Optional.of(optional.get().func_212638_h()) : Optional.empty();
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };
    public static final DataSerializer<ItemStack> field_187196_f = new DataSerializer<ItemStack>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, ItemStack itemStack) {
            packetBuffer.func_150788_a(itemStack);
        }

        @Override
        public ItemStack func_187159_a(PacketBuffer packetBuffer) {
            return packetBuffer.func_150791_c();
        }

        @Override
        public DataParameter<ItemStack> func_187161_a(int n) {
            return new DataParameter<ItemStack>(n, this);
        }

        @Override
        public ItemStack func_192717_a(ItemStack itemStack) {
            return itemStack.func_77946_l();
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };
    public static final DataSerializer<Optional<IBlockState>> field_187197_g = new DataSerializer<Optional<IBlockState>>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, Optional<IBlockState> optional) {
            if (optional.isPresent()) {
                packetBuffer.func_150787_b(Block.func_196246_j(optional.get()));
            } else {
                packetBuffer.func_150787_b(0);
            }
        }

        @Override
        public Optional<IBlockState> func_187159_a(PacketBuffer packetBuffer) {
            int n = packetBuffer.func_150792_a();
            if (n == 0) {
                return Optional.empty();
            }
            return Optional.of(Block.func_196257_b(n));
        }

        @Override
        public DataParameter<Optional<IBlockState>> func_187161_a(int n) {
            return new DataParameter<Optional<IBlockState>>(n, this);
        }

        @Override
        public Optional<IBlockState> func_192717_a(Optional<IBlockState> optional) {
            return optional;
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };
    public static final DataSerializer<Boolean> field_187198_h = new DataSerializer<Boolean>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, Boolean bl) {
            packetBuffer.writeBoolean(bl);
        }

        @Override
        public Boolean func_187159_a(PacketBuffer packetBuffer) {
            return packetBuffer.readBoolean();
        }

        @Override
        public DataParameter<Boolean> func_187161_a(int n) {
            return new DataParameter<Boolean>(n, this);
        }

        @Override
        public Boolean func_192717_a(Boolean bl) {
            return bl;
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };
    public static final DataSerializer<IParticleData> field_198166_i = new DataSerializer<IParticleData>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, IParticleData iParticleData) {
            packetBuffer.func_150787_b(IRegistry.field_212632_u.func_148757_b(iParticleData.func_197554_b()));
            iParticleData.func_197553_a(packetBuffer);
        }

        @Override
        public IParticleData func_187159_a(PacketBuffer packetBuffer) {
            return this.func_200543_a(packetBuffer, IRegistry.field_212632_u.func_148754_a(packetBuffer.func_150792_a()));
        }

        private <T extends IParticleData> T func_200543_a(PacketBuffer packetBuffer, ParticleType<T> particleType) {
            return particleType.func_197571_g().func_197543_b(particleType, packetBuffer);
        }

        @Override
        public DataParameter<IParticleData> func_187161_a(int n) {
            return new DataParameter<IParticleData>(n, this);
        }

        @Override
        public IParticleData func_192717_a(IParticleData iParticleData) {
            return iParticleData;
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };
    public static final DataSerializer<Rotations> field_187199_i = new DataSerializer<Rotations>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, Rotations rotations) {
            packetBuffer.writeFloat(rotations.func_179415_b());
            packetBuffer.writeFloat(rotations.func_179416_c());
            packetBuffer.writeFloat(rotations.func_179413_d());
        }

        @Override
        public Rotations func_187159_a(PacketBuffer packetBuffer) {
            return new Rotations(packetBuffer.readFloat(), packetBuffer.readFloat(), packetBuffer.readFloat());
        }

        @Override
        public DataParameter<Rotations> func_187161_a(int n) {
            return new DataParameter<Rotations>(n, this);
        }

        @Override
        public Rotations func_192717_a(Rotations rotations) {
            return rotations;
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };
    public static final DataSerializer<BlockPos> field_187200_j = new DataSerializer<BlockPos>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, BlockPos blockPos) {
            packetBuffer.func_179255_a(blockPos);
        }

        @Override
        public BlockPos func_187159_a(PacketBuffer packetBuffer) {
            return packetBuffer.func_179259_c();
        }

        @Override
        public DataParameter<BlockPos> func_187161_a(int n) {
            return new DataParameter<BlockPos>(n, this);
        }

        @Override
        public BlockPos func_192717_a(BlockPos blockPos) {
            return blockPos;
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };
    public static final DataSerializer<Optional<BlockPos>> field_187201_k = new DataSerializer<Optional<BlockPos>>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, Optional<BlockPos> optional) {
            packetBuffer.writeBoolean(optional.isPresent());
            if (optional.isPresent()) {
                packetBuffer.func_179255_a(optional.get());
            }
        }

        @Override
        public Optional<BlockPos> func_187159_a(PacketBuffer packetBuffer) {
            if (!packetBuffer.readBoolean()) {
                return Optional.empty();
            }
            return Optional.of(packetBuffer.func_179259_c());
        }

        @Override
        public DataParameter<Optional<BlockPos>> func_187161_a(int n) {
            return new DataParameter<Optional<BlockPos>>(n, this);
        }

        @Override
        public Optional<BlockPos> func_192717_a(Optional<BlockPos> optional) {
            return optional;
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };
    public static final DataSerializer<EnumFacing> field_187202_l = new DataSerializer<EnumFacing>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, EnumFacing enumFacing) {
            packetBuffer.func_179249_a(enumFacing);
        }

        @Override
        public EnumFacing func_187159_a(PacketBuffer packetBuffer) {
            return packetBuffer.func_179257_a(EnumFacing.class);
        }

        @Override
        public DataParameter<EnumFacing> func_187161_a(int n) {
            return new DataParameter<EnumFacing>(n, this);
        }

        @Override
        public EnumFacing func_192717_a(EnumFacing enumFacing) {
            return enumFacing;
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };
    public static final DataSerializer<Optional<UUID>> field_187203_m = new DataSerializer<Optional<UUID>>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, Optional<UUID> optional) {
            packetBuffer.writeBoolean(optional.isPresent());
            if (optional.isPresent()) {
                packetBuffer.func_179252_a(optional.get());
            }
        }

        @Override
        public Optional<UUID> func_187159_a(PacketBuffer packetBuffer) {
            if (!packetBuffer.readBoolean()) {
                return Optional.empty();
            }
            return Optional.of(packetBuffer.func_179253_g());
        }

        @Override
        public DataParameter<Optional<UUID>> func_187161_a(int n) {
            return new DataParameter<Optional<UUID>>(n, this);
        }

        @Override
        public Optional<UUID> func_192717_a(Optional<UUID> optional) {
            return optional;
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };
    public static final DataSerializer<NBTTagCompound> field_192734_n = new DataSerializer<NBTTagCompound>(){

        @Override
        public void func_187160_a(PacketBuffer packetBuffer, NBTTagCompound nBTTagCompound) {
            packetBuffer.func_150786_a(nBTTagCompound);
        }

        @Override
        public NBTTagCompound func_187159_a(PacketBuffer packetBuffer) {
            return packetBuffer.func_150793_b();
        }

        @Override
        public DataParameter<NBTTagCompound> func_187161_a(int n) {
            return new DataParameter<NBTTagCompound>(n, this);
        }

        @Override
        public NBTTagCompound func_192717_a(NBTTagCompound nBTTagCompound) {
            return nBTTagCompound.func_74737_b();
        }

        @Override
        public /* synthetic */ Object func_187159_a(PacketBuffer packetBuffer) {
            return this.func_187159_a(packetBuffer);
        }
    };

    public static void func_187189_a(DataSerializer<?> dataSerializer) {
        field_187204_n.func_186808_c(dataSerializer);
    }

    @Nullable
    public static DataSerializer<?> func_187190_a(int n) {
        return field_187204_n.func_186813_a(n);
    }

    public static int func_187188_b(DataSerializer<?> dataSerializer) {
        return field_187204_n.func_186815_a(dataSerializer);
    }

    static {
        DataSerializers.func_187189_a(field_187191_a);
        DataSerializers.func_187189_a(field_187192_b);
        DataSerializers.func_187189_a(field_187193_c);
        DataSerializers.func_187189_a(field_187194_d);
        DataSerializers.func_187189_a(field_187195_e);
        DataSerializers.func_187189_a(field_200544_f);
        DataSerializers.func_187189_a(field_187196_f);
        DataSerializers.func_187189_a(field_187198_h);
        DataSerializers.func_187189_a(field_187199_i);
        DataSerializers.func_187189_a(field_187200_j);
        DataSerializers.func_187189_a(field_187201_k);
        DataSerializers.func_187189_a(field_187202_l);
        DataSerializers.func_187189_a(field_187203_m);
        DataSerializers.func_187189_a(field_187197_g);
        DataSerializers.func_187189_a(field_192734_n);
        DataSerializers.func_187189_a(field_198166_i);
    }
}

