/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;

public class SPacketChunkData
implements Packet<INetHandlerPlayClient> {
    private int field_149284_a;
    private int field_149282_b;
    private int field_186948_c;
    private byte[] field_186949_d;
    private List<NBTTagCompound> field_189557_e;
    private boolean field_149279_g;

    public SPacketChunkData() {
    }

    public SPacketChunkData(Chunk chunk, int n) {
        this.field_149284_a = chunk.field_76635_g;
        this.field_149282_b = chunk.field_76647_h;
        this.field_149279_g = n == 65535;
        boolean bl = chunk.func_177412_p().field_73011_w.func_191066_m();
        this.field_186949_d = new byte[this.func_189556_a(chunk, bl, n)];
        this.field_186948_c = this.func_189555_a(new PacketBuffer(this.func_186945_f()), chunk, bl, n);
        this.field_189557_e = Lists.newArrayList();
        for (Map.Entry<BlockPos, TileEntity> entry : chunk.func_177434_r().entrySet()) {
            BlockPos blockPos = entry.getKey();
            TileEntity \u26032 = entry.getValue();
            int \u26033 = blockPos.func_177956_o() >> 4;
            if (!this.func_149274_i() && (n & 1 << \u26033) == 0) continue;
            NBTTagCompound \u26034 = \u26032.func_189517_E_();
            this.field_189557_e.add(\u26034);
        }
    }

    @Override
    public void func_148837_a(PacketBuffer packetBuffer) throws IOException {
        this.field_149284_a = packetBuffer.readInt();
        this.field_149282_b = packetBuffer.readInt();
        this.field_149279_g = packetBuffer.readBoolean();
        this.field_186948_c = packetBuffer.func_150792_a();
        int n = packetBuffer.func_150792_a();
        if (n > 0x200000) {
            throw new RuntimeException("Chunk Packet trying to allocate too much memory on read.");
        }
        this.field_186949_d = new byte[n];
        packetBuffer.readBytes(this.field_186949_d);
        \u2603 = packetBuffer.func_150792_a();
        this.field_189557_e = Lists.newArrayList();
        for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
            this.field_189557_e.add(packetBuffer.func_150793_b());
        }
    }

    @Override
    public void func_148840_b(PacketBuffer packetBuffer) throws IOException {
        packetBuffer.writeInt(this.field_149284_a);
        packetBuffer.writeInt(this.field_149282_b);
        packetBuffer.writeBoolean(this.field_149279_g);
        packetBuffer.func_150787_b(this.field_186948_c);
        packetBuffer.func_150787_b(this.field_186949_d.length);
        packetBuffer.writeBytes(this.field_186949_d);
        packetBuffer.func_150787_b(this.field_189557_e.size());
        for (NBTTagCompound nBTTagCompound : this.field_189557_e) {
            packetBuffer.func_150786_a(nBTTagCompound);
        }
    }

    @Override
    public void func_148833_a(INetHandlerPlayClient iNetHandlerPlayClient) {
        iNetHandlerPlayClient.func_147263_a(this);
    }

    public PacketBuffer func_186946_a() {
        return new PacketBuffer(Unpooled.wrappedBuffer((byte[])this.field_186949_d));
    }

    private ByteBuf func_186945_f() {
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])this.field_186949_d);
        byteBuf.writerIndex(0);
        return byteBuf;
    }

    public int func_189555_a(PacketBuffer packetBuffer, Chunk chunk2, boolean bl, int n) {
        \u2603 = 0;
        ChunkSection[] chunkSectionArray = chunk2.func_76587_i();
        int \u26032 = chunkSectionArray.length;
        for (int i = 0; i < \u26032; ++i) {
            ChunkSection chunkSection = chunkSectionArray[i];
            if (chunkSection == Chunk.field_186036_a || this.func_149274_i() && chunkSection.func_76663_a() || (n & 1 << i) == 0) continue;
            \u2603 |= 1 << i;
            chunkSection.func_186049_g().func_186009_b(packetBuffer);
            packetBuffer.writeBytes(chunkSection.func_76661_k().func_177481_a());
            if (!bl) continue;
            packetBuffer.writeBytes(chunkSection.func_76671_l().func_177481_a());
        }
        if (this.func_149274_i()) {
            Chunk chunk2;
            Biome[] \u26033 = chunk2.func_201590_e();
            for (\u26032 = 0; \u26032 < \u26033.length; ++\u26032) {
                packetBuffer.writeInt(IRegistry.field_212624_m.func_148757_b(\u26033[\u26032]));
            }
        }
        return \u2603;
    }

    protected int func_189556_a(Chunk chunk2, boolean bl, int n) {
        int n2;
        n2 = 0;
        ChunkSection[] chunkSectionArray = chunk2.func_76587_i();
        int \u26032 = chunkSectionArray.length;
        for (int i = 0; i < \u26032; ++i) {
            ChunkSection chunkSection = chunkSectionArray[i];
            if (chunkSection == Chunk.field_186036_a || this.func_149274_i() && chunkSection.func_76663_a() || (n & 1 << i) == 0) continue;
            n2 += chunkSection.func_186049_g().func_186018_a();
            n2 += chunkSection.func_76661_k().func_177481_a().length;
            if (!bl) continue;
            n2 += chunkSection.func_76671_l().func_177481_a().length;
        }
        if (this.func_149274_i()) {
            Chunk chunk2;
            n2 += chunk2.func_201590_e().length * 4;
        }
        return n2;
    }

    public int func_149273_e() {
        return this.field_149284_a;
    }

    public int func_149271_f() {
        return this.field_149282_b;
    }

    public int func_149276_g() {
        return this.field_186948_c;
    }

    public boolean func_149274_i() {
        return this.field_149279_g;
    }

    public List<NBTTagCompound> func_189554_f() {
        return this.field_189557_e;
    }
}

