/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.rcon;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.network.rcon.IServer;
import net.minecraft.network.rcon.RConThreadBase;
import net.minecraft.network.rcon.RConThreadClient;

public class RConThreadMain
extends RConThreadBase {
    private int field_72647_g;
    private final int field_72651_h;
    private String field_72652_i;
    private ServerSocket field_72649_j;
    private final String field_72650_k;
    private Map<SocketAddress, RConThreadClient> field_72648_l;

    public RConThreadMain(IServer iServer) {
        super(iServer, "RCON Listener");
        this.field_72647_g = iServer.func_71327_a("rcon.port", 0);
        this.field_72650_k = iServer.func_71330_a("rcon.password", "");
        this.field_72652_i = iServer.func_71277_t();
        this.field_72651_h = iServer.func_71234_u();
        if (0 == this.field_72647_g) {
            this.field_72647_g = this.field_72651_h + 10;
            this.func_72609_b("Setting default rcon port to " + this.field_72647_g);
            iServer.func_71328_a("rcon.port", this.field_72647_g);
            if (this.field_72650_k.isEmpty()) {
                iServer.func_71328_a("rcon.password", "");
            }
            iServer.func_71326_a();
        }
        if (this.field_72652_i.isEmpty()) {
            this.field_72652_i = "0.0.0.0";
        }
        this.func_72646_f();
        this.field_72649_j = null;
    }

    private void func_72646_f() {
        this.field_72648_l = Maps.newHashMap();
    }

    private void func_72645_g() {
        Iterator<Map.Entry<SocketAddress, RConThreadClient>> iterator = this.field_72648_l.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<SocketAddress, RConThreadClient> entry = iterator.next();
            if (entry.getValue().func_72613_c()) continue;
            iterator.remove();
        }
    }

    @Override
    public void run() {
        this.func_72609_b("RCON running on " + this.field_72652_i + ":" + this.field_72647_g);
        try {
            while (this.field_72619_a) {
                try {
                    Socket socket = this.field_72649_j.accept();
                    socket.setSoTimeout(500);
                    RConThreadClient \u26032 = new RConThreadClient(this.field_72617_b, socket);
                    \u26032.func_72602_a();
                    this.field_72648_l.put(socket.getRemoteSocketAddress(), \u26032);
                    this.func_72645_g();
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    this.func_72645_g();
                }
                catch (IOException iOException) {
                    if (!this.field_72619_a) continue;
                    this.func_72609_b("IO: " + iOException.getMessage());
                }
            }
        }
        finally {
            this.func_72608_b(this.field_72649_j);
        }
    }

    @Override
    public void func_72602_a() {
        if (this.field_72650_k.isEmpty()) {
            this.func_72606_c("No rcon password set in '" + this.field_72617_b.func_71329_c() + "', rcon disabled!");
            return;
        }
        if (0 >= this.field_72647_g || 65535 < this.field_72647_g) {
            this.func_72606_c("Invalid rcon port " + this.field_72647_g + " found in '" + this.field_72617_b.func_71329_c() + "', rcon disabled!");
            return;
        }
        if (this.field_72619_a) {
            return;
        }
        try {
            this.field_72649_j = new ServerSocket(this.field_72647_g, 0, InetAddress.getByName(this.field_72652_i));
            this.field_72649_j.setSoTimeout(500);
            super.func_72602_a();
        }
        catch (IOException iOException) {
            this.func_72606_c("Unable to initialise rcon on " + this.field_72652_i + ":" + this.field_72647_g + " : " + iOException.getMessage());
        }
    }
}

