/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.potion;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class PotionUtils {
    public static List<PotionEffect> func_185189_a(ItemStack itemStack) {
        return PotionUtils.func_185185_a(itemStack.func_77978_p());
    }

    public static List<PotionEffect> func_185186_a(PotionType potionType, Collection<PotionEffect> collection) {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.addAll(potionType.func_185170_a());
        arrayList.addAll(collection);
        return arrayList;
    }

    public static List<PotionEffect> func_185185_a(@Nullable NBTTagCompound nBTTagCompound) {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.addAll(PotionUtils.func_185187_c(nBTTagCompound).func_185170_a());
        PotionUtils.func_185193_a(nBTTagCompound, arrayList);
        return arrayList;
    }

    public static List<PotionEffect> func_185190_b(ItemStack itemStack) {
        return PotionUtils.func_185192_b(itemStack.func_77978_p());
    }

    public static List<PotionEffect> func_185192_b(@Nullable NBTTagCompound nBTTagCompound) {
        ArrayList arrayList = Lists.newArrayList();
        PotionUtils.func_185193_a(nBTTagCompound, arrayList);
        return arrayList;
    }

    public static void func_185193_a(@Nullable NBTTagCompound nBTTagCompound, List<PotionEffect> list) {
        if (nBTTagCompound != null && nBTTagCompound.func_150297_b("CustomPotionEffects", 9)) {
            NBTTagList nBTTagList = nBTTagCompound.func_150295_c("CustomPotionEffects", 10);
            for (int i = 0; i < nBTTagList.size(); ++i) {
                NBTTagCompound nBTTagCompound2 = nBTTagList.func_150305_b(i);
                PotionEffect \u26032 = PotionEffect.func_82722_b(nBTTagCompound2);
                if (\u26032 == null) continue;
                list.add(\u26032);
            }
        }
    }

    public static int func_190932_c(ItemStack itemStack) {
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        if (nBTTagCompound != null && nBTTagCompound.func_150297_b("CustomPotionColor", 99)) {
            return nBTTagCompound.func_74762_e("CustomPotionColor");
        }
        return PotionUtils.func_185191_c(itemStack) == PotionTypes.field_185229_a ? 0xF800F8 : PotionUtils.func_185181_a(PotionUtils.func_185189_a(itemStack));
    }

    public static int func_185183_a(PotionType potionType) {
        return potionType == PotionTypes.field_185229_a ? 0xF800F8 : PotionUtils.func_185181_a(potionType.func_185170_a());
    }

    public static int func_185181_a(Collection<PotionEffect> collection) {
        int n;
        int n2 = 3694022;
        if (collection.isEmpty()) {
            return 3694022;
        }
        float \u26032 = 0.0f;
        float \u26033 = 0.0f;
        float \u26034 = 0.0f;
        n = 0;
        for (PotionEffect potionEffect : collection) {
            if (!potionEffect.func_188418_e()) continue;
            int n3 = potionEffect.func_188419_a().func_76401_j();
            \u2603 = potionEffect.func_76458_c() + 1;
            \u26032 += (float)(\u2603 * (n3 >> 16 & 0xFF)) / 255.0f;
            \u26033 += (float)(\u2603 * (n3 >> 8 & 0xFF)) / 255.0f;
            \u26034 += (float)(\u2603 * (n3 >> 0 & 0xFF)) / 255.0f;
            n += \u2603;
        }
        if (n == 0) {
            return 0;
        }
        \u26032 = \u26032 / (float)n * 255.0f;
        \u26033 = \u26033 / (float)n * 255.0f;
        \u26034 = \u26034 / (float)n * 255.0f;
        return (int)\u26032 << 16 | (int)\u26033 << 8 | (int)\u26034;
    }

    public static PotionType func_185191_c(ItemStack itemStack) {
        return PotionUtils.func_185187_c(itemStack.func_77978_p());
    }

    public static PotionType func_185187_c(@Nullable NBTTagCompound nBTTagCompound) {
        if (nBTTagCompound == null) {
            return PotionTypes.field_185229_a;
        }
        return PotionType.func_185168_a(nBTTagCompound.func_74779_i("Potion"));
    }

    public static ItemStack func_185188_a(ItemStack itemStack, PotionType potionType) {
        ResourceLocation resourceLocation = IRegistry.field_212621_j.func_177774_c(potionType);
        if (potionType == PotionTypes.field_185229_a) {
            itemStack.func_196083_e("Potion");
        } else {
            itemStack.func_196082_o().func_74778_a("Potion", resourceLocation.toString());
        }
        return itemStack;
    }

    public static ItemStack func_185184_a(ItemStack itemStack, Collection<PotionEffect> collection) {
        if (collection.isEmpty()) {
            return itemStack;
        }
        NBTTagCompound nBTTagCompound = itemStack.func_196082_o();
        NBTTagList \u26032 = nBTTagCompound.func_150295_c("CustomPotionEffects", 9);
        for (PotionEffect potionEffect : collection) {
            \u26032.add(potionEffect.func_82719_a(new NBTTagCompound()));
        }
        nBTTagCompound.func_74782_a("CustomPotionEffects", \u26032);
        return itemStack;
    }

    public static void func_185182_a(ItemStack itemStack, List<ITextComponent> list3, float f) {
        Object object;
        List<PotionEffect> list2 = PotionUtils.func_185189_a(itemStack);
        ArrayList \u26032 = Lists.newArrayList();
        if (list2.isEmpty()) {
            list3.add(new TextComponentTranslation("effect.none", new Object[0]).func_211708_a(TextFormatting.GRAY));
        } else {
            for (PotionEffect potionEffect : list2) {
                object = new TextComponentTranslation(potionEffect.func_76453_d(), new Object[0]);
                Potion potion = potionEffect.func_188419_a();
                Map<IAttribute, AttributeModifier> \u26033 = potion.func_111186_k();
                if (!\u26033.isEmpty()) {
                    for (Map.Entry<IAttribute, AttributeModifier> entry : \u26033.entrySet()) {
                        AttributeModifier attributeModifier = entry.getValue();
                        AttributeModifier attributeModifier2 = new AttributeModifier(attributeModifier.func_111166_b(), potion.func_111183_a(potionEffect.func_76458_c(), attributeModifier), attributeModifier.func_111169_c());
                        \u26032.add(new Tuple<String, AttributeModifier>(entry.getKey().func_111108_a(), attributeModifier2));
                    }
                }
                if (potionEffect.func_76458_c() > 0) {
                    object.func_150258_a(" ").func_150257_a(new TextComponentTranslation("potion.potency." + potionEffect.func_76458_c(), new Object[0]));
                }
                if (potionEffect.func_76459_b() > 20) {
                    object.func_150258_a(" (").func_150258_a(PotionUtil.func_188410_a(potionEffect, f)).func_150258_a(")");
                }
                list3.add(object.func_211708_a(potion.func_76398_f() ? TextFormatting.RED : TextFormatting.BLUE));
            }
        }
        if (!\u26032.isEmpty()) {
            list3.add(new TextComponentString(""));
            list3.add(new TextComponentTranslation("potion.whenDrank", new Object[0]).func_211708_a(TextFormatting.DARK_PURPLE));
            for (Tuple tuple : \u26032) {
                object = (AttributeModifier)tuple.func_76340_b();
                double d = ((AttributeModifier)object).func_111164_d();
                double \u26034 = ((AttributeModifier)object).func_111169_c() == 1 || ((AttributeModifier)object).func_111169_c() == 2 ? ((AttributeModifier)object).func_111164_d() * 100.0 : ((AttributeModifier)object).func_111164_d();
                if (d > 0.0) {
                    list3.add(new TextComponentTranslation("attribute.modifier.plus." + ((AttributeModifier)object).func_111169_c(), ItemStack.field_111284_a.format(\u26034), new TextComponentTranslation("attribute.name." + (String)tuple.func_76341_a(), new Object[0])).func_211708_a(TextFormatting.BLUE));
                    continue;
                }
                if (!(d < 0.0)) continue;
                list3.add(new TextComponentTranslation("attribute.modifier.take." + ((AttributeModifier)object).func_111169_c(), ItemStack.field_111284_a.format(\u26034 *= -1.0), new TextComponentTranslation("attribute.name." + (String)tuple.func_76341_a(), new Object[0])).func_211708_a(TextFormatting.RED));
            }
        }
    }
}

