/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.realms;

import java.util.List;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.util.text.ITextComponent;

public class DisconnectedRealmsScreen
extends RealmsScreen {
    private final String title;
    private final ITextComponent reason;
    private List<String> lines;
    private final RealmsScreen parent;
    private int textHeight;

    public DisconnectedRealmsScreen(RealmsScreen realmsScreen, String string, ITextComponent iTextComponent) {
        this.parent = realmsScreen;
        this.title = DisconnectedRealmsScreen.getLocalizedString(string);
        this.reason = iTextComponent;
    }

    @Override
    public void init() {
        Realms.setConnectedToRealms(false);
        Realms.clearResourcePack();
        this.lines = this.fontSplit(this.reason.func_150254_d(), this.width() - 50);
        this.textHeight = this.lines.size() * this.fontLineHeight();
        this.buttonsAdd(new RealmsButton(0, this.width() / 2 - 100, this.height() / 2 + this.textHeight / 2 + this.fontLineHeight(), DisconnectedRealmsScreen.getLocalizedString("gui.back")){

            @Override
            public void onClick(double d, double d2) {
                Realms.setScreen(DisconnectedRealmsScreen.this.parent);
            }
        });
    }

    @Override
    public boolean keyPressed(int n, int n2, int n3) {
        if (n == 256) {
            Realms.setScreen(this.parent);
            return true;
        }
        return super.keyPressed(n, n2, n3);
    }

    @Override
    public void render(int n3, int n2, float f) {
        int n3;
        this.renderBackground();
        this.drawCenteredString(this.title, this.width() / 2, this.height() / 2 - this.textHeight / 2 - this.fontLineHeight() * 2, 0xAAAAAA);
        int n4 = this.height() / 2 - this.textHeight / 2;
        if (this.lines != null) {
            for (String string : this.lines) {
                this.drawCenteredString(string, this.width() / 2, n4, 0xFFFFFF);
                n4 += this.fontLineHeight();
            }
        }
        super.render(n3, n2, f);
    }
}

