/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.realms;

import java.lang.reflect.Constructor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenAlert;
import net.minecraft.client.gui.GuiScreenRealmsProxy;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.util.Util;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RealmsBridge
extends RealmsScreen {
    private static final Logger LOGGER = LogManager.getLogger();
    private GuiScreen previousScreen;

    public void switchToRealms(GuiScreen guiScreen) {
        this.previousScreen = guiScreen;
        try {
            Class<?> clazz = Class.forName("com.mojang.realmsclient.RealmsMainScreen");
            Constructor<?> \u26032 = clazz.getDeclaredConstructor(RealmsScreen.class);
            \u26032.setAccessible(true);
            Object \u26033 = \u26032.newInstance(this);
            Minecraft.func_71410_x().func_147108_a(((RealmsScreen)\u26033).getProxy());
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.error("Realms module missing");
            this.showMissingRealmsErrorScreen();
        }
        catch (Exception exception) {
            LOGGER.error("Failed to load Realms module", (Throwable)exception);
            this.showMissingRealmsErrorScreen();
        }
    }

    public GuiScreenRealmsProxy getNotificationScreen(GuiScreen guiScreen) {
        try {
            this.previousScreen = guiScreen;
            Class<?> clazz = Class.forName("com.mojang.realmsclient.gui.screens.RealmsNotificationsScreen");
            Constructor<?> \u26032 = clazz.getDeclaredConstructor(RealmsScreen.class);
            \u26032.setAccessible(true);
            Object \u26033 = \u26032.newInstance(this);
            return ((RealmsScreen)\u26033).getProxy();
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.error("Realms module missing");
        }
        catch (Exception exception) {
            LOGGER.error("Failed to load Realms module", (Throwable)exception);
        }
        return null;
    }

    @Override
    public void init() {
        Minecraft.func_71410_x().func_147108_a(this.previousScreen);
    }

    public static void openUri(String string) {
        Util.func_110647_a().func_195640_a(string);
    }

    public static void setClipboard(String string) {
        Minecraft.func_71410_x().field_195559_v.func_197960_a(string);
    }

    private void showMissingRealmsErrorScreen() {
        Minecraft.func_71410_x().func_147108_a(new GuiScreenAlert(() -> Minecraft.func_71410_x().func_147108_a(this.previousScreen), new TextComponentString(""), new TextComponentTranslation("realms.missing.module.error.text", new Object[0])));
    }
}

