/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.realms;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.realms.RealmsButton;
import net.minecraft.util.math.MathHelper;

public abstract class RealmsSliderButton
extends RealmsButton {
    public double value = 1.0;
    public boolean sliding;
    private final double minValue;
    private final double maxValue;
    private int steps;

    public RealmsSliderButton(int n, int n2, int n3, int n4, int n5, int n6) {
        this(n, n2, n3, n4, n6, 0, 1.0, n5);
    }

    public RealmsSliderButton(int n, int n2, int n3, int n4, int n5, int n6, double d, double d2) {
        super(n, n2, n3, n4, 20, "");
        this.minValue = d;
        this.maxValue = d2;
        this.value = this.toPct(n6);
        this.getProxy().field_146126_j = this.getMessage();
    }

    public String getMessage() {
        return "";
    }

    public double toPct(double d) {
        return MathHelper.func_151237_a((this.clamp(d) - this.minValue) / (this.maxValue - this.minValue), 0.0, 1.0);
    }

    public double toValue(double d) {
        return this.clamp(this.minValue + (this.maxValue - this.minValue) * MathHelper.func_151237_a(d, 0.0, 1.0));
    }

    public double clamp(double d) {
        d = this.clampSteps(d);
        return MathHelper.func_151237_a(d, this.minValue, this.maxValue);
    }

    protected double clampSteps(double d) {
        if (this.steps > 0) {
            d = (long)this.steps * Math.round(d / (double)this.steps);
        }
        return d;
    }

    @Override
    public int getYImage(boolean bl) {
        return 0;
    }

    @Override
    public void renderBg(int n, int n2) {
        if (!this.getProxy().field_146125_m) {
            return;
        }
        if (this.sliding) {
            this.value = (float)(n - (this.getProxy().field_146128_h + 4)) / (float)(this.getProxy().func_146117_b() - 8);
            this.value = MathHelper.func_151237_a(this.value, 0.0, 1.0);
            double d = this.toValue(this.value);
            this.clicked(d);
            this.value = this.toPct(d);
            this.getProxy().field_146126_j = this.getMessage();
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(WIDGETS_LOCATION);
        GlStateManager.func_179131_c(1.0f, 1.0f, 1.0f, 1.0f);
        this.blit(this.getProxy().field_146128_h + (int)(this.value * (double)(this.getProxy().func_146117_b() - 8)), this.getProxy().field_146129_i, 0, 66, 4, 20);
        this.blit(this.getProxy().field_146128_h + (int)(this.value * (double)(this.getProxy().func_146117_b() - 8)) + 4, this.getProxy().field_146129_i, 196, 66, 4, 20);
    }

    @Override
    public void onClick(double d, double d2) {
        this.value = (d - (double)(this.getProxy().field_146128_h + 4)) / (double)(this.getProxy().func_146117_b() - 8);
        this.value = MathHelper.func_151237_a(this.value, 0.0, 1.0);
        this.clicked(this.toValue(this.value));
        this.getProxy().field_146126_j = this.getMessage();
        this.sliding = true;
    }

    public void clicked(double d) {
    }

    @Override
    public void onRelease(double d, double d2) {
        this.sliding = false;
    }
}

