/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.resources.FallbackResourceManager;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimpleReloadableResourceManager
implements IReloadableResourceManager {
    private static final Logger field_199012_a = LogManager.getLogger();
    private final Map<String, FallbackResourceManager> field_199014_c = Maps.newHashMap();
    private final List<IResourceManagerReloadListener> field_199015_d = Lists.newArrayList();
    private final Set<String> field_199016_e = Sets.newLinkedHashSet();
    private final ResourcePackType field_199017_f;

    public SimpleReloadableResourceManager(ResourcePackType resourcePackType) {
        this.field_199017_f = resourcePackType;
    }

    public void func_199009_a(IResourcePack iResourcePack) {
        for (String string : iResourcePack.func_195759_a(this.field_199017_f)) {
            this.field_199016_e.add(string);
            FallbackResourceManager fallbackResourceManager = this.field_199014_c.get(string);
            if (fallbackResourceManager == null) {
                fallbackResourceManager = new FallbackResourceManager(this.field_199017_f);
                this.field_199014_c.put(string, fallbackResourceManager);
            }
            fallbackResourceManager.func_199021_a(iResourcePack);
        }
    }

    @Override
    public Set<String> func_199001_a() {
        return this.field_199016_e;
    }

    @Override
    public IResource func_199002_a(ResourceLocation resourceLocation) throws IOException {
        IResourceManager iResourceManager = this.field_199014_c.get(resourceLocation.func_110624_b());
        if (iResourceManager != null) {
            return iResourceManager.func_199002_a(resourceLocation);
        }
        throw new FileNotFoundException(resourceLocation.toString());
    }

    @Override
    public List<IResource> func_199004_b(ResourceLocation resourceLocation) throws IOException {
        IResourceManager iResourceManager = this.field_199014_c.get(resourceLocation.func_110624_b());
        if (iResourceManager != null) {
            return iResourceManager.func_199004_b(resourceLocation);
        }
        throw new FileNotFoundException(resourceLocation.toString());
    }

    @Override
    public Collection<ResourceLocation> func_199003_a(String string, Predicate<String> predicate) {
        HashSet hashSet = Sets.newHashSet();
        for (FallbackResourceManager fallbackResourceManager : this.field_199014_c.values()) {
            hashSet.addAll(fallbackResourceManager.func_199003_a(string, predicate));
        }
        ArrayList \u26032 = Lists.newArrayList((Iterable)hashSet);
        Collections.sort(\u26032);
        return \u26032;
    }

    private void func_199008_b() {
        this.field_199014_c.clear();
        this.field_199016_e.clear();
    }

    @Override
    public void func_199005_a(List<IResourcePack> list) {
        this.func_199008_b();
        field_199012_a.info("Reloading ResourceManager: {}", (Object)list.stream().map(IResourcePack::func_195762_a).collect(Collectors.joining(", ")));
        for (IResourcePack iResourcePack : list) {
            this.func_199009_a(iResourcePack);
        }
        if (field_199012_a.isDebugEnabled()) {
            this.func_199011_d();
        } else {
            this.func_199010_c();
        }
    }

    @Override
    public void func_199006_a(IResourceManagerReloadListener iResourceManagerReloadListener) {
        this.field_199015_d.add(iResourceManagerReloadListener);
        if (field_199012_a.isDebugEnabled()) {
            field_199012_a.info(this.func_199007_b(iResourceManagerReloadListener));
        } else {
            iResourceManagerReloadListener.func_195410_a(this);
        }
    }

    private void func_199010_c() {
        for (IResourceManagerReloadListener iResourceManagerReloadListener : this.field_199015_d) {
            iResourceManagerReloadListener.func_195410_a(this);
        }
    }

    private void func_199011_d() {
        field_199012_a.info("Reloading all resources! {} listeners to update.", (Object)this.field_199015_d.size());
        ArrayList arrayList = Lists.newArrayList();
        Stopwatch \u26032 = Stopwatch.createStarted();
        for (IResourceManagerReloadListener iResourceManagerReloadListener : this.field_199015_d) {
            arrayList.add(this.func_199007_b(iResourceManagerReloadListener));
        }
        \u26032.stop();
        field_199012_a.info("----");
        field_199012_a.info("Complete resource reload took {} ms", (Object)\u26032.elapsed(TimeUnit.MILLISECONDS));
        for (String string : arrayList) {
            field_199012_a.info(string);
        }
        field_199012_a.info("----");
    }

    private String func_199007_b(IResourceManagerReloadListener iResourceManagerReloadListener) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        iResourceManagerReloadListener.func_195410_a(this);
        stopwatch.stop();
        return "Resource reload for " + iResourceManagerReloadListener.getClass().getSimpleName() + " took " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms";
    }
}

