/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.scoreboard;

import java.util.Collection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.storage.WorldSavedData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScoreboardSaveData
extends WorldSavedData {
    private static final Logger field_151481_a = LogManager.getLogger();
    private Scoreboard field_96507_a;
    private NBTTagCompound field_96506_b;

    public ScoreboardSaveData() {
        this("scoreboard");
    }

    public ScoreboardSaveData(String string) {
        super(string);
    }

    public void func_96499_a(Scoreboard scoreboard) {
        this.field_96507_a = scoreboard;
        if (this.field_96506_b != null) {
            this.func_76184_a(this.field_96506_b);
        }
    }

    @Override
    public void func_76184_a(NBTTagCompound nBTTagCompound) {
        if (this.field_96507_a == null) {
            this.field_96506_b = nBTTagCompound;
            return;
        }
        this.func_96501_b(nBTTagCompound.func_150295_c("Objectives", 10));
        this.field_96507_a.func_197905_a(nBTTagCompound.func_150295_c("PlayerScores", 10));
        if (nBTTagCompound.func_150297_b("DisplaySlots", 10)) {
            this.func_96504_c(nBTTagCompound.func_74775_l("DisplaySlots"));
        }
        if (nBTTagCompound.func_150297_b("Teams", 9)) {
            this.func_96498_a(nBTTagCompound.func_150295_c("Teams", 10));
        }
    }

    protected void func_96498_a(NBTTagList nBTTagList) {
        for (int i = 0; i < nBTTagList.size(); ++i) {
            Team.CollisionRule collisionRule;
            Team.EnumVisible enumVisible;
            Team.EnumVisible enumVisible2;
            ITextComponent iTextComponent;
            ITextComponent iTextComponent2;
            NBTTagCompound nBTTagCompound = nBTTagList.func_150305_b(i);
            String \u26032 = nBTTagCompound.func_74779_i("Name");
            if (\u26032.length() > 16) {
                \u26032 = \u26032.substring(0, 16);
            }
            ScorePlayerTeam \u26033 = this.field_96507_a.func_96527_f(\u26032);
            ITextComponent \u26034 = ITextComponent.Serializer.func_150699_a(nBTTagCompound.func_74779_i("DisplayName"));
            if (\u26034 != null) {
                \u26033.func_96664_a(\u26034);
            }
            if (nBTTagCompound.func_150297_b("TeamColor", 8)) {
                \u26033.func_178774_a(TextFormatting.func_96300_b(nBTTagCompound.func_74779_i("TeamColor")));
            }
            if (nBTTagCompound.func_150297_b("AllowFriendlyFire", 99)) {
                \u26033.func_96660_a(nBTTagCompound.func_74767_n("AllowFriendlyFire"));
            }
            if (nBTTagCompound.func_150297_b("SeeFriendlyInvisibles", 99)) {
                \u26033.func_98300_b(nBTTagCompound.func_74767_n("SeeFriendlyInvisibles"));
            }
            if (nBTTagCompound.func_150297_b("MemberNamePrefix", 8) && (iTextComponent2 = ITextComponent.Serializer.func_150699_a(nBTTagCompound.func_74779_i("MemberNamePrefix"))) != null) {
                \u26033.func_207408_a(iTextComponent2);
            }
            if (nBTTagCompound.func_150297_b("MemberNameSuffix", 8) && (iTextComponent = ITextComponent.Serializer.func_150699_a(nBTTagCompound.func_74779_i("MemberNameSuffix"))) != null) {
                \u26033.func_207409_b(iTextComponent);
            }
            if (nBTTagCompound.func_150297_b("NameTagVisibility", 8) && (enumVisible2 = Team.EnumVisible.func_178824_a(nBTTagCompound.func_74779_i("NameTagVisibility"))) != null) {
                \u26033.func_178772_a(enumVisible2);
            }
            if (nBTTagCompound.func_150297_b("DeathMessageVisibility", 8) && (enumVisible = Team.EnumVisible.func_178824_a(nBTTagCompound.func_74779_i("DeathMessageVisibility"))) != null) {
                \u26033.func_178773_b(enumVisible);
            }
            if (nBTTagCompound.func_150297_b("CollisionRule", 8) && (collisionRule = Team.CollisionRule.func_186686_a(nBTTagCompound.func_74779_i("CollisionRule"))) != null) {
                \u26033.func_186682_a(collisionRule);
            }
            this.func_96502_a(\u26033, nBTTagCompound.func_150295_c("Players", 8));
        }
    }

    protected void func_96502_a(ScorePlayerTeam scorePlayerTeam, NBTTagList nBTTagList) {
        for (int i = 0; i < nBTTagList.size(); ++i) {
            this.field_96507_a.func_197901_a(nBTTagList.func_150307_f(i), scorePlayerTeam);
        }
    }

    protected void func_96504_c(NBTTagCompound nBTTagCompound) {
        for (int i = 0; i < 19; ++i) {
            if (!nBTTagCompound.func_150297_b("slot_" + i, 8)) continue;
            String string = nBTTagCompound.func_74779_i("slot_" + i);
            ScoreObjective \u26032 = this.field_96507_a.func_96518_b(string);
            this.field_96507_a.func_96530_a(i, \u26032);
        }
    }

    protected void func_96501_b(NBTTagList nBTTagList) {
        for (int i = 0; i < nBTTagList.size(); ++i) {
            NBTTagCompound nBTTagCompound = nBTTagList.func_150305_b(i);
            ScoreCriteria \u26032 = ScoreCriteria.func_197911_a(nBTTagCompound.func_74779_i("CriteriaName"));
            if (\u26032 == null) continue;
            String \u26033 = nBTTagCompound.func_74779_i("Name");
            if (\u26033.length() > 16) {
                \u26033 = \u26033.substring(0, 16);
            }
            ITextComponent \u26034 = ITextComponent.Serializer.func_150699_a(nBTTagCompound.func_74779_i("DisplayName"));
            ScoreCriteria.RenderType \u26035 = ScoreCriteria.RenderType.func_211839_a(nBTTagCompound.func_74779_i("RenderType"));
            this.field_96507_a.func_199868_a(\u26033, \u26032, \u26034, \u26035);
        }
    }

    @Override
    public NBTTagCompound func_189551_b(NBTTagCompound nBTTagCompound) {
        if (this.field_96507_a == null) {
            field_151481_a.warn("Tried to save scoreboard without having a scoreboard...");
            return nBTTagCompound;
        }
        nBTTagCompound.func_74782_a("Objectives", this.func_96505_b());
        nBTTagCompound.func_74782_a("PlayerScores", this.field_96507_a.func_197902_i());
        nBTTagCompound.func_74782_a("Teams", this.func_96496_a());
        this.func_96497_d(nBTTagCompound);
        return nBTTagCompound;
    }

    protected NBTTagList func_96496_a() {
        NBTTagList nBTTagList = new NBTTagList();
        Collection<ScorePlayerTeam> \u26032 = this.field_96507_a.func_96525_g();
        for (ScorePlayerTeam scorePlayerTeam : \u26032) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74778_a("Name", scorePlayerTeam.func_96661_b());
            nBTTagCompound.func_74778_a("DisplayName", ITextComponent.Serializer.func_150696_a(scorePlayerTeam.func_96669_c()));
            if (scorePlayerTeam.func_178775_l().func_175746_b() >= 0) {
                nBTTagCompound.func_74778_a("TeamColor", scorePlayerTeam.func_178775_l().func_96297_d());
            }
            nBTTagCompound.func_74757_a("AllowFriendlyFire", scorePlayerTeam.func_96665_g());
            nBTTagCompound.func_74757_a("SeeFriendlyInvisibles", scorePlayerTeam.func_98297_h());
            nBTTagCompound.func_74778_a("MemberNamePrefix", ITextComponent.Serializer.func_150696_a(scorePlayerTeam.func_207406_e()));
            nBTTagCompound.func_74778_a("MemberNameSuffix", ITextComponent.Serializer.func_150696_a(scorePlayerTeam.func_207407_f()));
            nBTTagCompound.func_74778_a("NameTagVisibility", scorePlayerTeam.func_178770_i().field_178830_e);
            nBTTagCompound.func_74778_a("DeathMessageVisibility", scorePlayerTeam.func_178771_j().field_178830_e);
            nBTTagCompound.func_74778_a("CollisionRule", scorePlayerTeam.func_186681_k().field_186693_e);
            NBTTagList \u26033 = new NBTTagList();
            for (String string : scorePlayerTeam.func_96670_d()) {
                \u26033.add(new NBTTagString(string));
            }
            nBTTagCompound.func_74782_a("Players", \u26033);
            nBTTagList.add(nBTTagCompound);
        }
        return nBTTagList;
    }

    protected void func_96497_d(NBTTagCompound nBTTagCompound) {
        \u2603 = new NBTTagCompound();
        boolean \u26032 = false;
        for (int i = 0; i < 19; ++i) {
            ScoreObjective scoreObjective = this.field_96507_a.func_96539_a(i);
            if (scoreObjective == null) continue;
            \u2603.func_74778_a("slot_" + i, scoreObjective.func_96679_b());
            \u26032 = true;
        }
        if (\u26032) {
            nBTTagCompound.func_74782_a("DisplaySlots", \u2603);
        }
    }

    protected NBTTagList func_96505_b() {
        NBTTagList nBTTagList = new NBTTagList();
        Collection<ScoreObjective> \u26032 = this.field_96507_a.func_96514_c();
        for (ScoreObjective scoreObjective : \u26032) {
            if (scoreObjective.func_96680_c() == null) continue;
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74778_a("Name", scoreObjective.func_96679_b());
            nBTTagCompound.func_74778_a("CriteriaName", scoreObjective.func_96680_c().func_96636_a());
            nBTTagCompound.func_74778_a("DisplayName", ITextComponent.Serializer.func_150696_a(scoreObjective.func_96678_d()));
            nBTTagCompound.func_74778_a("RenderType", scoreObjective.func_199865_f().func_211838_a());
            nBTTagList.add(nBTTagCompound);
        }
        return nBTTagList;
    }
}

