/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.LambdaMetafactory;
import java.net.Proxy;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.FunctionManager;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ICommandSource;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Bootstrap;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.network.NetworkSystem;
import net.minecraft.network.ServerStatusResponse;
import net.minecraft.network.play.server.SPacketTimeUpdate;
import net.minecraft.profiler.ISnooperInfo;
import net.minecraft.profiler.Profiler;
import net.minecraft.profiler.Snooper;
import net.minecraft.resources.FolderPackFinder;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.ServerPackFinder;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.server.CustomBossEvents;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.server.management.UserListOpsEntry;
import net.minecraft.server.management.UserListWhitelist;
import net.minecraft.tags.NetworkTagManager;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.ITickable;
import net.minecraft.util.Util;
import net.minecraft.util.WorldOptimizer;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.ForcedChunksSaveData;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.ServerWorldEventHandler;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldServerDemo;
import net.minecraft.world.WorldServerMulti;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.storage.AnvilSaveConverter;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.SessionLockException;
import net.minecraft.world.storage.WorldInfo;
import net.minecraft.world.storage.WorldSavedDataStorage;
import net.minecraft.world.storage.loot.LootTableManager;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MinecraftServer
implements IThreadListener,
ISnooperInfo,
ICommandSource,
Runnable {
    private static final Logger field_147145_h = LogManager.getLogger();
    public static final File field_152367_a = new File("usercache.json");
    private final ISaveFormat field_71310_m;
    private final Snooper field_71307_n = new Snooper("server", this, Util.func_211177_b());
    private final File field_71308_o;
    private final List<ITickable> field_71322_p = Lists.newArrayList();
    public final Profiler field_71304_b = new Profiler();
    private final NetworkSystem field_147144_o;
    private final ServerStatusResponse field_147147_p = new ServerStatusResponse();
    private final Random field_147146_q = new Random();
    private final DataFixer field_184112_s;
    private String field_71320_r;
    private int field_71319_s = -1;
    private final Map<DimensionType, WorldServer> field_71305_c = Maps.newIdentityHashMap();
    private PlayerList field_71318_t;
    private boolean field_71317_u = true;
    private boolean field_71316_v;
    private int field_71315_w;
    protected final Proxy field_110456_c;
    private ITextComponent field_71302_d;
    private int field_71303_e;
    private boolean field_71325_x;
    private boolean field_190519_A;
    private boolean field_71324_y;
    private boolean field_71323_z;
    private boolean field_71284_A;
    private boolean field_71285_B;
    private String field_71286_C;
    private int field_71280_D;
    private int field_143008_E;
    public final long[] field_71311_j = new long[100];
    protected final Map<DimensionType, long[]> field_71312_k = Maps.newIdentityHashMap();
    private KeyPair field_71292_I;
    private String field_71293_J;
    private String field_71294_K;
    private String field_71287_L;
    private boolean field_71288_M;
    private boolean field_71289_N;
    private String field_147141_M = "";
    private String field_175588_P = "";
    private boolean field_71296_Q;
    private long field_71299_R;
    private ITextComponent field_71298_S;
    private boolean field_71295_T;
    private boolean field_104057_T;
    private final YggdrasilAuthenticationService field_152364_T;
    private final MinecraftSessionService field_147143_S;
    private final GameProfileRepository field_152365_W;
    private final PlayerProfileCache field_152366_X;
    private long field_147142_T;
    public final Queue<FutureTask<?>> field_175589_i = Queues.newConcurrentLinkedQueue();
    private Thread field_175590_aa;
    private long field_211151_aa = Util.func_211177_b();
    private boolean field_184111_ab;
    private final IReloadableResourceManager field_195576_ac = new SimpleReloadableResourceManager(ResourcePackType.SERVER_DATA);
    private final ResourcePackList<ResourcePackInfo> field_195577_ad = new ResourcePackList<ResourcePackInfo>(ResourcePackInfo::new);
    private FolderPackFinder field_195578_ae;
    private final Commands field_195579_af;
    private final RecipeManager field_199530_ag = new RecipeManager();
    private final NetworkTagManager field_199736_ah = new NetworkTagManager();
    private final ServerScoreboard field_200255_ai = new ServerScoreboard(this);
    private final CustomBossEvents field_201301_aj = new CustomBossEvents(this);
    private final LootTableManager field_200256_aj = new LootTableManager();
    private final AdvancementManager field_200257_ak = new AdvancementManager();
    private final FunctionManager field_200258_al = new FunctionManager(this);
    private boolean field_205745_an;
    private boolean field_212205_ao;
    private float field_211152_ao;

    public MinecraftServer(@Nullable File file, Proxy proxy, DataFixer dataFixer, Commands commands, YggdrasilAuthenticationService yggdrasilAuthenticationService, MinecraftSessionService minecraftSessionService, GameProfileRepository gameProfileRepository, PlayerProfileCache playerProfileCache) {
        this.field_110456_c = proxy;
        this.field_195579_af = commands;
        this.field_152364_T = yggdrasilAuthenticationService;
        this.field_147143_S = minecraftSessionService;
        this.field_152365_W = gameProfileRepository;
        this.field_152366_X = playerProfileCache;
        this.field_71308_o = file;
        this.field_147144_o = file == null ? null : new NetworkSystem(this);
        this.field_71310_m = file == null ? null : new AnvilSaveConverter(file.toPath(), file.toPath().resolve("../backups"), dataFixer);
        this.field_184112_s = dataFixer;
        this.field_195576_ac.func_199006_a(this.field_199736_ah);
        this.field_195576_ac.func_199006_a(this.field_199530_ag);
        this.field_195576_ac.func_199006_a(this.field_200256_aj);
        this.field_195576_ac.func_199006_a(this.field_200258_al);
        this.field_195576_ac.func_199006_a(this.field_200257_ak);
    }

    public abstract boolean func_71197_b() throws IOException;

    public void func_71237_c(String string) {
        if (this.func_71254_M().func_75801_b(string)) {
            field_147145_h.info("Converting map!");
            this.func_200245_b(new TextComponentTranslation("menu.convertingLevel", new Object[0]));
            this.func_71254_M().func_75805_a(string, new IProgressUpdate(){
                private long field_96245_b = Util.func_211177_b();

                @Override
                public void func_200210_a(ITextComponent iTextComponent) {
                }

                @Override
                public void func_200211_b(ITextComponent iTextComponent) {
                }

                @Override
                public void func_73718_a(int n) {
                    if (Util.func_211177_b() - this.field_96245_b >= 1000L) {
                        this.field_96245_b = Util.func_211177_b();
                        field_147145_h.info("Converting... {}%", (Object)n);
                    }
                }

                @Override
                public void func_146586_a() {
                }

                @Override
                public void func_200209_c(ITextComponent iTextComponent) {
                }
            });
        }
        if (this.field_212205_ao) {
            field_147145_h.info("Forcing world upgrade!");
            WorldInfo worldInfo = this.func_71254_M().func_75803_c(this.func_71270_I());
            if (worldInfo != null) {
                WorldOptimizer worldOptimizer = new WorldOptimizer(this.func_71270_I(), this.func_71254_M(), worldInfo);
                ITextComponent \u26032 = null;
                while (!worldOptimizer.func_212218_b()) {
                    ITextComponent iTextComponent = worldOptimizer.func_212215_m();
                    if (\u26032 != iTextComponent) {
                        \u26032 = iTextComponent;
                        field_147145_h.info(worldOptimizer.func_212215_m().getString());
                    }
                    if ((\u2603 = worldOptimizer.func_212211_j()) > 0) {
                        int n = worldOptimizer.func_212208_k() + worldOptimizer.func_212209_l();
                        field_147145_h.info("{}% completed ({} / {} chunks)...", (Object)MathHelper.func_76141_d((float)n / (float)\u2603 * 100.0f), (Object)n, (Object)\u2603);
                    }
                    if (this.func_71241_aa()) {
                        worldOptimizer.func_212217_a();
                        continue;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    protected synchronized void func_200245_b(ITextComponent iTextComponent) {
        this.field_71298_S = iTextComponent;
    }

    @Nullable
    public synchronized ITextComponent func_200253_h_() {
        return this.field_71298_S;
    }

    public void func_71247_a(String string, String string2, long l2, WorldType worldType, JsonElement jsonElement) {
        WorldSettings \u26033;
        this.func_71237_c(string);
        this.func_200245_b(new TextComponentTranslation("menu.loadingLevel", new Object[0]));
        ISaveHandler iSaveHandler = this.func_71254_M().func_197715_a(string, this);
        this.func_175584_a(this.func_71270_I(), iSaveHandler);
        WorldInfo \u26032 = iSaveHandler.func_75757_d();
        if (\u26032 == null) {
            if (this.func_71242_L()) {
                \u26033 = WorldServerDemo.field_73071_a;
            } else {
                long l2;
                \u26033 = new WorldSettings(l2, this.func_71265_f(), this.func_71225_e(), this.func_71199_h(), worldType);
                \u26033.func_205390_a(jsonElement);
                if (this.field_71289_N) {
                    \u26033.func_77159_a();
                }
            }
            \u26032 = new WorldInfo(\u26033, string2);
        } else {
            \u26032.func_76062_a(string2);
            \u26033 = new WorldSettings(\u26032);
        }
        this.func_195560_a(iSaveHandler.func_75765_b(), \u26032);
        WorldSavedDataStorage worldSavedDataStorage = new WorldSavedDataStorage(iSaveHandler);
        this.func_212369_a(iSaveHandler, worldSavedDataStorage, \u26032, \u26033);
        this.func_147139_a(this.func_147135_j());
        this.func_71222_d(worldSavedDataStorage);
    }

    public void func_212369_a(ISaveHandler iSaveHandler, WorldSavedDataStorage worldSavedDataStorage, WorldInfo worldInfo, WorldSettings worldSettings) {
        if (this.func_71242_L()) {
            this.field_71305_c.put(DimensionType.OVERWORLD, new WorldServerDemo(this, iSaveHandler, worldSavedDataStorage, worldInfo, DimensionType.OVERWORLD, this.field_71304_b).func_212251_i__());
        } else {
            this.field_71305_c.put(DimensionType.OVERWORLD, new WorldServer(this, iSaveHandler, worldSavedDataStorage, worldInfo, DimensionType.OVERWORLD, this.field_71304_b).func_212251_i__());
        }
        WorldServer worldServer = this.func_71218_a(DimensionType.OVERWORLD);
        worldServer.func_72963_a(worldSettings);
        worldServer.func_72954_a(new ServerWorldEventHandler(this, worldServer));
        if (!this.func_71264_H()) {
            worldServer.func_72912_H().func_76060_a(this.func_71265_f());
        }
        WorldServerMulti \u26032 = new WorldServerMulti(this, iSaveHandler, DimensionType.NETHER, worldServer, this.field_71304_b).func_212251_i__();
        this.field_71305_c.put(DimensionType.NETHER, \u26032);
        \u26032.func_72954_a(new ServerWorldEventHandler(this, \u26032));
        if (!this.func_71264_H()) {
            \u26032.func_72912_H().func_76060_a(this.func_71265_f());
        }
        WorldServerMulti \u26033 = new WorldServerMulti(this, iSaveHandler, DimensionType.THE_END, worldServer, this.field_71304_b).func_212251_i__();
        this.field_71305_c.put(DimensionType.THE_END, \u26033);
        \u26033.func_72954_a(new ServerWorldEventHandler(this, \u26033));
        if (!this.func_71264_H()) {
            \u26033.func_72912_H().func_76060_a(this.func_71265_f());
        }
        this.func_184103_al().func_212504_a(worldServer);
        if (worldInfo.func_201357_P() != null) {
            this.func_201300_aS().func_201381_a(worldInfo.func_201357_P());
        }
    }

    public void func_195560_a(File file, WorldInfo worldInfo) {
        this.field_195577_ad.func_198982_a(new ServerPackFinder());
        this.field_195578_ae = new FolderPackFinder(new File(file, "datapacks"));
        this.field_195577_ad.func_198982_a(this.field_195578_ae);
        this.field_195577_ad.func_198983_a();
        ArrayList arrayList = Lists.newArrayList();
        for (String string : worldInfo.func_197720_O()) {
            ResourcePackInfo resourcePackInfo = this.field_195577_ad.func_198981_a(string);
            if (resourcePackInfo != null) {
                arrayList.add(resourcePackInfo);
                continue;
            }
            field_147145_h.warn("Missing data pack {}", (Object)string);
        }
        this.field_195577_ad.func_198985_a(arrayList);
        this.func_195568_a(worldInfo);
    }

    /*
     * WARNING - void declaration
     */
    public void func_71222_d(WorldSavedDataStorage worldSavedDataStorage) {
        int n = 16;
        int n2 = 4;
        \u2603 = 12;
        \u2603 = 192;
        \u2603 = 625;
        this.func_200245_b(new TextComponentTranslation("menu.generatingTerrain", new Object[0]));
        WorldServer \u26032 = this.func_71218_a(DimensionType.OVERWORLD);
        field_147145_h.info("Preparing start region for dimension " + DimensionType.func_212678_a(\u26032.field_73011_w.func_186058_p()));
        BlockPos \u26033 = \u26032.func_175694_M();
        ArrayList \u26034 = Lists.newArrayList();
        Set \u26035 = Sets.newConcurrentHashSet();
        Stopwatch \u26036 = Stopwatch.createStarted();
        for (\u2603 = -192; \u2603 <= 192 && this.func_71278_l(); \u2603 += 16) {
            void var13_16;
            int n3 = -192;
            while (var13_16 <= 192 && this.func_71278_l()) {
                \u26034.add(new ChunkPos(\u26033.func_177958_n() + \u2603 >> 4, \u26033.func_177952_p() + var13_16 >> 4));
                var13_16 += 16;
            }
            CompletableFuture<ChunkPrimer> completableFuture = \u26032.func_72863_F().func_201720_a(\u26034, chunk -> \u26035.add(chunk.func_76632_l()));
            while (!completableFuture.isDone()) {
                try {
                    completableFuture.get(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
                catch (ExecutionException executionException) {
                    if (executionException.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)executionException.getCause();
                    }
                    throw new RuntimeException(executionException.getCause());
                }
                catch (TimeoutException timeoutException) {
                    this.func_200250_a(new TextComponentTranslation("menu.preparingSpawn", new Object[0]), \u26035.size() * 100 / 625);
                }
            }
            this.func_200250_a(new TextComponentTranslation("menu.preparingSpawn", new Object[0]), \u26035.size() * 100 / 625);
        }
        field_147145_h.info("Time elapsed: {} ms", (Object)\u26036.elapsed(TimeUnit.MILLISECONDS));
        for (DimensionType dimensionType : DimensionType.func_212681_b()) {
            ForcedChunksSaveData forcedChunksSaveData = worldSavedDataStorage.func_212426_a(dimensionType, ForcedChunksSaveData::new, "chunks");
            if (forcedChunksSaveData == null) continue;
            WorldServer \u26037 = this.func_71218_a(dimensionType);
            LongIterator \u26038 = forcedChunksSaveData.func_212438_a().iterator();
            while (\u26038.hasNext()) {
                this.func_200250_a(new TextComponentTranslation("menu.loadingForcedChunks", dimensionType), forcedChunksSaveData.func_212438_a().size() * 100 / 625);
                long l = \u26038.nextLong();
                ChunkPos \u26039 = new ChunkPos(l);
                \u26037.func_72863_F().func_186025_d(\u26039.field_77276_a, \u26039.field_77275_b, true, true);
            }
        }
        this.func_71243_i();
    }

    public void func_175584_a(String string, ISaveHandler iSaveHandler) {
        File file = new File(iSaveHandler.func_75765_b(), "resources.zip");
        if (file.isFile()) {
            try {
                this.func_180507_a_("level://" + URLEncoder.encode(string, StandardCharsets.UTF_8.toString()) + "/" + "resources.zip", "");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                field_147145_h.warn("Something went wrong url encoding {}", (Object)string);
            }
        }
    }

    public abstract boolean func_71225_e();

    public abstract GameType func_71265_f();

    public abstract EnumDifficulty func_147135_j();

    public abstract boolean func_71199_h();

    public abstract int func_110455_j();

    public abstract boolean func_195569_l();

    protected void func_200250_a(ITextComponent iTextComponent, int n) {
        this.field_71302_d = iTextComponent;
        this.field_71303_e = n;
        field_147145_h.info("{}: {}%", (Object)iTextComponent.getString(), (Object)n);
    }

    protected void func_71243_i() {
        this.field_71302_d = null;
        this.field_71303_e = 0;
    }

    public void func_71267_a(boolean bl) {
        for (WorldServer worldServer : this.func_212370_w()) {
            if (worldServer == null) continue;
            if (!bl) {
                field_147145_h.info("Saving chunks for level '{}'/{}", (Object)worldServer.func_72912_H().func_76065_j(), (Object)DimensionType.func_212678_a(worldServer.field_73011_w.func_186058_p()));
            }
            try {
                worldServer.func_73044_a(true, null);
            }
            catch (SessionLockException sessionLockException) {
                field_147145_h.warn(sessionLockException.getMessage());
            }
        }
    }

    public void func_71260_j() {
        field_147145_h.info("Stopping server");
        if (this.func_147137_ag() != null) {
            this.func_147137_ag().func_151268_b();
        }
        if (this.field_71318_t != null) {
            field_147145_h.info("Saving players");
            this.field_71318_t.func_72389_g();
            this.field_71318_t.func_72392_r();
        }
        field_147145_h.info("Saving worlds");
        for (WorldServer worldServer : this.func_212370_w()) {
            if (worldServer == null) continue;
            worldServer.field_73058_d = false;
        }
        this.func_71267_a(false);
        for (WorldServer worldServer : this.func_212370_w()) {
            if (worldServer == null) continue;
            worldServer.close();
        }
        if (this.field_71307_n.func_76468_d()) {
            this.field_71307_n.func_76470_e();
        }
    }

    public String func_71211_k() {
        return this.field_71320_r;
    }

    public void func_71189_e(String string) {
        this.field_71320_r = string;
    }

    public boolean func_71278_l() {
        return this.field_71317_u;
    }

    public void func_71263_m() {
        this.field_71317_u = false;
    }

    private boolean func_212379_aT() {
        return Util.func_211177_b() < this.field_211151_aa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.func_71197_b()) {
                this.field_211151_aa = Util.func_211177_b();
                this.field_147147_p.func_151315_a(new TextComponentString(this.field_71286_C));
                this.field_147147_p.func_151321_a(new ServerStatusResponse.Version("1.13.2", 404));
                this.func_184107_a(this.field_147147_p);
                while (this.field_71317_u) {
                    long l = Util.func_211177_b() - this.field_211151_aa;
                    if (l > 2000L && this.field_211151_aa - this.field_71299_R >= 15000L) {
                        \u2603 = l / 50L;
                        field_147145_h.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)l, (Object)\u2603);
                        this.field_211151_aa += \u2603 * 50L;
                        this.field_71299_R = this.field_211151_aa;
                    }
                    this.func_71217_p(this::func_212379_aT);
                    this.field_211151_aa += 50L;
                    while (this.func_212379_aT()) {
                        Thread.sleep(1L);
                    }
                    this.field_71296_Q = true;
                }
            } else {
                this.func_71228_a(null);
            }
        }
        catch (Throwable throwable) {
            field_147145_h.error("Encountered an unexpected exception", throwable);
            CrashReport crashReport = throwable instanceof ReportedException ? this.func_71230_b(((ReportedException)throwable).func_71575_a()) : this.func_71230_b(new CrashReport("Exception in server tick loop", throwable));
            File \u26032 = new File(new File(this.func_71238_n(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (crashReport.func_147149_a(\u26032)) {
                field_147145_h.error("This crash report has been saved to: {}", (Object)\u26032.getAbsolutePath());
            } else {
                field_147145_h.error("We were unable to save this crash report to disk.");
            }
            this.func_71228_a(crashReport);
        }
        finally {
            try {
                this.field_71316_v = true;
                this.func_71260_j();
            }
            catch (Throwable \u26033) {
                field_147145_h.error("Exception stopping the server", \u26033);
            }
            finally {
                this.func_71240_o();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_184107_a(ServerStatusResponse serverStatusResponse) {
        File file = this.func_71209_f("server-icon.png");
        if (!file.exists()) {
            file = this.func_71254_M().func_186352_b(this.func_71270_I(), "icon.png");
        }
        if (file.isFile()) {
            ByteBuf byteBuf = Unpooled.buffer();
            try {
                BufferedImage bufferedImage = ImageIO.read(file);
                Validate.validState((bufferedImage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((bufferedImage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ImageIO.write((RenderedImage)bufferedImage, "PNG", (OutputStream)new ByteBufOutputStream(byteBuf));
                ByteBuffer \u26032 = Base64.getEncoder().encode(byteBuf.nioBuffer());
                serverStatusResponse.func_151320_a("data:image/png;base64," + StandardCharsets.UTF_8.decode(\u26032));
            }
            catch (Exception exception) {
                field_147145_h.error("Couldn't load server icon", (Throwable)exception);
            }
            finally {
                byteBuf.release();
            }
        }
    }

    public boolean func_184106_y() {
        this.field_184111_ab = this.field_184111_ab || this.func_184109_z().isFile();
        return this.field_184111_ab;
    }

    public File func_184109_z() {
        return this.func_71254_M().func_186352_b(this.func_71270_I(), "icon.png");
    }

    public File func_71238_n() {
        return new File(".");
    }

    public void func_71228_a(CrashReport crashReport) {
    }

    public void func_71240_o() {
    }

    public void func_71217_p(BooleanSupplier booleanSupplier) {
        long l = Util.func_211178_c();
        ++this.field_71315_w;
        if (this.field_71295_T) {
            this.field_71295_T = false;
            this.field_71304_b.func_199095_a(this.field_71315_w);
        }
        this.field_71304_b.func_76320_a("root");
        this.func_71190_q(booleanSupplier);
        if (l - this.field_147142_T >= 5000000000L) {
            this.field_147142_T = l;
            this.field_147147_p.func_151319_a(new ServerStatusResponse.Players(this.func_71275_y(), this.func_71233_x()));
            GameProfile[] gameProfileArray = new GameProfile[Math.min(this.func_71233_x(), 12)];
            int \u26032 = MathHelper.func_76136_a(this.field_147146_q, 0, this.func_71233_x() - gameProfileArray.length);
            for (int i = 0; i < gameProfileArray.length; ++i) {
                gameProfileArray[i] = this.field_71318_t.func_181057_v().get(\u26032 + i).func_146103_bH();
            }
            Collections.shuffle(Arrays.asList(gameProfileArray));
            this.field_147147_p.func_151318_b().func_151330_a(gameProfileArray);
        }
        if (this.field_71315_w % 900 == 0) {
            this.field_71304_b.func_76320_a("save");
            this.field_71318_t.func_72389_g();
            this.func_71267_a(true);
            this.field_71304_b.func_76319_b();
        }
        this.field_71304_b.func_76320_a("snooper");
        if (!this.field_71307_n.func_76468_d() && this.field_71315_w > 100) {
            this.field_71307_n.func_76463_a();
        }
        if (this.field_71315_w % 6000 == 0) {
            this.field_71307_n.func_76471_b();
        }
        this.field_71304_b.func_76319_b();
        this.field_71304_b.func_76320_a("tallying");
        long l2 = Util.func_211178_c() - l;
        this.field_71311_j[this.field_71315_w % 100] = l2;
        \u2603 = l2;
        this.field_211152_ao = this.field_211152_ao * 0.8f + (float)\u2603 / 1000000.0f * 0.19999999f;
        this.field_71304_b.func_76319_b();
        this.field_71304_b.func_76319_b();
    }

    public void func_71190_q(BooleanSupplier booleanSupplier) {
        this.field_71304_b.func_76320_a("jobs");
        while ((\u2603 = this.field_175589_i.poll()) != null) {
            Util.func_181617_a(\u2603, field_147145_h);
        }
        this.field_71304_b.func_76318_c("commandFunctions");
        this.func_193030_aL().func_73660_a();
        this.field_71304_b.func_76318_c("levels");
        for (WorldServer worldServer2 : this.func_212370_w()) {
            long l = Util.func_211178_c();
            if (worldServer2.field_73011_w.func_186058_p() == DimensionType.OVERWORLD || this.func_71255_r()) {
                WorldServer worldServer2;
                this.field_71304_b.func_194340_a(() -> "dim-" + worldServer.field_73011_w.func_186058_p().func_186068_a());
                if (this.field_71315_w % 20 == 0) {
                    this.field_71304_b.func_76320_a("timeSync");
                    this.field_71318_t.func_148537_a(new SPacketTimeUpdate(worldServer2.func_82737_E(), worldServer2.func_72820_D(), worldServer2.func_82736_K().func_82766_b("doDaylightCycle")), worldServer2.field_73011_w.func_186058_p());
                    this.field_71304_b.func_76319_b();
                }
                this.field_71304_b.func_76320_a("tick");
                try {
                    worldServer2.func_72835_b(booleanSupplier);
                }
                catch (Throwable throwable) {
                    CrashReport crashReport = CrashReport.func_85055_a(throwable, "Exception ticking world");
                    worldServer2.func_72914_a(crashReport);
                    throw new ReportedException(crashReport);
                }
                try {
                    worldServer2.func_72939_s();
                }
                catch (Throwable throwable) {
                    CrashReport crashReport = CrashReport.func_85055_a(throwable, "Exception ticking world entities");
                    worldServer2.func_72914_a(crashReport);
                    throw new ReportedException(crashReport);
                }
                this.field_71304_b.func_76319_b();
                this.field_71304_b.func_76320_a("tracker");
                worldServer2.func_73039_n().func_72788_a();
                this.field_71304_b.func_76319_b();
                this.field_71304_b.func_76319_b();
            }
            this.field_71312_k.computeIfAbsent((DimensionType)worldServer2.field_73011_w.func_186058_p(), (Function<DimensionType, long[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, func_212377_b(net.minecraft.world.dimension.DimensionType ), (Lnet/minecraft/world/dimension/DimensionType;)[J)())[this.field_71315_w % 100] = Util.func_211178_c() - l;
        }
        this.field_71304_b.func_76318_c("connection");
        this.func_147137_ag().func_151269_c();
        this.field_71304_b.func_76318_c("players");
        this.field_71318_t.func_72374_b();
        this.field_71304_b.func_76318_c("tickables");
        for (int i = 0; i < this.field_71322_p.size(); ++i) {
            this.field_71322_p.get(i).func_73660_a();
        }
        this.field_71304_b.func_76319_b();
    }

    public boolean func_71255_r() {
        return true;
    }

    public void func_82010_a(ITickable iTickable) {
        this.field_71322_p.add(iTickable);
    }

    public static void main(String[] stringArray) {
        Bootstrap.func_151354_b();
        try {
            GameProfileRepository \u26036;
            String \u26038;
            boolean bl = true;
            GameProfileRepository \u26032 = null;
            String \u26033 = ".";
            GameProfileRepository \u26034 = null;
            bl2 = false;
            bl3 = false;
            bl4 = false;
            int \u26035 = -1;
            for (int i = 0; i < stringArray.length; ++i) {
                \u26038 = stringArray[i];
                \u26036 = i == stringArray.length - 1 ? null : stringArray[i + 1];
                boolean \u26037 = false;
                if ("nogui".equals(\u26038) || "--nogui".equals(\u26038)) {
                    bl = false;
                } else if ("--port".equals(\u26038) && \u26036 != null) {
                    \u26037 = true;
                    try {
                        \u26035 = Integer.parseInt((String)\u26036);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if ("--singleplayer".equals(\u26038) && \u26036 != null) {
                    \u26037 = true;
                    \u26032 = \u26036;
                } else if ("--universe".equals(\u26038) && \u26036 != null) {
                    \u26037 = true;
                    \u26033 = \u26036;
                } else if ("--world".equals(\u26038) && \u26036 != null) {
                    \u26037 = true;
                    \u26034 = \u26036;
                } else if ("--demo".equals(\u26038)) {
                    boolean bl2 = true;
                } else if ("--bonusChest".equals(\u26038)) {
                    boolean bl3 = true;
                } else if ("--forceUpgrade".equals(\u26038)) {
                    boolean bl4 = true;
                }
                if (!\u26037) continue;
                ++i;
            }
            YggdrasilAuthenticationService yggdrasilAuthenticationService = new YggdrasilAuthenticationService(Proxy.NO_PROXY, UUID.randomUUID().toString());
            \u26038 = yggdrasilAuthenticationService.createMinecraftSessionService();
            \u26036 = yggdrasilAuthenticationService.createProfileRepository();
            PlayerProfileCache \u26039 = new PlayerProfileCache(\u26036, new File(\u26033, field_152367_a.getName()));
            final DedicatedServer \u260310 = new DedicatedServer(new File(\u26033), DataFixesManager.func_210901_a(), yggdrasilAuthenticationService, (MinecraftSessionService)\u26038, \u26036, \u26039);
            if (\u26032 != null) {
                \u260310.func_71224_l((String)\u26032);
            }
            if (\u26034 != null) {
                \u260310.func_71261_m((String)\u26034);
            }
            if (\u26035 >= 0) {
                \u260310.func_71208_b(\u26035);
            }
            if (bl2) {
                \u260310.func_71204_b(true);
            }
            if (bl3) {
                \u260310.func_71194_c(true);
            }
            if (bl && !GraphicsEnvironment.isHeadless()) {
                \u260310.func_120011_ar();
            }
            if (bl4) {
                \u260310.func_212204_b(true);
            }
            \u260310.func_71256_s();
            Thread \u260311 = new Thread("Server Shutdown Thread"){

                @Override
                public void run() {
                    \u260310.func_71260_j();
                }
            };
            \u260311.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(field_147145_h));
            Runtime.getRuntime().addShutdownHook(\u260311);
        }
        catch (Exception exception) {
            field_147145_h.fatal("Failed to start the minecraft server", (Throwable)exception);
        }
    }

    protected void func_212204_b(boolean bl) {
        this.field_212205_ao = bl;
    }

    public void func_71256_s() {
        this.field_175590_aa = new Thread((Runnable)this, "Server thread");
        this.field_175590_aa.setUncaughtExceptionHandler((thread, throwable) -> field_147145_h.error((Object)throwable));
        this.field_175590_aa.start();
    }

    public File func_71209_f(String string) {
        return new File(this.func_71238_n(), string);
    }

    public void func_71244_g(String string) {
        field_147145_h.info(string);
    }

    public void func_71236_h(String string) {
        field_147145_h.warn(string);
    }

    public WorldServer func_71218_a(DimensionType dimensionType) {
        return this.field_71305_c.get(dimensionType);
    }

    public Iterable<WorldServer> func_212370_w() {
        return this.field_71305_c.values();
    }

    public String func_71249_w() {
        return "1.13.2";
    }

    public int func_71233_x() {
        return this.field_71318_t.func_72394_k();
    }

    public int func_71275_y() {
        return this.field_71318_t.func_72352_l();
    }

    public String[] func_71213_z() {
        return this.field_71318_t.func_72369_d();
    }

    public boolean func_71239_B() {
        return false;
    }

    public void func_71201_j(String string) {
        field_147145_h.error(string);
    }

    public void func_71198_k(String string) {
        if (this.func_71239_B()) {
            field_147145_h.info(string);
        }
    }

    public String getServerModName() {
        return "vanilla";
    }

    public CrashReport func_71230_b(CrashReport crashReport) {
        crashReport.func_85056_g().func_189529_a("Profiler Position", () -> this.field_71304_b.func_199094_a() ? this.field_71304_b.func_76322_c() : "N/A (disabled)");
        if (this.field_71318_t != null) {
            crashReport.func_85056_g().func_189529_a("Player Count", () -> this.field_71318_t.func_72394_k() + " / " + this.field_71318_t.func_72352_l() + "; " + this.field_71318_t.func_181057_v());
        }
        crashReport.func_85056_g().func_189529_a("Data Packs", () -> {
            StringBuilder stringBuilder = new StringBuilder();
            for (ResourcePackInfo resourcePackInfo : this.field_195577_ad.func_198980_d()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(resourcePackInfo.func_195790_f());
                if (resourcePackInfo.func_195791_d().func_198968_a()) continue;
                stringBuilder.append(" (incompatible)");
            }
            return stringBuilder.toString();
        });
        return crashReport;
    }

    public boolean func_175578_N() {
        return this.field_71308_o != null;
    }

    @Override
    public void func_145747_a(ITextComponent iTextComponent) {
        field_147145_h.info(iTextComponent.getString());
    }

    public KeyPair func_71250_E() {
        return this.field_71292_I;
    }

    public int func_71215_F() {
        return this.field_71319_s;
    }

    public void func_71208_b(int n) {
        this.field_71319_s = n;
    }

    public String func_71214_G() {
        return this.field_71293_J;
    }

    public void func_71224_l(String string) {
        this.field_71293_J = string;
    }

    public boolean func_71264_H() {
        return this.field_71293_J != null;
    }

    public String func_71270_I() {
        return this.field_71294_K;
    }

    public void func_71261_m(String string) {
        this.field_71294_K = string;
    }

    public void func_71246_n(String string) {
        this.field_71287_L = string;
    }

    public String func_71221_J() {
        return this.field_71287_L;
    }

    public void func_71253_a(KeyPair keyPair) {
        this.field_71292_I = keyPair;
    }

    public void func_147139_a(EnumDifficulty enumDifficulty) {
        for (WorldServer worldServer : this.func_212370_w()) {
            if (worldServer.func_72912_H().func_76093_s()) {
                worldServer.func_72912_H().func_176144_a(EnumDifficulty.HARD);
                worldServer.func_72891_a(true, true);
                continue;
            }
            if (this.func_71264_H()) {
                worldServer.func_72912_H().func_176144_a(enumDifficulty);
                worldServer.func_72891_a(worldServer.func_175659_aa() != EnumDifficulty.PEACEFUL, true);
                continue;
            }
            worldServer.func_72912_H().func_176144_a(enumDifficulty);
            worldServer.func_72891_a(this.func_71193_K(), this.field_71324_y);
        }
    }

    public boolean func_71193_K() {
        return true;
    }

    public boolean func_71242_L() {
        return this.field_71288_M;
    }

    public void func_71204_b(boolean bl) {
        this.field_71288_M = bl;
    }

    public void func_71194_c(boolean bl) {
        this.field_71289_N = bl;
    }

    public ISaveFormat func_71254_M() {
        return this.field_71310_m;
    }

    public String func_147133_T() {
        return this.field_147141_M;
    }

    public String func_175581_ab() {
        return this.field_175588_P;
    }

    public void func_180507_a_(String string, String string2) {
        this.field_147141_M = string;
        this.field_175588_P = string2;
    }

    @Override
    public void func_70000_a(Snooper snooper2) {
        Snooper snooper2;
        snooper2.func_152768_a("whitelist_enabled", false);
        snooper2.func_152768_a("whitelist_count", 0);
        if (this.field_71318_t != null) {
            snooper2.func_152768_a("players_current", this.func_71233_x());
            snooper2.func_152768_a("players_max", this.func_71275_y());
            snooper2.func_152768_a("players_seen", this.field_71318_t.func_72373_m().length);
        }
        snooper2.func_152768_a("uses_auth", this.field_71325_x);
        snooper2.func_152768_a("gui_state", this.func_71279_ae() ? "enabled" : "disabled");
        snooper2.func_152768_a("run_time", (Util.func_211177_b() - snooper2.func_130105_g()) / 60L * 1000L);
        snooper2.func_152768_a("avg_tick_ms", (int)(MathHelper.func_76127_a(this.field_71311_j) * 1.0E-6));
        int n = 0;
        for (WorldServer worldServer : this.func_212370_w()) {
            if (worldServer == null) continue;
            WorldInfo worldInfo = worldServer.func_72912_H();
            snooper2.func_152768_a("world[" + n + "][dimension]", worldServer.field_73011_w.func_186058_p());
            snooper2.func_152768_a("world[" + n + "][mode]", (Object)worldInfo.func_76077_q());
            snooper2.func_152768_a("world[" + n + "][difficulty]", (Object)worldServer.func_175659_aa());
            snooper2.func_152768_a("world[" + n + "][hardcore]", worldInfo.func_76093_s());
            snooper2.func_152768_a("world[" + n + "][generator_name]", worldInfo.func_76067_t().func_211888_a());
            snooper2.func_152768_a("world[" + n + "][generator_version]", worldInfo.func_76067_t().func_77131_c());
            snooper2.func_152768_a("world[" + n + "][height]", this.field_71280_D);
            snooper2.func_152768_a("world[" + n + "][chunks_loaded]", worldServer.func_72863_F().func_73152_e());
            ++n;
        }
        snooper2.func_152768_a("worlds", n);
    }

    public boolean func_70002_Q() {
        return true;
    }

    public abstract boolean func_71262_S();

    public boolean func_71266_T() {
        return this.field_71325_x;
    }

    public void func_71229_d(boolean bl) {
        this.field_71325_x = bl;
    }

    public boolean func_190518_ac() {
        return this.field_190519_A;
    }

    public void func_190517_e(boolean bl) {
        this.field_190519_A = bl;
    }

    public boolean func_71268_U() {
        return this.field_71324_y;
    }

    public void func_71251_e(boolean bl) {
        this.field_71324_y = bl;
    }

    public boolean func_71220_V() {
        return this.field_71323_z;
    }

    public abstract boolean func_181035_ah();

    public void func_71257_f(boolean bl) {
        this.field_71323_z = bl;
    }

    public boolean func_71219_W() {
        return this.field_71284_A;
    }

    public void func_71188_g(boolean bl) {
        this.field_71284_A = bl;
    }

    public boolean func_71231_X() {
        return this.field_71285_B;
    }

    public void func_71245_h(boolean bl) {
        this.field_71285_B = bl;
    }

    public abstract boolean func_82356_Z();

    public String func_71273_Y() {
        return this.field_71286_C;
    }

    public void func_71205_p(String string) {
        this.field_71286_C = string;
    }

    public int func_71207_Z() {
        return this.field_71280_D;
    }

    public void func_71191_d(int n) {
        this.field_71280_D = n;
    }

    public boolean func_71241_aa() {
        return this.field_71316_v;
    }

    public PlayerList func_184103_al() {
        return this.field_71318_t;
    }

    public void func_184105_a(PlayerList playerList) {
        this.field_71318_t = playerList;
    }

    public abstract boolean func_71344_c();

    public void func_71235_a(GameType gameType) {
        for (WorldServer worldServer : this.func_212370_w()) {
            worldServer.func_72912_H().func_76060_a(gameType);
        }
    }

    public NetworkSystem func_147137_ag() {
        return this.field_147144_o;
    }

    public boolean func_71200_ad() {
        return this.field_71296_Q;
    }

    public boolean func_71279_ae() {
        return false;
    }

    public abstract boolean func_195565_a(GameType var1, boolean var2, int var3);

    public int func_71259_af() {
        return this.field_71315_w;
    }

    public void func_71223_ag() {
        this.field_71295_T = true;
    }

    public Snooper func_80003_ah() {
        return this.field_71307_n;
    }

    public int func_82357_ak() {
        return 16;
    }

    public boolean func_175579_a(World world, BlockPos blockPos, EntityPlayer entityPlayer) {
        return false;
    }

    public void func_104055_i(boolean bl) {
        this.field_104057_T = bl;
    }

    public boolean func_104056_am() {
        return this.field_104057_T;
    }

    public int func_143007_ar() {
        return this.field_143008_E;
    }

    public void func_143006_e(int n) {
        this.field_143008_E = n;
    }

    public MinecraftSessionService func_147130_as() {
        return this.field_147143_S;
    }

    public GameProfileRepository func_152359_aw() {
        return this.field_152365_W;
    }

    public PlayerProfileCache func_152358_ax() {
        return this.field_152366_X;
    }

    public ServerStatusResponse func_147134_at() {
        return this.field_147147_p;
    }

    public void func_147132_au() {
        this.field_147142_T = 0L;
    }

    public int func_175580_aG() {
        return 29999984;
    }

    public <V> ListenableFuture<V> func_175586_a(Callable<V> callable2) {
        Validate.notNull(callable2);
        if (!this.func_152345_ab() && !this.func_71241_aa()) {
            ListenableFutureTask listenableFutureTask = ListenableFutureTask.create(callable2);
            this.field_175589_i.add((FutureTask<?>)listenableFutureTask);
            return listenableFutureTask;
        }
        try {
            Callable<V> callable2;
            return Futures.immediateFuture(callable2.call());
        }
        catch (Exception exception) {
            return Futures.immediateFailedCheckedFuture((Exception)exception);
        }
    }

    @Override
    public ListenableFuture<Object> func_152344_a(Runnable runnable) {
        Validate.notNull((Object)runnable);
        return this.func_175586_a(Executors.callable(runnable));
    }

    @Override
    public boolean func_152345_ab() {
        return Thread.currentThread() == this.field_175590_aa;
    }

    public int func_175577_aI() {
        return 256;
    }

    public long func_211150_az() {
        return this.field_211151_aa;
    }

    public Thread func_175583_aK() {
        return this.field_175590_aa;
    }

    public DataFixer func_195563_aC() {
        return this.field_184112_s;
    }

    public int func_184108_a(@Nullable WorldServer worldServer) {
        if (worldServer != null) {
            return worldServer.func_82736_K().func_180263_c("spawnRadius");
        }
        return 10;
    }

    public AdvancementManager func_191949_aK() {
        return this.field_200257_ak;
    }

    public FunctionManager func_193030_aL() {
        return this.field_200258_al;
    }

    public void func_193031_aM() {
        if (!this.func_152345_ab()) {
            this.func_152344_a(this::func_193031_aM);
            return;
        }
        this.func_184103_al().func_72389_g();
        this.field_195577_ad.func_198983_a();
        this.func_195568_a(this.func_71218_a(DimensionType.OVERWORLD).func_72912_H());
        this.func_184103_al().func_193244_w();
    }

    private void func_195568_a(WorldInfo worldInfo) {
        ArrayList arrayList = Lists.newArrayList(this.field_195577_ad.func_198980_d());
        for (ResourcePackInfo resourcePackInfo2 : this.field_195577_ad.func_198978_b()) {
            if (worldInfo.func_197719_N().contains(resourcePackInfo2.func_195790_f()) || arrayList.contains(resourcePackInfo2)) continue;
            field_147145_h.info("Found new data pack {}, loading it automatically", (Object)resourcePackInfo2.func_195790_f());
            resourcePackInfo2.func_195792_i().func_198993_a(arrayList, resourcePackInfo2, resourcePackInfo -> resourcePackInfo, false);
        }
        this.field_195577_ad.func_198985_a(arrayList);
        \u2603 = Lists.newArrayList();
        this.field_195577_ad.func_198980_d().forEach(resourcePackInfo -> \u2603.add(resourcePackInfo.func_195796_e()));
        this.field_195576_ac.func_199005_a(\u2603);
        worldInfo.func_197720_O().clear();
        worldInfo.func_197719_N().clear();
        this.field_195577_ad.func_198980_d().forEach(resourcePackInfo -> worldInfo.func_197720_O().add(resourcePackInfo.func_195790_f()));
        this.field_195577_ad.func_198978_b().forEach(resourcePackInfo -> {
            if (!this.field_195577_ad.func_198980_d().contains(resourcePackInfo)) {
                worldInfo.func_197719_N().add(resourcePackInfo.func_195790_f());
            }
        });
    }

    public void func_205743_a(CommandSource commandSource) {
        if (!this.func_205744_aT()) {
            return;
        }
        PlayerList playerList = commandSource.func_197028_i().func_184103_al();
        UserListWhitelist \u26032 = playerList.func_152599_k();
        if (!\u26032.func_152689_b()) {
            return;
        }
        ArrayList \u26033 = Lists.newArrayList(playerList.func_181057_v());
        for (EntityPlayerMP entityPlayerMP : \u26033) {
            if (\u26032.func_152705_a(entityPlayerMP.func_146103_bH())) continue;
            entityPlayerMP.field_71135_a.func_194028_b(new TextComponentTranslation("multiplayer.disconnect.not_whitelisted", new Object[0]));
        }
    }

    public IReloadableResourceManager func_195570_aG() {
        return this.field_195576_ac;
    }

    public ResourcePackList<ResourcePackInfo> func_195561_aH() {
        return this.field_195577_ad;
    }

    public ITextComponent func_200246_aJ() {
        return this.field_71302_d;
    }

    public int func_195566_aK() {
        return this.field_71303_e;
    }

    public Commands func_195571_aL() {
        return this.field_195579_af;
    }

    public CommandSource func_195573_aM() {
        return new CommandSource(this, this.func_71218_a(DimensionType.OVERWORLD) == null ? Vec3d.field_186680_a : new Vec3d(this.func_71218_a(DimensionType.OVERWORLD).func_175694_M()), Vec2f.field_189974_a, this.func_71218_a(DimensionType.OVERWORLD), 4, "Server", new TextComponentString("Server"), this, null);
    }

    @Override
    public boolean func_195039_a() {
        return true;
    }

    @Override
    public boolean func_195040_b() {
        return true;
    }

    public RecipeManager func_199529_aN() {
        return this.field_199530_ag;
    }

    public NetworkTagManager func_199731_aO() {
        return this.field_199736_ah;
    }

    public ServerScoreboard func_200251_aP() {
        return this.field_200255_ai;
    }

    public LootTableManager func_200249_aQ() {
        return this.field_200256_aj;
    }

    public GameRules func_200252_aR() {
        return this.func_71218_a(DimensionType.OVERWORLD).func_82736_K();
    }

    public CustomBossEvents func_201300_aS() {
        return this.field_201301_aj;
    }

    public boolean func_205744_aT() {
        return this.field_205745_an;
    }

    public void func_205741_k(boolean bl) {
        this.field_205745_an = bl;
    }

    public float func_211149_aT() {
        return this.field_211152_ao;
    }

    public int func_211833_a(GameProfile gameProfile) {
        if (this.func_184103_al().func_152596_g(gameProfile)) {
            UserListOpsEntry userListOpsEntry = (UserListOpsEntry)this.func_184103_al().func_152603_m().func_152683_b(gameProfile);
            if (userListOpsEntry != null) {
                return userListOpsEntry.func_152644_a();
            }
            if (this.func_71264_H()) {
                if (this.func_71214_G().equals(gameProfile.getName())) {
                    return 4;
                }
                return this.func_184103_al().func_206257_x() ? 4 : 0;
            }
            return this.func_110455_j();
        }
        return 0;
    }

    private static /* synthetic */ long[] func_212377_b(DimensionType dimensionType) {
        return new long[100];
    }
}

