/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.management;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.Dimension;

public class PlayerChunkMap {
    private static final Predicate<EntityPlayerMP> field_187308_a = entityPlayerMP -> entityPlayerMP != null && !entityPlayerMP.func_175149_v();
    private static final Predicate<EntityPlayerMP> field_187309_b = entityPlayerMP -> entityPlayerMP != null && (!entityPlayerMP.func_175149_v() || entityPlayerMP.func_71121_q().func_82736_K().func_82766_b("spectatorsGenerateChunks"));
    private final WorldServer field_72701_a;
    private final List<EntityPlayerMP> field_72699_b = Lists.newArrayList();
    private final Long2ObjectMap<PlayerChunkMapEntry> field_72700_c = new Long2ObjectOpenHashMap(4096);
    private final Set<PlayerChunkMapEntry> field_72697_d = Sets.newHashSet();
    private final List<PlayerChunkMapEntry> field_187310_g = Lists.newLinkedList();
    private final List<PlayerChunkMapEntry> field_187311_h = Lists.newLinkedList();
    private final List<PlayerChunkMapEntry> field_111193_e = Lists.newArrayList();
    private int field_72698_e;
    private long field_111192_g;
    private boolean field_187312_l = true;
    private boolean field_187313_m = true;

    public PlayerChunkMap(WorldServer worldServer) {
        this.field_72701_a = worldServer;
        this.func_152622_a(worldServer.func_73046_m().func_184103_al().func_72395_o());
    }

    public WorldServer func_72688_a() {
        return this.field_72701_a;
    }

    public Iterator<Chunk> func_187300_b() {
        final Iterator<PlayerChunkMapEntry> iterator = this.field_111193_e.iterator();
        return new AbstractIterator<Chunk>(){

            protected Chunk computeNext() {
                while (iterator.hasNext()) {
                    PlayerChunkMapEntry playerChunkMapEntry = (PlayerChunkMapEntry)iterator.next();
                    Chunk \u26032 = playerChunkMapEntry.func_187266_f();
                    if (\u26032 == null) continue;
                    if (!\u26032.func_186035_j()) {
                        return \u26032;
                    }
                    if (!playerChunkMapEntry.func_187271_a(128.0, field_187308_a)) continue;
                    return \u26032;
                }
                return (Chunk)this.endOfData();
            }

            protected /* synthetic */ Object computeNext() {
                return this.computeNext();
            }
        };
    }

    public void func_72693_b() {
        Dimension dimension;
        long l = this.field_72701_a.func_82737_E();
        if (l - this.field_111192_g > 8000L) {
            this.field_111192_g = l;
            for (int n = 0; n < this.field_111193_e.size(); ++n) {
                PlayerChunkMapEntry playerChunkMapEntry3 = this.field_111193_e.get(n);
                playerChunkMapEntry3.func_187280_d();
                playerChunkMapEntry3.func_187279_c();
            }
        }
        if (!this.field_72697_d.isEmpty()) {
            for (PlayerChunkMapEntry playerChunkMapEntry4 : this.field_72697_d) {
                playerChunkMapEntry4.func_187280_d();
            }
            this.field_72697_d.clear();
        }
        if (this.field_187312_l && l % 4L == 0L) {
            this.field_187312_l = false;
            Collections.sort(this.field_187311_h, (playerChunkMapEntry, playerChunkMapEntry2) -> ComparisonChain.start().compare(playerChunkMapEntry.func_187270_g(), playerChunkMapEntry2.func_187270_g()).result());
        }
        if (this.field_187313_m && l % 4L == 2L) {
            this.field_187313_m = false;
            Collections.sort(this.field_187310_g, (playerChunkMapEntry, playerChunkMapEntry2) -> ComparisonChain.start().compare(playerChunkMapEntry.func_187270_g(), playerChunkMapEntry2.func_187270_g()).result());
        }
        if (!this.field_187311_h.isEmpty()) {
            long l2 = Util.func_211178_c() + 50000000L;
            int n2 = 49;
            Iterator<PlayerChunkMapEntry> \u26032 = this.field_187311_h.iterator();
            while (\u26032.hasNext()) {
                PlayerChunkMapEntry playerChunkMapEntry3 = \u26032.next();
                if (playerChunkMapEntry3.func_187266_f() != null || !playerChunkMapEntry3.func_187268_a(\u2603 = playerChunkMapEntry3.func_187269_a(field_187309_b))) continue;
                \u26032.remove();
                if (playerChunkMapEntry3.func_187272_b()) {
                    this.field_187310_g.remove(playerChunkMapEntry3);
                }
                if (--n2 >= 0 && Util.func_211178_c() <= l2) continue;
                break;
            }
        }
        if (!this.field_187310_g.isEmpty()) {
            int n = 81;
            Iterator<PlayerChunkMapEntry> iterator = this.field_187310_g.iterator();
            while (iterator.hasNext()) {
                PlayerChunkMapEntry playerChunkMapEntry4 = iterator.next();
                if (!playerChunkMapEntry4.func_187272_b()) continue;
                iterator.remove();
                if (--n >= 0) continue;
                break;
            }
        }
        if (this.field_72699_b.isEmpty() && !(dimension = this.field_72701_a.field_73011_w).func_76567_e()) {
            this.field_72701_a.func_72863_F().func_73240_a();
        }
    }

    public boolean func_152621_a(int n, int n2) {
        long l = PlayerChunkMap.func_187307_d(n, n2);
        return this.field_72700_c.get(l) != null;
    }

    @Nullable
    public PlayerChunkMapEntry func_187301_b(int n, int n2) {
        return (PlayerChunkMapEntry)this.field_72700_c.get(PlayerChunkMap.func_187307_d(n, n2));
    }

    private PlayerChunkMapEntry func_187302_c(int n, int n2) {
        long l = PlayerChunkMap.func_187307_d(n, n2);
        PlayerChunkMapEntry \u26032 = (PlayerChunkMapEntry)this.field_72700_c.get(l);
        if (\u26032 == null) {
            \u26032 = new PlayerChunkMapEntry(this, n, n2);
            this.field_72700_c.put(l, (Object)\u26032);
            this.field_111193_e.add(\u26032);
            if (\u26032.func_187266_f() == null) {
                this.field_187311_h.add(\u26032);
            }
            if (!\u26032.func_187272_b()) {
                this.field_187310_g.add(\u26032);
            }
        }
        return \u26032;
    }

    public void func_180244_a(BlockPos blockPos) {
        int n = blockPos.func_177958_n() >> 4;
        PlayerChunkMapEntry \u26032 = this.func_187301_b(n, \u2603 = blockPos.func_177952_p() >> 4);
        if (\u26032 != null) {
            \u26032.func_187265_a(blockPos.func_177958_n() & 0xF, blockPos.func_177956_o(), blockPos.func_177952_p() & 0xF);
        }
    }

    public void func_72683_a(EntityPlayerMP entityPlayerMP) {
        int n = (int)entityPlayerMP.field_70165_t >> 4;
        \u2603 = (int)entityPlayerMP.field_70161_v >> 4;
        entityPlayerMP.field_71131_d = entityPlayerMP.field_70165_t;
        entityPlayerMP.field_71132_e = entityPlayerMP.field_70161_v;
        for (\u2603 = n - this.field_72698_e; \u2603 <= n + this.field_72698_e; ++\u2603) {
            for (\u2603 = \u2603 - this.field_72698_e; \u2603 <= \u2603 + this.field_72698_e; ++\u2603) {
                this.func_187302_c(\u2603, \u2603).func_187276_a(entityPlayerMP);
            }
        }
        this.field_72699_b.add(entityPlayerMP);
        this.func_187306_e();
    }

    public void func_72695_c(EntityPlayerMP entityPlayerMP2) {
        EntityPlayerMP entityPlayerMP2;
        int n = (int)entityPlayerMP2.field_71131_d >> 4;
        \u2603 = (int)entityPlayerMP2.field_71132_e >> 4;
        for (\u2603 = n - this.field_72698_e; \u2603 <= n + this.field_72698_e; ++\u2603) {
            for (\u2603 = \u2603 - this.field_72698_e; \u2603 <= \u2603 + this.field_72698_e; ++\u2603) {
                PlayerChunkMapEntry playerChunkMapEntry = this.func_187301_b(\u2603, \u2603);
                if (playerChunkMapEntry == null) continue;
                playerChunkMapEntry.func_187277_b(entityPlayerMP2);
            }
        }
        this.field_72699_b.remove(entityPlayerMP2);
        this.func_187306_e();
    }

    private boolean func_72684_a(int n, int n2, int n3, int n4, int n5) {
        \u2603 = n - n3;
        \u2603 = n2 - n4;
        if (\u2603 < -n5 || \u2603 > n5) {
            return false;
        }
        return \u2603 >= -n5 && \u2603 <= n5;
    }

    public void func_72685_d(EntityPlayerMP entityPlayerMP) {
        int n = (int)entityPlayerMP.field_70165_t >> 4;
        \u2603 = (int)entityPlayerMP.field_70161_v >> 4;
        double \u26032 = entityPlayerMP.field_71131_d - entityPlayerMP.field_70165_t;
        double \u26033 = entityPlayerMP.field_71132_e - entityPlayerMP.field_70161_v;
        double \u26034 = \u26032 * \u26032 + \u26033 * \u26033;
        if (\u26034 < 64.0) {
            return;
        }
        \u2603 = (int)entityPlayerMP.field_71131_d >> 4;
        \u2603 = (int)entityPlayerMP.field_71132_e >> 4;
        \u2603 = this.field_72698_e;
        \u2603 = n - \u2603;
        \u2603 = \u2603 - \u2603;
        if (\u2603 == 0 && \u2603 == 0) {
            return;
        }
        for (\u2603 = n - \u2603; \u2603 <= n + \u2603; ++\u2603) {
            for (\u2603 = \u2603 - \u2603; \u2603 <= \u2603 + \u2603; ++\u2603) {
                if (!this.func_72684_a(\u2603, \u2603, \u2603, \u2603, \u2603)) {
                    this.func_187302_c(\u2603, \u2603).func_187276_a(entityPlayerMP);
                }
                if (this.func_72684_a(\u2603 - \u2603, \u2603 - \u2603, n, \u2603, \u2603) || (\u2603 = this.func_187301_b(\u2603 - \u2603, \u2603 - \u2603)) == null) continue;
                \u2603.func_187277_b(entityPlayerMP);
            }
        }
        entityPlayerMP.field_71131_d = entityPlayerMP.field_70165_t;
        entityPlayerMP.field_71132_e = entityPlayerMP.field_70161_v;
        this.func_187306_e();
    }

    public boolean func_72694_a(EntityPlayerMP entityPlayerMP, int n, int n2) {
        PlayerChunkMapEntry playerChunkMapEntry = this.func_187301_b(n, n2);
        return playerChunkMapEntry != null && playerChunkMapEntry.func_187275_d(entityPlayerMP) && playerChunkMapEntry.func_187274_e();
    }

    public void func_152622_a(int n2) {
        int n2;
        if ((n2 = MathHelper.func_76125_a(n2, 3, 32)) == this.field_72698_e) {
            return;
        }
        \u2603 = n2 - this.field_72698_e;
        ArrayList arrayList = Lists.newArrayList(this.field_72699_b);
        for (EntityPlayerMP entityPlayerMP : arrayList) {
            int n3 = (int)entityPlayerMP.field_70165_t >> 4;
            \u2603 = (int)entityPlayerMP.field_70161_v >> 4;
            if (\u2603 > 0) {
                for (i = n3 - n2; i <= n3 + n2; ++i) {
                    for (\u2603 = \u2603 - n2; \u2603 <= \u2603 + n2; ++\u2603) {
                        PlayerChunkMapEntry playerChunkMapEntry = this.func_187302_c(i, \u2603);
                        if (playerChunkMapEntry.func_187275_d(entityPlayerMP)) continue;
                        playerChunkMapEntry.func_187276_a(entityPlayerMP);
                    }
                }
                continue;
            }
            for (int i = n3 - this.field_72698_e; i <= n3 + this.field_72698_e; ++i) {
                for (\u2603 = \u2603 - this.field_72698_e; \u2603 <= \u2603 + this.field_72698_e; ++\u2603) {
                    if (this.func_72684_a(i, \u2603, n3, \u2603, n2)) continue;
                    this.func_187302_c(i, \u2603).func_187277_b(entityPlayerMP);
                }
            }
        }
        this.field_72698_e = n2;
        this.func_187306_e();
    }

    private void func_187306_e() {
        this.field_187312_l = true;
        this.field_187313_m = true;
    }

    public static int func_72686_a(int n) {
        return n * 16 - 16;
    }

    private static long func_187307_d(int n, int n2) {
        return (long)n + Integer.MAX_VALUE | (long)n2 + Integer.MAX_VALUE << 32;
    }

    public void func_187304_a(PlayerChunkMapEntry playerChunkMapEntry) {
        this.field_72697_d.add(playerChunkMapEntry);
    }

    public void func_187305_b(PlayerChunkMapEntry playerChunkMapEntry) {
        ChunkPos chunkPos = playerChunkMapEntry.func_187264_a();
        long \u26032 = PlayerChunkMap.func_187307_d(chunkPos.field_77276_a, chunkPos.field_77275_b);
        playerChunkMapEntry.func_187279_c();
        this.field_72700_c.remove(\u26032);
        this.field_111193_e.remove(playerChunkMapEntry);
        this.field_72697_d.remove(playerChunkMapEntry);
        this.field_187310_g.remove(playerChunkMapEntry);
        this.field_187311_h.remove(playerChunkMapEntry);
        Chunk \u26033 = playerChunkMapEntry.func_187266_f();
        if (\u26033 != null) {
            this.func_72688_a().func_72863_F().func_189549_a(\u26033);
        }
    }
}

