/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.management;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.network.play.server.SPacketChunkData;
import net.minecraft.network.play.server.SPacketMultiBlockChange;
import net.minecraft.network.play.server.SPacketUnloadChunk;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerChunkMapEntry {
    private static final Logger field_187281_a = LogManager.getLogger();
    private final PlayerChunkMap field_187282_b;
    private final List<EntityPlayerMP> field_187283_c = Lists.newArrayList();
    private final ChunkPos field_187284_d;
    private final short[] field_187285_e = new short[64];
    @Nullable
    private Chunk field_187286_f;
    private int field_187287_g;
    private int field_187288_h;
    private long field_187289_i;
    private boolean field_187290_j;

    public PlayerChunkMapEntry(PlayerChunkMap playerChunkMap, int n, int n2) {
        this.field_187282_b = playerChunkMap;
        this.field_187284_d = new ChunkPos(n, n2);
        ChunkProviderServer chunkProviderServer = playerChunkMap.func_72688_a().func_72863_F();
        chunkProviderServer.func_212469_a(n, n2);
        this.field_187286_f = chunkProviderServer.func_186025_d(n, n2, true, false);
    }

    public ChunkPos func_187264_a() {
        return this.field_187284_d;
    }

    public void func_187276_a(EntityPlayerMP entityPlayerMP) {
        if (this.field_187283_c.contains(entityPlayerMP)) {
            field_187281_a.debug("Failed to add player. {} already is in chunk {}, {}", (Object)entityPlayerMP, (Object)this.field_187284_d.field_77276_a, (Object)this.field_187284_d.field_77275_b);
            return;
        }
        if (this.field_187283_c.isEmpty()) {
            this.field_187289_i = this.field_187282_b.func_72688_a().func_82737_E();
        }
        this.field_187283_c.add(entityPlayerMP);
        if (this.field_187290_j) {
            this.func_187278_c(entityPlayerMP);
        }
    }

    public void func_187277_b(EntityPlayerMP entityPlayerMP) {
        if (!this.field_187283_c.contains(entityPlayerMP)) {
            return;
        }
        if (this.field_187290_j) {
            entityPlayerMP.field_71135_a.func_147359_a(new SPacketUnloadChunk(this.field_187284_d.field_77276_a, this.field_187284_d.field_77275_b));
        }
        this.field_187283_c.remove(entityPlayerMP);
        if (this.field_187283_c.isEmpty()) {
            this.field_187282_b.func_187305_b(this);
        }
    }

    public boolean func_187268_a(boolean bl) {
        if (this.field_187286_f != null) {
            return true;
        }
        this.field_187286_f = this.field_187282_b.func_72688_a().func_72863_F().func_186025_d(this.field_187284_d.field_77276_a, this.field_187284_d.field_77275_b, true, bl);
        return this.field_187286_f != null;
    }

    public boolean func_187272_b() {
        if (this.field_187290_j) {
            return true;
        }
        if (this.field_187286_f == null) {
            return false;
        }
        if (!this.field_187286_f.func_150802_k()) {
            return false;
        }
        this.field_187287_g = 0;
        this.field_187288_h = 0;
        this.field_187290_j = true;
        if (!this.field_187283_c.isEmpty()) {
            SPacketChunkData sPacketChunkData = new SPacketChunkData(this.field_187286_f, 65535);
            for (EntityPlayerMP entityPlayerMP : this.field_187283_c) {
                entityPlayerMP.field_71135_a.func_147359_a(sPacketChunkData);
                this.field_187282_b.func_72688_a().func_73039_n().func_85172_a(entityPlayerMP, this.field_187286_f);
            }
        }
        return true;
    }

    public void func_187278_c(EntityPlayerMP entityPlayerMP) {
        if (!this.field_187290_j) {
            return;
        }
        entityPlayerMP.field_71135_a.func_147359_a(new SPacketChunkData(this.field_187286_f, 65535));
        this.field_187282_b.func_72688_a().func_73039_n().func_85172_a(entityPlayerMP, this.field_187286_f);
    }

    public void func_187279_c() {
        long l = this.field_187282_b.func_72688_a().func_82737_E();
        if (this.field_187286_f != null) {
            this.field_187286_f.func_177415_c(this.field_187286_f.func_177416_w() + l - this.field_187289_i);
        }
        this.field_187289_i = l;
    }

    public void func_187265_a(int n, int n2, int n3) {
        if (!this.field_187290_j) {
            return;
        }
        if (this.field_187287_g == 0) {
            this.field_187282_b.func_187304_a(this);
        }
        this.field_187288_h |= 1 << (n2 >> 4);
        if (this.field_187287_g < 64) {
            short s = (short)(n << 12 | n3 << 8 | n2);
            for (int i = 0; i < this.field_187287_g; ++i) {
                if (this.field_187285_e[i] != s) continue;
                return;
            }
            this.field_187285_e[this.field_187287_g++] = s;
        }
    }

    public void func_187267_a(Packet<?> packet) {
        if (!this.field_187290_j) {
            return;
        }
        for (int i = 0; i < this.field_187283_c.size(); ++i) {
            this.field_187283_c.get((int)i).field_71135_a.func_147359_a(packet);
        }
    }

    public void func_187280_d() {
        if (!this.field_187290_j || this.field_187286_f == null) {
            return;
        }
        if (this.field_187287_g == 0) {
            return;
        }
        if (this.field_187287_g == 1) {
            int n = (this.field_187285_e[0] >> 12 & 0xF) + this.field_187284_d.field_77276_a * 16;
            \u2603 = this.field_187285_e[0] & 0xFF;
            \u2603 = (this.field_187285_e[0] >> 8 & 0xF) + this.field_187284_d.field_77275_b * 16;
            BlockPos \u26032 = new BlockPos(n, \u2603, \u2603);
            this.func_187267_a(new SPacketBlockChange(this.field_187282_b.func_72688_a(), \u26032));
            if (this.field_187282_b.func_72688_a().func_180495_p(\u26032).func_177230_c().func_149716_u()) {
                this.func_187273_a(this.field_187282_b.func_72688_a().func_175625_s(\u26032));
            }
        } else if (this.field_187287_g == 64) {
            this.func_187267_a(new SPacketChunkData(this.field_187286_f, this.field_187288_h));
        } else {
            this.func_187267_a(new SPacketMultiBlockChange(this.field_187287_g, this.field_187285_e, this.field_187286_f));
            for (\u2603 = 0; \u2603 < this.field_187287_g; ++\u2603) {
                \u2603 = (this.field_187285_e[\u2603] >> 12 & 0xF) + this.field_187284_d.field_77276_a * 16;
                \u2603 = this.field_187285_e[\u2603] & 0xFF;
                \u2603 = (this.field_187285_e[\u2603] >> 8 & 0xF) + this.field_187284_d.field_77275_b * 16;
                BlockPos blockPos = new BlockPos(\u2603, \u2603, \u2603);
                if (!this.field_187282_b.func_72688_a().func_180495_p(blockPos).func_177230_c().func_149716_u()) continue;
                this.func_187273_a(this.field_187282_b.func_72688_a().func_175625_s(blockPos));
            }
        }
        this.field_187287_g = 0;
        this.field_187288_h = 0;
    }

    private void func_187273_a(@Nullable TileEntity tileEntity) {
        if (tileEntity != null && (\u2603 = tileEntity.func_189518_D_()) != null) {
            this.func_187267_a(\u2603);
        }
    }

    public boolean func_187275_d(EntityPlayerMP entityPlayerMP) {
        return this.field_187283_c.contains(entityPlayerMP);
    }

    public boolean func_187269_a(Predicate<EntityPlayerMP> predicate) {
        return this.field_187283_c.stream().anyMatch(predicate);
    }

    public boolean func_187271_a(double d, Predicate<EntityPlayerMP> predicate) {
        int n = this.field_187283_c.size();
        for (\u2603 = 0; \u2603 < n; ++\u2603) {
            EntityPlayerMP entityPlayerMP = this.field_187283_c.get(\u2603);
            if (!predicate.test(entityPlayerMP) || !(this.field_187284_d.func_185327_a(entityPlayerMP) < d * d)) continue;
            return true;
        }
        return false;
    }

    public boolean func_187274_e() {
        return this.field_187290_j;
    }

    @Nullable
    public Chunk func_187266_f() {
        return this.field_187286_f;
    }

    public double func_187270_g() {
        double d = Double.MAX_VALUE;
        for (EntityPlayerMP entityPlayerMP : this.field_187283_c) {
            double d2 = this.field_187284_d.func_185327_a(entityPlayerMP);
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }
}

