/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.management;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.network.play.server.SPacketChat;
import net.minecraft.network.play.server.SPacketCustomPayload;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketEntityStatus;
import net.minecraft.network.play.server.SPacketHeldItemChange;
import net.minecraft.network.play.server.SPacketJoinGame;
import net.minecraft.network.play.server.SPacketPlayerAbilities;
import net.minecraft.network.play.server.SPacketPlayerListItem;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.network.play.server.SPacketServerDifficulty;
import net.minecraft.network.play.server.SPacketSetExperience;
import net.minecraft.network.play.server.SPacketSpawnPosition;
import net.minecraft.network.play.server.SPacketTagsList;
import net.minecraft.network.play.server.SPacketTeams;
import net.minecraft.network.play.server.SPacketTimeUpdate;
import net.minecraft.network.play.server.SPacketUpdateRecipes;
import net.minecraft.network.play.server.SPacketWorldBorder;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.DemoPlayerInteractionManager;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.server.management.UserListBans;
import net.minecraft.server.management.UserListBansEntry;
import net.minecraft.server.management.UserListIPBans;
import net.minecraft.server.management.UserListIPBansEntry;
import net.minecraft.server.management.UserListOps;
import net.minecraft.server.management.UserListOpsEntry;
import net.minecraft.server.management.UserListWhitelist;
import net.minecraft.stats.StatList;
import net.minecraft.stats.StatisticsManagerServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.IWorld;
import net.minecraft.world.WorldServer;
import net.minecraft.world.border.IBorderListener;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.IPlayerFileData;
import net.minecraft.world.storage.WorldInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PlayerList {
    public static final File field_152613_a = new File("banned-players.json");
    public static final File field_152614_b = new File("banned-ips.json");
    public static final File field_152615_c = new File("ops.json");
    public static final File field_152616_d = new File("whitelist.json");
    private static final Logger field_148546_d = LogManager.getLogger();
    private static final SimpleDateFormat field_72403_e = new SimpleDateFormat("yyyy-MM-dd 'at' HH:mm:ss z");
    private final MinecraftServer field_72400_f;
    private final List<EntityPlayerMP> field_72404_b = Lists.newArrayList();
    private final Map<UUID, EntityPlayerMP> field_177454_f = Maps.newHashMap();
    private final UserListBans field_72401_g = new UserListBans(field_152613_a);
    private final UserListIPBans field_72413_h = new UserListIPBans(field_152614_b);
    private final UserListOps field_72414_i = new UserListOps(field_152615_c);
    private final UserListWhitelist field_72411_j = new UserListWhitelist(field_152616_d);
    private final Map<UUID, StatisticsManagerServer> field_148547_k = Maps.newHashMap();
    private final Map<UUID, PlayerAdvancements> field_192055_p = Maps.newHashMap();
    private IPlayerFileData field_72412_k;
    private boolean field_72409_l;
    protected int field_72405_c;
    private int field_72402_d;
    private GameType field_72410_m;
    private boolean field_72407_n;
    private int field_72408_o;

    public PlayerList(MinecraftServer minecraftServer) {
        this.field_72400_f = minecraftServer;
        this.func_152608_h().func_152686_a(true);
        this.func_72363_f().func_152686_a(true);
        this.field_72405_c = 8;
    }

    public void func_72355_a(NetworkManager networkManager, EntityPlayerMP entityPlayerMP2) {
        Entity entity;
        TextComponentTranslation textComponentTranslation;
        GameProfile gameProfile = entityPlayerMP2.func_146103_bH();
        PlayerProfileCache \u26032 = this.field_72400_f.func_152358_ax();
        GameProfile gameProfile2 = \u26032.func_152652_a(gameProfile.getId());
        String \u26033 = gameProfile2 == null ? gameProfile.getName() : gameProfile2.getName();
        \u26032.func_152649_a(gameProfile);
        NBTTagCompound \u26034 = this.func_72380_a(entityPlayerMP2);
        entityPlayerMP2.func_70029_a(this.field_72400_f.func_71218_a(entityPlayerMP2.field_71093_bK));
        entityPlayerMP2.field_71134_c.func_73080_a((WorldServer)entityPlayerMP2.field_70170_p);
        String \u26035 = "local";
        if (networkManager.func_74430_c() != null) {
            \u26035 = networkManager.func_74430_c().toString();
        }
        field_148546_d.info("{}[{}] logged in with entity id {} at ({}, {}, {})", (Object)entityPlayerMP2.func_200200_C_().getString(), (Object)\u26035, (Object)entityPlayerMP2.func_145782_y(), (Object)entityPlayerMP2.field_70165_t, (Object)entityPlayerMP2.field_70163_u, (Object)entityPlayerMP2.field_70161_v);
        WorldServer \u26036 = this.field_72400_f.func_71218_a(entityPlayerMP2.field_71093_bK);
        WorldInfo \u26037 = \u26036.func_72912_H();
        this.func_72381_a(entityPlayerMP2, null, \u26036);
        NetHandlerPlayServer \u26038 = new NetHandlerPlayServer(this.field_72400_f, networkManager, entityPlayerMP2);
        \u26038.func_147359_a(new SPacketJoinGame(entityPlayerMP2.func_145782_y(), entityPlayerMP2.field_71134_c.func_73081_b(), \u26037.func_76093_s(), \u26036.field_73011_w.func_186058_p(), \u26036.func_175659_aa(), this.func_72352_l(), \u26037.func_76067_t(), \u26036.func_82736_K().func_82766_b("reducedDebugInfo")));
        \u26038.func_147359_a(new SPacketCustomPayload(SPacketCustomPayload.field_209911_b, new PacketBuffer(Unpooled.buffer()).func_180714_a(this.func_72365_p().getServerModName())));
        \u26038.func_147359_a(new SPacketServerDifficulty(\u26037.func_176130_y(), \u26037.func_176123_z()));
        \u26038.func_147359_a(new SPacketPlayerAbilities(entityPlayerMP2.field_71075_bZ));
        \u26038.func_147359_a(new SPacketHeldItemChange(entityPlayerMP2.field_71071_by.field_70461_c));
        \u26038.func_147359_a(new SPacketUpdateRecipes(this.field_72400_f.func_199529_aN().func_199510_b()));
        \u26038.func_147359_a(new SPacketTagsList(this.field_72400_f.func_199731_aO()));
        this.func_187243_f(entityPlayerMP2);
        entityPlayerMP2.func_147099_x().func_150877_d();
        entityPlayerMP2.func_192037_E().func_192826_c(entityPlayerMP2);
        this.func_96456_a(\u26036.func_96441_U(), entityPlayerMP2);
        this.field_72400_f.func_147132_au();
        if (entityPlayerMP2.func_146103_bH().getName().equalsIgnoreCase(\u26033)) {
            TextComponentTranslation \u26039 = new TextComponentTranslation("multiplayer.player.joined", entityPlayerMP2.func_145748_c_());
        } else {
            textComponentTranslation = new TextComponentTranslation("multiplayer.player.joined.renamed", entityPlayerMP2.func_145748_c_(), \u26033);
        }
        this.func_148539_a(textComponentTranslation.func_211708_a(TextFormatting.YELLOW));
        this.func_72377_c(entityPlayerMP2);
        \u26038.func_147364_a(entityPlayerMP2.field_70165_t, entityPlayerMP2.field_70163_u, entityPlayerMP2.field_70161_v, entityPlayerMP2.field_70177_z, entityPlayerMP2.field_70125_A);
        this.func_72354_b(entityPlayerMP2, \u26036);
        if (!this.field_72400_f.func_147133_T().isEmpty()) {
            entityPlayerMP2.func_175397_a(this.field_72400_f.func_147133_T(), this.field_72400_f.func_175581_ab());
        }
        for (PotionEffect potionEffect : entityPlayerMP2.func_70651_bq()) {
            \u26038.func_147359_a(new SPacketEntityEffect(entityPlayerMP2.func_145782_y(), potionEffect));
        }
        if (\u26034 != null && \u26034.func_150297_b("RootVehicle", 10) && (entity = AnvilChunkLoader.func_186051_a((\u2603 = \u26034.func_74775_l("RootVehicle")).func_74775_l("Entity"), \u26036, true)) != null) {
            UUID uUID = \u2603.func_186857_a("Attach");
            if (entity.func_110124_au().equals(uUID)) {
                entityPlayerMP2.func_184205_a(entity, true);
            } else {
                for (Entity entity2 : entity.func_184182_bu()) {
                    if (!entity2.func_110124_au().equals(uUID)) continue;
                    entityPlayerMP2.func_184205_a(entity2, true);
                    break;
                }
            }
            if (!entityPlayerMP2.func_184218_aH()) {
                field_148546_d.warn("Couldn't reattach entity to player");
                \u26036.func_72973_f(entity);
                for (Entity entity3 : entity.func_184182_bu()) {
                    \u26036.func_72973_f(entity3);
                }
            }
        }
        entityPlayerMP2.func_71116_b();
    }

    protected void func_96456_a(ServerScoreboard serverScoreboard, EntityPlayerMP entityPlayerMP) {
        HashSet hashSet = Sets.newHashSet();
        for (ScorePlayerTeam scorePlayerTeam : serverScoreboard.func_96525_g()) {
            entityPlayerMP.field_71135_a.func_147359_a(new SPacketTeams(scorePlayerTeam, 0));
        }
        for (int i = 0; i < 19; ++i) {
            ScoreObjective scoreObjective = serverScoreboard.func_96539_a(i);
            if (scoreObjective == null || hashSet.contains(scoreObjective)) continue;
            List<Packet<?>> \u26032 = serverScoreboard.func_96550_d(scoreObjective);
            for (Packet<?> packet : \u26032) {
                entityPlayerMP.field_71135_a.func_147359_a(packet);
            }
            hashSet.add(scoreObjective);
        }
    }

    public void func_212504_a(WorldServer worldServer) {
        this.field_72412_k = worldServer.func_72860_G().func_75756_e();
        worldServer.func_175723_af().func_177737_a(new IBorderListener(){

            @Override
            public void func_177694_a(WorldBorder worldBorder, double d) {
                PlayerList.this.func_148540_a(new SPacketWorldBorder(worldBorder, SPacketWorldBorder.Action.SET_SIZE));
            }

            @Override
            public void func_177692_a(WorldBorder worldBorder, double d, double d2, long l) {
                PlayerList.this.func_148540_a(new SPacketWorldBorder(worldBorder, SPacketWorldBorder.Action.LERP_SIZE));
            }

            @Override
            public void func_177693_a(WorldBorder worldBorder, double d, double d2) {
                PlayerList.this.func_148540_a(new SPacketWorldBorder(worldBorder, SPacketWorldBorder.Action.SET_CENTER));
            }

            @Override
            public void func_177691_a(WorldBorder worldBorder, int n) {
                PlayerList.this.func_148540_a(new SPacketWorldBorder(worldBorder, SPacketWorldBorder.Action.SET_WARNING_TIME));
            }

            @Override
            public void func_177690_b(WorldBorder worldBorder, int n) {
                PlayerList.this.func_148540_a(new SPacketWorldBorder(worldBorder, SPacketWorldBorder.Action.SET_WARNING_BLOCKS));
            }

            @Override
            public void func_177696_b(WorldBorder worldBorder, double d) {
            }

            @Override
            public void func_177695_c(WorldBorder worldBorder, double d) {
            }
        });
    }

    public void func_72375_a(EntityPlayerMP entityPlayerMP, @Nullable WorldServer worldServer) {
        \u2603 = entityPlayerMP.func_71121_q();
        if (worldServer != null) {
            worldServer.func_184164_w().func_72695_c(entityPlayerMP);
        }
        \u2603.func_184164_w().func_72683_a(entityPlayerMP);
        \u2603.func_72863_F().func_186025_d((int)entityPlayerMP.field_70165_t >> 4, (int)entityPlayerMP.field_70161_v >> 4, true, true);
        if (worldServer != null) {
            CriteriaTriggers.field_193134_u.func_193143_a(entityPlayerMP, worldServer.field_73011_w.func_186058_p(), \u2603.field_73011_w.func_186058_p());
            if (worldServer.field_73011_w.func_186058_p() == DimensionType.NETHER && entityPlayerMP.field_70170_p.field_73011_w.func_186058_p() == DimensionType.OVERWORLD && entityPlayerMP.func_193106_Q() != null) {
                CriteriaTriggers.field_193131_B.func_193168_a(entityPlayerMP, entityPlayerMP.func_193106_Q());
            }
        }
    }

    public int func_72372_a() {
        return PlayerChunkMap.func_72686_a(this.func_72395_o());
    }

    @Nullable
    public NBTTagCompound func_72380_a(EntityPlayerMP entityPlayerMP) {
        NBTTagCompound nBTTagCompound = this.field_72400_f.func_71218_a(DimensionType.OVERWORLD).func_72912_H().func_76072_h();
        if (entityPlayerMP.func_200200_C_().getString().equals(this.field_72400_f.func_71214_G()) && nBTTagCompound != null) {
            \u2603 = nBTTagCompound;
            entityPlayerMP.func_70020_e(\u2603);
            field_148546_d.debug("loading single player");
        } else {
            \u2603 = this.field_72412_k.func_75752_b(entityPlayerMP);
        }
        return \u2603;
    }

    protected void func_72391_b(EntityPlayerMP entityPlayerMP) {
        this.field_72412_k.func_75753_a(entityPlayerMP);
        StatisticsManagerServer statisticsManagerServer = this.field_148547_k.get(entityPlayerMP.func_110124_au());
        if (statisticsManagerServer != null) {
            statisticsManagerServer.func_150883_b();
        }
        if ((\u2603 = this.field_192055_p.get(entityPlayerMP.func_110124_au())) != null) {
            \u2603.func_192749_b();
        }
    }

    public void func_72377_c(EntityPlayerMP entityPlayerMP) {
        this.field_72404_b.add(entityPlayerMP);
        this.field_177454_f.put(entityPlayerMP.func_110124_au(), entityPlayerMP);
        this.func_148540_a(new SPacketPlayerListItem(SPacketPlayerListItem.Action.ADD_PLAYER, entityPlayerMP));
        WorldServer worldServer = this.field_72400_f.func_71218_a(entityPlayerMP.field_71093_bK);
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            entityPlayerMP.field_71135_a.func_147359_a(new SPacketPlayerListItem(SPacketPlayerListItem.Action.ADD_PLAYER, this.field_72404_b.get(i)));
        }
        worldServer.func_72838_d(entityPlayerMP);
        this.func_72375_a(entityPlayerMP, null);
        this.field_72400_f.func_201300_aS().func_201383_a(entityPlayerMP);
    }

    public void func_72358_d(EntityPlayerMP entityPlayerMP) {
        entityPlayerMP.func_71121_q().func_184164_w().func_72685_d(entityPlayerMP);
    }

    public void func_72367_e(EntityPlayerMP entityPlayerMP) {
        WorldServer worldServer = entityPlayerMP.func_71121_q();
        entityPlayerMP.func_195066_a(StatList.field_75947_j);
        this.func_72391_b(entityPlayerMP);
        if (entityPlayerMP.func_184218_aH() && ((Entity)(\u26032 = entityPlayerMP.func_184208_bv())).func_200601_bK()) {
            field_148546_d.debug("Removing player mount");
            entityPlayerMP.func_184210_p();
            worldServer.func_72973_f((Entity)\u26032);
            for (Entity entity : ((Entity)\u26032).func_184182_bu()) {
                worldServer.func_72973_f(entity);
            }
            worldServer.func_72964_e(entityPlayerMP.field_70176_ah, entityPlayerMP.field_70164_aj).func_76630_e();
        }
        worldServer.func_72900_e(entityPlayerMP);
        worldServer.func_184164_w().func_72695_c(entityPlayerMP);
        entityPlayerMP.func_192039_O().func_192745_a();
        this.field_72404_b.remove(entityPlayerMP);
        this.field_72400_f.func_201300_aS().func_201382_b(entityPlayerMP);
        Object \u26032 = entityPlayerMP.func_110124_au();
        EntityPlayerMP \u26033 = this.field_177454_f.get(\u26032);
        if (\u26033 == entityPlayerMP) {
            this.field_177454_f.remove(\u26032);
            this.field_148547_k.remove(\u26032);
            this.field_192055_p.remove(\u26032);
        }
        this.func_148540_a(new SPacketPlayerListItem(SPacketPlayerListItem.Action.REMOVE_PLAYER, entityPlayerMP));
    }

    @Nullable
    public ITextComponent func_206258_a(SocketAddress socketAddress, GameProfile gameProfile) {
        if (this.field_72401_g.func_152702_a(gameProfile)) {
            UserListBansEntry userListBansEntry = (UserListBansEntry)this.field_72401_g.func_152683_b(gameProfile);
            TextComponentTranslation \u26032 = new TextComponentTranslation("multiplayer.disconnect.banned.reason", userListBansEntry.func_73686_f());
            if (userListBansEntry.func_73680_d() != null) {
                \u26032.func_150257_a(new TextComponentTranslation("multiplayer.disconnect.banned.expiration", field_72403_e.format(userListBansEntry.func_73680_d())));
            }
            return \u26032;
        }
        if (!this.func_152607_e(gameProfile)) {
            return new TextComponentTranslation("multiplayer.disconnect.not_whitelisted", new Object[0]);
        }
        if (this.field_72413_h.func_152708_a(socketAddress)) {
            UserListIPBansEntry \u26033 = this.field_72413_h.func_152709_b(socketAddress);
            TextComponentTranslation \u26034 = new TextComponentTranslation("multiplayer.disconnect.banned_ip.reason", \u26033.func_73686_f());
            if (\u26033.func_73680_d() != null) {
                \u26034.func_150257_a(new TextComponentTranslation("multiplayer.disconnect.banned_ip.expiration", field_72403_e.format(\u26033.func_73680_d())));
            }
            return \u26034;
        }
        if (this.field_72404_b.size() >= this.field_72405_c && !this.func_183023_f(gameProfile)) {
            return new TextComponentTranslation("multiplayer.disconnect.server_full", new Object[0]);
        }
        return null;
    }

    public EntityPlayerMP func_148545_a(GameProfile gameProfile2) {
        GameProfile gameProfile2;
        Object object;
        UUID uUID = EntityPlayer.func_146094_a(gameProfile2);
        ArrayList \u26032 = Lists.newArrayList();
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            object = this.field_72404_b.get(i);
            if (!((Entity)object).func_110124_au().equals(uUID)) continue;
            \u26032.add(object);
        }
        EntityPlayerMP \u26033 = this.field_177454_f.get(gameProfile2.getId());
        if (\u26033 != null && !\u26032.contains(\u26033)) {
            \u26032.add(\u26033);
        }
        for (EntityPlayerMP entityPlayerMP : \u26032) {
            entityPlayerMP.field_71135_a.func_194028_b(new TextComponentTranslation("multiplayer.disconnect.duplicate_login", new Object[0]));
        }
        object = this.field_72400_f.func_71242_L() ? new DemoPlayerInteractionManager(this.field_72400_f.func_71218_a(DimensionType.OVERWORLD)) : new PlayerInteractionManager(this.field_72400_f.func_71218_a(DimensionType.OVERWORLD));
        return new EntityPlayerMP(this.field_72400_f, this.field_72400_f.func_71218_a(DimensionType.OVERWORLD), gameProfile2, (PlayerInteractionManager)object);
    }

    public EntityPlayerMP func_72368_a(EntityPlayerMP entityPlayerMP2, DimensionType dimensionType, boolean bl) {
        PlayerInteractionManager playerInteractionManager;
        entityPlayerMP2.func_71121_q().func_73039_n().func_72787_a(entityPlayerMP2);
        entityPlayerMP2.func_71121_q().func_73039_n().func_72790_b(entityPlayerMP2);
        entityPlayerMP2.func_71121_q().func_184164_w().func_72695_c(entityPlayerMP2);
        this.field_72404_b.remove(entityPlayerMP2);
        this.field_72400_f.func_71218_a(entityPlayerMP2.field_71093_bK).func_72973_f(entityPlayerMP2);
        BlockPos blockPos = entityPlayerMP2.func_180470_cg();
        boolean \u26032 = entityPlayerMP2.func_82245_bX();
        entityPlayerMP2.field_71093_bK = dimensionType;
        if (this.field_72400_f.func_71242_L()) {
            DemoPlayerInteractionManager \u26033 = new DemoPlayerInteractionManager(this.field_72400_f.func_71218_a(entityPlayerMP2.field_71093_bK));
        } else {
            playerInteractionManager = new PlayerInteractionManager(this.field_72400_f.func_71218_a(entityPlayerMP2.field_71093_bK));
        }
        EntityPlayerMP \u26034 = new EntityPlayerMP(this.field_72400_f, this.field_72400_f.func_71218_a(entityPlayerMP2.field_71093_bK), entityPlayerMP2.func_146103_bH(), playerInteractionManager);
        \u26034.field_71135_a = entityPlayerMP2.field_71135_a;
        \u26034.func_193104_a(entityPlayerMP2, bl);
        \u26034.func_145769_d(entityPlayerMP2.func_145782_y());
        \u26034.func_184819_a(entityPlayerMP2.func_184591_cq());
        for (String string : entityPlayerMP2.func_184216_O()) {
            \u26034.func_184211_a(string);
        }
        WorldServer \u26035 = this.field_72400_f.func_71218_a(entityPlayerMP2.field_71093_bK);
        this.func_72381_a(\u26034, entityPlayerMP2, \u26035);
        if (blockPos != null) {
            BlockPos blockPos2 = EntityPlayer.func_180467_a(this.field_72400_f.func_71218_a(entityPlayerMP2.field_71093_bK), blockPos, \u26032);
            if (blockPos2 != null) {
                \u26034.func_70012_b((float)blockPos2.func_177958_n() + 0.5f, (float)blockPos2.func_177956_o() + 0.1f, (float)blockPos2.func_177952_p() + 0.5f, 0.0f, 0.0f);
                \u26034.func_180473_a(blockPos, \u26032);
            } else {
                \u26034.field_71135_a.func_147359_a(new SPacketChangeGameState(0, 0.0f));
            }
        }
        \u26035.func_72863_F().func_186025_d((int)\u26034.field_70165_t >> 4, (int)\u26034.field_70161_v >> 4, true, true);
        while (!\u26035.func_195586_b(\u26034, \u26034.func_174813_aQ()) && \u26034.field_70163_u < 256.0) {
            \u26034.func_70107_b(\u26034.field_70165_t, \u26034.field_70163_u + 1.0, \u26034.field_70161_v);
        }
        \u26034.field_71135_a.func_147359_a(new SPacketRespawn(\u26034.field_71093_bK, \u26034.field_70170_p.func_175659_aa(), \u26034.field_70170_p.func_72912_H().func_76067_t(), \u26034.field_71134_c.func_73081_b()));
        BlockPos blockPos3 = \u26035.func_175694_M();
        \u26034.field_71135_a.func_147364_a(\u26034.field_70165_t, \u26034.field_70163_u, \u26034.field_70161_v, \u26034.field_70177_z, \u26034.field_70125_A);
        \u26034.field_71135_a.func_147359_a(new SPacketSpawnPosition(blockPos3));
        \u26034.field_71135_a.func_147359_a(new SPacketSetExperience(\u26034.field_71106_cc, \u26034.field_71067_cb, \u26034.field_71068_ca));
        this.func_72354_b(\u26034, \u26035);
        this.func_187243_f(\u26034);
        \u26035.func_184164_w().func_72683_a(\u26034);
        \u26035.func_72838_d(\u26034);
        this.field_72404_b.add(\u26034);
        this.field_177454_f.put(\u26034.func_110124_au(), \u26034);
        \u26034.func_71116_b();
        \u26034.func_70606_j(\u26034.func_110143_aJ());
        return \u26034;
    }

    public void func_187243_f(EntityPlayerMP entityPlayerMP) {
        GameProfile gameProfile = entityPlayerMP.func_146103_bH();
        int \u26032 = this.field_72400_f.func_211833_a(gameProfile);
        this.func_187245_a(entityPlayerMP, \u26032);
    }

    public void func_187242_a(EntityPlayerMP entityPlayerMP, DimensionType dimensionType) {
        \u2603 = entityPlayerMP.field_71093_bK;
        WorldServer worldServer = this.field_72400_f.func_71218_a(entityPlayerMP.field_71093_bK);
        entityPlayerMP.field_71093_bK = dimensionType;
        \u2603 = this.field_72400_f.func_71218_a(entityPlayerMP.field_71093_bK);
        entityPlayerMP.field_71135_a.func_147359_a(new SPacketRespawn(entityPlayerMP.field_71093_bK, entityPlayerMP.field_70170_p.func_175659_aa(), entityPlayerMP.field_70170_p.func_72912_H().func_76067_t(), entityPlayerMP.field_71134_c.func_73081_b()));
        this.func_187243_f(entityPlayerMP);
        worldServer.func_72973_f(entityPlayerMP);
        entityPlayerMP.field_70128_L = false;
        this.func_82448_a(entityPlayerMP, \u2603, worldServer, \u2603);
        this.func_72375_a(entityPlayerMP, worldServer);
        entityPlayerMP.field_71135_a.func_147364_a(entityPlayerMP.field_70165_t, entityPlayerMP.field_70163_u, entityPlayerMP.field_70161_v, entityPlayerMP.field_70177_z, entityPlayerMP.field_70125_A);
        entityPlayerMP.field_71134_c.func_73080_a(\u2603);
        entityPlayerMP.field_71135_a.func_147359_a(new SPacketPlayerAbilities(entityPlayerMP.field_71075_bZ));
        this.func_72354_b(entityPlayerMP, \u2603);
        this.func_72385_f(entityPlayerMP);
        for (PotionEffect potionEffect : entityPlayerMP.func_70651_bq()) {
            entityPlayerMP.field_71135_a.func_147359_a(new SPacketEntityEffect(entityPlayerMP.func_145782_y(), potionEffect));
        }
    }

    public void func_82448_a(Entity entity, DimensionType dimensionType, WorldServer worldServer, WorldServer worldServer2) {
        double \u26034;
        double \u26033 = entity.field_70165_t;
        \u26034 = entity.field_70161_v;
        \u2603 = 8.0;
        float \u26032 = entity.field_70177_z;
        worldServer.field_72984_F.func_76320_a("moving");
        if (entity.field_71093_bK == DimensionType.NETHER) {
            \u26033 = MathHelper.func_151237_a(\u26033 / 8.0, worldServer2.func_175723_af().func_177726_b() + 16.0, worldServer2.func_175723_af().func_177728_d() - 16.0);
            \u26034 = MathHelper.func_151237_a(\u26034 / 8.0, worldServer2.func_175723_af().func_177736_c() + 16.0, worldServer2.func_175723_af().func_177733_e() - 16.0);
            entity.func_70012_b(\u26033, entity.field_70163_u, \u26034, entity.field_70177_z, entity.field_70125_A);
            if (entity.func_70089_S()) {
                worldServer.func_72866_a(entity, false);
            }
        } else if (entity.field_71093_bK == DimensionType.OVERWORLD) {
            \u26033 = MathHelper.func_151237_a(\u26033 * 8.0, worldServer2.func_175723_af().func_177726_b() + 16.0, worldServer2.func_175723_af().func_177728_d() - 16.0);
            \u26034 = MathHelper.func_151237_a(\u26034 * 8.0, worldServer2.func_175723_af().func_177736_c() + 16.0, worldServer2.func_175723_af().func_177733_e() - 16.0);
            entity.func_70012_b(\u26033, entity.field_70163_u, \u26034, entity.field_70177_z, entity.field_70125_A);
            if (entity.func_70089_S()) {
                worldServer.func_72866_a(entity, false);
            }
        } else {
            BlockPos blockPos = dimensionType == DimensionType.THE_END ? worldServer2.func_175694_M() : worldServer2.func_180504_m();
            \u26033 = blockPos.func_177958_n();
            entity.field_70163_u = blockPos.func_177956_o();
            \u26034 = blockPos.func_177952_p();
            entity.func_70012_b(\u26033, entity.field_70163_u, \u26034, 90.0f, 0.0f);
            if (entity.func_70089_S()) {
                worldServer.func_72866_a(entity, false);
            }
        }
        worldServer.field_72984_F.func_76319_b();
        if (dimensionType != DimensionType.THE_END) {
            worldServer.field_72984_F.func_76320_a("placing");
            \u26033 = MathHelper.func_76125_a((int)\u26033, -29999872, 29999872);
            \u26034 = MathHelper.func_76125_a((int)\u26034, -29999872, 29999872);
            if (entity.func_70089_S()) {
                entity.func_70012_b(\u26033, entity.field_70163_u, \u26034, entity.field_70177_z, entity.field_70125_A);
                worldServer2.func_85176_s().func_180266_a(entity, \u26032);
                worldServer2.func_72838_d(entity);
                worldServer2.func_72866_a(entity, false);
            }
            worldServer.field_72984_F.func_76319_b();
        }
        entity.func_70029_a(worldServer2);
    }

    public void func_72374_b() {
        if (++this.field_72408_o > 600) {
            this.func_148540_a(new SPacketPlayerListItem(SPacketPlayerListItem.Action.UPDATE_LATENCY, this.field_72404_b));
            this.field_72408_o = 0;
        }
    }

    public void func_148540_a(Packet<?> packet) {
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            this.field_72404_b.get((int)i).field_71135_a.func_147359_a(packet);
        }
    }

    public void func_148537_a(Packet<?> packet, DimensionType dimensionType) {
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            EntityPlayerMP entityPlayerMP = this.field_72404_b.get(i);
            if (entityPlayerMP.field_71093_bK != dimensionType) continue;
            entityPlayerMP.field_71135_a.func_147359_a(packet);
        }
    }

    public void func_177453_a(EntityPlayer entityPlayer, ITextComponent iTextComponent) {
        Team team = entityPlayer.func_96124_cp();
        if (team == null) {
            return;
        }
        Collection<String> \u26032 = team.func_96670_d();
        for (String string : \u26032) {
            EntityPlayerMP entityPlayerMP = this.func_152612_a(string);
            if (entityPlayerMP == null || entityPlayerMP == entityPlayer) continue;
            entityPlayerMP.func_145747_a(iTextComponent);
        }
    }

    public void func_177452_b(EntityPlayer entityPlayer, ITextComponent iTextComponent) {
        Team team = entityPlayer.func_96124_cp();
        if (team == null) {
            this.func_148539_a(iTextComponent);
            return;
        }
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            EntityPlayerMP entityPlayerMP = this.field_72404_b.get(i);
            if (entityPlayerMP.func_96124_cp() == team) continue;
            entityPlayerMP.func_145747_a(iTextComponent);
        }
    }

    public String[] func_72369_d() {
        String[] stringArray = new String[this.field_72404_b.size()];
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            stringArray[i] = this.field_72404_b.get(i).func_146103_bH().getName();
        }
        return stringArray;
    }

    public UserListBans func_152608_h() {
        return this.field_72401_g;
    }

    public UserListIPBans func_72363_f() {
        return this.field_72413_h;
    }

    public void func_152605_a(GameProfile gameProfile) {
        this.field_72414_i.func_152687_a(new UserListOpsEntry(gameProfile, this.field_72400_f.func_110455_j(), this.field_72414_i.func_183026_b(gameProfile)));
        EntityPlayerMP entityPlayerMP = this.func_177451_a(gameProfile.getId());
        if (entityPlayerMP != null) {
            this.func_187243_f(entityPlayerMP);
        }
    }

    public void func_152610_b(GameProfile gameProfile) {
        this.field_72414_i.func_152684_c(gameProfile);
        EntityPlayerMP entityPlayerMP = this.func_177451_a(gameProfile.getId());
        if (entityPlayerMP != null) {
            this.func_187243_f(entityPlayerMP);
        }
    }

    private void func_187245_a(EntityPlayerMP entityPlayerMP2, int n) {
        EntityPlayerMP entityPlayerMP2;
        if (entityPlayerMP2.field_71135_a != null) {
            byte by = n <= 0 ? (byte)24 : (n >= 4 ? (byte)28 : (byte)((byte)(24 + n)));
            entityPlayerMP2.field_71135_a.func_147359_a(new SPacketEntityStatus(entityPlayerMP2, by));
        }
        this.field_72400_f.func_195571_aL().func_197051_a(entityPlayerMP2);
    }

    public boolean func_152607_e(GameProfile gameProfile) {
        return !this.field_72409_l || this.field_72414_i.func_152692_d(gameProfile) || this.field_72411_j.func_152692_d(gameProfile);
    }

    public boolean func_152596_g(GameProfile gameProfile) {
        return this.field_72414_i.func_152692_d(gameProfile) || this.field_72400_f.func_71264_H() && this.field_72400_f.func_71218_a(DimensionType.OVERWORLD).func_72912_H().func_76086_u() && this.field_72400_f.func_71214_G().equalsIgnoreCase(gameProfile.getName()) || this.field_72407_n;
    }

    @Nullable
    public EntityPlayerMP func_152612_a(String string) {
        for (EntityPlayerMP entityPlayerMP : this.field_72404_b) {
            if (!entityPlayerMP.func_146103_bH().getName().equalsIgnoreCase(string)) continue;
            return entityPlayerMP;
        }
        return null;
    }

    public void func_148543_a(@Nullable EntityPlayer entityPlayer, double d, double d2, double d3, double d4, DimensionType dimensionType, Packet<?> packet) {
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            EntityPlayerMP entityPlayerMP = this.field_72404_b.get(i);
            if (entityPlayerMP == entityPlayer || entityPlayerMP.field_71093_bK != dimensionType || !((\u2603 = d - entityPlayerMP.field_70165_t) * \u2603 + (\u2603 = d2 - entityPlayerMP.field_70163_u) * \u2603 + (\u2603 = d3 - entityPlayerMP.field_70161_v) * \u2603 < d4 * d4)) continue;
            entityPlayerMP.field_71135_a.func_147359_a(packet);
        }
    }

    public void func_72389_g() {
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            this.func_72391_b(this.field_72404_b.get(i));
        }
    }

    public UserListWhitelist func_152599_k() {
        return this.field_72411_j;
    }

    public String[] func_152598_l() {
        return this.field_72411_j.func_152685_a();
    }

    public UserListOps func_152603_m() {
        return this.field_72414_i;
    }

    public String[] func_152606_n() {
        return this.field_72414_i.func_152685_a();
    }

    public void func_187244_a() {
    }

    public void func_72354_b(EntityPlayerMP entityPlayerMP, WorldServer worldServer) {
        WorldBorder worldBorder = this.field_72400_f.func_71218_a(DimensionType.OVERWORLD).func_175723_af();
        entityPlayerMP.field_71135_a.func_147359_a(new SPacketWorldBorder(worldBorder, SPacketWorldBorder.Action.INITIALIZE));
        entityPlayerMP.field_71135_a.func_147359_a(new SPacketTimeUpdate(worldServer.func_82737_E(), worldServer.func_72820_D(), worldServer.func_82736_K().func_82766_b("doDaylightCycle")));
        BlockPos \u26032 = worldServer.func_175694_M();
        entityPlayerMP.field_71135_a.func_147359_a(new SPacketSpawnPosition(\u26032));
        if (worldServer.func_72896_J()) {
            entityPlayerMP.field_71135_a.func_147359_a(new SPacketChangeGameState(1, 0.0f));
            entityPlayerMP.field_71135_a.func_147359_a(new SPacketChangeGameState(7, worldServer.func_72867_j(1.0f)));
            entityPlayerMP.field_71135_a.func_147359_a(new SPacketChangeGameState(8, worldServer.func_72819_i(1.0f)));
        }
    }

    public void func_72385_f(EntityPlayerMP entityPlayerMP) {
        entityPlayerMP.func_71120_a(entityPlayerMP.field_71069_bz);
        entityPlayerMP.func_71118_n();
        entityPlayerMP.field_71135_a.func_147359_a(new SPacketHeldItemChange(entityPlayerMP.field_71071_by.field_70461_c));
    }

    public int func_72394_k() {
        return this.field_72404_b.size();
    }

    public int func_72352_l() {
        return this.field_72405_c;
    }

    public String[] func_72373_m() {
        return this.field_72400_f.func_71218_a(DimensionType.OVERWORLD).func_72860_G().func_75756_e().func_75754_f();
    }

    public boolean func_72383_n() {
        return this.field_72409_l;
    }

    public void func_72371_a(boolean bl) {
        this.field_72409_l = bl;
    }

    public List<EntityPlayerMP> func_72382_j(String string) {
        ArrayList arrayList = Lists.newArrayList();
        for (EntityPlayerMP entityPlayerMP : this.field_72404_b) {
            if (!entityPlayerMP.func_71114_r().equals(string)) continue;
            arrayList.add(entityPlayerMP);
        }
        return arrayList;
    }

    public int func_72395_o() {
        return this.field_72402_d;
    }

    public MinecraftServer func_72365_p() {
        return this.field_72400_f;
    }

    public NBTTagCompound func_72378_q() {
        return null;
    }

    public void func_152604_a(GameType gameType) {
        this.field_72410_m = gameType;
    }

    private void func_72381_a(EntityPlayerMP entityPlayerMP, EntityPlayerMP entityPlayerMP2, IWorld iWorld) {
        if (entityPlayerMP2 != null) {
            entityPlayerMP.field_71134_c.func_73076_a(entityPlayerMP2.field_71134_c.func_73081_b());
        } else if (this.field_72410_m != null) {
            entityPlayerMP.field_71134_c.func_73076_a(this.field_72410_m);
        }
        entityPlayerMP.field_71134_c.func_73077_b(iWorld.func_72912_H().func_76077_q());
    }

    public void func_72387_b(boolean bl) {
        this.field_72407_n = bl;
    }

    public void func_72392_r() {
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            this.field_72404_b.get((int)i).field_71135_a.func_194028_b(new TextComponentTranslation("multiplayer.disconnect.server_shutdown", new Object[0]));
        }
    }

    public void func_148544_a(ITextComponent iTextComponent, boolean bl) {
        this.field_72400_f.func_145747_a(iTextComponent);
        ChatType chatType = bl ? ChatType.SYSTEM : ChatType.CHAT;
        this.func_148540_a(new SPacketChat(iTextComponent, chatType));
    }

    public void func_148539_a(ITextComponent iTextComponent) {
        this.func_148544_a(iTextComponent, true);
    }

    public StatisticsManagerServer func_152602_a(EntityPlayer entityPlayer) {
        StatisticsManagerServer \u26032;
        UUID uUID = entityPlayer.func_110124_au();
        StatisticsManagerServer statisticsManagerServer = \u26032 = uUID == null ? null : this.field_148547_k.get(uUID);
        if (\u26032 == null) {
            File file = new File(this.field_72400_f.func_71218_a(DimensionType.OVERWORLD).func_72860_G().func_75765_b(), "stats");
            \u2603 = new File(file, uUID + ".json");
            if (!\u2603.exists() && (\u2603 = new File(file, entityPlayer.func_200200_C_().getString() + ".json")).exists() && \u2603.isFile()) {
                \u2603.renameTo(\u2603);
            }
            \u26032 = new StatisticsManagerServer(this.field_72400_f, \u2603);
            this.field_148547_k.put(uUID, \u26032);
        }
        return \u26032;
    }

    public PlayerAdvancements func_192054_h(EntityPlayerMP entityPlayerMP2) {
        EntityPlayerMP entityPlayerMP2;
        UUID uUID = entityPlayerMP2.func_110124_au();
        PlayerAdvancements \u26032 = this.field_192055_p.get(uUID);
        if (\u26032 == null) {
            File file = new File(this.field_72400_f.func_71218_a(DimensionType.OVERWORLD).func_72860_G().func_75765_b(), "advancements");
            \u2603 = new File(file, uUID + ".json");
            \u26032 = new PlayerAdvancements(this.field_72400_f, \u2603, entityPlayerMP2);
            this.field_192055_p.put(uUID, \u26032);
        }
        \u26032.func_192739_a(entityPlayerMP2);
        return \u26032;
    }

    public void func_152611_a(int n) {
        this.field_72402_d = n;
        for (WorldServer worldServer : this.field_72400_f.func_212370_w()) {
            if (worldServer == null) continue;
            worldServer.func_184164_w().func_152622_a(n);
            worldServer.func_73039_n().func_187252_a(n);
        }
    }

    public List<EntityPlayerMP> func_181057_v() {
        return this.field_72404_b;
    }

    @Nullable
    public EntityPlayerMP func_177451_a(UUID uUID) {
        return this.field_177454_f.get(uUID);
    }

    public boolean func_183023_f(GameProfile gameProfile) {
        return false;
    }

    public void func_193244_w() {
        for (PlayerAdvancements playerAdvancements : this.field_192055_p.values()) {
            playerAdvancements.func_193766_b();
        }
        this.func_148540_a(new SPacketTagsList(this.field_72400_f.func_199731_aO()));
        SPacketUpdateRecipes sPacketUpdateRecipes = new SPacketUpdateRecipes(this.field_72400_f.func_199529_aN().func_199510_b());
        for (EntityPlayerMP entityPlayerMP : this.field_72404_b) {
            entityPlayerMP.field_71135_a.func_147359_a(sPacketUpdateRecipes);
            entityPlayerMP.func_192037_E().func_192826_c(entityPlayerMP);
        }
    }

    public boolean func_206257_x() {
        return this.field_72407_n;
    }
}

