/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.management;

import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.server.management.UserListEntryBan;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class UserListBansEntry
extends UserListEntryBan<GameProfile> {
    public UserListBansEntry(GameProfile gameProfile) {
        this(gameProfile, (Date)null, (String)null, (Date)null, (String)null);
    }

    public UserListBansEntry(GameProfile gameProfile, @Nullable Date date, @Nullable String string, @Nullable Date date2, @Nullable String string2) {
        super(gameProfile, date2, string, date2, string2);
    }

    public UserListBansEntry(JsonObject jsonObject) {
        super(UserListBansEntry.func_152648_b(jsonObject), jsonObject);
    }

    @Override
    protected void func_152641_a(JsonObject jsonObject) {
        if (this.func_152640_f() == null) {
            return;
        }
        jsonObject.addProperty("uuid", ((GameProfile)this.func_152640_f()).getId() == null ? "" : ((GameProfile)this.func_152640_f()).getId().toString());
        jsonObject.addProperty("name", ((GameProfile)this.func_152640_f()).getName());
        super.func_152641_a(jsonObject);
    }

    @Override
    public ITextComponent func_199041_e() {
        GameProfile gameProfile = (GameProfile)this.func_152640_f();
        return new TextComponentString(gameProfile.getName() != null ? gameProfile.getName() : Objects.toString(gameProfile.getId(), "(Unknown)"));
    }

    private static GameProfile func_152648_b(JsonObject jsonObject) {
        if (!jsonObject.has("uuid") || !jsonObject.has("name")) {
            return null;
        }
        String string = jsonObject.get("uuid").getAsString();
        try {
            UUID uUID = UUID.fromString(string);
        }
        catch (Throwable throwable) {
            return null;
        }
        return new GameProfile(uUID, jsonObject.get("name").getAsString());
    }
}

