/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.state;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.state.AbstractProperty;

public class IntegerProperty
extends AbstractProperty<Integer> {
    private final ImmutableSet<Integer> field_177720_a;

    protected IntegerProperty(String string, int n, int n2) {
        super(string, Integer.class);
        if (n < 0) {
            throw new IllegalArgumentException("Min value of " + string + " must be 0 or greater");
        }
        if (n2 <= n) {
            throw new IllegalArgumentException("Max value of " + string + " must be greater than min (" + n + ")");
        }
        HashSet hashSet = Sets.newHashSet();
        for (int i = n; i <= n2; ++i) {
            hashSet.add(i);
        }
        this.field_177720_a = ImmutableSet.copyOf((Collection)hashSet);
    }

    @Override
    public Collection<Integer> func_177700_c() {
        return this.field_177720_a;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof IntegerProperty && super.equals(object)) {
            IntegerProperty integerProperty = (IntegerProperty)object;
            return this.field_177720_a.equals(integerProperty.field_177720_a);
        }
        return false;
    }

    @Override
    public int func_206906_c() {
        return 31 * super.func_206906_c() + this.field_177720_a.hashCode();
    }

    public static IntegerProperty func_177719_a(String string, int n, int n2) {
        return new IntegerProperty(string, n, n2);
    }

    @Override
    public Optional<Integer> func_185929_b(String string) {
        try {
            Integer n = Integer.valueOf(string);
            return this.field_177720_a.contains((Object)n) ? Optional.of(n) : Optional.empty();
        }
        catch (NumberFormatException numberFormatException) {
            return Optional.empty();
        }
    }

    @Override
    public String func_177702_a(Integer n) {
        return n.toString();
    }
}

