/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tags.Tag;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TagCollection<T> {
    private static final Logger field_199918_a = LogManager.getLogger();
    private static final Gson field_199919_b = new Gson();
    private static final int field_199920_c = ".json".length();
    private final Map<ResourceLocation, Tag<T>> field_199921_d = Maps.newHashMap();
    private final Function<ResourceLocation, T> field_200040_e;
    private final Predicate<ResourceLocation> field_200156_f;
    private final String field_199923_f;
    private final boolean field_200041_g;
    private final String field_200157_i;

    public TagCollection(Predicate<ResourceLocation> predicate, Function<ResourceLocation, T> function, String string, boolean bl, String string2) {
        this.field_200156_f = predicate;
        this.field_200040_e = function;
        this.field_199923_f = string;
        this.field_200041_g = bl;
        this.field_200157_i = string2;
    }

    public void func_199912_a(Tag<T> tag) {
        if (this.field_199921_d.containsKey(tag.func_199886_b())) {
            throw new IllegalArgumentException("Duplicate " + this.field_200157_i + " tag '" + tag.func_199886_b() + "'");
        }
        this.field_199921_d.put(tag.func_199886_b(), tag);
    }

    @Nullable
    public Tag<T> func_199910_a(ResourceLocation resourceLocation) {
        return this.field_199921_d.get(resourceLocation);
    }

    public Tag<T> func_199915_b(ResourceLocation resourceLocation) {
        Tag<T> tag = this.field_199921_d.get(resourceLocation);
        if (tag == null) {
            return new Tag(resourceLocation);
        }
        return tag;
    }

    public Collection<ResourceLocation> func_199908_a() {
        return this.field_199921_d.keySet();
    }

    public Collection<ResourceLocation> func_199913_a(T t) {
        ArrayList arrayList = Lists.newArrayList();
        for (Map.Entry<ResourceLocation, Tag<T>> entry : this.field_199921_d.entrySet()) {
            if (!entry.getValue().func_199685_a_(t)) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList;
    }

    public void func_199917_b() {
        this.field_199921_d.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_199909_a(IResourceManager iResourceManager) {
        HashMap hashMap = Maps.newHashMap();
        for (ResourceLocation resourceLocation : iResourceManager.func_199003_a(this.field_199923_f, string -> string.endsWith(".json"))) {
            String string2 = resourceLocation.func_110623_a();
            ResourceLocation \u26032 = new ResourceLocation(resourceLocation.func_110624_b(), string2.substring(this.field_199923_f.length() + 1, string2.length() - field_199920_c));
            try {
                for (IResource iResource : iResourceManager.func_199004_b(resourceLocation)) {
                    try {
                        JsonObject jsonObject = JsonUtils.func_188178_a(field_199919_b, IOUtils.toString((InputStream)iResource.func_199027_b(), (Charset)StandardCharsets.UTF_8), JsonObject.class);
                        if (jsonObject == null) {
                            field_199918_a.error("Couldn't load {} tag list {} from {} in data pack {} as it's empty or null", (Object)this.field_200157_i, (Object)\u26032, (Object)resourceLocation, (Object)iResource.func_199026_d());
                            continue;
                        }
                        Tag.Builder<T> \u26033 = hashMap.getOrDefault(\u26032, Tag.Builder.func_200047_a());
                        \u26033.func_200158_a(this.field_200156_f, this.field_200040_e, jsonObject);
                        hashMap.put(\u26032, \u26033);
                    }
                    catch (IOException | RuntimeException exception) {
                        field_199918_a.error("Couldn't read {} tag list {} from {} in data pack {}", (Object)this.field_200157_i, (Object)\u26032, (Object)resourceLocation, (Object)iResource.func_199026_d(), (Object)exception);
                    }
                    finally {
                        IOUtils.closeQuietly((Closeable)iResource);
                    }
                }
            }
            catch (IOException iOException) {
                field_199918_a.error("Couldn't read {} tag list {} from {}", (Object)this.field_200157_i, (Object)\u26032, (Object)resourceLocation, (Object)iOException);
            }
        }
        while (!hashMap.isEmpty()) {
            boolean \u26035 = false;
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!((Tag.Builder)entry.getValue()).func_200160_a(this::func_199910_a)) continue;
                \u26035 = true;
                this.func_199912_a(((Tag.Builder)entry.getValue()).func_200051_a((ResourceLocation)entry.getKey()));
                iterator.remove();
            }
            if (\u26035) continue;
            for (Map.Entry entry : hashMap.entrySet()) {
                field_199918_a.error("Couldn't load {} tag {} as it either references another tag that doesn't exist, or ultimately references itself", (Object)this.field_200157_i, entry.getKey());
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            this.func_199912_a(((Tag.Builder)entry.getValue()).func_200045_a(this.field_200041_g).func_200051_a((ResourceLocation)entry.getKey()));
        }
    }

    public Map<ResourceLocation, Tag<T>> func_200039_c() {
        return this.field_199921_d;
    }
}

