/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerShulkerBox;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class TileEntityShulkerBox
extends TileEntityLockableLoot
implements ISidedInventory,
ITickable {
    private static final int[] field_190595_a = IntStream.range(0, 27).toArray();
    private NonNullList<ItemStack> field_190596_f = NonNullList.func_191197_a(27, ItemStack.field_190927_a);
    private boolean field_190597_g;
    private int field_190598_h;
    private AnimationStatus field_190599_i = AnimationStatus.CLOSED;
    private float field_190600_j;
    private float field_190601_k;
    private EnumDyeColor field_190602_l;
    private boolean field_204400_o;
    private boolean field_190594_p;

    public TileEntityShulkerBox(@Nullable EnumDyeColor enumDyeColor) {
        super(TileEntityType.field_200993_x);
        this.field_190602_l = enumDyeColor;
    }

    public TileEntityShulkerBox() {
        this((EnumDyeColor)null);
        this.field_204400_o = true;
    }

    @Override
    public void func_73660_a() {
        this.func_190583_o();
        if (this.field_190599_i == AnimationStatus.OPENING || this.field_190599_i == AnimationStatus.CLOSING) {
            this.func_190589_G();
        }
    }

    protected void func_190583_o() {
        this.field_190601_k = this.field_190600_j;
        switch (this.field_190599_i) {
            case CLOSED: {
                this.field_190600_j = 0.0f;
                break;
            }
            case OPENING: {
                this.field_190600_j += 0.1f;
                if (!(this.field_190600_j >= 1.0f)) break;
                this.func_190589_G();
                this.field_190599_i = AnimationStatus.OPENED;
                this.field_190600_j = 1.0f;
                break;
            }
            case CLOSING: {
                this.field_190600_j -= 0.1f;
                if (!(this.field_190600_j <= 0.0f)) break;
                this.field_190599_i = AnimationStatus.CLOSED;
                this.field_190600_j = 0.0f;
                break;
            }
            case OPENED: {
                this.field_190600_j = 1.0f;
            }
        }
    }

    public AnimationStatus func_190591_p() {
        return this.field_190599_i;
    }

    public AxisAlignedBB func_190584_a(IBlockState iBlockState) {
        return this.func_190587_b(iBlockState.func_177229_b(BlockShulkerBox.field_190957_a));
    }

    public AxisAlignedBB func_190587_b(EnumFacing enumFacing) {
        return VoxelShapes.func_197868_b().func_197752_a().func_72321_a(0.5f * this.func_190585_a(1.0f) * (float)enumFacing.func_82601_c(), 0.5f * this.func_190585_a(1.0f) * (float)enumFacing.func_96559_d(), 0.5f * this.func_190585_a(1.0f) * (float)enumFacing.func_82599_e());
    }

    private AxisAlignedBB func_190588_c(EnumFacing enumFacing) {
        \u2603 = enumFacing.func_176734_d();
        return this.func_190587_b(enumFacing).func_191195_a(\u2603.func_82601_c(), \u2603.func_96559_d(), \u2603.func_82599_e());
    }

    private void func_190589_G() {
        IBlockState iBlockState = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (!(iBlockState.func_177230_c() instanceof BlockShulkerBox)) {
            return;
        }
        EnumFacing \u26032 = iBlockState.func_177229_b(BlockShulkerBox.field_190957_a);
        AxisAlignedBB \u26033 = this.func_190588_c(\u26032).func_186670_a(this.field_174879_c);
        List<Entity> \u26034 = this.field_145850_b.func_72839_b(null, \u26033);
        if (\u26034.isEmpty()) {
            return;
        }
        for (int i = 0; i < \u26034.size(); ++i) {
            Entity entity = \u26034.get(i);
            if (entity.func_184192_z() == EnumPushReaction.IGNORE) continue;
            double \u26035 = 0.0;
            double \u26036 = 0.0;
            double \u26037 = 0.0;
            AxisAlignedBB \u26038 = entity.func_174813_aQ();
            switch (\u26032.func_176740_k()) {
                case X: {
                    \u26035 = \u26032.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? \u26033.field_72336_d - \u26038.field_72340_a : \u26038.field_72336_d - \u26033.field_72340_a;
                    \u26035 += 0.01;
                    break;
                }
                case Y: {
                    \u26036 = \u26032.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? \u26033.field_72337_e - \u26038.field_72338_b : \u26038.field_72337_e - \u26033.field_72338_b;
                    \u26036 += 0.01;
                    break;
                }
                case Z: {
                    \u26037 = \u26032.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? \u26033.field_72334_f - \u26038.field_72339_c : \u26038.field_72334_f - \u26033.field_72339_c;
                    \u26037 += 0.01;
                }
            }
            entity.func_70091_d(MoverType.SHULKER_BOX, \u26035 * (double)\u26032.func_82601_c(), \u26036 * (double)\u26032.func_96559_d(), \u26037 * (double)\u26032.func_82599_e());
        }
    }

    @Override
    public int func_70302_i_() {
        return this.field_190596_f.size();
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_145842_c(int n, int n2) {
        if (n == 1) {
            this.field_190598_h = n2;
            if (n2 == 0) {
                this.field_190599_i = AnimationStatus.CLOSING;
            }
            if (n2 == 1) {
                this.field_190599_i = AnimationStatus.OPENING;
            }
            return true;
        }
        return super.func_145842_c(n, n2);
    }

    @Override
    public void func_174889_b(EntityPlayer entityPlayer) {
        if (!entityPlayer.func_175149_v()) {
            if (this.field_190598_h < 0) {
                this.field_190598_h = 0;
            }
            ++this.field_190598_h;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_195044_w().func_177230_c(), 1, this.field_190598_h);
            if (this.field_190598_h == 1) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_191262_fB, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    @Override
    public void func_174886_c(EntityPlayer entityPlayer) {
        if (!entityPlayer.func_175149_v()) {
            --this.field_190598_h;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_195044_w().func_177230_c(), 1, this.field_190598_h);
            if (this.field_190598_h <= 0) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_191261_fA, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    @Override
    public Container func_174876_a(InventoryPlayer inventoryPlayer, EntityPlayer entityPlayer) {
        return new ContainerShulkerBox(inventoryPlayer, this, entityPlayer);
    }

    @Override
    public String func_174875_k() {
        return "minecraft:shulker_box";
    }

    @Override
    public ITextComponent func_200200_C_() {
        ITextComponent iTextComponent = this.func_200201_e();
        if (iTextComponent != null) {
            return iTextComponent;
        }
        return new TextComponentTranslation("container.shulkerBox", new Object[0]);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.func_190586_e(nBTTagCompound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nBTTagCompound) {
        super.func_189515_b(nBTTagCompound);
        return this.func_190580_f(nBTTagCompound);
    }

    public void func_190586_e(NBTTagCompound nBTTagCompound) {
        this.field_190596_f = NonNullList.func_191197_a(this.func_70302_i_(), ItemStack.field_190927_a);
        if (!this.func_184283_b(nBTTagCompound) && nBTTagCompound.func_150297_b("Items", 9)) {
            ItemStackHelper.func_191283_b(nBTTagCompound, this.field_190596_f);
        }
        if (nBTTagCompound.func_150297_b("CustomName", 8)) {
            this.field_190577_o = ITextComponent.Serializer.func_150699_a(nBTTagCompound.func_74779_i("CustomName"));
        }
    }

    public NBTTagCompound func_190580_f(NBTTagCompound nBTTagCompound) {
        if (!this.func_184282_c(nBTTagCompound)) {
            ItemStackHelper.func_191281_a(nBTTagCompound, this.field_190596_f, false);
        }
        if ((\u2603 = this.func_200201_e()) != null) {
            nBTTagCompound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a(\u2603));
        }
        if (!nBTTagCompound.func_74764_b("Lock") && this.func_174893_q_()) {
            this.func_174891_i().func_180157_a(nBTTagCompound);
        }
        return nBTTagCompound;
    }

    @Override
    protected NonNullList<ItemStack> func_190576_q() {
        return this.field_190596_f;
    }

    @Override
    protected void func_199721_a(NonNullList<ItemStack> nonNullList) {
        this.field_190596_f = nonNullList;
    }

    @Override
    public boolean func_191420_l() {
        for (ItemStack itemStack : this.field_190596_f) {
            if (itemStack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int[] func_180463_a(EnumFacing enumFacing) {
        return field_190595_a;
    }

    @Override
    public boolean func_180462_a(int n, ItemStack itemStack, @Nullable EnumFacing enumFacing) {
        return !(Block.func_149634_a(itemStack.func_77973_b()) instanceof BlockShulkerBox);
    }

    @Override
    public boolean func_180461_b(int n, ItemStack itemStack, EnumFacing enumFacing) {
        return true;
    }

    @Override
    public void func_174888_l() {
        this.field_190597_g = true;
        super.func_174888_l();
    }

    public boolean func_190590_r() {
        return this.field_190597_g;
    }

    public float func_190585_a(float f) {
        return this.field_190601_k + (this.field_190600_j - this.field_190601_k) * f;
    }

    public EnumDyeColor func_190592_s() {
        if (this.field_204400_o) {
            this.field_190602_l = BlockShulkerBox.func_190954_c(this.func_195044_w().func_177230_c());
            this.field_204400_o = false;
        }
        return this.field_190602_l;
    }

    @Override
    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 10, this.func_189517_E_());
    }

    public boolean func_190581_E() {
        return this.field_190594_p;
    }

    public void func_190579_a(boolean bl) {
        this.field_190594_p = bl;
    }

    public boolean func_190582_F() {
        return !this.func_190581_E() || !this.func_191420_l() || this.func_145818_k_() || this.field_184284_m != null;
    }

    public static enum AnimationStatus {
        CLOSED,
        OPENING,
        OPENED,
        CLOSING;

    }
}

