/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import org.apache.commons.lang3.StringUtils;

public class JsonUtils {
    private static final Gson field_212747_a = new GsonBuilder().create();

    public static boolean func_151205_a(JsonObject jsonObject, String string) {
        if (!JsonUtils.func_151201_f(jsonObject, string)) {
            return false;
        }
        return jsonObject.getAsJsonPrimitive(string).isString();
    }

    public static boolean func_151211_a(JsonElement jsonElement) {
        if (!jsonElement.isJsonPrimitive()) {
            return false;
        }
        return jsonElement.getAsJsonPrimitive().isString();
    }

    public static boolean func_188175_b(JsonElement jsonElement) {
        if (!jsonElement.isJsonPrimitive()) {
            return false;
        }
        return jsonElement.getAsJsonPrimitive().isNumber();
    }

    public static boolean func_180199_c(JsonObject jsonObject, String string) {
        if (!JsonUtils.func_151201_f(jsonObject, string)) {
            return false;
        }
        return jsonObject.getAsJsonPrimitive(string).isBoolean();
    }

    public static boolean func_151202_d(JsonObject jsonObject, String string) {
        if (!JsonUtils.func_151204_g(jsonObject, string)) {
            return false;
        }
        return jsonObject.get(string).isJsonArray();
    }

    public static boolean func_151201_f(JsonObject jsonObject, String string) {
        if (!JsonUtils.func_151204_g(jsonObject, string)) {
            return false;
        }
        return jsonObject.get(string).isJsonPrimitive();
    }

    public static boolean func_151204_g(JsonObject jsonObject, String string) {
        if (jsonObject == null) {
            return false;
        }
        return jsonObject.get(string) != null;
    }

    public static String func_151206_a(JsonElement jsonElement, String string) {
        if (jsonElement.isJsonPrimitive()) {
            return jsonElement.getAsString();
        }
        throw new JsonSyntaxException("Expected " + string + " to be a string, was " + JsonUtils.func_151222_d(jsonElement));
    }

    public static String func_151200_h(JsonObject jsonObject, String string) {
        if (jsonObject.has(string)) {
            return JsonUtils.func_151206_a(jsonObject.get(string), string);
        }
        throw new JsonSyntaxException("Missing " + string + ", expected to find a string");
    }

    public static String func_151219_a(JsonObject jsonObject, String string, String string2) {
        if (jsonObject.has(string)) {
            return JsonUtils.func_151206_a(jsonObject.get(string), string);
        }
        return string2;
    }

    public static Item func_188172_b(JsonElement jsonElement, String string2) {
        String string2;
        if (jsonElement.isJsonPrimitive()) {
            \u2603 = jsonElement.getAsString();
            Item item = IRegistry.field_212630_s.func_212608_b(new ResourceLocation(\u2603));
            if (item == null) {
                throw new JsonSyntaxException("Expected " + string2 + " to be an item, was unknown string '" + \u2603 + "'");
            }
            return item;
        }
        throw new JsonSyntaxException("Expected " + string2 + " to be an item, was " + JsonUtils.func_151222_d(jsonElement));
    }

    public static Item func_188180_i(JsonObject jsonObject, String string) {
        if (jsonObject.has(string)) {
            return JsonUtils.func_188172_b(jsonObject.get(string), string);
        }
        throw new JsonSyntaxException("Missing " + string + ", expected to find an item");
    }

    public static boolean func_151216_b(JsonElement jsonElement, String string) {
        if (jsonElement.isJsonPrimitive()) {
            return jsonElement.getAsBoolean();
        }
        throw new JsonSyntaxException("Expected " + string + " to be a Boolean, was " + JsonUtils.func_151222_d(jsonElement));
    }

    public static boolean func_151212_i(JsonObject jsonObject, String string) {
        if (jsonObject.has(string)) {
            return JsonUtils.func_151216_b(jsonObject.get(string), string);
        }
        throw new JsonSyntaxException("Missing " + string + ", expected to find a Boolean");
    }

    public static boolean func_151209_a(JsonObject jsonObject, String string, boolean bl) {
        if (jsonObject.has(string)) {
            return JsonUtils.func_151216_b(jsonObject.get(string), string);
        }
        return bl;
    }

    public static float func_151220_d(JsonElement jsonElement, String string) {
        if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isNumber()) {
            return jsonElement.getAsFloat();
        }
        throw new JsonSyntaxException("Expected " + string + " to be a Float, was " + JsonUtils.func_151222_d(jsonElement));
    }

    public static float func_151217_k(JsonObject jsonObject, String string) {
        if (jsonObject.has(string)) {
            return JsonUtils.func_151220_d(jsonObject.get(string), string);
        }
        throw new JsonSyntaxException("Missing " + string + ", expected to find a Float");
    }

    public static float func_151221_a(JsonObject jsonObject, String string, float f) {
        if (jsonObject.has(string)) {
            return JsonUtils.func_151220_d(jsonObject.get(string), string);
        }
        return f;
    }

    public static int func_151215_f(JsonElement jsonElement, String string) {
        if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isNumber()) {
            return jsonElement.getAsInt();
        }
        throw new JsonSyntaxException("Expected " + string + " to be a Int, was " + JsonUtils.func_151222_d(jsonElement));
    }

    public static int func_151203_m(JsonObject jsonObject, String string) {
        if (jsonObject.has(string)) {
            return JsonUtils.func_151215_f(jsonObject.get(string), string);
        }
        throw new JsonSyntaxException("Missing " + string + ", expected to find a Int");
    }

    public static int func_151208_a(JsonObject jsonObject, String string, int n) {
        if (jsonObject.has(string)) {
            return JsonUtils.func_151215_f(jsonObject.get(string), string);
        }
        return n;
    }

    public static byte func_204332_h(JsonElement jsonElement, String string) {
        if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isNumber()) {
            return jsonElement.getAsByte();
        }
        throw new JsonSyntaxException("Expected " + string + " to be a Byte, was " + JsonUtils.func_151222_d(jsonElement));
    }

    public static byte func_204331_o(JsonObject jsonObject, String string) {
        if (jsonObject.has(string)) {
            return JsonUtils.func_204332_h(jsonObject.get(string), string);
        }
        throw new JsonSyntaxException("Missing " + string + ", expected to find a Byte");
    }

    public static JsonObject func_151210_l(JsonElement jsonElement, String string) {
        if (jsonElement.isJsonObject()) {
            return jsonElement.getAsJsonObject();
        }
        throw new JsonSyntaxException("Expected " + string + " to be a JsonObject, was " + JsonUtils.func_151222_d(jsonElement));
    }

    public static JsonObject func_152754_s(JsonObject jsonObject, String string) {
        if (jsonObject.has(string)) {
            return JsonUtils.func_151210_l(jsonObject.get(string), string);
        }
        throw new JsonSyntaxException("Missing " + string + ", expected to find a JsonObject");
    }

    public static JsonObject func_151218_a(JsonObject jsonObject, String string, JsonObject jsonObject2) {
        if (jsonObject.has(string)) {
            return JsonUtils.func_151210_l(jsonObject.get(string), string);
        }
        return jsonObject2;
    }

    public static JsonArray func_151207_m(JsonElement jsonElement, String string) {
        if (jsonElement.isJsonArray()) {
            return jsonElement.getAsJsonArray();
        }
        throw new JsonSyntaxException("Expected " + string + " to be a JsonArray, was " + JsonUtils.func_151222_d(jsonElement));
    }

    public static JsonArray func_151214_t(JsonObject jsonObject, String string) {
        if (jsonObject.has(string)) {
            return JsonUtils.func_151207_m(jsonObject.get(string), string);
        }
        throw new JsonSyntaxException("Missing " + string + ", expected to find a JsonArray");
    }

    public static JsonArray func_151213_a(JsonObject jsonObject, String string, @Nullable JsonArray jsonArray) {
        if (jsonObject.has(string)) {
            return JsonUtils.func_151207_m(jsonObject.get(string), string);
        }
        return jsonArray;
    }

    public static <T> T func_188179_a(@Nullable JsonElement jsonElement, String string, JsonDeserializationContext jsonDeserializationContext, Class<? extends T> clazz) {
        if (jsonElement != null) {
            return (T)jsonDeserializationContext.deserialize(jsonElement, clazz);
        }
        throw new JsonSyntaxException("Missing " + string);
    }

    public static <T> T func_188174_a(JsonObject jsonObject, String string, JsonDeserializationContext jsonDeserializationContext, Class<? extends T> clazz) {
        if (jsonObject.has(string)) {
            return JsonUtils.func_188179_a(jsonObject.get(string), string, jsonDeserializationContext, clazz);
        }
        throw new JsonSyntaxException("Missing " + string);
    }

    public static <T> T func_188177_a(JsonObject jsonObject, String string, T t, JsonDeserializationContext jsonDeserializationContext, Class<? extends T> clazz) {
        if (jsonObject.has(string)) {
            return JsonUtils.func_188179_a(jsonObject.get(string), string, jsonDeserializationContext, clazz);
        }
        return t;
    }

    public static String func_151222_d(JsonElement jsonElement) {
        String string = StringUtils.abbreviateMiddle((String)String.valueOf(jsonElement), (String)"...", (int)10);
        if (jsonElement == null) {
            return "null (missing)";
        }
        if (jsonElement.isJsonNull()) {
            return "null (json)";
        }
        if (jsonElement.isJsonArray()) {
            return "an array (" + string + ")";
        }
        if (jsonElement.isJsonObject()) {
            return "an object (" + string + ")";
        }
        if (jsonElement.isJsonPrimitive()) {
            JsonPrimitive jsonPrimitive = jsonElement.getAsJsonPrimitive();
            if (jsonPrimitive.isNumber()) {
                return "a number (" + string + ")";
            }
            if (jsonPrimitive.isBoolean()) {
                return "a boolean (" + string + ")";
            }
        }
        return string;
    }

    @Nullable
    public static <T> T func_188173_a(Gson gson, Reader reader, Class<T> clazz, boolean bl) {
        try {
            JsonReader jsonReader = new JsonReader(reader);
            jsonReader.setLenient(bl);
            return (T)gson.getAdapter(clazz).read(jsonReader);
        }
        catch (IOException iOException) {
            throw new JsonParseException((Throwable)iOException);
        }
    }

    @Nullable
    public static <T> T func_193838_a(Gson gson, Reader reader, Type type, boolean bl) {
        try {
            JsonReader jsonReader = new JsonReader(reader);
            jsonReader.setLenient(bl);
            return (T)gson.getAdapter(TypeToken.get((Type)type)).read(jsonReader);
        }
        catch (IOException iOException) {
            throw new JsonParseException((Throwable)iOException);
        }
    }

    @Nullable
    public static <T> T func_193837_a(Gson gson, String string, Type type, boolean bl) {
        return JsonUtils.func_193838_a(gson, new StringReader(string), type, bl);
    }

    @Nullable
    public static <T> T func_188176_a(Gson gson, String string, Class<T> clazz, boolean bl) {
        return JsonUtils.func_188173_a(gson, new StringReader(string), clazz, bl);
    }

    @Nullable
    public static <T> T func_193841_a(Gson gson, Reader reader, Type type) {
        return JsonUtils.func_193838_a(gson, reader, type, false);
    }

    @Nullable
    public static <T> T func_193840_a(Gson gson, String string, Type type) {
        return JsonUtils.func_193837_a(gson, string, type, false);
    }

    @Nullable
    public static <T> T func_193839_a(Gson gson, Reader reader, Class<T> clazz) {
        return JsonUtils.func_188173_a(gson, reader, clazz, false);
    }

    @Nullable
    public static <T> T func_188178_a(Gson gson, String string, Class<T> clazz) {
        return JsonUtils.func_188176_a(gson, string, clazz, false);
    }

    public static JsonObject func_212746_a(String string, boolean bl) {
        return JsonUtils.func_212744_a(new StringReader(string), bl);
    }

    public static JsonObject func_212744_a(Reader reader, boolean bl) {
        return JsonUtils.func_188173_a(field_212747_a, reader, JsonObject.class, bl);
    }

    public static JsonObject func_212745_a(String string) {
        return JsonUtils.func_212746_a(string, false);
    }

    public static JsonObject func_212743_a(Reader reader) {
        return JsonUtils.func_212744_a(reader, false);
    }
}

