/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.Hash;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.state.IProperty;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Util {
    public static LongSupplier field_211180_a = System::nanoTime;
    private static final Logger field_195650_a = LogManager.getLogger();
    private static final Pattern field_209538_b = Pattern.compile(".*\\.|(?:CON|PRN|AUX|NUL|COM1|COM2|COM3|COM4|COM5|COM6|COM7|COM8|COM9|LPT1|LPT2|LPT3|LPT4|LPT5|LPT6|LPT7|LPT8|LPT9)(?:\\..*)?", 2);

    public static <K, V> Collector<Map.Entry<? extends K, ? extends V>, ?, Map<K, V>> func_199749_a() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <T extends Comparable<T>> String func_200269_a(IProperty<T> iProperty, Object object) {
        return iProperty.func_177702_a((Comparable)object);
    }

    public static String func_200697_a(String string, @Nullable ResourceLocation resourceLocation) {
        if (resourceLocation == null) {
            return string + ".unregistered_sadface";
        }
        return string + '.' + resourceLocation.func_110624_b() + '.' + resourceLocation.func_110623_a().replace('/', '.');
    }

    public static long func_211177_b() {
        return Util.func_211178_c() / 1000000L;
    }

    public static long func_211178_c() {
        return field_211180_a.getAsLong();
    }

    public static long func_211179_d() {
        return Instant.now().toEpochMilli();
    }

    public static EnumOS func_110647_a() {
        String string = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (string.contains("win")) {
            return EnumOS.WINDOWS;
        }
        if (string.contains("mac")) {
            return EnumOS.OSX;
        }
        if (string.contains("solaris")) {
            return EnumOS.SOLARIS;
        }
        if (string.contains("sunos")) {
            return EnumOS.SOLARIS;
        }
        if (string.contains("linux")) {
            return EnumOS.LINUX;
        }
        if (string.contains("unix")) {
            return EnumOS.LINUX;
        }
        return EnumOS.UNKNOWN;
    }

    public static Stream<String> func_211565_f() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        return runtimeMXBean.getInputArguments().stream().filter(string -> string.startsWith("-X"));
    }

    public static boolean func_209537_a(Path path) {
        \u2603 = path.normalize();
        return \u2603.equals(path);
    }

    public static boolean func_209536_b(Path path) {
        for (Path path2 : path) {
            if (!field_209538_b.matcher(path2.toString()).matches()) continue;
            return false;
        }
        return true;
    }

    public static Path func_209535_a(Path path, String string, String string2) {
        \u2603 = string + string2;
        Path path2 = Paths.get(\u2603, new String[0]);
        if (path2.endsWith(string2)) {
            throw new InvalidPathException(\u2603, "empty resource name");
        }
        return path.resolve(path2);
    }

    @Nullable
    public static <V> V func_181617_a(FutureTask<V> futureTask, Logger logger) {
        try {
            futureTask.run();
            return futureTask.get();
        }
        catch (ExecutionException executionException) {
            logger.fatal("Error executing task", (Throwable)executionException);
        }
        catch (InterruptedException interruptedException) {
            logger.fatal("Error executing task", (Throwable)interruptedException);
        }
        return null;
    }

    public static <T> T func_184878_a(List<T> list) {
        return list.get(list.size() - 1);
    }

    public static <T> T func_195647_a(Iterable<T> iterable, @Nullable T t) {
        Iterator<T> iterator = iterable.iterator();
        T \u26032 = iterator.next();
        if (t != null) {
            T t2 = \u26032;
            while (true) {
                if (t2 == t) {
                    if (!iterator.hasNext()) break;
                    return iterator.next();
                }
                if (!iterator.hasNext()) continue;
                t2 = iterator.next();
            }
        }
        return \u26032;
    }

    public static <T> T func_195648_b(Iterable<T> iterable, @Nullable T t) {
        Iterator<T> iterator = iterable.iterator();
        T \u26032 = null;
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            if (t2 == t) {
                if (\u26032 != null) break;
                \u26032 = (T)(iterator.hasNext() ? Iterators.getLast(iterator) : t);
                break;
            }
            \u26032 = t2;
        }
        return \u26032;
    }

    public static <T> T func_199748_a(Supplier<T> supplier) {
        return supplier.get();
    }

    public static <T> T func_200696_a(T t, Consumer<T> consumer) {
        consumer.accept(t);
        return t;
    }

    public static <K> Hash.Strategy<K> func_212443_g() {
        return IdentityStrategy.INSTANCE;
    }

    static enum IdentityStrategy implements Hash.Strategy<Object>
    {
        INSTANCE;


        public int hashCode(Object object) {
            return System.identityHashCode(object);
        }

        public boolean equals(Object object, Object object2) {
            return object == object2;
        }
    }

    public static enum EnumOS {
        LINUX,
        SOLARIS,
        WINDOWS{

            @Override
            protected String[] func_195643_b(URL uRL) {
                return new String[]{"rundll32", "url.dll,FileProtocolHandler", uRL.toString()};
            }
        }
        ,
        OSX{

            @Override
            protected String[] func_195643_b(URL uRL) {
                return new String[]{"open", uRL.toString()};
            }
        }
        ,
        UNKNOWN;


        public void func_195639_a(URL uRL) {
            try {
                Process process = AccessController.doPrivileged(() -> Runtime.getRuntime().exec(this.func_195643_b(uRL)));
                for (String string : IOUtils.readLines((InputStream)process.getErrorStream())) {
                    field_195650_a.error(string);
                }
                process.getInputStream().close();
                process.getErrorStream().close();
                process.getOutputStream().close();
            }
            catch (IOException | PrivilegedActionException exception) {
                field_195650_a.error("Couldn't open url '{}'", (Object)uRL, (Object)exception);
            }
        }

        public void func_195642_a(URI uRI) {
            try {
                this.func_195639_a(uRI.toURL());
            }
            catch (MalformedURLException malformedURLException) {
                field_195650_a.error("Couldn't open uri '{}'", (Object)uRI, (Object)malformedURLException);
            }
        }

        public void func_195641_a(File file) {
            try {
                this.func_195639_a(file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                field_195650_a.error("Couldn't open file '{}'", (Object)file, (Object)malformedURLException);
            }
        }

        protected String[] func_195643_b(URL uRL) {
            String string = uRL.toString();
            if ("file".equals(uRL.getProtocol())) {
                string = string.replace("file:", "file://");
            }
            return new String[]{"xdg-open", string};
        }

        public void func_195640_a(String string) {
            try {
                this.func_195639_a(new URI(string).toURL());
            }
            catch (IllegalArgumentException | MalformedURLException | URISyntaxException exception) {
                field_195650_a.error("Couldn't open uri '{}'", (Object)string, (Object)exception);
            }
        }
    }
}

