/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMaps;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenCustomHashMap;
import java.io.File;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import net.minecraft.util.Util;
import net.minecraft.util.WorldChunkEnumerator;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraft.world.storage.WorldSavedDataStorage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldOptimizer {
    private static final Logger field_212219_a = LogManager.getLogger();
    private static final ThreadFactory field_212220_b = new ThreadFactoryBuilder().setDaemon(true).build();
    private final String field_212237_s;
    private final ISaveHandler field_212221_c;
    private final WorldSavedDataStorage field_212222_d;
    private final Thread field_212223_e;
    private volatile boolean field_212224_f = true;
    private volatile boolean field_212225_g = false;
    private volatile float field_212232_n;
    private volatile int field_212233_o;
    private volatile int field_212234_p = 0;
    private volatile int field_212235_q = 0;
    private final Object2FloatMap<DimensionType> field_212544_m = Object2FloatMaps.synchronize((Object2FloatMap)new Object2FloatOpenCustomHashMap(Util.func_212443_g()));
    private volatile ITextComponent field_212236_r = new TextComponentTranslation("optimizeWorld.stage.counting", new Object[0]);

    public WorldOptimizer(String string, ISaveFormat iSaveFormat, WorldInfo worldInfo) {
        this.field_212237_s = worldInfo.func_76065_j();
        this.field_212221_c = iSaveFormat.func_197715_a(string, null);
        this.field_212221_c.func_75761_a(worldInfo);
        this.field_212222_d = new WorldSavedDataStorage(this.field_212221_c);
        this.field_212223_e = field_212220_b.newThread(this::func_212216_o);
        this.field_212223_e.setUncaughtExceptionHandler(this::func_212206_a);
        this.field_212223_e.start();
    }

    private void func_212206_a(Thread thread, Throwable throwable) {
        field_212219_a.error("Error upgrading world", throwable);
        this.field_212224_f = false;
        this.field_212236_r = new TextComponentTranslation("optimizeWorld.stage.failed", new Object[0]);
    }

    public void func_212217_a() {
        this.field_212224_f = false;
        try {
            this.field_212223_e.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void func_212216_o() {
        File file = this.field_212221_c.func_75765_b();
        WorldChunkEnumerator \u26032 = new WorldChunkEnumerator(file);
        ImmutableMap.Builder \u26033 = ImmutableMap.builder();
        for (DimensionType dimensionType : DimensionType.func_212681_b()) {
            \u26033.put((Object)dimensionType, (Object)new AnvilChunkLoader(dimensionType.func_212679_a(file), this.field_212221_c.func_197718_i()));
        }
        ImmutableMap immutableMap = \u26033.build();
        long \u26034 = Util.func_211177_b();
        this.field_212233_o = 0;
        ImmutableMap.Builder \u26035 = ImmutableMap.builder();
        for (DimensionType dimensionType : DimensionType.func_212681_b()) {
            Iterator<DimensionType> iterator = \u26032.func_212541_a(dimensionType);
            \u26035.put((Object)dimensionType, iterator.listIterator());
            this.field_212233_o += iterator.size();
        }
        ImmutableMap immutableMap2 = \u26035.build();
        float \u26036 = this.field_212233_o;
        this.field_212236_r = new TextComponentTranslation("optimizeWorld.stage.structures", new Object[0]);
        for (Map.Entry entry : immutableMap.entrySet()) {
            ((AnvilChunkLoader)entry.getValue()).func_212429_a((DimensionType)entry.getKey(), this.field_212222_d);
        }
        this.field_212222_d.func_75744_a();
        this.field_212236_r = new TextComponentTranslation("optimizeWorld.stage.upgrading", new Object[0]);
        if (\u26036 <= 0.0f) {
            for (DimensionType dimensionType : DimensionType.func_212681_b()) {
                this.field_212544_m.put((Object)dimensionType, 1.0f / (float)immutableMap.size());
            }
        }
        while (this.field_212224_f) {
            boolean bl = false;
            float f = 0.0f;
            for (DimensionType dimensionType : DimensionType.func_212681_b()) {
                ListIterator listIterator = (ListIterator)immutableMap2.get((Object)dimensionType);
                bl |= this.func_212542_a((AnvilChunkLoader)immutableMap.get(dimensionType), listIterator, dimensionType);
                if (!(\u26036 > 0.0f)) continue;
                float \u26038 = (float)listIterator.nextIndex() / \u26036;
                this.field_212544_m.put((Object)dimensionType, \u26038);
                f += \u26038;
            }
            this.field_212232_n = f;
            if (bl) continue;
            this.field_212224_f = false;
        }
        this.field_212236_r = new TextComponentTranslation("optimizeWorld.stage.finished", new Object[0]);
        \u26034 = Util.func_211177_b() - \u26034;
        field_212219_a.info("World optimizaton finished after {} ms", (Object)\u26034);
        immutableMap.values().forEach(AnvilChunkLoader::func_75818_b);
        this.field_212222_d.func_75744_a();
        this.field_212221_c.func_75759_a();
        this.field_212225_g = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean func_212542_a(AnvilChunkLoader anvilChunkLoader, ListIterator<ChunkPos> listIterator, DimensionType dimensionType) {
        if (listIterator.hasNext()) {
            boolean bl;
            AnvilChunkLoader anvilChunkLoader2 = anvilChunkLoader;
            synchronized (anvilChunkLoader2) {
                bl = anvilChunkLoader.func_212147_a(listIterator.next(), dimensionType, this.field_212222_d);
            }
            if (bl) {
                ++this.field_212234_p;
            } else {
                ++this.field_212235_q;
            }
            return true;
        }
        return false;
    }

    public boolean func_212218_b() {
        return this.field_212225_g;
    }

    public float func_212543_a(DimensionType dimensionType) {
        return this.field_212544_m.getFloat((Object)dimensionType);
    }

    public float func_212207_i() {
        return this.field_212232_n;
    }

    public int func_212211_j() {
        return this.field_212233_o;
    }

    public int func_212208_k() {
        return this.field_212234_p;
    }

    public int func_212209_l() {
        return this.field_212235_q;
    }

    public ITextComponent func_212215_m() {
        return this.field_212236_r;
    }

    public String func_212214_n() {
        return this.field_212237_s;
    }
}

