/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.List;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import javax.annotation.Nullable;
import net.minecraft.util.BitArray;
import net.minecraft.util.datafix.TypeReferences;

public class LeavesFix
extends DataFix {
    private static final int[][] field_208425_a = new int[][]{{-1, 0, 0}, {1, 0, 0}, {0, -1, 0}, {0, 1, 0}, {0, 0, -1}, {0, 0, 1}};
    private static final Object2IntMap<String> field_208434_j = (Object2IntMap)DataFixUtils.make((Object)new Object2IntOpenHashMap(), object2IntOpenHashMap -> {
        object2IntOpenHashMap.put((Object)"minecraft:acacia_leaves", 0);
        object2IntOpenHashMap.put((Object)"minecraft:birch_leaves", 1);
        object2IntOpenHashMap.put((Object)"minecraft:dark_oak_leaves", 2);
        object2IntOpenHashMap.put((Object)"minecraft:jungle_leaves", 3);
        object2IntOpenHashMap.put((Object)"minecraft:oak_leaves", 4);
        object2IntOpenHashMap.put((Object)"minecraft:spruce_leaves", 5);
    });
    private static final Set<String> field_208435_k = ImmutableSet.of((Object)"minecraft:acacia_bark", (Object)"minecraft:birch_bark", (Object)"minecraft:dark_oak_bark", (Object)"minecraft:jungle_bark", (Object)"minecraft:oak_bark", (Object)"minecraft:spruce_bark", (Object[])new String[]{"minecraft:acacia_log", "minecraft:birch_log", "minecraft:dark_oak_log", "minecraft:jungle_log", "minecraft:oak_log", "minecraft:spruce_log", "minecraft:stripped_acacia_log", "minecraft:stripped_birch_log", "minecraft:stripped_dark_oak_log", "minecraft:stripped_jungle_log", "minecraft:stripped_oak_log", "minecraft:stripped_spruce_log"});

    public LeavesFix(Schema schema, boolean bl) {
        super(schema, bl);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(TypeReferences.field_211287_c);
        OpticFinder \u26032 = type.findField("Level");
        OpticFinder \u26033 = \u26032.type().findField("Sections");
        \u2603 = \u26033.type();
        if (!(\u2603 instanceof List.ListType)) {
            throw new IllegalStateException("Expecting sections to be a list.");
        }
        \u2603 = ((List.ListType)\u2603).getElement();
        OpticFinder \u26034 = DSL.typeFinder((Type)\u2603);
        return this.fixTypeEverywhereTyped("Leaves fix", type, typed2 -> typed2.updateTyped(\u26032, typed -> {
            int[] nArray = new int[]{0};
            Typed \u26032 = typed.updateTyped(\u26033, typed22 -> {
                Typed typed22;
                Int2ObjectOpenHashMap int2ObjectOpenHashMap = new Int2ObjectOpenHashMap(typed22.getAllTyped(\u26034).stream().map(typed -> new LeavesSection((Typed<?>)typed, this.getInputSchema())).collect(Collectors.toMap(Section::func_208456_b, leavesSection -> leavesSection)));
                if (int2ObjectOpenHashMap.values().stream().allMatch(Section::func_208461_a)) {
                    return typed22;
                }
                ArrayList \u26032 = Lists.newArrayList();
                for (int i = 0; i < 7; ++i) {
                    \u26032.add(new IntOpenHashSet());
                }
                for (LeavesSection \u26033 : int2ObjectOpenHashMap.values()) {
                    if (\u26033.func_208461_a()) continue;
                    for (int i = 0; i < 4096; ++i) {
                        \u2603 = \u26033.func_208453_a(i);
                        if (\u26033.func_208457_b(\u2603)) {
                            ((IntSet)\u26032.get(0)).add(\u26033.func_208456_b() << 12 | i);
                            continue;
                        }
                        if (!\u26033.func_208460_c(\u2603)) continue;
                        n = this.func_208412_a(i);
                        \u2603 = this.func_208409_c(i);
                        nArray[0] = nArray[0] | LeavesFix.func_210537_a(n == 0, n == 15, \u2603 == 0, \u2603 == 15);
                    }
                }
                for (int i = 1; i < 7; ++i) {
                    LeavesSection \u26033;
                    \u26033 = (IntSet)\u26032.get(i - 1);
                    IntSet intSet = (IntSet)\u26032.get(i);
                    IntIterator \u26034 = \u26033.iterator();
                    while (\u26034.hasNext()) {
                        int n = \u26034.nextInt();
                        \u2603 = this.func_208412_a(n);
                        \u2603 = this.func_208421_b(n);
                        \u2603 = this.func_208409_c(n);
                        for (int[] nArray2 : field_208425_a) {
                            int n2 = \u2603 + nArray2[0];
                            \u2603 = \u2603 + nArray2[1];
                            \u2603 = \u2603 + nArray2[2];
                            if (n2 < 0 || n2 > 15 || \u2603 < 0 || \u2603 > 15 || \u2603 < 0 || \u2603 > 255 || (\u2603 = (LeavesSection)int2ObjectOpenHashMap.get(\u2603 >> 4)) == null || \u2603.func_208461_a() || !\u2603.func_208460_c(\u2603 = \u2603.func_208453_a(\u2603 = LeavesFix.func_208411_a(n2, \u2603 & 0xF, \u2603))) || (\u2603 = \u2603.func_208459_d(\u2603)) <= i) continue;
                            \u2603.func_208454_a(\u2603, \u2603, i);
                            intSet.add(LeavesFix.func_208411_a(n2, \u2603, \u2603));
                        }
                    }
                }
                return typed22.updateTyped(\u26034, arg_0 -> LeavesFix.func_208413_a((Int2ObjectMap)int2ObjectOpenHashMap, arg_0));
            });
            if (nArray[0] != 0) {
                \u26032 = \u26032.update(DSL.remainderFinder(), dynamic -> {
                    \u2603 = (Dynamic)DataFixUtils.orElse((Optional)dynamic.get("UpgradeData"), (Object)dynamic.emptyMap());
                    return dynamic.set("UpgradeData", \u2603.set("Sides", dynamic.createByte((byte)(\u2603.getByte("Sides") | nArray[0]))));
                });
            }
            return \u26032;
        }));
    }

    public static int func_208411_a(int n, int n2, int n3) {
        return n2 << 8 | n3 << 4 | n;
    }

    private int func_208412_a(int n) {
        return n & 0xF;
    }

    private int func_208421_b(int n) {
        return n >> 8 & 0xFF;
    }

    private int func_208409_c(int n) {
        return n >> 4 & 0xF;
    }

    public static int func_210537_a(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n = 0;
        if (bl3) {
            n = bl2 ? (n |= 2) : (bl ? (n |= 0x80) : (n |= 1));
        } else if (bl4) {
            n = bl ? (n |= 0x20) : (bl2 ? (n |= 8) : (n |= 0x10));
        } else if (bl2) {
            n |= 4;
        } else if (bl) {
            n |= 0x40;
        }
        return n;
    }

    private static /* synthetic */ Typed func_208413_a(Int2ObjectMap int2ObjectMap, Typed typed) {
        return ((LeavesSection)int2ObjectMap.get(((Dynamic)typed.get(DSL.remainderFinder())).getInt("Y"))).func_208465_a(typed);
    }

    public static final class LeavesSection
    extends Section {
        @Nullable
        private IntSet field_212523_f;
        @Nullable
        private IntSet field_212524_g;
        @Nullable
        private Int2IntMap field_212525_h;

        public LeavesSection(Typed<?> typed, Schema schema) {
            super(typed, schema);
        }

        @Override
        protected boolean func_212508_a() {
            this.field_212523_f = new IntOpenHashSet();
            this.field_212524_g = new IntOpenHashSet();
            this.field_212525_h = new Int2IntOpenHashMap();
            for (int i = 0; i < this.field_208469_d.size(); ++i) {
                Dynamic dynamic2 = (Dynamic)this.field_208469_d.get(i);
                String \u26032 = dynamic2.getString("Name");
                if (field_208434_j.containsKey((Object)\u26032)) {
                    boolean bl = Objects.equals(dynamic2.get("Properties").flatMap(dynamic -> dynamic.get("decayable")).flatMap(Dynamic::getStringValue).orElse(""), "false");
                    this.field_212523_f.add(i);
                    this.field_212525_h.put(this.func_208464_a(\u26032, bl, 7), i);
                    this.field_208469_d.set(i, this.func_209770_a(dynamic2, \u26032, bl, 7));
                }
                if (!field_208435_k.contains(\u26032)) continue;
                this.field_212524_g.add(i);
            }
            return this.field_212523_f.isEmpty() && this.field_212524_g.isEmpty();
        }

        private Dynamic<?> func_209770_a(Dynamic<?> dynamic, String string, boolean bl, int n) {
            Dynamic dynamic2 = dynamic.emptyMap();
            dynamic2 = dynamic2.set("persistent", dynamic2.createString(bl ? "true" : "false"));
            dynamic2 = dynamic2.set("distance", dynamic2.createString(Integer.toString(n)));
            \u2603 = dynamic.emptyMap();
            \u2603 = \u2603.set("Properties", dynamic2);
            \u2603 = \u2603.set("Name", \u2603.createString(string));
            return \u2603;
        }

        public boolean func_208457_b(int n) {
            return this.field_212524_g.contains(n);
        }

        public boolean func_208460_c(int n) {
            return this.field_212523_f.contains(n);
        }

        private int func_208459_d(int n) {
            if (this.func_208457_b(n)) {
                return 0;
            }
            return Integer.parseInt(((Dynamic)this.field_208469_d.get(n)).get("Properties").flatMap(dynamic -> dynamic.get("distance")).flatMap(Dynamic::getStringValue).orElse(""));
        }

        private void func_208454_a(int n4, int n2, int n3) {
            int n4;
            int n5;
            Dynamic dynamic2 = (Dynamic)this.field_208469_d.get(n2);
            String \u26032 = dynamic2.getString("Name");
            int \u26033 = this.func_208464_a(\u26032, \u2603 = Objects.equals(dynamic2.get("Properties").flatMap(dynamic -> dynamic.get("persistent")).flatMap(Dynamic::getStringValue).orElse(""), "true"), n3);
            if (!this.field_212525_h.containsKey(\u26033)) {
                n5 = this.field_208469_d.size();
                this.field_212523_f.add(n5);
                this.field_212525_h.put(\u26033, n5);
                this.field_208469_d.add(this.func_209770_a(dynamic2, \u26032, \u2603, n3));
            }
            n5 = this.field_212525_h.get(\u26033);
            if (1 << this.field_208470_e.func_208535_c() <= n5) {
                BitArray bitArray = new BitArray(this.field_208470_e.func_208535_c() + 1, 4096);
                for (int i = 0; i < 4096; ++i) {
                    bitArray.func_188141_a(i, this.field_208470_e.func_188142_a(i));
                }
                this.field_208470_e = bitArray;
            }
            this.field_208470_e.func_188141_a(n4, n5);
        }
    }

    public static abstract class Section {
        final Type<Pair<String, Dynamic<?>>> field_208466_a = DSL.named((String)TypeReferences.field_211296_l.typeName(), (Type)DSL.remainderType());
        protected final OpticFinder<List<Pair<String, Dynamic<?>>>> field_208468_c = DSL.fieldFinder((String)"Palette", (Type)DSL.list(this.field_208466_a));
        protected final List<Dynamic<?>> field_208469_d;
        protected final int field_208474_i;
        @Nullable
        protected BitArray field_208470_e;

        public Section(Typed<?> typed, Schema schema) {
            if (!Objects.equals(schema.getType(TypeReferences.field_211296_l), this.field_208466_a)) {
                throw new IllegalStateException("Block state type is not what was expected.");
            }
            Optional optional = typed.getOptional(this.field_208468_c);
            this.field_208469_d = optional.map(list -> list.stream().map(Pair::getSecond).collect(Collectors.toList())).orElse((List)ImmutableList.of());
            Dynamic \u26032 = (Dynamic)typed.get(DSL.remainderFinder());
            this.field_208474_i = \u26032.getInt("Y");
            this.func_212507_a(\u26032);
        }

        protected void func_212507_a(Dynamic<?> dynamic) {
            if (this.func_212508_a()) {
                this.field_208470_e = null;
            } else {
                long[] lArray = ((LongStream)dynamic.get("BlockStates").flatMap(Dynamic::getLongStream).get()).toArray();
                int \u26032 = Math.max(4, DataFixUtils.ceillog2((int)this.field_208469_d.size()));
                this.field_208470_e = new BitArray(\u26032, 4096, lArray);
            }
        }

        public Typed<?> func_208465_a(Typed<?> typed) {
            if (this.func_208461_a()) {
                return typed;
            }
            return typed.update(DSL.remainderFinder(), dynamic -> dynamic.set("BlockStates", dynamic.createLongList(Arrays.stream(this.field_208470_e.func_188143_a())))).set(this.field_208468_c, this.field_208469_d.stream().map(dynamic -> Pair.of((Object)TypeReferences.field_211296_l.typeName(), (Object)dynamic)).collect(Collectors.toList()));
        }

        public boolean func_208461_a() {
            return this.field_208470_e == null;
        }

        public int func_208453_a(int n) {
            return this.field_208470_e.func_188142_a(n);
        }

        protected int func_208464_a(String string, boolean bl, int n) {
            return field_208434_j.get((Object)string) << 5 | (bl ? 16 : 0) | n;
        }

        int func_208456_b() {
            return this.field_208474_i;
        }

        protected abstract boolean func_212508_a();
    }
}

