/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.math.shapes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.math.DoubleMath;
import com.google.common.math.IntMath;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.util.AxisRotation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.DoubleCubeMergingList;
import net.minecraft.util.math.shapes.DoubleRangeList;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.IDoubleListMerger;
import net.minecraft.util.math.shapes.IndirectMerger;
import net.minecraft.util.math.shapes.NonOverlappingMerger;
import net.minecraft.util.math.shapes.SimpleDoubleMerger;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapeArray;
import net.minecraft.util.math.shapes.VoxelShapeCube;
import net.minecraft.util.math.shapes.VoxelShapePart;
import net.minecraft.util.math.shapes.VoxelShapePartBitSet;
import net.minecraft.util.math.shapes.VoxelShapeSplit;

public final class VoxelShapes {
    private static final VoxelShape field_197886_a = new VoxelShapeArray((VoxelShapePart)new VoxelShapePartBitSet(0, 0, 0), (DoubleList)new DoubleArrayList(new double[]{0.0}), (DoubleList)new DoubleArrayList(new double[]{0.0}), (DoubleList)new DoubleArrayList(new double[]{0.0}));
    private static final VoxelShape field_197887_b = Util.func_199748_a(() -> {
        VoxelShapePartBitSet voxelShapePartBitSet = new VoxelShapePartBitSet(1, 1, 1);
        ((VoxelShapePart)voxelShapePartBitSet).func_199625_a(0, 0, 0, true, true);
        return new VoxelShapeCube(voxelShapePartBitSet);
    });

    public static VoxelShape func_197880_a() {
        return field_197886_a;
    }

    public static VoxelShape func_197868_b() {
        return field_197887_b;
    }

    public static VoxelShape func_197873_a(double d, double d2, double d3, double d4, double d5, double d6) {
        return VoxelShapes.func_197881_a(new AxisAlignedBB(d, d2, d3, d4, d5, d6));
    }

    public static VoxelShape func_197881_a(AxisAlignedBB axisAlignedBB) {
        int n = VoxelShapes.func_197885_a(axisAlignedBB.field_72340_a, axisAlignedBB.field_72336_d);
        \u2603 = VoxelShapes.func_197885_a(axisAlignedBB.field_72338_b, axisAlignedBB.field_72337_e);
        \u2603 = VoxelShapes.func_197885_a(axisAlignedBB.field_72339_c, axisAlignedBB.field_72334_f);
        if (n < 0 || \u2603 < 0 || \u2603 < 0) {
            return new VoxelShapeArray(VoxelShapes.field_197887_b.field_197768_g, new double[]{axisAlignedBB.field_72340_a, axisAlignedBB.field_72336_d}, new double[]{axisAlignedBB.field_72338_b, axisAlignedBB.field_72337_e}, new double[]{axisAlignedBB.field_72339_c, axisAlignedBB.field_72334_f});
        }
        if (n == 0 && \u2603 == 0 && \u2603 == 0) {
            return axisAlignedBB.func_197744_e(0.5, 0.5, 0.5) ? VoxelShapes.func_197868_b() : VoxelShapes.func_197880_a();
        }
        \u2603 = 1 << n;
        \u2603 = 1 << \u2603;
        \u2603 = 1 << \u2603;
        \u2603 = (int)Math.round(axisAlignedBB.field_72340_a * (double)\u2603);
        \u2603 = (int)Math.round(axisAlignedBB.field_72336_d * (double)\u2603);
        \u2603 = (int)Math.round(axisAlignedBB.field_72338_b * (double)\u2603);
        \u2603 = (int)Math.round(axisAlignedBB.field_72337_e * (double)\u2603);
        \u2603 = (int)Math.round(axisAlignedBB.field_72339_c * (double)\u2603);
        \u2603 = (int)Math.round(axisAlignedBB.field_72334_f * (double)\u2603);
        VoxelShapePartBitSet \u26032 = new VoxelShapePartBitSet(\u2603, \u2603, \u2603, \u2603, \u2603, \u2603, \u2603, \u2603, \u2603);
        for (long i = (long)\u2603; i < (long)\u2603; ++i) {
            for (\u2603 = (long)\u2603; \u2603 < (long)\u2603; ++\u2603) {
                for (\u2603 = (long)\u2603; \u2603 < (long)\u2603; ++\u2603) {
                    \u26032.func_199625_a((int)i, (int)\u2603, (int)\u2603, false, true);
                }
            }
        }
        return new VoxelShapeCube(\u26032);
    }

    private static int func_197885_a(double d, double d2) {
        if (d < -1.0E-7 || d2 > 1.0000001) {
            return -1;
        }
        for (int i = 0; i <= 3; ++i) {
            double d3 = d * (double)(1 << i);
            \u2603 = d2 * (double)(1 << i);
            boolean \u26032 = Math.abs(d3 - Math.floor(d3)) < 1.0E-7;
            boolean bl = \u2603 = Math.abs(\u2603 - Math.floor(\u2603)) < 1.0E-7;
            if (!\u26032 || !\u2603) continue;
            return i;
        }
        return -1;
    }

    protected static long func_197877_a(int n, int n2) {
        return (long)n * (long)(n2 / IntMath.gcd((int)n, (int)n2));
    }

    public static VoxelShape func_197872_a(VoxelShape voxelShape, VoxelShape voxelShape2) {
        return VoxelShapes.func_197878_a(voxelShape, voxelShape2, IBooleanFunction.OR);
    }

    public static VoxelShape func_197878_a(VoxelShape voxelShape, VoxelShape voxelShape2, IBooleanFunction iBooleanFunction) {
        return VoxelShapes.func_197882_b(voxelShape, voxelShape2, iBooleanFunction).func_197753_c();
    }

    public static VoxelShape func_197882_b(VoxelShape voxelShape, VoxelShape voxelShape2, IBooleanFunction iBooleanFunction) {
        if (iBooleanFunction.apply(false, false)) {
            throw new IllegalArgumentException();
        }
        if (voxelShape == voxelShape2) {
            return iBooleanFunction.apply(true, true) ? voxelShape : VoxelShapes.func_197880_a();
        }
        boolean bl = iBooleanFunction.apply(true, false);
        \u2603 = iBooleanFunction.apply(false, true);
        if (voxelShape.func_197766_b()) {
            return \u2603 ? voxelShape2 : VoxelShapes.func_197880_a();
        }
        if (voxelShape2.func_197766_b()) {
            return bl ? voxelShape : VoxelShapes.func_197880_a();
        }
        IDoubleListMerger \u26032 = VoxelShapes.func_199410_a(1, voxelShape.func_197757_a(EnumFacing.Axis.X), voxelShape2.func_197757_a(EnumFacing.Axis.X), bl, \u2603);
        IDoubleListMerger \u26033 = VoxelShapes.func_199410_a(\u26032.func_212435_a().size() - 1, voxelShape.func_197757_a(EnumFacing.Axis.Y), voxelShape2.func_197757_a(EnumFacing.Axis.Y), bl, \u2603);
        IDoubleListMerger \u26034 = VoxelShapes.func_199410_a((\u26032.func_212435_a().size() - 1) * (\u26033.func_212435_a().size() - 1), voxelShape.func_197757_a(EnumFacing.Axis.Z), voxelShape2.func_197757_a(EnumFacing.Axis.Z), bl, \u2603);
        VoxelShapePartBitSet \u26035 = VoxelShapePartBitSet.func_197852_a(voxelShape.field_197768_g, voxelShape2.field_197768_g, \u26032, \u26033, \u26034, iBooleanFunction);
        if (\u26032 instanceof DoubleCubeMergingList && \u26033 instanceof DoubleCubeMergingList && \u26034 instanceof DoubleCubeMergingList) {
            return new VoxelShapeCube(\u26035);
        }
        return new VoxelShapeArray((VoxelShapePart)\u26035, \u26032.func_212435_a(), \u26033.func_212435_a(), \u26034.func_212435_a());
    }

    public static boolean func_197879_c(VoxelShape voxelShape3, VoxelShape voxelShape2, IBooleanFunction iBooleanFunction) {
        VoxelShape voxelShape3;
        if (iBooleanFunction.apply(false, false)) {
            throw new IllegalArgumentException();
        }
        if (voxelShape3 == voxelShape2) {
            return iBooleanFunction.apply(true, true);
        }
        if (voxelShape3.func_197766_b()) {
            return iBooleanFunction.apply(false, !voxelShape2.func_197766_b());
        }
        if (voxelShape2.func_197766_b()) {
            return iBooleanFunction.apply(!voxelShape3.func_197766_b(), false);
        }
        boolean bl = iBooleanFunction.apply(true, false);
        \u2603 = iBooleanFunction.apply(false, true);
        for (EnumFacing.Axis axis : AxisRotation.field_197521_d) {
            if (voxelShape3.func_197758_c(axis) < voxelShape2.func_197762_b(axis) - 1.0E-7) {
                return bl || \u2603;
            }
            if (!(voxelShape2.func_197758_c(axis) < voxelShape3.func_197762_b(axis) - 1.0E-7)) continue;
            return bl || \u2603;
        }
        IDoubleListMerger \u26032 = VoxelShapes.func_199410_a(1, voxelShape3.func_197757_a(EnumFacing.Axis.X), voxelShape2.func_197757_a(EnumFacing.Axis.X), bl, \u2603);
        IDoubleListMerger \u26033 = VoxelShapes.func_199410_a(\u26032.func_212435_a().size() - 1, voxelShape3.func_197757_a(EnumFacing.Axis.Y), voxelShape2.func_197757_a(EnumFacing.Axis.Y), bl, \u2603);
        IDoubleListMerger \u26034 = VoxelShapes.func_199410_a((\u26032.func_212435_a().size() - 1) * (\u26033.func_212435_a().size() - 1), voxelShape3.func_197757_a(EnumFacing.Axis.Z), voxelShape2.func_197757_a(EnumFacing.Axis.Z), bl, \u2603);
        return VoxelShapes.func_197874_a(\u26032, \u26033, \u26034, voxelShape3.field_197768_g, voxelShape2.field_197768_g, iBooleanFunction);
    }

    private static boolean func_197874_a(IDoubleListMerger iDoubleListMerger, IDoubleListMerger iDoubleListMerger2, IDoubleListMerger iDoubleListMerger3, VoxelShapePart voxelShapePart, VoxelShapePart voxelShapePart2, IBooleanFunction iBooleanFunction) {
        return !iDoubleListMerger.func_197855_a((n, n2, n5) -> iDoubleListMerger2.func_197855_a((n3, n4, n8) -> iDoubleListMerger3.func_197855_a((n5, n6, n7) -> !iBooleanFunction.apply(voxelShapePart.func_197818_c(n, n3, n5), voxelShapePart2.func_197818_c(n2, n4, n6)))));
    }

    public static double func_212437_a(EnumFacing.Axis axis, AxisAlignedBB axisAlignedBB, Stream<VoxelShape> stream, double d2) {
        double d2;
        Iterator iterator = stream.iterator();
        while (iterator.hasNext()) {
            if (Math.abs(d2) < 1.0E-7) {
                return 0.0;
            }
            d2 = ((VoxelShape)iterator.next()).func_212430_a(axis, axisAlignedBB, d2);
        }
        return d2;
    }

    public static boolean func_197875_a(VoxelShape voxelShape, VoxelShape voxelShape2, EnumFacing enumFacing) {
        if (voxelShape == VoxelShapes.func_197868_b() && voxelShape2 == VoxelShapes.func_197868_b()) {
            return true;
        }
        if (voxelShape2.func_197766_b()) {
            return false;
        }
        EnumFacing.Axis axis = enumFacing.func_176740_k();
        EnumFacing.AxisDirection \u26032 = enumFacing.func_176743_c();
        VoxelShape \u26033 = \u26032 == EnumFacing.AxisDirection.POSITIVE ? voxelShape : voxelShape2;
        VoxelShape \u26034 = \u26032 == EnumFacing.AxisDirection.POSITIVE ? voxelShape2 : voxelShape;
        IBooleanFunction \u26035 = \u26032 == EnumFacing.AxisDirection.POSITIVE ? IBooleanFunction.ONLY_FIRST : IBooleanFunction.ONLY_SECOND;
        return DoubleMath.fuzzyEquals((double)\u26033.func_197758_c(axis), (double)1.0, (double)1.0E-7) && DoubleMath.fuzzyEquals((double)\u26034.func_197762_b(axis), (double)0.0, (double)1.0E-7) && !VoxelShapes.func_197879_c(new VoxelShapeSplit(\u26033, axis, \u26033.field_197768_g.func_197819_a(axis) - 1), new VoxelShapeSplit(\u26034, axis, 0), \u26035);
    }

    public static boolean func_204642_b(VoxelShape voxelShape, VoxelShape voxelShape2, EnumFacing enumFacing) {
        if (voxelShape == VoxelShapes.func_197868_b() || voxelShape2 == VoxelShapes.func_197868_b()) {
            return true;
        }
        EnumFacing.Axis axis = enumFacing.func_176740_k();
        EnumFacing.AxisDirection \u26032 = enumFacing.func_176743_c();
        VoxelShape \u26033 = \u26032 == EnumFacing.AxisDirection.POSITIVE ? voxelShape : voxelShape2;
        VoxelShape voxelShape3 = voxelShape4 = \u26032 == EnumFacing.AxisDirection.POSITIVE ? voxelShape2 : voxelShape;
        if (!DoubleMath.fuzzyEquals((double)\u26033.func_197758_c(axis), (double)1.0, (double)1.0E-7)) {
            \u26033 = VoxelShapes.func_197880_a();
        }
        if (!DoubleMath.fuzzyEquals((double)voxelShape4.func_197762_b(axis), (double)0.0, (double)1.0E-7)) {
            VoxelShape voxelShape4 = VoxelShapes.func_197880_a();
        }
        return !VoxelShapes.func_197879_c(VoxelShapes.func_197868_b(), VoxelShapes.func_197882_b(new VoxelShapeSplit(\u26033, axis, \u26033.field_197768_g.func_197819_a(axis) - 1), new VoxelShapeSplit(voxelShape4, axis, 0), IBooleanFunction.OR), IBooleanFunction.ONLY_FIRST);
    }

    @VisibleForTesting
    protected static IDoubleListMerger func_199410_a(int n, DoubleList doubleList, DoubleList doubleList2, boolean bl, boolean bl2) {
        if (doubleList instanceof DoubleRangeList && doubleList2 instanceof DoubleRangeList && (long)n * (\u2603 = VoxelShapes.func_197877_a(\u2603 = doubleList.size() - 1, \u2603 = doubleList2.size() - 1)) <= 256L) {
            return new DoubleCubeMergingList(\u2603, \u2603);
        }
        if (doubleList.getDouble(doubleList.size() - 1) < doubleList2.getDouble(0) - 1.0E-7) {
            return new NonOverlappingMerger(doubleList, doubleList2, false);
        }
        if (doubleList2.getDouble(doubleList2.size() - 1) < doubleList.getDouble(0) - 1.0E-7) {
            return new NonOverlappingMerger(doubleList2, doubleList, true);
        }
        if (Objects.equals(doubleList, doubleList2)) {
            if (doubleList instanceof SimpleDoubleMerger) {
                return (IDoubleListMerger)doubleList;
            }
            if (doubleList2 instanceof SimpleDoubleMerger) {
                return (IDoubleListMerger)doubleList2;
            }
            return new SimpleDoubleMerger(doubleList);
        }
        return new IndirectMerger(doubleList, doubleList2, bl, bl2);
    }

    public static interface LineConsumer {
        public void consume(double var1, double var3, double var5, double var7, double var9, double var11);
    }
}

