/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapeInt;
import net.minecraft.util.math.shapes.VoxelShapePartBitSet;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.EnumLightType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.gen.Heightmap;

public interface IWorldReaderBase
extends IBlockReader {
    public boolean func_175623_d(BlockPos var1);

    public Biome func_180494_b(BlockPos var1);

    public int func_175642_b(EnumLightType var1, BlockPos var2);

    default public boolean func_175710_j(BlockPos blockPos) {
        if (blockPos.func_177956_o() >= this.func_181545_F()) {
            return this.func_175678_i(blockPos);
        }
        \u26032 = new BlockPos(blockPos.func_177958_n(), this.func_181545_F(), blockPos.func_177952_p());
        if (!this.func_175678_i(\u26032)) {
            return false;
        }
        \u26032 = \u26032.func_177977_b();
        while (\u26032.func_177956_o() > blockPos.func_177956_o()) {
            IBlockState iBlockState = this.func_180495_p(\u26032);
            if (iBlockState.func_200016_a(this, \u26032) > 0 && !iBlockState.func_185904_a().func_76224_d()) {
                return false;
            }
            BlockPos \u26032 = \u26032.func_177977_b();
        }
        return true;
    }

    public int func_201669_a(BlockPos var1, int var2);

    public boolean func_175680_a(int var1, int var2, boolean var3);

    public boolean func_175678_i(BlockPos var1);

    default public BlockPos func_205770_a(Heightmap.Type type, BlockPos blockPos) {
        return new BlockPos(blockPos.func_177958_n(), this.func_201676_a(type, blockPos.func_177958_n(), blockPos.func_177952_p()), blockPos.func_177952_p());
    }

    public int func_201676_a(Heightmap.Type var1, int var2, int var3);

    default public float func_205052_D(BlockPos blockPos) {
        return this.func_201675_m().func_177497_p()[this.func_201696_r(blockPos)];
    }

    @Nullable
    default public EntityPlayer func_72890_a(Entity entity, double d) {
        return this.func_184137_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, d, false);
    }

    @Nullable
    default public EntityPlayer func_184136_b(Entity entity, double d) {
        return this.func_184137_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, d, true);
    }

    @Nullable
    default public EntityPlayer func_184137_a(double d, double d2, double d3, double d4, boolean bl) {
        Predicate<Entity> predicate = bl ? EntitySelectors.field_188444_d : EntitySelectors.field_180132_d;
        return this.func_190525_a(d, d2, d3, d4, predicate);
    }

    @Nullable
    public EntityPlayer func_190525_a(double var1, double var3, double var5, double var7, Predicate<Entity> var9);

    public int func_175657_ab();

    public WorldBorder func_175723_af();

    public boolean func_195585_a(@Nullable Entity var1, VoxelShape var2);

    public int func_175627_a(BlockPos var1, EnumFacing var2);

    public boolean func_201670_d();

    public int func_181545_F();

    default public boolean func_195584_a(IBlockState iBlockState, BlockPos blockPos) {
        VoxelShape voxelShape = iBlockState.func_196952_d(this, blockPos);
        return voxelShape.func_197766_b() || this.func_195585_a(null, voxelShape.func_197751_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()));
    }

    default public boolean func_195587_c(@Nullable Entity entity, AxisAlignedBB axisAlignedBB) {
        return this.func_195585_a(entity, VoxelShapes.func_197881_a(axisAlignedBB));
    }

    default public Stream<VoxelShape> func_212391_a(VoxelShape voxelShape, VoxelShape voxelShape3, boolean bl) {
        int n = MathHelper.func_76128_c(voxelShape.func_197762_b(EnumFacing.Axis.X)) - 1;
        \u2603 = MathHelper.func_76143_f(voxelShape.func_197758_c(EnumFacing.Axis.X)) + 1;
        \u2603 = MathHelper.func_76128_c(voxelShape.func_197762_b(EnumFacing.Axis.Y)) - 1;
        \u2603 = MathHelper.func_76143_f(voxelShape.func_197758_c(EnumFacing.Axis.Y)) + 1;
        \u2603 = MathHelper.func_76128_c(voxelShape.func_197762_b(EnumFacing.Axis.Z)) - 1;
        \u2603 = MathHelper.func_76143_f(voxelShape.func_197758_c(EnumFacing.Axis.Z)) + 1;
        WorldBorder \u26032 = this.func_175723_af();
        boolean \u26033 = \u26032.func_177726_b() < (double)n && (double)\u2603 < \u26032.func_177728_d() && \u26032.func_177736_c() < (double)\u2603 && (double)\u2603 < \u26032.func_177733_e();
        VoxelShapePartBitSet \u26034 = new VoxelShapePartBitSet(\u2603 - n, \u2603 - \u2603, \u2603 - \u2603);
        Predicate<VoxelShape> \u26035 = voxelShape2 -> !voxelShape2.func_197766_b() && VoxelShapes.func_197879_c(voxelShape, voxelShape2, IBooleanFunction.AND);
        Stream<VoxelShape> \u26036 = StreamSupport.stream(BlockPos.MutableBlockPos.func_191531_b(n, \u2603, \u2603, \u2603 - 1, \u2603 - 1, \u2603 - 1).spliterator(), false).map(mutableBlockPos -> {
            int n7 = mutableBlockPos.func_177958_n();
            \u2603 = mutableBlockPos.func_177956_o();
            \u2603 = mutableBlockPos.func_177952_p();
            boolean \u26032 = n7 == n || n7 == \u2603 - 1;
            boolean \u26033 = \u2603 == \u2603 || \u2603 == \u2603 - 1;
            boolean bl3 = \u2603 = \u2603 == \u2603 || \u2603 == \u2603 - 1;
            if (\u26032 && \u26033 || \u26033 && \u2603 || \u2603 && \u26032 || !this.func_175667_e((BlockPos)mutableBlockPos)) {
                return VoxelShapes.func_197880_a();
            }
            VoxelShape \u26034 = !bl || \u26033 || \u26032.func_177746_a((BlockPos)mutableBlockPos) ? this.func_180495_p((BlockPos)mutableBlockPos).func_196952_d(this, (BlockPos)mutableBlockPos) : VoxelShapes.func_197868_b();
            VoxelShape \u26035 = voxelShape3.func_197751_a(-n7, -\u2603, -\u2603);
            if (VoxelShapes.func_197879_c(\u26035, \u26034, IBooleanFunction.AND)) {
                return VoxelShapes.func_197880_a();
            }
            if (\u26034 == VoxelShapes.func_197868_b()) {
                \u26034.func_199625_a(n7 - n, \u2603 - \u2603, \u2603 - \u2603, true, true);
                return VoxelShapes.func_197880_a();
            }
            return \u26034.func_197751_a(n7, \u2603, \u2603);
        }).filter(\u26035);
        return Stream.concat(\u26036, Stream.generate(() -> new VoxelShapeInt(\u26034, n, \u2603, \u2603)).limit(1L).filter(\u26035));
    }

    default public Stream<VoxelShape> func_199406_a(@Nullable Entity entity, AxisAlignedBB axisAlignedBB, double d, double d2, double d3) {
        return this.func_212389_a(entity, axisAlignedBB, Collections.emptySet(), d, d2, d3);
    }

    default public Stream<VoxelShape> func_212389_a(@Nullable Entity entity, AxisAlignedBB axisAlignedBB, Set<Entity> set, double d, double d2, double d3) {
        \u2603 = 1.0E-7;
        VoxelShape voxelShape = VoxelShapes.func_197881_a(axisAlignedBB);
        \u2603 = VoxelShapes.func_197881_a(axisAlignedBB.func_72317_d(d > 0.0 ? -1.0E-7 : 1.0E-7, d2 > 0.0 ? -1.0E-7 : 1.0E-7, d3 > 0.0 ? -1.0E-7 : 1.0E-7));
        \u2603 = VoxelShapes.func_197882_b(VoxelShapes.func_197881_a(axisAlignedBB.func_72321_a(d, d2, d3).func_186662_g(1.0E-7)), \u2603, IBooleanFunction.ONLY_FIRST);
        return this.func_212392_a(entity, \u2603, voxelShape, set);
    }

    default public Stream<VoxelShape> func_212388_b(@Nullable Entity entity, AxisAlignedBB axisAlignedBB) {
        return this.func_212392_a(entity, VoxelShapes.func_197881_a(axisAlignedBB), VoxelShapes.func_197880_a(), Collections.emptySet());
    }

    default public Stream<VoxelShape> func_212392_a(@Nullable Entity entity, VoxelShape voxelShape, VoxelShape voxelShape2, Set<Entity> set) {
        boolean bl = entity != null && entity.func_174832_aS();
        boolean bl2 = \u2603 = entity != null && this.func_191503_g(entity);
        if (entity != null && bl == \u2603) {
            entity.func_174821_h(!\u2603);
        }
        return this.func_212391_a(voxelShape, voxelShape2, \u2603);
    }

    default public boolean func_191503_g(Entity entity) {
        WorldBorder worldBorder = this.func_175723_af();
        double \u26032 = worldBorder.func_177726_b();
        double \u26033 = worldBorder.func_177736_c();
        double \u26034 = worldBorder.func_177728_d();
        double \u26035 = worldBorder.func_177733_e();
        if (entity.func_174832_aS()) {
            \u26032 += 1.0;
            \u26033 += 1.0;
            \u26034 -= 1.0;
            \u26035 -= 1.0;
        } else {
            \u26032 -= 1.0;
            \u26033 -= 1.0;
            \u26034 += 1.0;
            \u26035 += 1.0;
        }
        return entity.field_70165_t > \u26032 && entity.field_70165_t < \u26034 && entity.field_70161_v > \u26033 && entity.field_70161_v < \u26035;
    }

    default public boolean func_211156_a(@Nullable Entity entity, AxisAlignedBB axisAlignedBB, Set<Entity> set) {
        return this.func_212392_a(entity, VoxelShapes.func_197881_a(axisAlignedBB), VoxelShapes.func_197880_a(), set).allMatch(VoxelShape::func_197766_b);
    }

    default public boolean func_195586_b(@Nullable Entity entity, AxisAlignedBB axisAlignedBB) {
        return this.func_211156_a(entity, axisAlignedBB, Collections.emptySet());
    }

    default public boolean func_201671_F(BlockPos blockPos) {
        return this.func_204610_c(blockPos).func_206884_a(FluidTags.field_206959_a);
    }

    default public boolean func_72953_d(AxisAlignedBB axisAlignedBB) {
        int n = MathHelper.func_76128_c(axisAlignedBB.field_72340_a);
        \u2603 = MathHelper.func_76143_f(axisAlignedBB.field_72336_d);
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72338_b);
        \u2603 = MathHelper.func_76143_f(axisAlignedBB.field_72337_e);
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72339_c);
        \u2603 = MathHelper.func_76143_f(axisAlignedBB.field_72334_f);
        try (BlockPos.PooledMutableBlockPos \u26032 = BlockPos.PooledMutableBlockPos.func_185346_s();){
            for (\u2603 = n; \u2603 < \u2603; ++\u2603) {
                for (\u2603 = \u2603; \u2603 < \u2603; ++\u2603) {
                    for (\u2603 = \u2603; \u2603 < \u2603; ++\u2603) {
                        IBlockState iBlockState = this.func_180495_p(\u26032.func_181079_c(\u2603, \u2603, \u2603));
                        if (iBlockState.func_204520_s().func_206888_e()) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
            }
        }
        return false;
    }

    default public int func_201696_r(BlockPos blockPos) {
        return this.func_205049_d(blockPos, this.func_175657_ab());
    }

    default public int func_205049_d(BlockPos blockPos, int n) {
        if (blockPos.func_177958_n() < -30000000 || blockPos.func_177952_p() < -30000000 || blockPos.func_177958_n() >= 30000000 || blockPos.func_177952_p() >= 30000000) {
            return 15;
        }
        if (this.func_180495_p(blockPos).func_200130_c(this, blockPos)) {
            \u2603 = this.func_201669_a(blockPos.func_177984_a(), n);
            \u2603 = this.func_201669_a(blockPos.func_177974_f(), n);
            \u2603 = this.func_201669_a(blockPos.func_177976_e(), n);
            \u2603 = this.func_201669_a(blockPos.func_177968_d(), n);
            \u2603 = this.func_201669_a(blockPos.func_177978_c(), n);
            if (\u2603 > \u2603) {
                \u2603 = \u2603;
            }
            if (\u2603 > \u2603) {
                \u2603 = \u2603;
            }
            if (\u2603 > \u2603) {
                \u2603 = \u2603;
            }
            if (\u2603 > \u2603) {
                \u2603 = \u2603;
            }
            return \u2603;
        }
        return this.func_201669_a(blockPos, n);
    }

    default public boolean func_175667_e(BlockPos blockPos) {
        return this.func_175668_a(blockPos, true);
    }

    default public boolean func_175668_a(BlockPos blockPos, boolean bl) {
        return this.func_175680_a(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4, bl);
    }

    default public boolean func_205050_e(BlockPos blockPos, int n) {
        return this.func_175648_a(blockPos, n, true);
    }

    default public boolean func_175648_a(BlockPos blockPos, int n, boolean bl) {
        return this.func_175663_a(blockPos.func_177958_n() - n, blockPos.func_177956_o() - n, blockPos.func_177952_p() - n, blockPos.func_177958_n() + n, blockPos.func_177956_o() + n, blockPos.func_177952_p() + n, bl);
    }

    default public boolean func_175707_a(BlockPos blockPos, BlockPos blockPos2) {
        return this.func_175706_a(blockPos, blockPos2, true);
    }

    default public boolean func_175706_a(BlockPos blockPos, BlockPos blockPos2, boolean bl) {
        return this.func_175663_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), blockPos2.func_177958_n(), blockPos2.func_177956_o(), blockPos2.func_177952_p(), bl);
    }

    default public boolean func_175711_a(MutableBoundingBox mutableBoundingBox) {
        return this.func_175639_b(mutableBoundingBox, true);
    }

    default public boolean func_175639_b(MutableBoundingBox mutableBoundingBox, boolean bl) {
        return this.func_175663_a(mutableBoundingBox.field_78897_a, mutableBoundingBox.field_78895_b, mutableBoundingBox.field_78896_c, mutableBoundingBox.field_78893_d, mutableBoundingBox.field_78894_e, mutableBoundingBox.field_78892_f, bl);
    }

    default public boolean func_175663_a(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (n5 < 0 || n2 >= 256) {
            return false;
        }
        n3 >>= 4;
        n4 >>= 4;
        n6 >>= 4;
        for (int i = n >>= 4; i <= n4; ++i) {
            for (\u2603 = n3; \u2603 <= n6; ++\u2603) {
                if (this.func_175680_a(i, \u2603, bl)) continue;
                return false;
            }
        }
        return true;
    }

    public Dimension func_201675_m();
}

