/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMaterialMatcher;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Fluids;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.PathWorldListener;
import net.minecraft.profiler.Profiler;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.NetworkTagManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceFluidMode;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.village.VillageCollection;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumLightType;
import net.minecraft.world.Explosion;
import net.minecraft.world.ForcedChunksSaveData;
import net.minecraft.world.GameRules;
import net.minecraft.world.IEntityReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.SessionLockException;
import net.minecraft.world.storage.WorldInfo;
import net.minecraft.world.storage.WorldSavedDataStorage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class World
implements IEntityReader,
IWorld,
IWorldReader,
AutoCloseable {
    protected static final Logger field_195596_d = LogManager.getLogger();
    private static final EnumFacing[] field_200007_a = EnumFacing.values();
    private int field_181546_a = 63;
    public final List<Entity> field_72996_f = Lists.newArrayList();
    protected final List<Entity> field_72997_g = Lists.newArrayList();
    public final List<TileEntity> field_147482_g = Lists.newArrayList();
    public final List<TileEntity> field_175730_i = Lists.newArrayList();
    private final List<TileEntity> field_147484_a = Lists.newArrayList();
    private final List<TileEntity> field_147483_b = Lists.newArrayList();
    public final List<EntityPlayer> field_73010_i = Lists.newArrayList();
    public final List<Entity> field_73007_j = Lists.newArrayList();
    protected final IntHashMap<Entity> field_175729_l = new IntHashMap();
    private final long field_73001_c = 0xFFFFFFL;
    private int field_73008_k;
    protected int field_73005_l = new Random().nextInt();
    protected final int field_73006_m = 1013904223;
    protected float field_73003_n;
    protected float field_73004_o;
    protected float field_73018_p;
    protected float field_73017_q;
    private int field_73016_r;
    public final Random field_73012_v = new Random();
    public final Dimension field_73011_w;
    protected PathWorldListener field_184152_t = new PathWorldListener();
    protected List<IWorldEventListener> field_73021_x = Lists.newArrayList((Object[])new IWorldEventListener[]{this.field_184152_t});
    protected IChunkProvider field_73020_y;
    protected final ISaveHandler field_73019_z;
    protected WorldInfo field_72986_A;
    @Nullable
    private final WorldSavedDataStorage field_72988_C;
    protected VillageCollection field_72982_D;
    public final Profiler field_72984_F;
    public final boolean field_72995_K;
    protected boolean field_72985_G = true;
    protected boolean field_72992_H = true;
    private boolean field_147481_N;
    private final WorldBorder field_175728_M;
    int[] field_72994_J = new int[32768];

    protected World(ISaveHandler iSaveHandler, @Nullable WorldSavedDataStorage worldSavedDataStorage, WorldInfo worldInfo, Dimension dimension, Profiler profiler, boolean bl) {
        this.field_73019_z = iSaveHandler;
        this.field_72988_C = worldSavedDataStorage;
        this.field_72984_F = profiler;
        this.field_72986_A = worldInfo;
        this.field_73011_w = dimension;
        this.field_72995_K = bl;
        this.field_175728_M = dimension.func_177501_r();
    }

    @Override
    public Biome func_180494_b(BlockPos blockPos) {
        if (this.func_175667_e(blockPos)) {
            Chunk chunk = this.func_175726_f(blockPos);
            try {
                return chunk.func_201600_k(blockPos);
            }
            catch (Throwable \u26032) {
                CrashReport crashReport = CrashReport.func_85055_a(\u26032, "Getting biome");
                CrashReportCategory \u26033 = crashReport.func_85058_a("Coordinates of biome request");
                \u26033.func_189529_a("Location", () -> CrashReportCategory.func_180522_a(blockPos));
                throw new ReportedException(crashReport);
            }
        }
        return this.field_73020_y.func_201711_g().func_202090_b().func_180300_a(blockPos, Biomes.field_76772_c);
    }

    protected abstract IChunkProvider func_72970_h();

    public void func_72963_a(WorldSettings worldSettings) {
        this.field_72986_A.func_76091_d(true);
    }

    @Override
    public boolean func_201670_d() {
        return this.field_72995_K;
    }

    @Nullable
    public MinecraftServer func_73046_m() {
        return null;
    }

    public void func_72974_f() {
        this.func_175652_B(new BlockPos(8, 64, 8));
    }

    public IBlockState func_184141_c(BlockPos blockPos) {
        \u2603 = new BlockPos(blockPos.func_177958_n(), this.func_181545_F(), blockPos.func_177952_p());
        while (!this.func_175623_d(\u2603.func_177984_a())) {
            \u2603 = \u2603.func_177984_a();
        }
        return this.func_180495_p(\u2603);
    }

    public static boolean func_175701_a(BlockPos blockPos) {
        return !World.func_189509_E(blockPos) && blockPos.func_177958_n() >= -30000000 && blockPos.func_177952_p() >= -30000000 && blockPos.func_177958_n() < 30000000 && blockPos.func_177952_p() < 30000000;
    }

    public static boolean func_189509_E(BlockPos blockPos) {
        return blockPos.func_177956_o() < 0 || blockPos.func_177956_o() >= 256;
    }

    @Override
    public boolean func_175623_d(BlockPos blockPos) {
        return this.func_180495_p(blockPos).func_196958_f();
    }

    public Chunk func_175726_f(BlockPos blockPos) {
        return this.func_72964_e(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4);
    }

    @Override
    public Chunk func_72964_e(int n, int n2) {
        Chunk chunk = this.field_73020_y.func_186025_d(n, n2, true, true);
        if (chunk == null) {
            throw new IllegalStateException("Should always be able to create a chunk!");
        }
        return chunk;
    }

    @Override
    public boolean func_180501_a(BlockPos blockPos, IBlockState iBlockState, int n) {
        if (World.func_189509_E(blockPos)) {
            return false;
        }
        if (!this.field_72995_K && this.field_72986_A.func_76067_t() == WorldType.field_180272_g) {
            return false;
        }
        Chunk chunk = this.func_175726_f(blockPos);
        Block \u26032 = iBlockState.func_177230_c();
        IBlockState \u26033 = chunk.func_177436_a(blockPos, iBlockState, (n & 0x40) != 0);
        if (\u26033 != null) {
            IBlockState iBlockState2 = this.func_180495_p(blockPos);
            if (iBlockState2.func_200016_a(this, blockPos) != \u26033.func_200016_a(this, blockPos) || iBlockState2.func_185906_d() != \u26033.func_185906_d()) {
                this.field_72984_F.func_76320_a("checkLight");
                this.func_175664_x(blockPos);
                this.field_72984_F.func_76319_b();
            }
            if (iBlockState2 == iBlockState) {
                if (\u26033 != iBlockState2) {
                    this.func_175704_b(blockPos, blockPos);
                }
                if ((n & 2) != 0 && (!this.field_72995_K || (n & 4) == 0) && chunk.func_150802_k()) {
                    this.func_184138_a(blockPos, \u26033, iBlockState, n);
                }
                if (!this.field_72995_K && (n & 1) != 0) {
                    this.func_195592_c(blockPos, \u26033.func_177230_c());
                    if (iBlockState.func_185912_n()) {
                        this.func_175666_e(blockPos, \u26032);
                    }
                }
                if ((n & 0x10) == 0) {
                    int n2 = n & 0xFFFFFFFE;
                    \u26033.func_196948_b(this, blockPos, n2);
                    iBlockState.func_196946_a(this, blockPos, n2);
                    iBlockState.func_196948_b(this, blockPos, n2);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean func_175698_g(BlockPos blockPos) {
        IFluidState iFluidState = this.func_204610_c(blockPos);
        return this.func_180501_a(blockPos, iFluidState.func_206883_i(), 3);
    }

    @Override
    public boolean func_175655_b(BlockPos blockPos, boolean bl) {
        IBlockState iBlockState = this.func_180495_p(blockPos);
        if (iBlockState.func_196958_f()) {
            return false;
        }
        IFluidState \u26032 = this.func_204610_c(blockPos);
        this.func_175718_b(2001, blockPos, Block.func_196246_j(iBlockState));
        if (bl) {
            iBlockState.func_196949_c(this, blockPos, 0);
        }
        return this.func_180501_a(blockPos, \u26032.func_206883_i(), 3);
    }

    public boolean func_175656_a(BlockPos blockPos, IBlockState iBlockState) {
        return this.func_180501_a(blockPos, iBlockState, 3);
    }

    public void func_184138_a(BlockPos blockPos, IBlockState iBlockState, IBlockState iBlockState2, int n) {
        for (\u2603 = 0; \u2603 < this.field_73021_x.size(); ++\u2603) {
            this.field_73021_x.get(\u2603).func_184376_a(this, blockPos, iBlockState, iBlockState2, n);
        }
    }

    @Override
    public void func_195592_c(BlockPos blockPos, Block block) {
        if (this.field_72986_A.func_76067_t() != WorldType.field_180272_g) {
            this.func_195593_d(blockPos, block);
        }
    }

    public void func_72975_g(int n, int n2, int n3, int n4) {
        if (n3 > n4) {
            \u2603 = n4;
            n4 = n3;
            n3 = \u2603;
        }
        if (this.field_73011_w.func_191066_m()) {
            for (\u2603 = n3; \u2603 <= n4; ++\u2603) {
                this.func_180500_c(EnumLightType.SKY, new BlockPos(n, \u2603, n2));
            }
        }
        this.func_147458_c(n, n3, n2, n, n4, n2);
    }

    public void func_175704_b(BlockPos blockPos, BlockPos blockPos2) {
        this.func_147458_c(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), blockPos2.func_177958_n(), blockPos2.func_177956_o(), blockPos2.func_177952_p());
    }

    public void func_147458_c(int n, int n2, int n3, int n4, int n5, int n6) {
        for (\u2603 = 0; \u2603 < this.field_73021_x.size(); ++\u2603) {
            this.field_73021_x.get(\u2603).func_147585_a(n, n2, n3, n4, n5, n6);
        }
    }

    public void func_195593_d(BlockPos blockPos, Block block) {
        this.func_190524_a(blockPos.func_177976_e(), block, blockPos);
        this.func_190524_a(blockPos.func_177974_f(), block, blockPos);
        this.func_190524_a(blockPos.func_177977_b(), block, blockPos);
        this.func_190524_a(blockPos.func_177984_a(), block, blockPos);
        this.func_190524_a(blockPos.func_177978_c(), block, blockPos);
        this.func_190524_a(blockPos.func_177968_d(), block, blockPos);
    }

    public void func_175695_a(BlockPos blockPos, Block block, EnumFacing enumFacing) {
        if (enumFacing != EnumFacing.WEST) {
            this.func_190524_a(blockPos.func_177976_e(), block, blockPos);
        }
        if (enumFacing != EnumFacing.EAST) {
            this.func_190524_a(blockPos.func_177974_f(), block, blockPos);
        }
        if (enumFacing != EnumFacing.DOWN) {
            this.func_190524_a(blockPos.func_177977_b(), block, blockPos);
        }
        if (enumFacing != EnumFacing.UP) {
            this.func_190524_a(blockPos.func_177984_a(), block, blockPos);
        }
        if (enumFacing != EnumFacing.NORTH) {
            this.func_190524_a(blockPos.func_177978_c(), block, blockPos);
        }
        if (enumFacing != EnumFacing.SOUTH) {
            this.func_190524_a(blockPos.func_177968_d(), block, blockPos);
        }
    }

    public void func_190524_a(BlockPos blockPos, Block block, BlockPos blockPos2) {
        if (this.field_72995_K) {
            return;
        }
        IBlockState iBlockState = this.func_180495_p(blockPos);
        try {
            iBlockState.func_189546_a(this, blockPos, block, blockPos2);
        }
        catch (Throwable \u26032) {
            CrashReport crashReport = CrashReport.func_85055_a(\u26032, "Exception while updating neighbours");
            CrashReportCategory \u26033 = crashReport.func_85058_a("Block being updated");
            \u26033.func_189529_a("Source block type", () -> {
                try {
                    return String.format("ID #%s (%s // %s)", IRegistry.field_212618_g.func_177774_c(block), block.func_149739_a(), block.getClass().getCanonicalName());
                }
                catch (Throwable throwable) {
                    return "ID #" + IRegistry.field_212618_g.func_177774_c(block);
                }
            });
            CrashReportCategory.func_175750_a(\u26033, blockPos, iBlockState);
            throw new ReportedException(crashReport);
        }
    }

    @Override
    public boolean func_175678_i(BlockPos blockPos) {
        return this.func_175726_f(blockPos).func_177444_d(blockPos);
    }

    @Override
    public int func_201669_a(BlockPos blockPos2, int n) {
        BlockPos blockPos2;
        if (blockPos2.func_177958_n() < -30000000 || blockPos2.func_177952_p() < -30000000 || blockPos2.func_177958_n() >= 30000000 || blockPos2.func_177952_p() >= 30000000) {
            return 15;
        }
        if (blockPos2.func_177956_o() < 0) {
            return 0;
        }
        if (blockPos2.func_177956_o() >= 256) {
            blockPos2 = new BlockPos(blockPos2.func_177958_n(), 255, blockPos2.func_177952_p());
        }
        return this.func_175726_f(blockPos2).func_177443_a(blockPos2, n);
    }

    @Override
    public int func_201676_a(Heightmap.Type type, int n, int n2) {
        \u2603 = n < -30000000 || n2 < -30000000 || n >= 30000000 || n2 >= 30000000 ? this.func_181545_F() + 1 : (this.func_175680_a(n >> 4, n2 >> 4, true) ? this.func_72964_e(n >> 4, n2 >> 4).func_201576_a(type, n & 0xF, n2 & 0xF) + 1 : 0);
        return \u2603;
    }

    @Deprecated
    public int func_82734_g(int n, int n2) {
        if (n < -30000000 || n2 < -30000000 || n >= 30000000 || n2 >= 30000000) {
            return this.func_181545_F() + 1;
        }
        if (!this.func_175680_a(n >> 4, n2 >> 4, true)) {
            return 0;
        }
        Chunk chunk = this.func_72964_e(n >> 4, n2 >> 4);
        return chunk.func_177442_v();
    }

    public int func_175705_a(EnumLightType enumLightType, BlockPos blockPos2) {
        BlockPos blockPos2;
        if (!this.field_73011_w.func_191066_m() && enumLightType == EnumLightType.SKY) {
            return 0;
        }
        if (blockPos2.func_177956_o() < 0) {
            blockPos2 = new BlockPos(blockPos2.func_177958_n(), 0, blockPos2.func_177952_p());
        }
        if (!World.func_175701_a(blockPos2)) {
            return enumLightType.field_77198_c;
        }
        if (!this.func_175667_e(blockPos2)) {
            return enumLightType.field_77198_c;
        }
        if (this.func_180495_p(blockPos2).func_200130_c(this, blockPos2)) {
            int n = this.func_175642_b(enumLightType, blockPos2.func_177984_a());
            \u2603 = this.func_175642_b(enumLightType, blockPos2.func_177974_f());
            \u2603 = this.func_175642_b(enumLightType, blockPos2.func_177976_e());
            \u2603 = this.func_175642_b(enumLightType, blockPos2.func_177968_d());
            \u2603 = this.func_175642_b(enumLightType, blockPos2.func_177978_c());
            if (\u2603 > n) {
                n = \u2603;
            }
            if (\u2603 > n) {
                n = \u2603;
            }
            if (\u2603 > n) {
                n = \u2603;
            }
            if (\u2603 > n) {
                n = \u2603;
            }
            return n;
        }
        return this.func_175726_f(blockPos2).func_177413_a(enumLightType, blockPos2);
    }

    @Override
    public int func_175642_b(EnumLightType enumLightType, BlockPos blockPos) {
        if (blockPos.func_177956_o() < 0) {
            blockPos = new BlockPos(blockPos.func_177958_n(), 0, blockPos.func_177952_p());
        }
        if (!World.func_175701_a(blockPos)) {
            return enumLightType.field_77198_c;
        }
        if (!this.func_175667_e(blockPos)) {
            return enumLightType.field_77198_c;
        }
        return this.func_175726_f(blockPos).func_177413_a(enumLightType, blockPos);
    }

    @Override
    public void func_175653_a(EnumLightType enumLightType, BlockPos blockPos, int n) {
        if (!World.func_175701_a(blockPos)) {
            return;
        }
        if (!this.func_175667_e(blockPos)) {
            return;
        }
        this.func_175726_f(blockPos).func_177431_a(enumLightType, blockPos, n);
        this.func_175679_n(blockPos);
    }

    public void func_175679_n(BlockPos blockPos) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            this.field_73021_x.get(i).func_174959_b(blockPos);
        }
    }

    @Override
    public int func_175626_b(BlockPos blockPos, int n) {
        \u2603 = this.func_175705_a(EnumLightType.SKY, blockPos);
        \u2603 = this.func_175705_a(EnumLightType.BLOCK, blockPos);
        if (\u2603 < n) {
            \u2603 = n;
        }
        return \u2603 << 20 | \u2603 << 4;
    }

    @Override
    public IBlockState func_180495_p(BlockPos blockPos) {
        if (World.func_189509_E(blockPos)) {
            return Blocks.field_201940_ji.func_176223_P();
        }
        Chunk chunk = this.func_175726_f(blockPos);
        return chunk.func_180495_p(blockPos);
    }

    @Override
    public IFluidState func_204610_c(BlockPos blockPos) {
        if (World.func_189509_E(blockPos)) {
            return Fluids.field_204541_a.func_207188_f();
        }
        Chunk chunk = this.func_175726_f(blockPos);
        return chunk.func_204610_c(blockPos);
    }

    public boolean func_72935_r() {
        return this.field_73008_k < 4;
    }

    @Nullable
    public RayTraceResult func_72933_a(Vec3d vec3d, Vec3d vec3d2) {
        return this.func_200259_a(vec3d, vec3d2, RayTraceFluidMode.NEVER, false, false);
    }

    @Nullable
    public RayTraceResult func_200260_a(Vec3d vec3d, Vec3d vec3d2, RayTraceFluidMode rayTraceFluidMode) {
        return this.func_200259_a(vec3d, vec3d2, rayTraceFluidMode, false, false);
    }

    @Nullable
    public RayTraceResult func_200259_a(Vec3d vec3d, Vec3d vec3d2, RayTraceFluidMode rayTraceFluidMode, boolean bl, boolean bl22) {
        boolean bl22;
        boolean bl3;
        double \u260320 = vec3d.field_72450_a;
        \u260321 = vec3d.field_72448_b;
        \u260322 = vec3d.field_72449_c;
        if (Double.isNaN(\u260320) || Double.isNaN(\u260321) || Double.isNaN(\u260322)) {
            return null;
        }
        if (Double.isNaN(vec3d2.field_72450_a) || Double.isNaN(vec3d2.field_72448_b) || Double.isNaN(vec3d2.field_72449_c)) {
            return null;
        }
        int \u26032 = MathHelper.func_76128_c(vec3d2.field_72450_a);
        int \u26033 = MathHelper.func_76128_c(vec3d2.field_72448_b);
        int \u26034 = MathHelper.func_76128_c(vec3d2.field_72449_c);
        int \u26035 = MathHelper.func_76128_c(\u260320);
        int \u26036 = MathHelper.func_76128_c(\u260321);
        int \u26037 = MathHelper.func_76128_c(\u260322);
        BlockPos \u26038 = new BlockPos(\u26035, \u26036, \u26037);
        Object \u26039 = this.func_180495_p(\u26038);
        IFluidState \u260310 = this.func_204610_c(\u26038);
        if (!bl || !\u26039.func_196952_d(this, \u26038).func_197766_b()) {
            bl3 = \u26039.func_177230_c().func_200293_a((IBlockState)\u26039);
            \u2603 = rayTraceFluidMode.field_209544_d.test(\u260310);
            if (bl3 || \u2603) {
                RayTraceResult rayTraceResult = null;
                if (bl3) {
                    rayTraceResult = Block.func_180636_a((IBlockState)\u26039, this, \u26038, vec3d, vec3d2);
                }
                if (rayTraceResult == null && \u2603) {
                    rayTraceResult = VoxelShapes.func_197873_a(0.0, 0.0, 0.0, 1.0, \u260310.func_206885_f(), 1.0).func_212433_a(vec3d, vec3d2, \u26038);
                }
                if (rayTraceResult != null) {
                    return rayTraceResult;
                }
            }
        }
        \u26039 = null;
        int n = 200;
        while (n-- >= 0) {
            double \u260322;
            double \u260321;
            EnumFacing enumFacing;
            if (Double.isNaN(\u260320) || Double.isNaN(\u260321) || Double.isNaN(\u260322)) {
                return null;
            }
            if (\u26035 == \u26032 && \u26036 == \u26033 && \u26037 == \u26034) {
                return bl22 ? \u26039 : null;
            }
            bl3 = true;
            \u2603 = true;
            \u2603 = true;
            double \u260311 = 999.0;
            double \u260312 = 999.0;
            double \u260313 = 999.0;
            if (\u26032 > \u26035) {
                \u260311 = (double)\u26035 + 1.0;
            } else if (\u26032 < \u26035) {
                \u260311 = (double)\u26035 + 0.0;
            } else {
                bl3 = false;
            }
            if (\u26033 > \u26036) {
                \u260312 = (double)\u26036 + 1.0;
            } else if (\u26033 < \u26036) {
                \u260312 = (double)\u26036 + 0.0;
            } else {
                \u2603 = false;
            }
            if (\u26034 > \u26037) {
                \u260313 = (double)\u26037 + 1.0;
            } else if (\u26034 < \u26037) {
                \u260313 = (double)\u26037 + 0.0;
            } else {
                \u2603 = false;
            }
            double \u260314 = 999.0;
            double \u260315 = 999.0;
            double \u260316 = 999.0;
            double \u260317 = vec3d2.field_72450_a - \u260320;
            double \u260318 = vec3d2.field_72448_b - \u260321;
            double \u260319 = vec3d2.field_72449_c - \u260322;
            if (bl3) {
                \u260314 = (\u260311 - \u260320) / \u260317;
            }
            if (\u2603) {
                \u260315 = (\u260312 - \u260321) / \u260318;
            }
            if (\u2603) {
                \u260316 = (\u260313 - \u260322) / \u260319;
            }
            if (\u260314 == -0.0) {
                \u260314 = -1.0E-4;
            }
            if (\u260315 == -0.0) {
                \u260315 = -1.0E-4;
            }
            if (\u260316 == -0.0) {
                \u260316 = -1.0E-4;
            }
            if (\u260314 < \u260315 && \u260314 < \u260316) {
                enumFacing = \u26032 > \u26035 ? EnumFacing.WEST : EnumFacing.EAST;
                \u260320 = \u260311;
                \u260321 += \u260318 * \u260314;
                \u260322 += \u260319 * \u260314;
            } else if (\u260315 < \u260316) {
                enumFacing = \u26033 > \u26036 ? EnumFacing.DOWN : EnumFacing.UP;
                \u260320 += \u260317 * \u260315;
                \u260321 = \u260312;
                \u260322 += \u260319 * \u260315;
            } else {
                enumFacing = \u26034 > \u26037 ? EnumFacing.NORTH : EnumFacing.SOUTH;
                \u260320 += \u260317 * \u260316;
                \u260321 += \u260318 * \u260316;
                \u260322 = \u260313;
            }
            \u26035 = MathHelper.func_76128_c(\u260320) - (enumFacing == EnumFacing.EAST ? 1 : 0);
            \u26036 = MathHelper.func_76128_c(\u260321) - (enumFacing == EnumFacing.UP ? 1 : 0);
            \u26037 = MathHelper.func_76128_c(\u260322) - (enumFacing == EnumFacing.SOUTH ? 1 : 0);
            \u26038 = new BlockPos(\u26035, \u26036, \u26037);
            IBlockState iBlockState = this.func_180495_p(\u26038);
            IFluidState \u260323 = this.func_204610_c(\u26038);
            if (bl && iBlockState.func_185904_a() != Material.field_151567_E && iBlockState.func_196952_d(this, \u26038).func_197766_b()) continue;
            boolean \u260324 = iBlockState.func_177230_c().func_200293_a(iBlockState);
            boolean \u260325 = rayTraceFluidMode.field_209544_d.test(\u260323);
            if (\u260324 || \u260325) {
                RayTraceResult rayTraceResult = null;
                if (\u260324) {
                    rayTraceResult = Block.func_180636_a(iBlockState, this, \u26038, vec3d, vec3d2);
                }
                if (rayTraceResult == null && \u260325) {
                    rayTraceResult = VoxelShapes.func_197873_a(0.0, 0.0, 0.0, 1.0, \u260323.func_206885_f(), 1.0).func_212433_a(vec3d, vec3d2, \u26038);
                }
                if (rayTraceResult == null) continue;
                return rayTraceResult;
            }
            \u26039 = new RayTraceResult(RayTraceResult.Type.MISS, new Vec3d(\u260320, \u260321, \u260322), enumFacing, \u26038);
        }
        return bl22 ? \u26039 : null;
    }

    @Override
    public void func_184133_a(@Nullable EntityPlayer entityPlayer, BlockPos blockPos, SoundEvent soundEvent, SoundCategory soundCategory, float f, float f2) {
        this.func_184148_a(entityPlayer, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5, soundEvent, soundCategory, f, f2);
    }

    public void func_184148_a(@Nullable EntityPlayer entityPlayer, double d, double d2, double d3, SoundEvent soundEvent, SoundCategory soundCategory, float f, float f2) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            this.field_73021_x.get(i).func_184375_a(entityPlayer, soundEvent, soundCategory, d, d2, d3, f, f2);
        }
    }

    public void func_184134_a(double d, double d2, double d3, SoundEvent soundEvent, SoundCategory soundCategory, float f, float f2, boolean bl) {
    }

    public void func_184149_a(BlockPos blockPos, @Nullable SoundEvent soundEvent) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            this.field_73021_x.get(i).func_184377_a(soundEvent, blockPos);
        }
    }

    @Override
    public void func_195594_a(IParticleData iParticleData, double d, double d2, double d3, double d4, double d5, double d6) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            this.field_73021_x.get(i).func_195461_a(iParticleData, iParticleData.func_197554_b().func_197575_f(), d, d2, d3, d4, d5, d6);
        }
    }

    public void func_195590_a(IParticleData iParticleData, boolean bl, double d, double d2, double d3, double d4, double d5, double d6) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            this.field_73021_x.get(i).func_195461_a(iParticleData, iParticleData.func_197554_b().func_197575_f() || bl, d, d2, d3, d4, d5, d6);
        }
    }

    public void func_195589_b(IParticleData iParticleData, double d, double d2, double d3, double d4, double d5, double d6) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            this.field_73021_x.get(i).func_195462_a(iParticleData, false, true, d, d2, d3, d4, d5, d6);
        }
    }

    public boolean func_72942_c(Entity entity) {
        this.field_73007_j.add(entity);
        return true;
    }

    @Override
    public boolean func_72838_d(Entity entity) {
        int n = MathHelper.func_76128_c(entity.field_70165_t / 16.0);
        \u2603 = MathHelper.func_76128_c(entity.field_70161_v / 16.0);
        boolean \u26032 = entity.field_98038_p;
        if (entity instanceof EntityPlayer) {
            \u26032 = true;
        }
        if (\u26032 || this.func_175680_a(n, \u2603, false)) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityPlayer = (EntityPlayer)entity;
                this.field_73010_i.add(entityPlayer);
                this.func_72854_c();
            }
            this.func_72964_e(n, \u2603).func_76612_a(entity);
            this.field_72996_f.add(entity);
            this.func_72923_a(entity);
            return true;
        }
        return false;
    }

    protected void func_72923_a(Entity entity) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            this.field_73021_x.get(i).func_72703_a(entity);
        }
    }

    protected void func_72847_b(Entity entity) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            this.field_73021_x.get(i).func_72709_b(entity);
        }
    }

    public void func_72900_e(Entity entity) {
        if (entity.func_184207_aI()) {
            entity.func_184226_ay();
        }
        if (entity.func_184218_aH()) {
            entity.func_184210_p();
        }
        entity.func_70106_y();
        if (entity instanceof EntityPlayer) {
            this.field_73010_i.remove(entity);
            this.func_72854_c();
            this.func_72847_b(entity);
        }
    }

    public void func_72973_f(Entity entity) {
        entity.func_184174_b(false);
        entity.func_70106_y();
        if (entity instanceof EntityPlayer) {
            this.field_73010_i.remove(entity);
            this.func_72854_c();
        }
        int n = entity.field_70176_ah;
        \u2603 = entity.field_70164_aj;
        if (entity.field_70175_ag && this.func_175680_a(n, \u2603, true)) {
            this.func_72964_e(n, \u2603).func_76622_b(entity);
        }
        this.field_72996_f.remove(entity);
        this.func_72847_b(entity);
    }

    public void func_72954_a(IWorldEventListener iWorldEventListener) {
        this.field_73021_x.add(iWorldEventListener);
    }

    public void func_72848_b(IWorldEventListener iWorldEventListener) {
        this.field_73021_x.remove(iWorldEventListener);
    }

    public int func_72967_a(float f) {
        \u2603 = this.func_72826_c(f);
        \u2603 = 1.0f - (MathHelper.func_76134_b(\u2603 * ((float)Math.PI * 2)) * 2.0f + 0.5f);
        \u2603 = MathHelper.func_76131_a(\u2603, 0.0f, 1.0f);
        \u2603 = 1.0f - \u2603;
        \u2603 = (float)((double)\u2603 * (1.0 - (double)(this.func_72867_j(f) * 5.0f) / 16.0));
        \u2603 = (float)((double)\u2603 * (1.0 - (double)(this.func_72819_i(f) * 5.0f) / 16.0));
        \u2603 = 1.0f - \u2603;
        return (int)(\u2603 * 11.0f);
    }

    public float func_72971_b(float f) {
        \u2603 = this.func_72826_c(f);
        \u2603 = 1.0f - (MathHelper.func_76134_b(\u2603 * ((float)Math.PI * 2)) * 2.0f + 0.2f);
        \u2603 = MathHelper.func_76131_a(\u2603, 0.0f, 1.0f);
        \u2603 = 1.0f - \u2603;
        \u2603 = (float)((double)\u2603 * (1.0 - (double)(this.func_72867_j(f) * 5.0f) / 16.0));
        \u2603 = (float)((double)\u2603 * (1.0 - (double)(this.func_72819_i(f) * 5.0f) / 16.0));
        return \u2603 * 0.8f + 0.2f;
    }

    public Vec3d func_72833_a(Entity entity, float f) {
        float f2;
        \u2603 = this.func_72826_c(f);
        \u2603 = MathHelper.func_76134_b(\u2603 * ((float)Math.PI * 2)) * 2.0f + 0.5f;
        \u2603 = MathHelper.func_76131_a(\u2603, 0.0f, 1.0f);
        int n = MathHelper.func_76128_c(entity.field_70165_t);
        \u2603 = MathHelper.func_76128_c(entity.field_70163_u);
        \u2603 = MathHelper.func_76128_c(entity.field_70161_v);
        BlockPos \u26032 = new BlockPos(n, \u2603, \u2603);
        Biome \u26033 = this.func_180494_b(\u26032);
        float \u26034 = \u26033.func_180626_a(\u26032);
        \u2603 = \u26033.func_76731_a(\u26034);
        float \u26035 = (float)(\u2603 >> 16 & 0xFF) / 255.0f;
        float \u26036 = (float)(\u2603 >> 8 & 0xFF) / 255.0f;
        float \u26037 = (float)(\u2603 & 0xFF) / 255.0f;
        \u26035 *= \u2603;
        \u26036 *= \u2603;
        \u26037 *= \u2603;
        float \u26038 = this.func_72867_j(f);
        if (\u26038 > 0.0f) {
            f2 = (\u26035 * 0.3f + \u26036 * 0.59f + \u26037 * 0.11f) * 0.6f;
            \u2603 = 1.0f - \u26038 * 0.75f;
            \u26035 = \u26035 * \u2603 + f2 * (1.0f - \u2603);
            \u26036 = \u26036 * \u2603 + f2 * (1.0f - \u2603);
            \u26037 = \u26037 * \u2603 + f2 * (1.0f - \u2603);
        }
        if ((f2 = this.func_72819_i(f)) > 0.0f) {
            \u2603 = (\u26035 * 0.3f + \u26036 * 0.59f + \u26037 * 0.11f) * 0.2f;
            \u2603 = 1.0f - f2 * 0.75f;
            \u26035 = \u26035 * \u2603 + \u2603 * (1.0f - \u2603);
            \u26036 = \u26036 * \u2603 + \u2603 * (1.0f - \u2603);
            \u26037 = \u26037 * \u2603 + \u2603 * (1.0f - \u2603);
        }
        if (this.field_73016_r > 0) {
            \u2603 = (float)this.field_73016_r - f;
            if (\u2603 > 1.0f) {
                \u2603 = 1.0f;
            }
            \u26035 = \u26035 * (1.0f - (\u2603 *= 0.45f)) + 0.8f * \u2603;
            \u26036 = \u26036 * (1.0f - \u2603) + 0.8f * \u2603;
            \u26037 = \u26037 * (1.0f - \u2603) + 1.0f * \u2603;
        }
        return new Vec3d(\u26035, \u26036, \u26037);
    }

    public float func_72929_e(float f) {
        \u2603 = this.func_72826_c(f);
        return \u2603 * ((float)Math.PI * 2);
    }

    public Vec3d func_72824_f(float f) {
        \u2603 = this.func_72826_c(f);
        \u2603 = MathHelper.func_76134_b(\u2603 * ((float)Math.PI * 2)) * 2.0f + 0.5f;
        \u2603 = MathHelper.func_76131_a(\u2603, 0.0f, 1.0f);
        \u2603 = 1.0f;
        \u2603 = 1.0f;
        \u2603 = 1.0f;
        \u2603 = this.func_72867_j(f);
        if (\u2603 > 0.0f) {
            \u2603 = (\u2603 * 0.3f + \u2603 * 0.59f + \u2603 * 0.11f) * 0.6f;
            \u2603 = 1.0f - \u2603 * 0.95f;
            \u2603 = \u2603 * \u2603 + \u2603 * (1.0f - \u2603);
            \u2603 = \u2603 * \u2603 + \u2603 * (1.0f - \u2603);
            \u2603 = \u2603 * \u2603 + \u2603 * (1.0f - \u2603);
        }
        \u2603 *= \u2603 * 0.9f + 0.1f;
        \u2603 *= \u2603 * 0.9f + 0.1f;
        \u2603 *= \u2603 * 0.85f + 0.15f;
        \u2603 = this.func_72819_i(f);
        if (\u2603 > 0.0f) {
            \u2603 = (\u2603 * 0.3f + \u2603 * 0.59f + \u2603 * 0.11f) * 0.2f;
            \u2603 = 1.0f - \u2603 * 0.95f;
            \u2603 = \u2603 * \u2603 + \u2603 * (1.0f - \u2603);
            \u2603 = \u2603 * \u2603 + \u2603 * (1.0f - \u2603);
            \u2603 = \u2603 * \u2603 + \u2603 * (1.0f - \u2603);
        }
        return new Vec3d(\u2603, \u2603, \u2603);
    }

    public Vec3d func_72948_g(float f) {
        \u2603 = this.func_72826_c(f);
        return this.field_73011_w.func_76562_b(\u2603, f);
    }

    public float func_72880_h(float f) {
        \u2603 = this.func_72826_c(f);
        \u2603 = 1.0f - (MathHelper.func_76134_b(\u2603 * ((float)Math.PI * 2)) * 2.0f + 0.25f);
        \u2603 = MathHelper.func_76131_a(\u2603, 0.0f, 1.0f);
        return \u2603 * \u2603 * 0.5f;
    }

    public void func_72939_s() {
        int \u26035;
        Object object;
        int n;
        this.field_72984_F.func_76320_a("entities");
        this.field_72984_F.func_76320_a("global");
        for (n = 0; n < this.field_73007_j.size(); ++n) {
            object = this.field_73007_j.get(n);
            try {
                ++((Entity)object).field_70173_aa;
                ((Entity)object).func_70071_h_();
            }
            catch (Throwable \u26032) {
                CrashReport crashReport = CrashReport.func_85055_a(\u26032, "Ticking entity");
                CrashReportCategory \u26033 = crashReport.func_85058_a("Entity being ticked");
                if (object == null) {
                    \u26033.func_71507_a("Entity", "~~NULL~~");
                } else {
                    ((Entity)object).func_85029_a(\u26033);
                }
                throw new ReportedException(crashReport);
            }
            if (!((Entity)object).field_70128_L) continue;
            this.field_73007_j.remove(n--);
        }
        this.field_72984_F.func_76318_c("remove");
        this.field_72996_f.removeAll(this.field_72997_g);
        for (n = 0; n < this.field_72997_g.size(); ++n) {
            object = this.field_72997_g.get(n);
            int \u26034 = ((Entity)object).field_70176_ah;
            \u26035 = ((Entity)object).field_70164_aj;
            if (!((Entity)object).field_70175_ag || !this.func_175680_a(\u26034, \u26035, true)) continue;
            this.func_72964_e(\u26034, \u26035).func_76622_b((Entity)object);
        }
        for (n = 0; n < this.field_72997_g.size(); ++n) {
            this.func_72847_b(this.field_72997_g.get(n));
        }
        this.field_72997_g.clear();
        this.func_184147_l();
        this.field_72984_F.func_76318_c("regular");
        for (n = 0; n < this.field_72996_f.size(); ++n) {
            object = this.field_72996_f.get(n);
            Entity \u26036 = ((Entity)object).func_184187_bx();
            if (\u26036 != null) {
                if (!\u26036.field_70128_L && \u26036.func_184196_w((Entity)object)) continue;
                ((Entity)object).func_184210_p();
            }
            this.field_72984_F.func_76320_a("tick");
            if (!((Entity)object).field_70128_L && !(object instanceof EntityPlayerMP)) {
                try {
                    this.func_72870_g((Entity)object);
                }
                catch (Throwable throwable) {
                    CrashReport crashReport = CrashReport.func_85055_a(throwable, "Ticking entity");
                    CrashReportCategory \u26037 = crashReport.func_85058_a("Entity being ticked");
                    ((Entity)object).func_85029_a(\u26037);
                    throw new ReportedException(crashReport);
                }
            }
            this.field_72984_F.func_76319_b();
            this.field_72984_F.func_76320_a("remove");
            if (((Entity)object).field_70128_L) {
                \u26035 = ((Entity)object).field_70176_ah;
                int n2 = ((Entity)object).field_70164_aj;
                if (((Entity)object).field_70175_ag && this.func_175680_a(\u26035, n2, true)) {
                    this.func_72964_e(\u26035, n2).func_76622_b((Entity)object);
                }
                this.field_72996_f.remove(n--);
                this.func_72847_b((Entity)object);
            }
            this.field_72984_F.func_76319_b();
        }
        this.field_72984_F.func_76318_c("blockEntities");
        if (!this.field_147483_b.isEmpty()) {
            this.field_175730_i.removeAll(this.field_147483_b);
            this.field_147482_g.removeAll(this.field_147483_b);
            this.field_147483_b.clear();
        }
        this.field_147481_N = true;
        Iterator<TileEntity> iterator = this.field_175730_i.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!((TileEntity)object).func_145837_r() && ((TileEntity)object).func_145830_o() && this.func_175667_e(\u2603 = ((TileEntity)object).func_174877_v()) && this.field_175728_M.func_177746_a(\u2603)) {
                try {
                    this.field_72984_F.func_194340_a(() -> World.func_210187_c((TileEntity)object));
                    ((ITickable)object).func_73660_a();
                    this.field_72984_F.func_76319_b();
                }
                catch (Throwable throwable) {
                    CrashReport crashReport = CrashReport.func_85055_a(throwable, "Ticking block entity");
                    CrashReportCategory \u26038 = crashReport.func_85058_a("Block entity being ticked");
                    ((TileEntity)object).func_145828_a(\u26038);
                    throw new ReportedException(crashReport);
                }
            }
            if (!((TileEntity)object).func_145837_r()) continue;
            iterator.remove();
            this.field_147482_g.remove(object);
            if (!this.func_175667_e(((TileEntity)object).func_174877_v())) continue;
            this.func_175726_f(((TileEntity)object).func_174877_v()).func_177425_e(((TileEntity)object).func_174877_v());
        }
        this.field_147481_N = false;
        this.field_72984_F.func_76318_c("pendingBlockEntities");
        if (!this.field_147484_a.isEmpty()) {
            for (int i = 0; i < this.field_147484_a.size(); ++i) {
                TileEntity tileEntity = this.field_147484_a.get(i);
                if (tileEntity.func_145837_r()) continue;
                if (!this.field_147482_g.contains(tileEntity)) {
                    this.func_175700_a(tileEntity);
                }
                if (!this.func_175667_e(tileEntity.func_174877_v())) continue;
                Chunk \u26039 = this.func_175726_f(tileEntity.func_174877_v());
                IBlockState \u260310 = \u26039.func_180495_p(tileEntity.func_174877_v());
                \u26039.func_177426_a(tileEntity.func_174877_v(), tileEntity);
                this.func_184138_a(tileEntity.func_174877_v(), \u260310, \u260310, 3);
            }
            this.field_147484_a.clear();
        }
        this.field_72984_F.func_76319_b();
        this.field_72984_F.func_76319_b();
    }

    protected void func_184147_l() {
    }

    public boolean func_175700_a(TileEntity tileEntity) {
        boolean bl = this.field_147482_g.add(tileEntity);
        if (bl && tileEntity instanceof ITickable) {
            this.field_175730_i.add(tileEntity);
        }
        if (this.field_72995_K) {
            BlockPos blockPos = tileEntity.func_174877_v();
            IBlockState \u26032 = this.func_180495_p(blockPos);
            this.func_184138_a(blockPos, \u26032, \u26032, 2);
        }
        return bl;
    }

    public void func_147448_a(Collection<TileEntity> collection) {
        if (this.field_147481_N) {
            this.field_147484_a.addAll(collection);
        } else {
            for (TileEntity tileEntity : collection) {
                this.func_175700_a(tileEntity);
            }
        }
    }

    public void func_72870_g(Entity entity) {
        this.func_72866_a(entity, true);
    }

    public void func_72866_a(Entity entity2, boolean bl) {
        Entity entity2;
        int \u26032;
        if (!(entity2 instanceof EntityPlayer)) {
            \u26032 = MathHelper.func_76128_c(entity2.field_70165_t);
            \u26033 = MathHelper.func_76128_c(entity2.field_70161_v);
            \u26034 = 32;
            if (bl && !this.func_175663_a(\u26032 - 32, 0, \u26033 - 32, \u26032 + 32, 0, \u26033 + 32, true)) {
                return;
            }
        }
        entity2.field_70142_S = entity2.field_70165_t;
        entity2.field_70137_T = entity2.field_70163_u;
        entity2.field_70136_U = entity2.field_70161_v;
        entity2.field_70126_B = entity2.field_70177_z;
        entity2.field_70127_C = entity2.field_70125_A;
        if (bl && entity2.field_70175_ag) {
            ++entity2.field_70173_aa;
            if (entity2.func_184218_aH()) {
                entity2.func_70098_U();
            } else {
                this.field_72984_F.func_194340_a(() -> IRegistry.field_212629_r.func_177774_c(entity2.func_200600_R()).toString());
                entity2.func_70071_h_();
                this.field_72984_F.func_76319_b();
            }
        }
        this.field_72984_F.func_76320_a("chunkCheck");
        if (Double.isNaN(entity2.field_70165_t) || Double.isInfinite(entity2.field_70165_t)) {
            entity2.field_70165_t = entity2.field_70142_S;
        }
        if (Double.isNaN(entity2.field_70163_u) || Double.isInfinite(entity2.field_70163_u)) {
            entity2.field_70163_u = entity2.field_70137_T;
        }
        if (Double.isNaN(entity2.field_70161_v) || Double.isInfinite(entity2.field_70161_v)) {
            entity2.field_70161_v = entity2.field_70136_U;
        }
        if (Double.isNaN(entity2.field_70125_A) || Double.isInfinite(entity2.field_70125_A)) {
            entity2.field_70125_A = entity2.field_70127_C;
        }
        if (Double.isNaN(entity2.field_70177_z) || Double.isInfinite(entity2.field_70177_z)) {
            entity2.field_70177_z = entity2.field_70126_B;
        }
        \u26032 = MathHelper.func_76128_c(entity2.field_70165_t / 16.0);
        int \u26033 = MathHelper.func_76128_c(entity2.field_70163_u / 16.0);
        int \u26034 = MathHelper.func_76128_c(entity2.field_70161_v / 16.0);
        if (!entity2.field_70175_ag || entity2.field_70176_ah != \u26032 || entity2.field_70162_ai != \u26033 || entity2.field_70164_aj != \u26034) {
            if (entity2.field_70175_ag && this.func_175680_a(entity2.field_70176_ah, entity2.field_70164_aj, true)) {
                this.func_72964_e(entity2.field_70176_ah, entity2.field_70164_aj).func_76608_a(entity2, entity2.field_70162_ai);
            }
            if (entity2.func_184189_br() || this.func_175680_a(\u26032, \u26034, true)) {
                this.func_72964_e(\u26032, \u26034).func_76612_a(entity2);
            } else {
                entity2.field_70175_ag = false;
            }
        }
        this.field_72984_F.func_76319_b();
        if (bl && entity2.field_70175_ag) {
            for (Entity entity3 : entity2.func_184188_bt()) {
                if (entity3.field_70128_L || entity3.func_184187_bx() != entity2) {
                    entity3.func_184210_p();
                    continue;
                }
                this.func_72870_g(entity3);
            }
        }
    }

    @Override
    public boolean func_195585_a(@Nullable Entity entity, VoxelShape voxelShape) {
        if (voxelShape.func_197766_b()) {
            return true;
        }
        List<Entity> list = this.func_72839_b(null, voxelShape.func_197752_a());
        for (int i = 0; i < list.size(); ++i) {
            Entity entity2 = list.get(i);
            if (entity2.field_70128_L || !entity2.field_70156_m || entity2 == entity || entity != null && entity2.func_184223_x(entity) || !VoxelShapes.func_197879_c(voxelShape, VoxelShapes.func_197881_a(entity2.func_174813_aQ()), IBooleanFunction.AND)) continue;
            return false;
        }
        return true;
    }

    public boolean func_72829_c(AxisAlignedBB axisAlignedBB) {
        int n = MathHelper.func_76128_c(axisAlignedBB.field_72340_a);
        \u2603 = MathHelper.func_76143_f(axisAlignedBB.field_72336_d);
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72338_b);
        \u2603 = MathHelper.func_76143_f(axisAlignedBB.field_72337_e);
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72339_c);
        \u2603 = MathHelper.func_76143_f(axisAlignedBB.field_72334_f);
        try (BlockPos.PooledMutableBlockPos \u26032 = BlockPos.PooledMutableBlockPos.func_185346_s();){
            for (\u2603 = n; \u2603 < \u2603; ++\u2603) {
                for (\u2603 = \u2603; \u2603 < \u2603; ++\u2603) {
                    for (\u2603 = \u2603; \u2603 < \u2603; ++\u2603) {
                        IBlockState iBlockState = this.func_180495_p(\u26032.func_181079_c(\u2603, \u2603, \u2603));
                        if (iBlockState.func_196958_f()) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
            }
        }
        return false;
    }

    public boolean func_147470_e(AxisAlignedBB axisAlignedBB) {
        int n = MathHelper.func_76128_c(axisAlignedBB.field_72340_a);
        \u2603 = MathHelper.func_76143_f(axisAlignedBB.field_72336_d);
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72338_b);
        \u2603 = MathHelper.func_76143_f(axisAlignedBB.field_72337_e);
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72339_c);
        if (this.func_175663_a(n, \u2603, \u2603, \u2603, \u2603, \u2603 = MathHelper.func_76143_f(axisAlignedBB.field_72334_f), true)) {
            try (BlockPos.PooledMutableBlockPos pooledMutableBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();){
                for (int i = n; i < \u2603; ++i) {
                    for (\u2603 = \u2603; \u2603 < \u2603; ++\u2603) {
                        for (\u2603 = \u2603; \u2603 < \u2603; ++\u2603) {
                            Block block = this.func_180495_p(pooledMutableBlockPos.func_181079_c(i, \u2603, \u2603)).func_177230_c();
                            if (block != Blocks.field_150480_ab && block != Blocks.field_150353_l) continue;
                            boolean bl = true;
                            return bl;
                        }
                    }
                }
            }
        }
        return false;
    }

    @Nullable
    public IBlockState func_203067_a(AxisAlignedBB axisAlignedBB, Block block) {
        int n = MathHelper.func_76128_c(axisAlignedBB.field_72340_a);
        \u2603 = MathHelper.func_76143_f(axisAlignedBB.field_72336_d);
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72338_b);
        \u2603 = MathHelper.func_76143_f(axisAlignedBB.field_72337_e);
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72339_c);
        if (this.func_175663_a(n, \u2603, \u2603, \u2603, \u2603, \u2603 = MathHelper.func_76143_f(axisAlignedBB.field_72334_f), true)) {
            try (BlockPos.PooledMutableBlockPos pooledMutableBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();){
                for (int i = n; i < \u2603; ++i) {
                    for (\u2603 = \u2603; \u2603 < \u2603; ++\u2603) {
                        for (\u2603 = \u2603; \u2603 < \u2603; ++\u2603) {
                            IBlockState iBlockState = this.func_180495_p(pooledMutableBlockPos.func_181079_c(i, \u2603, \u2603));
                            if (iBlockState.func_177230_c() != block) continue;
                            IBlockState iBlockState2 = iBlockState;
                            return iBlockState2;
                        }
                    }
                }
            }
        }
        return null;
    }

    public boolean func_72875_a(AxisAlignedBB axisAlignedBB, Material material) {
        int n = MathHelper.func_76128_c(axisAlignedBB.field_72340_a);
        \u2603 = MathHelper.func_76143_f(axisAlignedBB.field_72336_d);
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72338_b);
        \u2603 = MathHelper.func_76143_f(axisAlignedBB.field_72337_e);
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72339_c);
        \u2603 = MathHelper.func_76143_f(axisAlignedBB.field_72334_f);
        BlockMaterialMatcher \u26032 = BlockMaterialMatcher.func_189886_a(material);
        try (BlockPos.PooledMutableBlockPos \u26033 = BlockPos.PooledMutableBlockPos.func_185346_s();){
            for (\u2603 = n; \u2603 < \u2603; ++\u2603) {
                for (\u2603 = \u2603; \u2603 < \u2603; ++\u2603) {
                    for (\u2603 = \u2603; \u2603 < \u2603; ++\u2603) {
                        if (!\u26032.test(this.func_180495_p(\u26033.func_181079_c(\u2603, \u2603, \u2603)))) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
            }
        }
        return false;
    }

    public Explosion func_72876_a(@Nullable Entity entity, double d, double d2, double d3, float f, boolean bl) {
        return this.func_211529_a(entity, null, d, d2, d3, f, false, bl);
    }

    public Explosion func_72885_a(@Nullable Entity entity, double d, double d2, double d3, float f, boolean bl, boolean bl2) {
        return this.func_211529_a(entity, null, d, d2, d3, f, bl, bl2);
    }

    public Explosion func_211529_a(@Nullable Entity entity, @Nullable DamageSource damageSource, double d, double d2, double d3, float f, boolean bl, boolean bl2) {
        Explosion explosion = new Explosion(this, entity, d, d2, d3, f, bl, bl2);
        if (damageSource != null) {
            explosion.func_199592_a(damageSource);
        }
        explosion.func_77278_a();
        explosion.func_77279_a(true);
        return explosion;
    }

    public float func_72842_a(Vec3d vec3d, AxisAlignedBB axisAlignedBB) {
        double d = 1.0 / ((axisAlignedBB.field_72336_d - axisAlignedBB.field_72340_a) * 2.0 + 1.0);
        \u2603 = 1.0 / ((axisAlignedBB.field_72337_e - axisAlignedBB.field_72338_b) * 2.0 + 1.0);
        \u2603 = 1.0 / ((axisAlignedBB.field_72334_f - axisAlignedBB.field_72339_c) * 2.0 + 1.0);
        \u2603 = (1.0 - Math.floor(1.0 / d) * d) / 2.0;
        \u2603 = (1.0 - Math.floor(1.0 / \u2603) * \u2603) / 2.0;
        if (d < 0.0 || \u2603 < 0.0 || \u2603 < 0.0) {
            return 0.0f;
        }
        int \u26032 = 0;
        int \u26033 = 0;
        float \u26034 = 0.0f;
        while (\u26034 <= 1.0f) {
            float f = 0.0f;
            while (f <= 1.0f) {
                \u26035 = 0.0f;
                while (\u26035 <= 1.0f) {
                    double d2 = axisAlignedBB.field_72340_a + (axisAlignedBB.field_72336_d - axisAlignedBB.field_72340_a) * (double)\u26034;
                    \u2603 = axisAlignedBB.field_72338_b + (axisAlignedBB.field_72337_e - axisAlignedBB.field_72338_b) * (double)f;
                    \u2603 = axisAlignedBB.field_72339_c + (axisAlignedBB.field_72334_f - axisAlignedBB.field_72339_c) * (double)\u26035;
                    if (this.func_72933_a(new Vec3d(d2 + \u2603, \u2603, \u2603 + \u2603), vec3d) == null) {
                        ++\u26032;
                    }
                    ++\u26033;
                    float \u26035 = (float)((double)\u26035 + \u2603);
                }
                f = (float)((double)f + \u2603);
            }
            \u26034 = (float)((double)\u26034 + d);
        }
        return (float)\u26032 / (float)\u26033;
    }

    public boolean func_175719_a(@Nullable EntityPlayer entityPlayer, BlockPos blockPos, EnumFacing enumFacing) {
        if (this.func_180495_p(blockPos = blockPos.func_177972_a(enumFacing)).func_177230_c() == Blocks.field_150480_ab) {
            this.func_180498_a(entityPlayer, 1009, blockPos, 0);
            this.func_175698_g(blockPos);
            return true;
        }
        return false;
    }

    public String func_72981_t() {
        return "All: " + this.field_72996_f.size();
    }

    public String func_72827_u() {
        return this.field_73020_y.func_73148_d();
    }

    @Override
    @Nullable
    public TileEntity func_175625_s(BlockPos blockPos) {
        if (World.func_189509_E(blockPos)) {
            return null;
        }
        TileEntity tileEntity = null;
        if (this.field_147481_N) {
            tileEntity = this.func_189508_F(blockPos);
        }
        if (tileEntity == null) {
            tileEntity = this.func_175726_f(blockPos).func_177424_a(blockPos, Chunk.EnumCreateEntityType.IMMEDIATE);
        }
        if (tileEntity == null) {
            tileEntity = this.func_189508_F(blockPos);
        }
        return tileEntity;
    }

    @Nullable
    private TileEntity func_189508_F(BlockPos blockPos) {
        for (int i = 0; i < this.field_147484_a.size(); ++i) {
            TileEntity tileEntity = this.field_147484_a.get(i);
            if (tileEntity.func_145837_r() || !tileEntity.func_174877_v().equals(blockPos)) continue;
            return tileEntity;
        }
        return null;
    }

    public void func_175690_a(BlockPos blockPos2, @Nullable TileEntity tileEntity2) {
        if (World.func_189509_E(blockPos2)) {
            return;
        }
        if (tileEntity2 != null && !tileEntity2.func_145837_r()) {
            if (this.field_147481_N) {
                TileEntity tileEntity2;
                tileEntity2.func_174878_a(blockPos2);
                Iterator<TileEntity> iterator = this.field_147484_a.iterator();
                while (iterator.hasNext()) {
                    TileEntity tileEntity3 = iterator.next();
                    if (!tileEntity3.func_174877_v().equals(blockPos2)) continue;
                    tileEntity3.func_145843_s();
                    iterator.remove();
                }
                this.field_147484_a.add(tileEntity2);
            } else {
                BlockPos blockPos2;
                this.func_175726_f(blockPos2).func_177426_a(blockPos2, tileEntity2);
                this.func_175700_a(tileEntity2);
            }
        }
    }

    public void func_175713_t(BlockPos blockPos) {
        TileEntity tileEntity = this.func_175625_s(blockPos);
        if (tileEntity != null && this.field_147481_N) {
            tileEntity.func_145843_s();
            this.field_147484_a.remove(tileEntity);
        } else {
            if (tileEntity != null) {
                this.field_147484_a.remove(tileEntity);
                this.field_147482_g.remove(tileEntity);
                this.field_175730_i.remove(tileEntity);
            }
            this.func_175726_f(blockPos).func_177425_e(blockPos);
        }
    }

    public void func_147457_a(TileEntity tileEntity) {
        this.field_147483_b.add(tileEntity);
    }

    public boolean func_175665_u(BlockPos blockPos) {
        return Block.func_208062_a(this.func_180495_p(blockPos).func_196952_d(this, blockPos));
    }

    public boolean func_195588_v(BlockPos blockPos) {
        if (World.func_189509_E(blockPos)) {
            return false;
        }
        Chunk chunk = this.field_73020_y.func_186025_d(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4, false, false);
        return chunk != null && !chunk.func_76621_g();
    }

    public boolean func_195595_w(BlockPos blockPos) {
        return this.func_195588_v(blockPos) && this.func_180495_p(blockPos).func_185896_q();
    }

    public void func_72966_v() {
        int n = this.func_72967_a(1.0f);
        if (n != this.field_73008_k) {
            this.field_73008_k = n;
        }
    }

    public void func_72891_a(boolean bl, boolean bl2) {
        this.field_72985_G = bl;
        this.field_72992_H = bl2;
    }

    public void func_72835_b(BooleanSupplier booleanSupplier) {
        this.field_175728_M.func_212673_r();
        this.func_72979_l();
    }

    protected void func_72947_a() {
        if (this.field_72986_A.func_76059_o()) {
            this.field_73004_o = 1.0f;
            if (this.field_72986_A.func_76061_m()) {
                this.field_73017_q = 1.0f;
            }
        }
    }

    @Override
    public void close() {
        this.field_73020_y.close();
    }

    protected void func_72979_l() {
        if (!this.field_73011_w.func_191066_m()) {
            return;
        }
        if (this.field_72995_K) {
            return;
        }
        boolean bl = this.func_82736_K().func_82766_b("doWeatherCycle");
        if (bl) {
            int n = this.field_72986_A.func_176133_A();
            if (n > 0) {
                this.field_72986_A.func_176142_i(--n);
                this.field_72986_A.func_76090_f(this.field_72986_A.func_76061_m() ? 1 : 2);
                this.field_72986_A.func_76080_g(this.field_72986_A.func_76059_o() ? 1 : 2);
            }
            if ((\u2603 = this.field_72986_A.func_76071_n()) <= 0) {
                if (this.field_72986_A.func_76061_m()) {
                    this.field_72986_A.func_76090_f(this.field_73012_v.nextInt(12000) + 3600);
                } else {
                    this.field_72986_A.func_76090_f(this.field_73012_v.nextInt(168000) + 12000);
                }
            } else {
                this.field_72986_A.func_76090_f(--\u2603);
                if (\u2603 <= 0) {
                    this.field_72986_A.func_76069_a(!this.field_72986_A.func_76061_m());
                }
            }
            \u2603 = this.field_72986_A.func_76083_p();
            if (\u2603 <= 0) {
                if (this.field_72986_A.func_76059_o()) {
                    this.field_72986_A.func_76080_g(this.field_73012_v.nextInt(12000) + 12000);
                } else {
                    this.field_72986_A.func_76080_g(this.field_73012_v.nextInt(168000) + 12000);
                }
            } else {
                this.field_72986_A.func_76080_g(--\u2603);
                if (\u2603 <= 0) {
                    this.field_72986_A.func_76084_b(!this.field_72986_A.func_76059_o());
                }
            }
        }
        this.field_73018_p = this.field_73017_q;
        this.field_73017_q = this.field_72986_A.func_76061_m() ? (float)((double)this.field_73017_q + 0.01) : (float)((double)this.field_73017_q - 0.01);
        this.field_73017_q = MathHelper.func_76131_a(this.field_73017_q, 0.0f, 1.0f);
        this.field_73003_n = this.field_73004_o;
        this.field_73004_o = this.field_72986_A.func_76059_o() ? (float)((double)this.field_73004_o + 0.01) : (float)((double)this.field_73004_o - 0.01);
        this.field_73004_o = MathHelper.func_76131_a(this.field_73004_o, 0.0f, 1.0f);
    }

    protected void func_147467_a(int n, int n2, Chunk chunk) {
        chunk.func_76594_o();
    }

    protected void func_147456_g() {
    }

    public boolean func_175664_x(BlockPos blockPos) {
        boolean bl = false;
        if (this.field_73011_w.func_191066_m()) {
            bl |= this.func_180500_c(EnumLightType.SKY, blockPos);
        }
        return bl |= this.func_180500_c(EnumLightType.BLOCK, blockPos);
    }

    private int func_175638_a(BlockPos blockPos, EnumLightType enumLightType) {
        if (enumLightType == EnumLightType.SKY && this.func_175678_i(blockPos)) {
            return 15;
        }
        IBlockState iBlockState = this.func_180495_p(blockPos);
        int \u26032 = enumLightType == EnumLightType.SKY ? 0 : iBlockState.func_185906_d();
        int \u26033 = iBlockState.func_200016_a(this, blockPos);
        if (\u26033 >= 15 && iBlockState.func_185906_d() > 0) {
            \u26033 = 1;
        }
        if (\u26033 < 1) {
            \u26033 = 1;
        }
        if (\u26033 >= 15) {
            return 0;
        }
        if (\u26032 >= 14) {
            return \u26032;
        }
        try (BlockPos.PooledMutableBlockPos \u26034 = BlockPos.PooledMutableBlockPos.func_185346_s();){
            for (EnumFacing enumFacing : field_200007_a) {
                \u26034.func_189533_g(blockPos).func_189536_c(enumFacing);
                int n = this.func_175642_b(enumLightType, \u26034) - \u26033;
                if (n > \u26032) {
                    \u26032 = n;
                }
                if (\u26032 < 14) continue;
                int n2 = \u26032;
                return n2;
            }
        }
        return \u26032;
    }

    public boolean func_180500_c(EnumLightType enumLightType, BlockPos blockPos) {
        int \u26032;
        if (!this.func_175648_a(blockPos, 17, false)) {
            return false;
        }
        int n = 0;
        \u2603 = 0;
        this.field_72984_F.func_76320_a("getBrightness");
        \u2603 = this.func_175642_b(enumLightType, blockPos);
        \u2603 = this.func_175638_a(blockPos, enumLightType);
        \u2603 = blockPos.func_177958_n();
        \u2603 = blockPos.func_177956_o();
        \u2603 = blockPos.func_177952_p();
        if (\u2603 > \u2603) {
            this.field_72994_J[\u2603++] = 133152;
        } else if (\u2603 < \u2603) {
            this.field_72994_J[\u2603++] = 0x20820 | \u2603 << 18;
            while (n < \u2603) {
                \u2603 = this.field_72994_J[n++];
                \u2603 = (\u2603 & 0x3F) - 32 + \u2603;
                \u2603 = (\u2603 >> 6 & 0x3F) - 32 + \u2603;
                \u2603 = (\u2603 >> 12 & 0x3F) - 32 + \u2603;
                \u2603 = \u2603 >> 18 & 0xF;
                BlockPos blockPos2 = new BlockPos(\u2603, \u2603, \u2603);
                \u26032 = this.func_175642_b(enumLightType, blockPos2);
                if (\u26032 != \u2603) continue;
                this.func_175653_a(enumLightType, blockPos2, 0);
                if (\u2603 <= 0 || (\u26035 = MathHelper.func_76130_a(\u2603 - \u2603)) + (\u26036 = MathHelper.func_76130_a(\u2603 - \u2603)) + (\u26037 = MathHelper.func_76130_a(\u2603 - \u2603)) >= 17) continue;
                BlockPos.PooledMutableBlockPos \u26033 = BlockPos.PooledMutableBlockPos.func_185346_s();
                Throwable throwable = null;
                try {
                    for (EnumFacing enumFacing : field_200007_a) {
                        int n2 = \u2603 + enumFacing.func_82601_c();
                        \u2603 = \u2603 + enumFacing.func_96559_d();
                        \u2603 = \u2603 + enumFacing.func_82599_e();
                        \u26033.func_181079_c(n2, \u2603, \u2603);
                        \u2603 = Math.max(1, this.func_180495_p(\u26033).func_200016_a(this, \u26033));
                        \u26032 = this.func_175642_b(enumLightType, \u26033);
                        if (\u26032 != \u2603 - \u2603 || \u2603 >= this.field_72994_J.length) continue;
                        this.field_72994_J[\u2603++] = n2 - \u2603 + 32 | \u2603 - \u2603 + 32 << 6 | \u2603 - \u2603 + 32 << 12 | \u2603 - \u2603 << 18;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (\u26033 == null) continue;
                    if (throwable != null) {
                        try {
                            \u26033.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    \u26033.close();
                }
            }
            n = 0;
        }
        this.field_72984_F.func_76319_b();
        this.field_72984_F.func_76320_a("checkedPosition < toCheckCount");
        while (n < \u2603) {
            \u2603 = this.field_72994_J[n++];
            \u2603 = (\u2603 & 0x3F) - 32 + \u2603;
            \u2603 = (\u2603 >> 6 & 0x3F) - 32 + \u2603;
            \u2603 = (\u2603 >> 12 & 0x3F) - 32 + \u2603;
            BlockPos blockPos3 = new BlockPos(\u2603, \u2603, \u2603);
            int \u26034 = this.func_175642_b(enumLightType, blockPos3);
            \u26032 = this.func_175638_a(blockPos3, enumLightType);
            if (\u26032 == \u26034) continue;
            this.func_175653_a(enumLightType, blockPos3, \u26032);
            if (\u26032 <= \u26034) continue;
            int \u26035 = Math.abs(\u2603 - \u2603);
            int \u26036 = Math.abs(\u2603 - \u2603);
            int \u26037 = Math.abs(\u2603 - \u2603);
            boolean bl = \u2603 = \u2603 < this.field_72994_J.length - 6;
            if (\u26035 + \u26036 + \u26037 >= 17 || !\u2603) continue;
            if (this.func_175642_b(enumLightType, blockPos3.func_177976_e()) < \u26032) {
                this.field_72994_J[\u2603++] = \u2603 - 1 - \u2603 + 32 + (\u2603 - \u2603 + 32 << 6) + (\u2603 - \u2603 + 32 << 12);
            }
            if (this.func_175642_b(enumLightType, blockPos3.func_177974_f()) < \u26032) {
                this.field_72994_J[\u2603++] = \u2603 + 1 - \u2603 + 32 + (\u2603 - \u2603 + 32 << 6) + (\u2603 - \u2603 + 32 << 12);
            }
            if (this.func_175642_b(enumLightType, blockPos3.func_177977_b()) < \u26032) {
                this.field_72994_J[\u2603++] = \u2603 - \u2603 + 32 + (\u2603 - 1 - \u2603 + 32 << 6) + (\u2603 - \u2603 + 32 << 12);
            }
            if (this.func_175642_b(enumLightType, blockPos3.func_177984_a()) < \u26032) {
                this.field_72994_J[\u2603++] = \u2603 - \u2603 + 32 + (\u2603 + 1 - \u2603 + 32 << 6) + (\u2603 - \u2603 + 32 << 12);
            }
            if (this.func_175642_b(enumLightType, blockPos3.func_177978_c()) < \u26032) {
                this.field_72994_J[\u2603++] = \u2603 - \u2603 + 32 + (\u2603 - \u2603 + 32 << 6) + (\u2603 - 1 - \u2603 + 32 << 12);
            }
            if (this.func_175642_b(enumLightType, blockPos3.func_177968_d()) >= \u26032) continue;
            this.field_72994_J[\u2603++] = \u2603 - \u2603 + 32 + (\u2603 - \u2603 + 32 << 6) + (\u2603 + 1 - \u2603 + 32 << 12);
        }
        this.field_72984_F.func_76319_b();
        return true;
    }

    @Override
    public Stream<VoxelShape> func_212392_a(@Nullable Entity entity, VoxelShape voxelShape, VoxelShape voxelShape2, Set<Entity> set) {
        Stream<VoxelShape> stream = IWorld.super.func_212392_a(entity, voxelShape, voxelShape2, set);
        if (entity == null) {
            return stream;
        }
        return Stream.concat(stream, this.func_211155_a(entity, voxelShape, set));
    }

    @Override
    public List<Entity> func_175674_a(@Nullable Entity entity, AxisAlignedBB axisAlignedBB, @Nullable Predicate<? super Entity> predicate) {
        ArrayList arrayList = Lists.newArrayList();
        int \u26032 = MathHelper.func_76128_c((axisAlignedBB.field_72340_a - 2.0) / 16.0);
        int \u26033 = MathHelper.func_76128_c((axisAlignedBB.field_72336_d + 2.0) / 16.0);
        int \u26034 = MathHelper.func_76128_c((axisAlignedBB.field_72339_c - 2.0) / 16.0);
        int \u26035 = MathHelper.func_76128_c((axisAlignedBB.field_72334_f + 2.0) / 16.0);
        for (int i = \u26032; i <= \u26033; ++i) {
            for (\u2603 = \u26034; \u2603 <= \u26035; ++\u2603) {
                if (!this.func_175680_a(i, \u2603, true)) continue;
                this.func_72964_e(i, \u2603).func_177414_a(entity, axisAlignedBB, arrayList, predicate);
            }
        }
        return arrayList;
    }

    public <T extends Entity> List<T> func_175644_a(Class<? extends T> clazz, Predicate<? super T> predicate) {
        ArrayList arrayList = Lists.newArrayList();
        for (Entity entity : this.field_72996_f) {
            if (!clazz.isAssignableFrom(entity.getClass()) || !predicate.test(entity)) continue;
            arrayList.add(entity);
        }
        return arrayList;
    }

    public <T extends Entity> List<T> func_175661_b(Class<? extends T> clazz, Predicate<? super T> predicate) {
        ArrayList arrayList = Lists.newArrayList();
        for (Entity entity : this.field_73010_i) {
            if (!clazz.isAssignableFrom(entity.getClass()) || !predicate.test(entity)) continue;
            arrayList.add(entity);
        }
        return arrayList;
    }

    public <T extends Entity> List<T> func_72872_a(Class<? extends T> clazz, AxisAlignedBB axisAlignedBB) {
        return this.func_175647_a(clazz, axisAlignedBB, EntitySelectors.field_180132_d);
    }

    public <T extends Entity> List<T> func_175647_a(Class<? extends T> clazz, AxisAlignedBB axisAlignedBB, @Nullable Predicate<? super T> predicate) {
        int n = MathHelper.func_76128_c((axisAlignedBB.field_72340_a - 2.0) / 16.0);
        \u2603 = MathHelper.func_76143_f((axisAlignedBB.field_72336_d + 2.0) / 16.0);
        \u2603 = MathHelper.func_76128_c((axisAlignedBB.field_72339_c - 2.0) / 16.0);
        \u2603 = MathHelper.func_76143_f((axisAlignedBB.field_72334_f + 2.0) / 16.0);
        ArrayList \u26032 = Lists.newArrayList();
        for (\u2603 = n; \u2603 < \u2603; ++\u2603) {
            for (\u2603 = \u2603; \u2603 < \u2603; ++\u2603) {
                if (!this.func_175680_a(\u2603, \u2603, true)) continue;
                this.func_72964_e(\u2603, \u2603).func_177430_a(clazz, axisAlignedBB, \u26032, predicate);
            }
        }
        return \u26032;
    }

    @Nullable
    public <T extends Entity> T func_72857_a(Class<? extends T> clazz, AxisAlignedBB axisAlignedBB, T t) {
        List<T> list = this.func_72872_a(clazz, axisAlignedBB);
        Entity \u26032 = null;
        double \u26033 = Double.MAX_VALUE;
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (entity == t || !EntitySelectors.field_180132_d.test(entity) || (\u2603 = t.func_70068_e(entity)) > \u26033) continue;
            \u26032 = entity;
            \u26033 = \u2603;
        }
        return (T)\u26032;
    }

    @Nullable
    public Entity func_73045_a(int n) {
        return this.field_175729_l.func_76041_a(n);
    }

    public int func_212419_R() {
        return this.field_72996_f.size();
    }

    public void func_175646_b(BlockPos blockPos, TileEntity tileEntity) {
        if (this.func_175667_e(blockPos)) {
            this.func_175726_f(blockPos).func_76630_e();
        }
    }

    public int func_72907_a(Class<?> clazz, int n) {
        int n2;
        n2 = 0;
        for (Entity entity : this.field_72996_f) {
            if (entity instanceof EntityLiving && ((EntityLiving)entity).func_104002_bU()) continue;
            if (clazz.isAssignableFrom(entity.getClass())) {
                ++n2;
            }
            if (n2 <= n) continue;
            return n2;
        }
        return n2;
    }

    public void func_212420_a(Stream<Entity> stream) {
        stream.forEach(entity -> {
            this.field_72996_f.add((Entity)entity);
            this.func_72923_a((Entity)entity);
        });
    }

    public void func_175681_c(Collection<Entity> collection) {
        this.field_72997_g.addAll(collection);
    }

    @Override
    public int func_181545_F() {
        return this.field_181546_a;
    }

    @Override
    public World func_201672_e() {
        return this;
    }

    public void func_181544_b(int n) {
        this.field_181546_a = n;
    }

    @Override
    public int func_175627_a(BlockPos blockPos, EnumFacing enumFacing) {
        return this.func_180495_p(blockPos).func_185893_b(this, blockPos, enumFacing);
    }

    public WorldType func_175624_G() {
        return this.field_72986_A.func_76067_t();
    }

    public int func_175676_y(BlockPos blockPos) {
        int n = 0;
        if ((n = Math.max(n, this.func_175627_a(blockPos.func_177977_b(), EnumFacing.DOWN))) >= 15) {
            return n;
        }
        if ((n = Math.max(n, this.func_175627_a(blockPos.func_177984_a(), EnumFacing.UP))) >= 15) {
            return n;
        }
        if ((n = Math.max(n, this.func_175627_a(blockPos.func_177978_c(), EnumFacing.NORTH))) >= 15) {
            return n;
        }
        if ((n = Math.max(n, this.func_175627_a(blockPos.func_177968_d(), EnumFacing.SOUTH))) >= 15) {
            return n;
        }
        if ((n = Math.max(n, this.func_175627_a(blockPos.func_177976_e(), EnumFacing.WEST))) >= 15) {
            return n;
        }
        if ((n = Math.max(n, this.func_175627_a(blockPos.func_177974_f(), EnumFacing.EAST))) >= 15) {
            return n;
        }
        return n;
    }

    public boolean func_175709_b(BlockPos blockPos, EnumFacing enumFacing) {
        return this.func_175651_c(blockPos, enumFacing) > 0;
    }

    public int func_175651_c(BlockPos blockPos, EnumFacing enumFacing) {
        IBlockState iBlockState = this.func_180495_p(blockPos);
        if (iBlockState.func_185915_l()) {
            return this.func_175676_y(blockPos);
        }
        return iBlockState.func_185911_a(this, blockPos, enumFacing);
    }

    public boolean func_175640_z(BlockPos blockPos) {
        if (this.func_175651_c(blockPos.func_177977_b(), EnumFacing.DOWN) > 0) {
            return true;
        }
        if (this.func_175651_c(blockPos.func_177984_a(), EnumFacing.UP) > 0) {
            return true;
        }
        if (this.func_175651_c(blockPos.func_177978_c(), EnumFacing.NORTH) > 0) {
            return true;
        }
        if (this.func_175651_c(blockPos.func_177968_d(), EnumFacing.SOUTH) > 0) {
            return true;
        }
        if (this.func_175651_c(blockPos.func_177976_e(), EnumFacing.WEST) > 0) {
            return true;
        }
        return this.func_175651_c(blockPos.func_177974_f(), EnumFacing.EAST) > 0;
    }

    public int func_175687_A(BlockPos blockPos) {
        int n = 0;
        for (EnumFacing enumFacing : field_200007_a) {
            int n2 = this.func_175651_c(blockPos.func_177972_a(enumFacing), enumFacing);
            if (n2 >= 15) {
                return 15;
            }
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    @Override
    @Nullable
    public EntityPlayer func_190525_a(double d, double d2, double d3, double d4, Predicate<Entity> predicate) {
        double \u26034 = -1.0;
        EntityPlayer \u26032 = null;
        for (int i = 0; i < this.field_73010_i.size(); ++i) {
            EntityPlayer entityPlayer = this.field_73010_i.get(i);
            if (!predicate.test(entityPlayer)) continue;
            double \u26033 = entityPlayer.func_70092_e(d, d2, d3);
            if (!(d4 < 0.0) && !(\u26033 < d4 * d4) || \u26034 != -1.0 && !(\u26033 < \u26034)) continue;
            \u26034 = \u26033;
            \u26032 = entityPlayer;
        }
        return \u26032;
    }

    public boolean func_175636_b(double d, double d2, double d3, double d4) {
        for (int i = 0; i < this.field_73010_i.size(); ++i) {
            EntityPlayer entityPlayer = this.field_73010_i.get(i);
            if (!EntitySelectors.field_180132_d.test(entityPlayer)) continue;
            double \u26032 = entityPlayer.func_70092_e(d, d2, d3);
            if (!(d4 < 0.0) && !(\u26032 < d4 * d4)) continue;
            return true;
        }
        return false;
    }

    public boolean func_212417_b(double d, double d2, double d3, double d4) {
        for (EntityPlayer entityPlayer : this.field_73010_i) {
            if (!EntitySelectors.field_180132_d.test(entityPlayer) || !EntitySelectors.field_212545_b.test(entityPlayer)) continue;
            double d5 = entityPlayer.func_70092_e(d, d2, d3);
            if (!(d4 < 0.0) && !(d5 < d4 * d4)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public EntityPlayer func_212817_a(double d, double d2, double d3) {
        \u26033 = -1.0;
        EntityPlayer entityPlayer = null;
        for (int i = 0; i < this.field_73010_i.size(); ++i) {
            EntityPlayer entityPlayer2 = this.field_73010_i.get(i);
            if (!EntitySelectors.field_180132_d.test(entityPlayer2)) continue;
            double \u26032 = entityPlayer2.func_70092_e(d, entityPlayer2.field_70163_u, d2);
            if (!(d3 < 0.0) && !(\u26032 < d3 * d3) || \u26033 != -1.0 && !(\u26032 < \u26033)) continue;
            double \u26033 = \u26032;
            entityPlayer = entityPlayer2;
        }
        return entityPlayer;
    }

    @Nullable
    public EntityPlayer func_184142_a(Entity entity, double d, double d2) {
        return this.func_184150_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, d, d2, null, null);
    }

    @Nullable
    public EntityPlayer func_184139_a(BlockPos blockPos, double d, double d2) {
        return this.func_184150_a((float)blockPos.func_177958_n() + 0.5f, (float)blockPos.func_177956_o() + 0.5f, (float)blockPos.func_177952_p() + 0.5f, d, d2, null, null);
    }

    @Nullable
    public EntityPlayer func_184150_a(double d, double d2, double d3, double d4, double d5, @Nullable Function<EntityPlayer, Double> function2, @Nullable Predicate<EntityPlayer> predicate) {
        double \u26035 = -1.0;
        EntityPlayer \u26032 = null;
        for (int i = 0; i < this.field_73010_i.size(); ++i) {
            Function<EntityPlayer, Double> function2;
            EntityPlayer entityPlayer = this.field_73010_i.get(i);
            if (entityPlayer.field_71075_bZ.field_75102_a || !entityPlayer.func_70089_S() || entityPlayer.func_175149_v() || predicate != null && !predicate.test(entityPlayer)) continue;
            double \u26033 = entityPlayer.func_70092_e(d, entityPlayer.field_70163_u, d3);
            double \u26034 = d4;
            if (entityPlayer.func_70093_af()) {
                \u26034 *= (double)0.8f;
            }
            if (entityPlayer.func_82150_aj()) {
                float f = entityPlayer.func_82243_bO();
                if (f < 0.1f) {
                    f = 0.1f;
                }
                \u26034 *= (double)(0.7f * f);
            }
            if (function2 != null) {
                \u26034 *= ((Double)MoreObjects.firstNonNull((Object)function2.apply(entityPlayer), (Object)1.0)).doubleValue();
            }
            if (!(d5 < 0.0) && !(Math.abs(entityPlayer.field_70163_u - d2) < d5 * d5) || !(d4 < 0.0) && !(\u26033 < \u26034 * \u26034) || \u26035 != -1.0 && !(\u26033 < \u26035)) continue;
            \u26035 = \u26033;
            \u26032 = entityPlayer;
        }
        return \u26032;
    }

    @Nullable
    public EntityPlayer func_72924_a(String string) {
        for (int i = 0; i < this.field_73010_i.size(); ++i) {
            EntityPlayer entityPlayer = this.field_73010_i.get(i);
            if (!string.equals(entityPlayer.func_200200_C_().getString())) continue;
            return entityPlayer;
        }
        return null;
    }

    @Nullable
    public EntityPlayer func_152378_a(UUID uUID) {
        for (int i = 0; i < this.field_73010_i.size(); ++i) {
            EntityPlayer entityPlayer = this.field_73010_i.get(i);
            if (!uUID.equals(entityPlayer.func_110124_au())) continue;
            return entityPlayer;
        }
        return null;
    }

    public void func_72882_A() {
    }

    public void func_72906_B() throws SessionLockException {
        this.field_73019_z.func_75762_c();
    }

    public void func_82738_a(long l) {
        this.field_72986_A.func_82572_b(l);
    }

    @Override
    public long func_72905_C() {
        return this.field_72986_A.func_76063_b();
    }

    public long func_82737_E() {
        return this.field_72986_A.func_82573_f();
    }

    public long func_72820_D() {
        return this.field_72986_A.func_76073_f();
    }

    public void func_72877_b(long l) {
        this.field_72986_A.func_76068_b(l);
    }

    @Override
    public BlockPos func_175694_M() {
        BlockPos blockPos = new BlockPos(this.field_72986_A.func_76079_c(), this.field_72986_A.func_76075_d(), this.field_72986_A.func_76074_e());
        if (!this.func_175723_af().func_177746_a(blockPos)) {
            blockPos = this.func_205770_a(Heightmap.Type.MOTION_BLOCKING, new BlockPos(this.func_175723_af().func_177731_f(), 0.0, this.func_175723_af().func_177721_g()));
        }
        return blockPos;
    }

    public void func_175652_B(BlockPos blockPos) {
        this.field_72986_A.func_176143_a(blockPos);
    }

    public void func_72897_h(Entity entity) {
        int n = MathHelper.func_76128_c(entity.field_70165_t / 16.0);
        \u2603 = MathHelper.func_76128_c(entity.field_70161_v / 16.0);
        \u2603 = 2;
        for (\u2603 = -2; \u2603 <= 2; ++\u2603) {
            for (\u2603 = -2; \u2603 <= 2; ++\u2603) {
                this.func_72964_e(n + \u2603, \u2603 + \u2603);
            }
        }
        if (!this.field_72996_f.contains(entity)) {
            this.field_72996_f.add(entity);
        }
    }

    public boolean func_175660_a(EntityPlayer entityPlayer, BlockPos blockPos) {
        return true;
    }

    public void func_72960_a(Entity entity, byte by) {
    }

    @Override
    public IChunkProvider func_72863_F() {
        return this.field_73020_y;
    }

    public void func_175641_c(BlockPos blockPos, Block block, int n, int n2) {
        this.func_180495_p(blockPos).func_189547_a(this, blockPos, n, n2);
    }

    @Override
    public ISaveHandler func_72860_G() {
        return this.field_73019_z;
    }

    @Override
    public WorldInfo func_72912_H() {
        return this.field_72986_A;
    }

    public GameRules func_82736_K() {
        return this.field_72986_A.func_82574_x();
    }

    public void func_72854_c() {
    }

    public float func_72819_i(float f) {
        return (this.field_73018_p + (this.field_73017_q - this.field_73018_p) * f) * this.func_72867_j(f);
    }

    public void func_147442_i(float f) {
        this.field_73018_p = f;
        this.field_73017_q = f;
    }

    public float func_72867_j(float f) {
        return this.field_73003_n + (this.field_73004_o - this.field_73003_n) * f;
    }

    public void func_72894_k(float f) {
        this.field_73003_n = f;
        this.field_73004_o = f;
    }

    public boolean func_72911_I() {
        if (!this.field_73011_w.func_191066_m() || this.field_73011_w.func_177495_o()) {
            return false;
        }
        return (double)this.func_72819_i(1.0f) > 0.9;
    }

    public boolean func_72896_J() {
        return (double)this.func_72867_j(1.0f) > 0.2;
    }

    public boolean func_175727_C(BlockPos blockPos) {
        if (!this.func_72896_J()) {
            return false;
        }
        if (!this.func_175678_i(blockPos)) {
            return false;
        }
        if (this.func_205770_a(Heightmap.Type.MOTION_BLOCKING, blockPos).func_177956_o() > blockPos.func_177956_o()) {
            return false;
        }
        return this.func_180494_b(blockPos).func_201851_b() == Biome.RainType.RAIN;
    }

    public boolean func_180502_D(BlockPos blockPos) {
        Biome biome = this.func_180494_b(blockPos);
        return biome.func_76736_e();
    }

    @Override
    @Nullable
    public WorldSavedDataStorage func_175693_T() {
        return this.field_72988_C;
    }

    public void func_175669_a(int n, BlockPos blockPos, int n2) {
        for (\u2603 = 0; \u2603 < this.field_73021_x.size(); ++\u2603) {
            this.field_73021_x.get(\u2603).func_180440_a(n, blockPos, n2);
        }
    }

    public void func_175718_b(int n, BlockPos blockPos, int n2) {
        this.func_180498_a(null, n, blockPos, n2);
    }

    public void func_180498_a(@Nullable EntityPlayer entityPlayer, int n, BlockPos blockPos, int n2) {
        try {
            for (\u2603 = 0; \u2603 < this.field_73021_x.size(); ++\u2603) {
                this.field_73021_x.get(\u2603).func_180439_a(entityPlayer, n, blockPos, n2);
            }
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Playing level event");
            CrashReportCategory \u26032 = crashReport.func_85058_a("Level event being played");
            \u26032.func_71507_a("Block coordinates", CrashReportCategory.func_180522_a(blockPos));
            \u26032.func_71507_a("Event source", entityPlayer);
            \u26032.func_71507_a("Event type", n);
            \u26032.func_71507_a("Event data", n2);
            throw new ReportedException(crashReport);
        }
    }

    public int func_72800_K() {
        return 256;
    }

    public int func_72940_L() {
        return this.field_73011_w.func_177495_o() ? 128 : 256;
    }

    public double func_72919_O() {
        if (this.field_72986_A.func_76067_t() == WorldType.field_77138_c) {
            return 0.0;
        }
        return 63.0;
    }

    public CrashReportCategory func_72914_a(CrashReport crashReport) {
        CrashReportCategory crashReportCategory = crashReport.func_85057_a("Affected level", 1);
        crashReportCategory.func_71507_a("Level name", this.field_72986_A == null ? "????" : this.field_72986_A.func_76065_j());
        crashReportCategory.func_189529_a("All players", () -> this.field_73010_i.size() + " total; " + this.field_73010_i);
        crashReportCategory.func_189529_a("Chunk stats", () -> this.field_73020_y.func_73148_d());
        try {
            this.field_72986_A.func_85118_a(crashReportCategory);
        }
        catch (Throwable \u26032) {
            crashReportCategory.func_71499_a("Level Data Unobtainable", \u26032);
        }
        return crashReportCategory;
    }

    public void func_175715_c(int n, BlockPos blockPos, int n2) {
        for (\u2603 = 0; \u2603 < this.field_73021_x.size(); ++\u2603) {
            IWorldEventListener iWorldEventListener = this.field_73021_x.get(\u2603);
            iWorldEventListener.func_180441_b(n, blockPos, n2);
        }
    }

    public void func_92088_a(double d, double d2, double d3, double d4, double d5, double d6, @Nullable NBTTagCompound nBTTagCompound) {
    }

    public abstract Scoreboard func_96441_U();

    public void func_175666_e(BlockPos blockPos, Block block) {
        for (EnumFacing enumFacing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos blockPos2 = blockPos.func_177972_a(enumFacing);
            if (!this.func_175667_e(blockPos2)) continue;
            IBlockState \u26032 = this.func_180495_p(blockPos2);
            if (\u26032.func_177230_c() == Blocks.field_196762_fd) {
                \u26032.func_189546_a(this, blockPos2, block, blockPos);
                continue;
            }
            if (!\u26032.func_185915_l() || (\u26032 = this.func_180495_p(blockPos2 = blockPos2.func_177972_a(enumFacing))).func_177230_c() != Blocks.field_196762_fd) continue;
            \u26032.func_189546_a(this, blockPos2, block, blockPos);
        }
    }

    @Override
    public DifficultyInstance func_175649_E(BlockPos blockPos) {
        long l = 0L;
        float \u26032 = 0.0f;
        if (this.func_175667_e(blockPos)) {
            \u26032 = this.func_130001_d();
            l = this.func_175726_f(blockPos).func_177416_w();
        }
        return new DifficultyInstance(this.func_175659_aa(), this.func_72820_D(), l, \u26032);
    }

    @Override
    public int func_175657_ab() {
        return this.field_73008_k;
    }

    public void func_175692_b(int n) {
        this.field_73008_k = n;
    }

    public int func_175658_ac() {
        return this.field_73016_r;
    }

    public void func_175702_c(int n) {
        this.field_73016_r = n;
    }

    public VillageCollection func_175714_ae() {
        return this.field_72982_D;
    }

    @Override
    public WorldBorder func_175723_af() {
        return this.field_175728_M;
    }

    public boolean func_72916_c(int n, int n2) {
        BlockPos blockPos = this.func_175694_M();
        int \u26032 = n * 16 + 8 - blockPos.func_177958_n();
        int \u26033 = n2 * 16 + 8 - blockPos.func_177952_p();
        int \u26034 = 128;
        return \u26032 >= -128 && \u26032 <= 128 && \u26033 >= -128 && \u26033 <= 128;
    }

    public LongSet func_212412_ag() {
        ForcedChunksSaveData forcedChunksSaveData = this.func_212411_a(this.field_73011_w.func_186058_p(), ForcedChunksSaveData::new, "chunks");
        return forcedChunksSaveData != null ? LongSets.unmodifiable((LongSet)forcedChunksSaveData.func_212438_a()) : LongSets.EMPTY_SET;
    }

    public boolean func_212416_f(int n, int n2) {
        ForcedChunksSaveData forcedChunksSaveData = this.func_212411_a(this.field_73011_w.func_186058_p(), ForcedChunksSaveData::new, "chunks");
        return forcedChunksSaveData != null && forcedChunksSaveData.func_212438_a().contains(ChunkPos.func_77272_a(n, n2));
    }

    public boolean func_212414_b(int n, int n2, boolean bl) {
        boolean bl2;
        String string = "chunks";
        ForcedChunksSaveData \u26032 = this.func_212411_a(this.field_73011_w.func_186058_p(), ForcedChunksSaveData::new, "chunks");
        if (\u26032 == null) {
            \u26032 = new ForcedChunksSaveData("chunks");
            this.func_212409_a(this.field_73011_w.func_186058_p(), "chunks", \u26032);
        }
        long \u26033 = ChunkPos.func_77272_a(n, n2);
        if (bl) {
            bl2 = \u26032.func_212438_a().add(\u26033);
            if (bl2) {
                this.func_72964_e(n, n2);
            }
        } else {
            bl2 = \u26032.func_212438_a().remove(\u26033);
        }
        \u26032.func_76186_a(bl2);
        return bl2;
    }

    public void func_184135_a(Packet<?> packet) {
        throw new UnsupportedOperationException("Can't send packets to server unless you're on the client.");
    }

    @Nullable
    public BlockPos func_211157_a(String string, BlockPos blockPos, int n, boolean bl) {
        return null;
    }

    @Override
    public Dimension func_201675_m() {
        return this.field_73011_w;
    }

    @Override
    public Random func_201674_k() {
        return this.field_73012_v;
    }

    public abstract RecipeManager func_199532_z();

    public abstract NetworkTagManager func_205772_D();

    @Override
    public /* synthetic */ IChunk func_72964_e(int n, int n2) {
        return this.func_72964_e(n, n2);
    }

    private static /* synthetic */ String func_210187_c(TileEntity tileEntity) {
        return String.valueOf(TileEntityType.func_200969_a(tileEntity.func_200662_C()));
    }
}

