/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome.provider;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.EndBiomeProviderSettings;
import net.minecraft.world.gen.NoiseGeneratorSimplex;
import net.minecraft.world.gen.feature.structure.Structure;

public class EndBiomeProvider
extends BiomeProvider {
    private final NoiseGeneratorSimplex field_201546_a;
    private final SharedSeedRandom field_201547_b;
    private final Biome[] field_205009_d = new Biome[]{Biomes.field_76779_k, Biomes.field_201938_R, Biomes.field_201937_Q, Biomes.field_201936_P, Biomes.field_201939_S};

    public EndBiomeProvider(EndBiomeProviderSettings endBiomeProviderSettings) {
        this.field_201547_b = new SharedSeedRandom(endBiomeProviderSettings.func_205445_a());
        this.field_201547_b.func_202423_a(17292);
        this.field_201546_a = new NoiseGeneratorSimplex(this.field_201547_b);
    }

    @Override
    @Nullable
    public Biome func_180300_a(BlockPos blockPos, @Nullable Biome biome) {
        return this.func_201545_a(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4);
    }

    private Biome func_201545_a(int n, int n2) {
        if ((long)n * (long)n + (long)n2 * (long)n2 <= 4096L) {
            return Biomes.field_76779_k;
        }
        float f = this.func_201536_c(n, n2, 1, 1);
        if (f > 40.0f) {
            return Biomes.field_201938_R;
        }
        if (f >= 0.0f) {
            return Biomes.field_201937_Q;
        }
        if (f < -20.0f) {
            return Biomes.field_201936_P;
        }
        return Biomes.field_201939_S;
    }

    @Override
    public Biome[] func_201535_a(int n, int n2, int n3, int n4) {
        return this.func_201539_b(n, n2, n3, n4);
    }

    @Override
    public Biome[] func_201537_a(int n, int n2, int n3, int n4, boolean bl) {
        Biome[] biomeArray = new Biome[n3 * n4];
        Long2ObjectOpenHashMap \u26032 = new Long2ObjectOpenHashMap();
        for (int i = 0; i < n3; ++i) {
            for (\u2603 = 0; \u2603 < n4; ++\u2603) {
                \u2603 = i + n >> 4;
                \u2603 = \u2603 + n2 >> 4;
                long l = ChunkPos.func_77272_a(\u2603, \u2603);
                Biome \u26033 = (Biome)\u26032.get(l);
                if (\u26033 == null) {
                    \u26033 = this.func_201545_a(\u2603, \u2603);
                    \u26032.put(l, (Object)\u26033);
                }
                biomeArray[i + \u2603 * n3] = \u26033;
            }
        }
        return biomeArray;
    }

    @Override
    public Set<Biome> func_201538_a(int n, int n2, int n3) {
        \u2603 = n - n3 >> 2;
        \u2603 = n2 - n3 >> 2;
        \u2603 = n + n3 >> 2;
        \u2603 = n2 + n3 >> 2;
        \u2603 = \u2603 - \u2603 + 1;
        \u2603 = \u2603 - \u2603 + 1;
        return Sets.newHashSet((Object[])this.func_201539_b(\u2603, \u2603, \u2603, \u2603));
    }

    @Override
    @Nullable
    public BlockPos func_180630_a(int n, int n2, int n3, List<Biome> list, Random random) {
        int n4 = n - n3 >> 2;
        \u2603 = n2 - n3 >> 2;
        \u2603 = n + n3 >> 2;
        \u2603 = n2 + n3 >> 2;
        \u2603 = \u2603 - n4 + 1;
        \u2603 = \u2603 - \u2603 + 1;
        Biome[] \u26032 = this.func_201539_b(n4, \u2603, \u2603, \u2603);
        BlockPos \u26033 = null;
        \u2603 = 0;
        for (\u2603 = 0; \u2603 < \u2603 * \u2603; ++\u2603) {
            \u2603 = n4 + \u2603 % \u2603 << 2;
            \u2603 = \u2603 + \u2603 / \u2603 << 2;
            if (!list.contains(\u26032[\u2603])) continue;
            if (\u26033 == null || random.nextInt(\u2603 + 1) == 0) {
                \u26033 = new BlockPos(\u2603, 0, \u2603);
            }
            ++\u2603;
        }
        return \u26033;
    }

    @Override
    public float func_201536_c(int n, int n2, int n3, int n4) {
        float \u26036;
        float \u26033 = n * 2 + n3;
        \u26034 = n2 * 2 + n4;
        \u26036 = 100.0f - MathHelper.func_76129_c(\u26033 * \u26033 + \u26034 * \u26034) * 8.0f;
        \u26036 = MathHelper.func_76131_a(\u26036, -100.0f, 80.0f);
        for (int i = -12; i <= 12; ++i) {
            for (\u2603 = -12; \u2603 <= 12; ++\u2603) {
                long l = n + i;
                \u2603 = n2 + \u2603;
                if (l * l + \u2603 * \u2603 <= 4096L || !(this.field_201546_a.func_151605_a(l, \u2603) < (double)-0.9f)) continue;
                float \u26032 = (MathHelper.func_76135_e(l) * 3439.0f + MathHelper.func_76135_e(\u2603) * 147.0f) % 13.0f + 9.0f;
                \u26033 = n3 - i * 2;
                float \u26034 = n4 - \u2603 * 2;
                float \u26035 = 100.0f - MathHelper.func_76129_c(\u26033 * \u26033 + \u26034 * \u26034) * \u26032;
                \u26035 = MathHelper.func_76131_a(\u26035, -100.0f, 80.0f);
                \u26036 = Math.max(\u26036, \u26035);
            }
        }
        return \u26036;
    }

    @Override
    public boolean func_205004_a(Structure<?> structure2) {
        return this.field_205005_a.computeIfAbsent(structure2, structure -> {
            for (Biome biome : this.field_205009_d) {
                if (!biome.func_201858_a(structure)) continue;
                return true;
            }
            return false;
        });
    }

    @Override
    public Set<IBlockState> func_205706_b() {
        if (this.field_205707_b.isEmpty()) {
            for (Biome biome : this.field_205009_d) {
                this.field_205707_b.add(biome.func_203944_q().func_204108_a());
            }
        }
        return this.field_205707_b;
    }
}

