/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BitArray;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.chunk.BlockStatePaletteHashMap;
import net.minecraft.world.chunk.BlockStatePaletteLinear;
import net.minecraft.world.chunk.IBlockStatePalette;
import net.minecraft.world.chunk.IBlockStatePaletteResizer;

public class BlockStateContainer<T>
implements IBlockStatePaletteResizer<T> {
    private final IBlockStatePalette<T> field_205521_b;
    private final IBlockStatePaletteResizer<T> field_205522_c = (n, object) -> 0;
    private final ObjectIntIdentityMap<T> field_205523_d;
    private final Function<NBTTagCompound, T> field_205524_e;
    private final Function<T, NBTTagCompound> field_205525_f;
    private final T field_205526_g;
    protected BitArray field_186021_b;
    private IBlockStatePalette<T> field_186022_c;
    private int field_186024_e;
    private final ReentrantLock field_210461_j = new ReentrantLock();

    private void func_210459_b() {
        if (this.field_210461_j.isLocked() && !this.field_210461_j.isHeldByCurrentThread()) {
            String string = Thread.getAllStackTraces().keySet().stream().filter(Objects::nonNull).map(thread -> thread.getName() + ": \n\tat " + Arrays.stream(thread.getStackTrace()).map(Object::toString).collect(Collectors.joining("\n\tat "))).collect(Collectors.joining("\n"));
            CrashReport \u26032 = new CrashReport("Writing into PalettedContainer from multiple threads", new IllegalStateException());
            CrashReportCategory \u26033 = \u26032.func_85058_a("Thread dumps");
            \u26033.func_71507_a("Thread dumps", string);
            throw new ReportedException(\u26032);
        }
        this.field_210461_j.lock();
    }

    private void func_210460_c() {
        this.field_210461_j.unlock();
    }

    public BlockStateContainer(IBlockStatePalette<T> iBlockStatePalette, ObjectIntIdentityMap<T> objectIntIdentityMap, Function<NBTTagCompound, T> function, Function<T, NBTTagCompound> function2, T t) {
        this.field_205521_b = iBlockStatePalette;
        this.field_205523_d = objectIntIdentityMap;
        this.field_205524_e = function;
        this.field_205525_f = function2;
        this.field_205526_g = t;
        this.func_186012_b(4);
    }

    private static int func_186011_b(int n, int n2, int n3) {
        return n2 << 8 | n3 << 4 | n;
    }

    private void func_186012_b(int n) {
        if (n == this.field_186024_e) {
            return;
        }
        this.field_186024_e = n;
        if (this.field_186024_e <= 4) {
            this.field_186024_e = 4;
            this.field_186022_c = new BlockStatePaletteLinear<T>(this.field_205523_d, this.field_186024_e, this, this.field_205524_e);
        } else if (this.field_186024_e < 9) {
            this.field_186022_c = new BlockStatePaletteHashMap<T>(this.field_205523_d, this.field_186024_e, this, this.field_205524_e, this.field_205525_f);
        } else {
            this.field_186022_c = this.field_205521_b;
            this.field_186024_e = MathHelper.func_151241_e(this.field_205523_d.func_186804_a());
        }
        this.field_186022_c.func_186041_a(this.field_205526_g);
        this.field_186021_b = new BitArray(this.field_186024_e, 4096);
    }

    @Override
    public int onResize(int n, T t2) {
        T t2;
        int \u26033;
        this.func_210459_b();
        BitArray bitArray = this.field_186021_b;
        IBlockStatePalette<T> \u26032 = this.field_186022_c;
        this.func_186012_b(n);
        for (\u26033 = 0; \u26033 < bitArray.func_188144_b(); ++\u26033) {
            T t3 = \u26032.func_186039_a(bitArray.func_188142_a(\u26033));
            if (t3 == null) continue;
            this.func_186014_b(\u26033, t3);
        }
        \u26033 = this.field_186022_c.func_186041_a(t2);
        this.func_210460_c();
        return \u26033;
    }

    public void func_186013_a(int n, int n2, int n3, T t) {
        this.func_210459_b();
        this.func_186014_b(BlockStateContainer.func_186011_b(n, n2, n3), t);
        this.func_210460_c();
    }

    protected void func_186014_b(int n, T t) {
        int n2 = this.field_186022_c.func_186041_a(t);
        this.field_186021_b.func_188141_a(n, n2);
    }

    public T func_186016_a(int n, int n2, int n3) {
        return this.func_186015_a(BlockStateContainer.func_186011_b(n, n2, n3));
    }

    protected T func_186015_a(int n) {
        T t = this.field_186022_c.func_186039_a(this.field_186021_b.func_188142_a(n));
        return t == null ? this.field_205526_g : t;
    }

    public void func_186010_a(PacketBuffer packetBuffer) {
        this.func_210459_b();
        byte by = packetBuffer.readByte();
        if (this.field_186024_e != by) {
            this.func_186012_b(by);
        }
        this.field_186022_c.func_186038_a(packetBuffer);
        packetBuffer.func_186873_b(this.field_186021_b.func_188143_a());
        this.func_210460_c();
    }

    public void func_186009_b(PacketBuffer packetBuffer) {
        this.func_210459_b();
        packetBuffer.writeByte(this.field_186024_e);
        this.field_186022_c.func_186037_b(packetBuffer);
        packetBuffer.func_186865_a(this.field_186021_b.func_188143_a());
        this.func_210460_c();
    }

    public void func_196964_a(NBTTagCompound nBTTagCompound, String string, String string2) {
        this.func_210459_b();
        NBTTagList nBTTagList = nBTTagCompound.func_150295_c(string, 10);
        int \u26032 = Math.max(4, MathHelper.func_151241_e(nBTTagList.size()));
        if (\u26032 != this.field_186024_e) {
            this.func_186012_b(\u26032);
        }
        this.field_186022_c.func_196968_a(nBTTagList);
        long[] \u26033 = nBTTagCompound.func_197645_o(string2);
        int \u26034 = \u26033.length * 64 / 4096;
        if (this.field_186022_c == this.field_205521_b) {
            BlockStatePaletteHashMap<T> blockStatePaletteHashMap = new BlockStatePaletteHashMap<T>(this.field_205523_d, \u26032, this.field_205522_c, this.field_205524_e, this.field_205525_f);
            blockStatePaletteHashMap.func_196968_a(nBTTagList);
            BitArray \u26035 = new BitArray(\u26032, 4096, \u26033);
            for (int i = 0; i < 4096; ++i) {
                this.field_186021_b.func_188141_a(i, this.field_205521_b.func_186041_a(blockStatePaletteHashMap.func_186039_a(\u26035.func_188142_a(i))));
            }
        } else if (\u26034 == this.field_186024_e) {
            System.arraycopy(\u26033, 0, this.field_186021_b.func_188143_a(), 0, \u26033.length);
        } else {
            BitArray bitArray = new BitArray(\u26034, 4096, \u26033);
            for (int i = 0; i < 4096; ++i) {
                this.field_186021_b.func_188141_a(i, bitArray.func_188142_a(i));
            }
        }
        this.func_210460_c();
    }

    public void func_196963_b(NBTTagCompound nBTTagCompound2, String string, String string2) {
        NBTTagCompound nBTTagCompound2;
        this.func_210459_b();
        BlockStatePaletteHashMap<T> blockStatePaletteHashMap = new BlockStatePaletteHashMap<T>(this.field_205523_d, this.field_186024_e, this.field_205522_c, this.field_205524_e, this.field_205525_f);
        blockStatePaletteHashMap.func_186041_a(this.field_205526_g);
        int[] \u26032 = new int[4096];
        for (int i = 0; i < 4096; ++i) {
            \u26032[i] = blockStatePaletteHashMap.func_186041_a(this.func_186015_a(i));
        }
        NBTTagList nBTTagList = new NBTTagList();
        blockStatePaletteHashMap.func_196969_b(nBTTagList);
        nBTTagCompound2.func_74782_a(string, nBTTagList);
        int \u26033 = Math.max(4, MathHelper.func_151241_e(nBTTagList.size()));
        BitArray \u26034 = new BitArray(\u26033, 4096);
        for (int i = 0; i < \u26032.length; ++i) {
            \u26034.func_188141_a(i, \u26032[i]);
        }
        nBTTagCompound2.func_197644_a(string2, \u26034.func_188143_a());
        this.func_210460_c();
    }

    public int func_186018_a() {
        return 1 + this.field_186022_c.func_186040_a() + PacketBuffer.func_150790_a(this.field_186021_b.func_188144_b()) + this.field_186021_b.func_188143_a().length * 8;
    }
}

