/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk;

import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Fluids;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.EmptyTickList;
import net.minecraft.world.EnumLightType;
import net.minecraft.world.ITickList;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkPrimerTickList;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.UpgradeData;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.gen.ChunkGeneratorDebug;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructureStart;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Chunk
implements IChunk {
    private static final Logger field_150817_t = LogManager.getLogger();
    public static final ChunkSection field_186036_a = null;
    private final ChunkSection[] field_76652_q = new ChunkSection[16];
    private final Biome[] field_76651_r;
    private final boolean[] field_76639_c = new boolean[256];
    private final Map<BlockPos, NBTTagCompound> field_201618_i = Maps.newHashMap();
    private boolean field_76636_d;
    private final World field_76637_e;
    private final Map<Heightmap.Type, Heightmap> field_76634_f = Maps.newEnumMap(Heightmap.Type.class);
    public final int field_76635_g;
    public final int field_76647_h;
    private boolean field_76650_s;
    private final UpgradeData field_196967_n;
    private final Map<BlockPos, TileEntity> field_150816_i = Maps.newHashMap();
    private final ClassInheritanceMultiMap<Entity>[] field_76645_j;
    private final Map<String, StructureStart> field_201619_q = Maps.newHashMap();
    private final Map<String, LongSet> field_201620_r = Maps.newHashMap();
    private final ShortList[] field_201622_t = new ShortList[16];
    private final ITickList<Block> field_201621_s;
    private final ITickList<Fluid> field_205325_u;
    private boolean field_150815_m;
    private boolean field_76644_m;
    private long field_76641_n;
    private boolean field_76643_l;
    private int field_82912_p;
    private long field_111204_q;
    private int field_76649_t = 4096;
    private final ConcurrentLinkedQueue<BlockPos> field_177447_w = Queues.newConcurrentLinkedQueue();
    private ChunkStatus field_201616_C = ChunkStatus.EMPTY;
    private int field_201617_D;
    private final AtomicInteger field_205757_F = new AtomicInteger();
    private final ChunkPos field_212816_F;

    public Chunk(World world, int n, int n2, Biome[] biomeArray) {
        this(world, n, n2, biomeArray, UpgradeData.field_196994_a, EmptyTickList.func_205388_a(), EmptyTickList.func_205388_a(), 0L);
    }

    public Chunk(World world, int n, int n2, Biome[] biomeArray2, UpgradeData upgradeData, ITickList<Block> iTickList, ITickList<Fluid> iTickList2, long l) {
        Biome[] biomeArray2;
        this.field_76645_j = new ClassInheritanceMultiMap[16];
        this.field_76637_e = world;
        this.field_76635_g = n;
        this.field_76647_h = n2;
        this.field_212816_F = new ChunkPos(n, n2);
        this.field_196967_n = upgradeData;
        for (Heightmap.Type type : Heightmap.Type.values()) {
            if (type.func_207512_c() != Heightmap.Usage.LIVE_WORLD) continue;
            this.field_76634_f.put(type, new Heightmap(this, type));
        }
        for (int i = 0; i < this.field_76645_j.length; ++i) {
            this.field_76645_j[i] = new ClassInheritanceMultiMap<Entity>(Entity.class);
        }
        this.field_76651_r = biomeArray2;
        this.field_201621_s = iTickList;
        this.field_205325_u = iTickList2;
        this.field_111204_q = l;
    }

    public Chunk(World world, ChunkPrimer chunkPrimer2, int n, int n2) {
        this(world, n, n2, chunkPrimer2.func_201590_e(), chunkPrimer2.func_201631_p(), chunkPrimer2.func_205218_i_(), chunkPrimer2.func_212247_j(), chunkPrimer2.func_209216_m());
        for (int i = 0; i < this.field_76652_q.length; ++i) {
            this.field_76652_q[i] = chunkPrimer2.func_76587_i()[i];
        }
        for (NBTTagCompound nBTTagCompound : chunkPrimer2.func_201652_l()) {
            AnvilChunkLoader.func_186050_a(nBTTagCompound, world, this);
        }
        for (TileEntity tileEntity : chunkPrimer2.func_201627_k().values()) {
            this.func_150813_a(tileEntity);
        }
        this.field_201618_i.putAll(chunkPrimer2.func_201632_q());
        for (int \u26033 = 0; \u26033 < chunkPrimer2.func_201645_n().length; ++\u26033) {
            this.field_201622_t[\u26033] = chunkPrimer2.func_201645_n()[\u26033];
        }
        this.func_201612_a(chunkPrimer2.func_201609_c());
        this.func_201606_b(chunkPrimer2.func_201604_d());
        for (Heightmap.Type type2 : chunkPrimer2.func_201634_m()) {
            if (type2.func_207512_c() != Heightmap.Usage.LIVE_WORLD) continue;
            this.field_76634_f.computeIfAbsent(type2, type -> new Heightmap(this, (Heightmap.Type)((Object)((Object)type)))).func_202268_a(chunkPrimer2.func_201642_a(type2).func_202269_a());
        }
        this.field_76643_l = true;
        this.func_201574_a(ChunkStatus.FULLCHUNK);
    }

    public Set<BlockPos> func_203066_o() {
        HashSet hashSet = Sets.newHashSet(this.field_201618_i.keySet());
        hashSet.addAll(this.field_150816_i.keySet());
        return hashSet;
    }

    public boolean func_76600_a(int n, int n2) {
        return n == this.field_76635_g && n2 == this.field_76647_h;
    }

    @Override
    public ChunkSection[] func_76587_i() {
        return this.field_76652_q;
    }

    protected void func_76590_a() {
        for (Heightmap heightmap : this.field_76634_f.values()) {
            heightmap.func_202266_a();
        }
        this.field_76643_l = true;
    }

    public void func_76603_b() {
        int n = this.func_76625_h();
        this.field_82912_p = Integer.MAX_VALUE;
        for (Heightmap heightmap : this.field_76634_f.values()) {
            heightmap.func_202266_a();
        }
        for (int i = 0; i < 16; ++i) {
            for (\u2603 = 0; \u2603 < 16; ++\u2603) {
                if (!this.field_76637_e.field_73011_w.func_191066_m()) continue;
                \u2603 = 15;
                \u2603 = n + 16 - 1;
                do {
                    if ((\u2603 = this.func_150808_b(i, \u2603, \u2603)) == 0 && \u2603 != 15) {
                        \u2603 = 1;
                    }
                    if ((\u2603 -= \u2603) <= 0 || (\u2603 = this.field_76652_q[\u2603 >> 4]) == field_186036_a) continue;
                    \u2603.func_76657_c(i, \u2603 & 0xF, \u2603, \u2603);
                    this.field_76637_e.func_175679_n(new BlockPos((this.field_76635_g << 4) + i, \u2603, (this.field_76647_h << 4) + \u2603));
                } while (--\u2603 > 0 && \u2603 > 0);
            }
        }
        this.field_76643_l = true;
    }

    private void func_76595_e(int n, int n2) {
        this.field_76639_c[n + n2 * 16] = true;
        this.field_76650_s = true;
    }

    private void func_150803_c(boolean bl2) {
        this.field_76637_e.field_72984_F.func_76320_a("recheckGaps");
        if (this.field_76637_e.func_205050_e(new BlockPos(this.field_76635_g * 16 + 8, 0, this.field_76647_h * 16 + 8), 16)) {
            for (int i = 0; i < 16; ++i) {
                for (\u2603 = 0; \u2603 < 16; ++\u2603) {
                    boolean bl2;
                    int n;
                    if (!this.field_76639_c[i + \u2603 * 16]) continue;
                    this.field_76639_c[i + \u2603 * 16] = false;
                    \u2603 = this.func_201576_a(Heightmap.Type.LIGHT_BLOCKING, i, \u2603);
                    n = this.field_76635_g * 16 + i;
                    \u2603 = this.field_76647_h * 16 + \u2603;
                    n2 = Integer.MAX_VALUE;
                    for (EnumFacing enumFacing : EnumFacing.Plane.HORIZONTAL) {
                        int n2 = Math.min(n2, this.field_76637_e.func_82734_g(n + enumFacing.func_82601_c(), \u2603 + enumFacing.func_82599_e()));
                    }
                    this.func_76599_g(n, \u2603, n2);
                    for (EnumFacing enumFacing : EnumFacing.Plane.HORIZONTAL) {
                        this.func_76599_g(n + enumFacing.func_82601_c(), \u2603 + enumFacing.func_82599_e(), \u2603);
                    }
                    if (!bl2) continue;
                    this.field_76637_e.field_72984_F.func_76319_b();
                    return;
                }
            }
            this.field_76650_s = false;
        }
        this.field_76637_e.field_72984_F.func_76319_b();
    }

    private void func_76599_g(int n, int n2, int n3) {
        \u2603 = this.field_76637_e.func_205770_a(Heightmap.Type.MOTION_BLOCKING, new BlockPos(n, 0, n2)).func_177956_o();
        if (\u2603 > n3) {
            this.func_76609_d(n, n2, n3, \u2603 + 1);
        } else if (\u2603 < n3) {
            this.func_76609_d(n, n2, \u2603, n3 + 1);
        }
    }

    private void func_76609_d(int n, int n2, int n3, int n4) {
        if (n4 > n3 && this.field_76637_e.func_205050_e(new BlockPos(n, 0, n2), 16)) {
            for (\u2603 = n3; \u2603 < n4; ++\u2603) {
                this.field_76637_e.func_180500_c(EnumLightType.SKY, new BlockPos(n, \u2603, n2));
            }
            this.field_76643_l = true;
        }
    }

    private void func_76615_h(int n, int n2, int n3, IBlockState iBlockState) {
        int \u26036;
        Heightmap heightmap = this.field_76634_f.get((Object)Heightmap.Type.LIGHT_BLOCKING);
        int \u26032 = heightmap.func_202273_a(n & 0xF, n3 & 0xF) & 0xFF;
        if (!heightmap.func_202270_a(n, n2, n3, iBlockState)) {
            return;
        }
        int \u26033 = heightmap.func_202273_a(n & 0xF, n3 & 0xF);
        int \u26034 = this.field_76635_g * 16 + n;
        int \u26035 = this.field_76647_h * 16 + n3;
        this.field_76637_e.func_72975_g(\u26034, \u26035, \u26033, \u26032);
        if (this.field_76637_e.field_73011_w.func_191066_m()) {
            \u26036 = Math.min(\u26032, \u26033);
            \u26037 = Math.max(\u26032, \u26033);
            \u26038 = \u26033 < \u26032 ? 15 : 0;
            for (n4 = \u26036; n4 < \u26037; ++n4) {
                ChunkSection chunkSection = this.field_76652_q[n4 >> 4];
                if (chunkSection == field_186036_a) continue;
                chunkSection.func_76657_c(n, n4 & 0xF, n3, \u26038);
                this.field_76637_e.func_175679_n(new BlockPos((this.field_76635_g << 4) + n, n4, (this.field_76647_h << 4) + n3));
            }
            int n4 = 15;
            while (\u26033 > 0 && n4 > 0) {
                \u2603 = (\u2603 = this.func_150808_b(n, --\u26033, n3)) == 0 ? 1 : \u2603;
                n4 -= \u2603;
                n4 = Math.max(0, n4);
                ChunkSection chunkSection = this.field_76652_q[\u26033 >> 4];
                if (chunkSection == field_186036_a) continue;
                chunkSection.func_76657_c(n, \u26033 & 0xF, n3, n4);
            }
        }
        if (\u26033 < this.field_82912_p) {
            this.field_82912_p = \u26033;
        }
        if (this.field_76637_e.field_73011_w.func_191066_m()) {
            \u26036 = heightmap.func_202273_a(n & 0xF, n3 & 0xF);
            int \u26037 = Math.min(\u26032, \u26036);
            int \u26038 = Math.max(\u26032, \u26036);
            for (EnumFacing enumFacing : EnumFacing.Plane.HORIZONTAL) {
                this.func_76609_d(\u26034 + enumFacing.func_82601_c(), \u26035 + enumFacing.func_82599_e(), \u26037, \u26038);
            }
            this.func_76609_d(\u26034, \u26035, \u26037, \u26038);
        }
        this.field_76643_l = true;
    }

    private int func_150808_b(int n, int n2, int n3) {
        return this.func_186032_a(n, n2, n3).func_200016_a(this.field_76637_e, new BlockPos(n, n2, n3));
    }

    @Override
    public IBlockState func_180495_p(BlockPos blockPos) {
        return this.func_186032_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
    }

    public IBlockState func_186032_a(int n, int n22, int n3) {
        if (this.field_76637_e.func_175624_G() == WorldType.field_180272_g) {
            IBlockState iBlockState = null;
            if (n22 == 60) {
                iBlockState = Blocks.field_180401_cv.func_176223_P();
            }
            if (n22 == 70) {
                iBlockState = ChunkGeneratorDebug.func_177461_b(n, n3);
            }
            return iBlockState == null ? Blocks.field_150350_a.func_176223_P() : iBlockState;
        }
        try {
            int n22;
            if (n22 >= 0 && n22 >> 4 < this.field_76652_q.length && (\u2603 = this.field_76652_q[n22 >> 4]) != field_186036_a) {
                return \u2603.func_177485_a(n & 0xF, n22 & 0xF, n3 & 0xF);
            }
            return Blocks.field_150350_a.func_176223_P();
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Getting block state");
            CrashReportCategory \u26032 = crashReport.func_85058_a("Block being got");
            \u26032.func_189529_a("Location", () -> CrashReportCategory.func_184876_a(n, n22, n3));
            throw new ReportedException(crashReport);
        }
    }

    @Override
    public IFluidState func_204610_c(BlockPos blockPos) {
        return this.func_205751_b(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
    }

    public IFluidState func_205751_b(int n, int n2, int n3) {
        try {
            if (n2 >= 0 && n2 >> 4 < this.field_76652_q.length && (\u2603 = this.field_76652_q[n2 >> 4]) != field_186036_a) {
                return \u2603.func_206914_b(n & 0xF, n2 & 0xF, n3 & 0xF);
            }
            return Fluids.field_204541_a.func_207188_f();
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Getting fluid state");
            CrashReportCategory \u26032 = crashReport.func_85058_a("Block being got");
            \u26032.func_189529_a("Location", () -> CrashReportCategory.func_184876_a(n, n2, n3));
            throw new ReportedException(crashReport);
        }
    }

    @Override
    @Nullable
    public IBlockState func_177436_a(BlockPos blockPos, IBlockState iBlockState, boolean bl) {
        int n = blockPos.func_177958_n() & 0xF;
        \u2603 = blockPos.func_177956_o();
        \u2603 = blockPos.func_177952_p() & 0xF;
        \u2603 = this.field_76634_f.get((Object)Heightmap.Type.LIGHT_BLOCKING).func_202273_a(n, \u2603);
        IBlockState \u26032 = this.func_180495_p(blockPos);
        if (\u26032 == iBlockState) {
            return null;
        }
        Block \u26033 = iBlockState.func_177230_c();
        Block \u26034 = \u26032.func_177230_c();
        ChunkSection \u26035 = this.field_76652_q[\u2603 >> 4];
        boolean \u26036 = false;
        if (\u26035 == field_186036_a) {
            if (iBlockState.func_196958_f()) {
                return null;
            }
            this.field_76652_q[\u2603 >> 4] = \u26035 = new ChunkSection(\u2603 >> 4 << 4, this.field_76637_e.field_73011_w.func_191066_m());
            \u26036 = \u2603 >= \u2603;
        }
        \u26035.func_177484_a(n, \u2603 & 0xF, \u2603, iBlockState);
        this.field_76634_f.get((Object)Heightmap.Type.MOTION_BLOCKING).func_202270_a(n, \u2603, \u2603, iBlockState);
        this.field_76634_f.get((Object)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES).func_202270_a(n, \u2603, \u2603, iBlockState);
        this.field_76634_f.get((Object)Heightmap.Type.OCEAN_FLOOR).func_202270_a(n, \u2603, \u2603, iBlockState);
        this.field_76634_f.get((Object)Heightmap.Type.WORLD_SURFACE).func_202270_a(n, \u2603, \u2603, iBlockState);
        if (!this.field_76637_e.field_72995_K) {
            \u26032.func_196947_b(this.field_76637_e, blockPos, iBlockState, bl);
        } else if (\u26034 != \u26033 && \u26034 instanceof ITileEntityProvider) {
            this.field_76637_e.func_175713_t(blockPos);
        }
        if (\u26035.func_177485_a(n, \u2603 & 0xF, \u2603).func_177230_c() != \u26033) {
            return null;
        }
        if (\u26036) {
            this.func_76603_b();
        } else {
            \u2603 = iBlockState.func_200016_a(this.field_76637_e, blockPos);
            \u2603 = \u26032.func_200016_a(this.field_76637_e, blockPos);
            this.func_76615_h(n, \u2603, \u2603, iBlockState);
            if (\u2603 != \u2603 && (\u2603 < \u2603 || this.func_177413_a(EnumLightType.SKY, blockPos) > 0 || this.func_177413_a(EnumLightType.BLOCK, blockPos) > 0)) {
                this.func_76595_e(n, \u2603);
            }
        }
        if (\u26034 instanceof ITileEntityProvider && (\u2603 = this.func_177424_a(blockPos, EnumCreateEntityType.CHECK)) != null) {
            \u2603.func_145836_u();
        }
        if (!this.field_76637_e.field_72995_K) {
            iBlockState.func_196945_a(this.field_76637_e, blockPos, \u26032);
        }
        if (\u26033 instanceof ITileEntityProvider) {
            TileEntity tileEntity = this.func_177424_a(blockPos, EnumCreateEntityType.CHECK);
            if (tileEntity == null) {
                tileEntity = ((ITileEntityProvider)((Object)\u26033)).func_196283_a_(this.field_76637_e);
                this.field_76637_e.func_175690_a(blockPos, tileEntity);
            } else {
                tileEntity.func_145836_u();
            }
        }
        this.field_76643_l = true;
        return \u26032;
    }

    public int func_177413_a(EnumLightType enumLightType, BlockPos blockPos) {
        return this.func_201587_a(enumLightType, blockPos, this.field_76637_e.func_201675_m().func_191066_m());
    }

    @Override
    public int func_201587_a(EnumLightType enumLightType, BlockPos blockPos, boolean bl) {
        int n = blockPos.func_177958_n() & 0xF;
        \u2603 = blockPos.func_177956_o();
        \u2603 = blockPos.func_177952_p() & 0xF;
        \u2603 = \u2603 >> 4;
        if (\u2603 < 0 || \u2603 > this.field_76652_q.length - 1) {
            if (enumLightType == EnumLightType.SKY && bl || enumLightType == EnumLightType.BLOCK) {
                return enumLightType.field_77198_c;
            }
            return 0;
        }
        ChunkSection \u26032 = this.field_76652_q[\u2603];
        if (\u26032 == field_186036_a) {
            if (this.func_177444_d(blockPos)) {
                return enumLightType.field_77198_c;
            }
            return 0;
        }
        if (enumLightType == EnumLightType.SKY) {
            if (!bl) {
                return 0;
            }
            return \u26032.func_76670_c(n, \u2603 & 0xF, \u2603);
        }
        if (enumLightType == EnumLightType.BLOCK) {
            return \u26032.func_76674_d(n, \u2603 & 0xF, \u2603);
        }
        return enumLightType.field_77198_c;
    }

    public void func_177431_a(EnumLightType enumLightType, BlockPos blockPos, int n) {
        this.func_201580_a(enumLightType, this.field_76637_e.func_201675_m().func_191066_m(), blockPos, n);
    }

    @Override
    public void func_201580_a(EnumLightType enumLightType, boolean bl, BlockPos blockPos, int n) {
        \u2603 = blockPos.func_177958_n() & 0xF;
        \u2603 = blockPos.func_177956_o();
        \u2603 = blockPos.func_177952_p() & 0xF;
        \u2603 = \u2603 >> 4;
        if (\u2603 >= 16 || \u2603 < 0) {
            return;
        }
        ChunkSection chunkSection = this.field_76652_q[\u2603];
        if (chunkSection == field_186036_a) {
            if (n == enumLightType.field_77198_c) {
                return;
            }
            this.field_76652_q[\u2603] = chunkSection = new ChunkSection(\u2603 << 4, bl);
            this.func_76603_b();
        }
        if (enumLightType == EnumLightType.SKY) {
            if (this.field_76637_e.field_73011_w.func_191066_m()) {
                chunkSection.func_76657_c(\u2603, \u2603 & 0xF, \u2603, n);
            }
        } else if (enumLightType == EnumLightType.BLOCK) {
            chunkSection.func_76677_d(\u2603, \u2603 & 0xF, \u2603, n);
        }
        this.field_76643_l = true;
    }

    public int func_177443_a(BlockPos blockPos, int n) {
        return this.func_201586_a(blockPos, n, this.field_76637_e.func_201675_m().func_191066_m());
    }

    @Override
    public int func_201586_a(BlockPos blockPos, int n, boolean bl) {
        int n2 = blockPos.func_177958_n() & 0xF;
        \u2603 = blockPos.func_177956_o();
        \u2603 = blockPos.func_177952_p() & 0xF;
        \u2603 = \u2603 >> 4;
        if (\u2603 < 0 || \u2603 > this.field_76652_q.length - 1) {
            return 0;
        }
        ChunkSection \u26032 = this.field_76652_q[\u2603];
        if (\u26032 == field_186036_a) {
            if (bl && n < EnumLightType.SKY.field_77198_c) {
                return EnumLightType.SKY.field_77198_c - n;
            }
            return 0;
        }
        \u2603 = bl ? \u26032.func_76670_c(n2, \u2603 & 0xF, \u2603) : 0;
        \u2603 = \u26032.func_76674_d(n2, \u2603 & 0xF, \u2603);
        if (\u2603 > (\u2603 -= n)) {
            \u2603 = \u2603;
        }
        return \u2603;
    }

    @Override
    public void func_76612_a(Entity entity) {
        this.field_76644_m = true;
        int n = MathHelper.func_76128_c(entity.field_70165_t / 16.0);
        \u2603 = MathHelper.func_76128_c(entity.field_70161_v / 16.0);
        if (n != this.field_76635_g || \u2603 != this.field_76647_h) {
            field_150817_t.warn("Wrong location! ({}, {}) should be ({}, {}), {}", (Object)n, (Object)\u2603, (Object)this.field_76635_g, (Object)this.field_76647_h, (Object)entity);
            entity.func_70106_y();
        }
        if ((\u2603 = MathHelper.func_76128_c(entity.field_70163_u / 16.0)) < 0) {
            \u2603 = 0;
        }
        if (\u2603 >= this.field_76645_j.length) {
            \u2603 = this.field_76645_j.length - 1;
        }
        entity.field_70175_ag = true;
        entity.field_70176_ah = this.field_76635_g;
        entity.field_70162_ai = \u2603;
        entity.field_70164_aj = this.field_76647_h;
        this.field_76645_j[\u2603].add(entity);
    }

    public void func_201607_a(Heightmap.Type type, long[] lArray) {
        this.field_76634_f.get((Object)type).func_202268_a(lArray);
    }

    public void func_76622_b(Entity entity) {
        this.func_76608_a(entity, entity.field_70162_ai);
    }

    public void func_76608_a(Entity entity, int n) {
        if (n < 0) {
            n = 0;
        }
        if (n >= this.field_76645_j.length) {
            n = this.field_76645_j.length - 1;
        }
        this.field_76645_j[n].remove(entity);
    }

    @Override
    public boolean func_177444_d(BlockPos blockPos) {
        int n = blockPos.func_177958_n() & 0xF;
        \u2603 = blockPos.func_177956_o();
        \u2603 = blockPos.func_177952_p() & 0xF;
        return \u2603 >= this.field_76634_f.get((Object)Heightmap.Type.LIGHT_BLOCKING).func_202273_a(n, \u2603);
    }

    @Override
    public int func_201576_a(Heightmap.Type type, int n, int n2) {
        return this.field_76634_f.get((Object)type).func_202273_a(n & 0xF, n2 & 0xF) - 1;
    }

    @Nullable
    private TileEntity func_177422_i(BlockPos blockPos) {
        IBlockState iBlockState = this.func_180495_p(blockPos);
        Block \u26032 = iBlockState.func_177230_c();
        if (!\u26032.func_149716_u()) {
            return null;
        }
        return ((ITileEntityProvider)((Object)\u26032)).func_196283_a_(this.field_76637_e);
    }

    @Override
    @Nullable
    public TileEntity func_175625_s(BlockPos blockPos) {
        return this.func_177424_a(blockPos, EnumCreateEntityType.CHECK);
    }

    @Nullable
    public TileEntity func_177424_a(BlockPos blockPos, EnumCreateEntityType enumCreateEntityType) {
        TileEntity tileEntity = this.field_150816_i.get(blockPos);
        if (tileEntity == null && (\u2603 = this.field_201618_i.remove(blockPos)) != null && (\u2603 = this.func_212815_a(blockPos, \u2603)) != null) {
            return \u2603;
        }
        if (tileEntity == null) {
            if (enumCreateEntityType == EnumCreateEntityType.IMMEDIATE) {
                tileEntity = this.func_177422_i(blockPos);
                this.field_76637_e.func_175690_a(blockPos, tileEntity);
            } else if (enumCreateEntityType == EnumCreateEntityType.QUEUED) {
                this.field_177447_w.add(blockPos);
            }
        } else if (tileEntity.func_145837_r()) {
            this.field_150816_i.remove(blockPos);
            return null;
        }
        return tileEntity;
    }

    public void func_150813_a(TileEntity tileEntity) {
        this.func_177426_a(tileEntity.func_174877_v(), tileEntity);
        if (this.field_76636_d) {
            this.field_76637_e.func_175700_a(tileEntity);
        }
    }

    @Override
    public void func_177426_a(BlockPos blockPos, TileEntity tileEntity) {
        tileEntity.func_145834_a(this.field_76637_e);
        tileEntity.func_174878_a(blockPos);
        if (!(this.func_180495_p(blockPos).func_177230_c() instanceof ITileEntityProvider)) {
            return;
        }
        if (this.field_150816_i.containsKey(blockPos)) {
            this.field_150816_i.get(blockPos).func_145843_s();
        }
        tileEntity.func_145829_t();
        this.field_150816_i.put(blockPos.func_185334_h(), tileEntity);
    }

    @Override
    public void func_201591_a(NBTTagCompound nBTTagCompound) {
        this.field_201618_i.put(new BlockPos(nBTTagCompound.func_74762_e("x"), nBTTagCompound.func_74762_e("y"), nBTTagCompound.func_74762_e("z")), nBTTagCompound);
    }

    @Override
    public void func_177425_e(BlockPos blockPos) {
        if (this.field_76636_d && (\u2603 = this.field_150816_i.remove(blockPos)) != null) {
            \u2603.func_145843_s();
        }
    }

    public void func_76631_c() {
        this.field_76636_d = true;
        this.field_76637_e.func_147448_a(this.field_150816_i.values());
        for (ClassInheritanceMultiMap<Entity> classInheritanceMultiMap : this.field_76645_j) {
            this.field_76637_e.func_212420_a(classInheritanceMultiMap.stream().filter(entity -> !(entity instanceof EntityPlayer)));
        }
    }

    public void func_76623_d() {
        this.field_76636_d = false;
        for (TileEntity tileEntity : this.field_150816_i.values()) {
            this.field_76637_e.func_147457_a(tileEntity);
        }
        for (ClassInheritanceMultiMap<Entity> classInheritanceMultiMap : this.field_76645_j) {
            this.field_76637_e.func_175681_c(classInheritanceMultiMap);
        }
    }

    public void func_76630_e() {
        this.field_76643_l = true;
    }

    public void func_177414_a(@Nullable Entity entity, AxisAlignedBB axisAlignedBB, List<Entity> list, Predicate<? super Entity> predicate) {
        int n = MathHelper.func_76128_c((axisAlignedBB.field_72338_b - 2.0) / 16.0);
        \u2603 = MathHelper.func_76128_c((axisAlignedBB.field_72337_e + 2.0) / 16.0);
        n = MathHelper.func_76125_a(n, 0, this.field_76645_j.length - 1);
        \u2603 = MathHelper.func_76125_a(\u2603, 0, this.field_76645_j.length - 1);
        for (\u2603 = n; \u2603 <= \u2603; ++\u2603) {
            if (this.field_76645_j[\u2603].isEmpty()) continue;
            for (Entity entity2 : this.field_76645_j[\u2603]) {
                if (!entity2.func_174813_aQ().func_72326_a(axisAlignedBB) || entity2 == entity) continue;
                if (predicate == null || predicate.test(entity2)) {
                    list.add(entity2);
                }
                if ((\u2603 = entity2.func_70021_al()) == null) continue;
                for (Entity entity3 : \u2603) {
                    entity2 = entity3;
                    if (entity2 == entity || !entity2.func_174813_aQ().func_72326_a(axisAlignedBB) || predicate != null && !predicate.test(entity2)) continue;
                    list.add(entity2);
                }
            }
        }
    }

    public <T extends Entity> void func_177430_a(Class<? extends T> clazz, AxisAlignedBB axisAlignedBB, List<T> list, @Nullable Predicate<? super T> predicate) {
        int n = MathHelper.func_76128_c((axisAlignedBB.field_72338_b - 2.0) / 16.0);
        \u2603 = MathHelper.func_76128_c((axisAlignedBB.field_72337_e + 2.0) / 16.0);
        n = MathHelper.func_76125_a(n, 0, this.field_76645_j.length - 1);
        \u2603 = MathHelper.func_76125_a(\u2603, 0, this.field_76645_j.length - 1);
        for (\u2603 = n; \u2603 <= \u2603; ++\u2603) {
            for (Entity entity : this.field_76645_j[\u2603].func_180215_b(clazz)) {
                if (!entity.func_174813_aQ().func_72326_a(axisAlignedBB) || predicate != null && !predicate.test(entity)) continue;
                list.add(entity);
            }
        }
    }

    public boolean func_76601_a(boolean bl) {
        if (bl ? this.field_76644_m && this.field_76637_e.func_82737_E() != this.field_76641_n || this.field_76643_l : this.field_76644_m && this.field_76637_e.func_82737_E() >= this.field_76641_n + 600L) {
            return true;
        }
        return this.field_76643_l;
    }

    public boolean func_76621_g() {
        return false;
    }

    public void func_150804_b(boolean bl) {
        if (this.field_76650_s && this.field_76637_e.field_73011_w.func_191066_m() && !bl) {
            this.func_150803_c(this.field_76637_e.field_72995_K);
        }
        this.field_150815_m = true;
        while (!this.field_177447_w.isEmpty()) {
            BlockPos blockPos = this.field_177447_w.poll();
            if (this.func_177424_a(blockPos, EnumCreateEntityType.CHECK) != null || !this.func_180495_p(blockPos).func_177230_c().func_149716_u()) continue;
            TileEntity \u26032 = this.func_177422_i(blockPos);
            this.field_76637_e.func_175690_a(blockPos, \u26032);
            this.field_76637_e.func_175704_b(blockPos, blockPos);
        }
    }

    public boolean func_150802_k() {
        return this.field_201616_C.func_209003_a(ChunkStatus.POSTPROCESSED);
    }

    public boolean func_186035_j() {
        return this.field_150815_m;
    }

    @Override
    public ChunkPos func_76632_l() {
        return this.field_212816_F;
    }

    public boolean func_76606_c(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 >= 256) {
            n2 = 255;
        }
        for (\u2603 = n; \u2603 <= n2; \u2603 += 16) {
            ChunkSection chunkSection = this.field_76652_q[\u2603 >> 4];
            if (chunkSection == field_186036_a || chunkSection.func_76663_a()) continue;
            return false;
        }
        return true;
    }

    public void func_76602_a(ChunkSection[] chunkSectionArray) {
        if (this.field_76652_q.length != chunkSectionArray.length) {
            field_150817_t.warn("Could not set level chunk sections, array length is {} instead of {}", (Object)chunkSectionArray.length, (Object)this.field_76652_q.length);
            return;
        }
        System.arraycopy(chunkSectionArray, 0, this.field_76652_q, 0, this.field_76652_q.length);
    }

    public void func_186033_a(PacketBuffer packetBuffer, int n, boolean bl2) {
        boolean bl2;
        int n2;
        if (bl2) {
            this.field_150816_i.clear();
        } else {
            Iterator<BlockPos> iterator = this.field_150816_i.keySet().iterator();
            while (iterator.hasNext()) {
                BlockPos blockPos = iterator.next();
                int \u26032 = blockPos.func_177956_o() >> 4;
                if ((n & 1 << \u26032) == 0) continue;
                iterator.remove();
            }
        }
        boolean bl3 = this.field_76637_e.field_73011_w.func_191066_m();
        for (n2 = 0; n2 < this.field_76652_q.length; ++n2) {
            ChunkSection chunkSection = this.field_76652_q[n2];
            if ((n & 1 << n2) == 0) {
                if (!bl2 || chunkSection == field_186036_a) continue;
                this.field_76652_q[n2] = field_186036_a;
                continue;
            }
            if (chunkSection == field_186036_a) {
                this.field_76652_q[n2] = chunkSection = new ChunkSection(n2 << 4, bl3);
            }
            chunkSection.func_186049_g().func_186010_a(packetBuffer);
            packetBuffer.readBytes(chunkSection.func_76661_k().func_177481_a());
            if (!bl3) continue;
            packetBuffer.readBytes(chunkSection.func_76671_l().func_177481_a());
        }
        if (bl2) {
            for (n2 = 0; n2 < this.field_76651_r.length; ++n2) {
                this.field_76651_r[n2] = IRegistry.field_212624_m.func_148754_a(packetBuffer.readInt());
            }
        }
        for (n2 = 0; n2 < this.field_76652_q.length; ++n2) {
            if (this.field_76652_q[n2] == field_186036_a || (n & 1 << n2) == 0) continue;
            this.field_76652_q[n2].func_76672_e();
        }
        this.func_76590_a();
        for (TileEntity tileEntity : this.field_150816_i.values()) {
            tileEntity.func_145836_u();
        }
    }

    public Biome func_201600_k(BlockPos blockPos) {
        int n = blockPos.func_177958_n() & 0xF;
        \u2603 = blockPos.func_177952_p() & 0xF;
        return this.field_76651_r[\u2603 << 4 | n];
    }

    @Override
    public Biome[] func_201590_e() {
        return this.field_76651_r;
    }

    public void func_76613_n() {
        this.field_76649_t = 0;
    }

    public void func_76594_o() {
        if (this.field_76649_t >= 4096) {
            return;
        }
        BlockPos blockPos = new BlockPos(this.field_76635_g << 4, 0, this.field_76647_h << 4);
        for (int i = 0; i < 8; ++i) {
            if (this.field_76649_t >= 4096) {
                return;
            }
            \u2603 = this.field_76649_t % 16;
            \u2603 = this.field_76649_t / 16 % 16;
            \u2603 = this.field_76649_t / 256;
            ++this.field_76649_t;
            for (\u2603 = 0; \u2603 < 16; ++\u2603) {
                BlockPos blockPos2 = blockPos.func_177982_a(\u2603, (\u2603 << 4) + \u2603, \u2603);
                boolean bl = \u2603 = \u2603 == 0 || \u2603 == 15 || \u2603 == 0 || \u2603 == 15 || \u2603 == 0 || \u2603 == 15;
                if ((this.field_76652_q[\u2603] != field_186036_a || !\u2603) && (this.field_76652_q[\u2603] == field_186036_a || !this.field_76652_q[\u2603].func_177485_a(\u2603, \u2603, \u2603).func_196958_f())) continue;
                for (EnumFacing enumFacing : EnumFacing.values()) {
                    BlockPos blockPos3 = blockPos2.func_177972_a(enumFacing);
                    if (this.field_76637_e.func_180495_p(blockPos3).func_185906_d() <= 0) continue;
                    this.field_76637_e.func_175664_x(blockPos3);
                }
                this.field_76637_e.func_175664_x(blockPos2);
            }
        }
    }

    public boolean func_177410_o() {
        return this.field_76636_d;
    }

    public void func_177417_c(boolean bl) {
        this.field_76636_d = bl;
    }

    public World func_177412_p() {
        return this.field_76637_e;
    }

    public Set<Heightmap.Type> func_201615_v() {
        return this.field_76634_f.keySet();
    }

    public Heightmap func_201608_a(Heightmap.Type type) {
        return this.field_76634_f.get((Object)type);
    }

    public Map<BlockPos, TileEntity> func_177434_r() {
        return this.field_150816_i;
    }

    public ClassInheritanceMultiMap<Entity>[] func_177429_s() {
        return this.field_76645_j;
    }

    @Override
    public NBTTagCompound func_201579_g(BlockPos blockPos) {
        return this.field_201618_i.get(blockPos);
    }

    @Override
    public ITickList<Block> func_205218_i_() {
        return this.field_201621_s;
    }

    @Override
    public ITickList<Fluid> func_212247_j() {
        return this.field_205325_u;
    }

    @Override
    public BitSet func_205749_a(GenerationStage.Carving carving) {
        throw new RuntimeException("Not yet implemented");
    }

    public void func_177427_f(boolean bl) {
        this.field_76643_l = bl;
    }

    public void func_177409_g(boolean bl) {
        this.field_76644_m = bl;
    }

    @Override
    public void func_177432_b(long l) {
        this.field_76641_n = l;
    }

    @Override
    @Nullable
    public StructureStart func_201585_a(String string) {
        return this.field_201619_q.get(string);
    }

    @Override
    public void func_201584_a(String string, StructureStart structureStart) {
        this.field_201619_q.put(string, structureStart);
    }

    @Override
    public Map<String, StructureStart> func_201609_c() {
        return this.field_201619_q;
    }

    public void func_201612_a(Map<String, StructureStart> map) {
        this.field_201619_q.clear();
        this.field_201619_q.putAll(map);
    }

    @Override
    @Nullable
    public LongSet func_201578_b(String string2) {
        return this.field_201620_r.computeIfAbsent(string2, string -> new LongOpenHashSet());
    }

    @Override
    public void func_201583_a(String string2, long l) {
        this.field_201620_r.computeIfAbsent(string2, string -> new LongOpenHashSet()).add(l);
    }

    @Override
    public Map<String, LongSet> func_201604_d() {
        return this.field_201620_r;
    }

    public void func_201606_b(Map<String, LongSet> map) {
        this.field_201620_r.clear();
        this.field_201620_r.putAll(map);
    }

    public int func_177442_v() {
        return this.field_82912_p;
    }

    public long func_177416_w() {
        return this.field_111204_q;
    }

    public void func_177415_c(long l) {
        this.field_111204_q = l;
    }

    public void func_201595_A() {
        if (this.field_201616_C.func_209003_a(ChunkStatus.POSTPROCESSED) || this.field_201617_D != 8) {
            return;
        }
        ChunkPos chunkPos = this.func_76632_l();
        for (int i = 0; i < this.field_201622_t.length; ++i) {
            if (this.field_201622_t[i] == null) continue;
            for (Short s : this.field_201622_t[i]) {
                BlockPos blockPos2 = ChunkPrimer.func_201635_a(s, i, chunkPos);
                IBlockState \u26032 = this.field_76637_e.func_180495_p(blockPos2);
                IBlockState \u26033 = Block.func_199770_b(\u26032, this.field_76637_e, blockPos2);
                this.field_76637_e.func_180501_a(blockPos2, \u26033, 20);
            }
            this.field_201622_t[i].clear();
        }
        if (this.field_201621_s instanceof ChunkPrimerTickList) {
            ((ChunkPrimerTickList)this.field_201621_s).func_205381_a(this.field_76637_e.func_205220_G_(), blockPos -> this.field_76637_e.func_180495_p((BlockPos)blockPos).func_177230_c());
        }
        if (this.field_205325_u instanceof ChunkPrimerTickList) {
            ((ChunkPrimerTickList)this.field_205325_u).func_205381_a(this.field_76637_e.func_205219_F_(), blockPos -> this.field_76637_e.func_204610_c((BlockPos)blockPos).func_206886_c());
        }
        for (BlockPos blockPos3 : new HashSet<BlockPos>(this.field_201618_i.keySet())) {
            this.func_175625_s(blockPos3);
        }
        this.field_201618_i.clear();
        this.func_201574_a(ChunkStatus.POSTPROCESSED);
        this.field_196967_n.func_196990_a(this);
    }

    @Nullable
    private TileEntity func_212815_a(BlockPos blockPos, NBTTagCompound nBTTagCompound2) {
        TileEntity \u26032;
        if ("DUMMY".equals(nBTTagCompound2.func_74779_i("id"))) {
            Block block = this.func_180495_p(blockPos).func_177230_c();
            if (block instanceof ITileEntityProvider) {
                \u26032 = ((ITileEntityProvider)((Object)block)).func_196283_a_(this.field_76637_e);
            } else {
                \u26032 = null;
                field_150817_t.warn("Tried to load a DUMMY block entity @ {} but found not block entity block {} at location", (Object)blockPos, (Object)this.func_180495_p(blockPos));
            }
        } else {
            NBTTagCompound nBTTagCompound2;
            \u26032 = TileEntity.func_203403_c(nBTTagCompound2);
        }
        if (\u26032 != null) {
            \u26032.func_174878_a(blockPos);
            this.func_150813_a(\u26032);
        } else {
            field_150817_t.warn("Tried to load a block entity for block {} but failed at location {}", (Object)this.func_180495_p(blockPos), (Object)blockPos);
        }
        return \u26032;
    }

    public UpgradeData func_196966_y() {
        return this.field_196967_n;
    }

    public ShortList[] func_201614_D() {
        return this.field_201622_t;
    }

    public void func_201610_a(short s, int n) {
        ChunkPrimer.func_205330_a(this.field_201622_t, n).add(s);
    }

    @Override
    public ChunkStatus func_201589_g() {
        return this.field_201616_C;
    }

    @Override
    public void func_201574_a(ChunkStatus chunkStatus) {
        this.field_201616_C = chunkStatus;
    }

    public void func_201613_c(String string) {
        this.func_201574_a(ChunkStatus.func_202127_a(string));
    }

    public void func_201605_F() {
        ++this.field_201617_D;
        if (this.field_201617_D > 8) {
            throw new RuntimeException("Error while adding chunk to cache. Too many neighbors");
        }
        if (this.func_201596_H()) {
            ((IThreadListener)((Object)this.field_76637_e)).func_152344_a(this::func_201595_A);
        }
    }

    public void func_201611_G() {
        --this.field_201617_D;
        if (this.field_201617_D < 0) {
            throw new RuntimeException("Error while removing chunk from cache. Not enough neighbors");
        }
    }

    public boolean func_201596_H() {
        return this.field_201617_D == 8;
    }

    public static enum EnumCreateEntityType {
        IMMEDIATE,
        QUEUED,
        CHECK;

    }
}

