/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk.storage;

import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nullable;
import net.minecraft.util.Util;

public class RegionFile {
    private static final byte[] field_76720_a = new byte[4096];
    private final File field_76718_b;
    private RandomAccessFile field_76719_c;
    private final int[] field_76716_d = new int[1024];
    private final int[] field_76717_e = new int[1024];
    private List<Boolean> field_76714_f;
    private int field_76715_g;
    private long field_76721_h;

    public RegionFile(File file) {
        this.field_76718_b = file;
        this.field_76715_g = 0;
        try {
            int n;
            if (file.exists()) {
                this.field_76721_h = file.lastModified();
            }
            this.field_76719_c = new RandomAccessFile(file, "rw");
            if (this.field_76719_c.length() < 4096L) {
                this.field_76719_c.write(field_76720_a);
                this.field_76719_c.write(field_76720_a);
                this.field_76715_g += 8192;
            }
            if ((this.field_76719_c.length() & 0xFFFL) != 0L) {
                n = 0;
                while ((long)n < (this.field_76719_c.length() & 0xFFFL)) {
                    this.field_76719_c.write(0);
                    ++n;
                }
            }
            n = (int)this.field_76719_c.length() / 4096;
            this.field_76714_f = Lists.newArrayListWithCapacity((int)n);
            for (\u2603 = 0; \u2603 < n; ++\u2603) {
                this.field_76714_f.add(true);
            }
            this.field_76714_f.set(0, false);
            this.field_76714_f.set(1, false);
            this.field_76719_c.seek(0L);
            for (\u2603 = 0; \u2603 < 1024; ++\u2603) {
                this.field_76716_d[\u2603] = \u2603 = this.field_76719_c.readInt();
                if (\u2603 == 0 || (\u2603 >> 8) + (\u2603 & 0xFF) > this.field_76714_f.size()) continue;
                for (\u2603 = 0; \u2603 < (\u2603 & 0xFF); ++\u2603) {
                    this.field_76714_f.set((\u2603 >> 8) + \u2603, false);
                }
            }
            for (\u2603 = 0; \u2603 < 1024; ++\u2603) {
                this.field_76717_e[\u2603] = \u2603 = this.field_76719_c.readInt();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Nullable
    public synchronized DataInputStream func_76704_a(int n, int n2) {
        if (this.func_76705_d(n, n2)) {
            return null;
        }
        try {
            \u2603 = this.func_76707_e(n, n2);
            if (\u2603 == 0) {
                return null;
            }
            \u2603 = \u2603 >> 8;
            \u2603 = \u2603 & 0xFF;
            if (\u2603 + \u2603 > this.field_76714_f.size()) {
                return null;
            }
            this.field_76719_c.seek(\u2603 * 4096);
            \u2603 = this.field_76719_c.readInt();
            if (\u2603 > 4096 * \u2603) {
                return null;
            }
            if (\u2603 <= 0) {
                return null;
            }
            byte by = this.field_76719_c.readByte();
            if (by == 1) {
                byte[] byArray = new byte[\u2603 - 1];
                this.field_76719_c.read(byArray);
                return new DataInputStream(new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(byArray))));
            }
            if (by == 2) {
                byte[] byArray = new byte[\u2603 - 1];
                this.field_76719_c.read(byArray);
                return new DataInputStream(new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(byArray))));
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean func_212167_b(int n, int n2) {
        if (this.func_76705_d(n, n2)) {
            return false;
        }
        \u2603 = this.func_76707_e(n, n2);
        if (\u2603 == 0) {
            return false;
        }
        \u2603 = \u2603 >> 8;
        \u2603 = \u2603 & 0xFF;
        if (\u2603 + \u2603 > this.field_76714_f.size()) {
            return false;
        }
        try {
            this.field_76719_c.seek(\u2603 * 4096);
            \u2603 = this.field_76719_c.readInt();
            if (\u2603 > 4096 * \u2603) {
                return false;
            }
            if (\u2603 <= 0) {
                return false;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    @Nullable
    public DataOutputStream func_76710_b(int n, int n2) {
        if (this.func_76705_d(n, n2)) {
            return null;
        }
        return new DataOutputStream(new BufferedOutputStream(new DeflaterOutputStream(new ChunkBuffer(n, n2))));
    }

    protected synchronized void func_76706_a(int n, int n2, byte[] byArray, int n3) {
        try {
            \u2603 = this.func_76707_e(n, n2);
            \u2603 = \u2603 >> 8;
            \u2603 = \u2603 & 0xFF;
            \u2603 = (n3 + 5) / 4096 + 1;
            if (\u2603 >= 256) {
                return;
            }
            if (\u2603 != 0 && \u2603 == \u2603) {
                this.func_76712_a(\u2603, byArray, n3);
            } else {
                for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
                    this.field_76714_f.set(\u2603 + \u2603, true);
                }
                \u2603 = this.field_76714_f.indexOf(true);
                \u2603 = 0;
                if (\u2603 != -1) {
                    for (\u2603 = \u2603; \u2603 < this.field_76714_f.size(); ++\u2603) {
                        if (\u2603 != 0) {
                            \u2603 = this.field_76714_f.get(\u2603).booleanValue() ? ++\u2603 : 0;
                        } else if (this.field_76714_f.get(\u2603).booleanValue()) {
                            \u2603 = \u2603;
                            \u2603 = 1;
                        }
                        if (\u2603 >= \u2603) break;
                    }
                }
                if (\u2603 >= \u2603) {
                    \u2603 = \u2603;
                    this.func_76711_a(n, n2, \u2603 << 8 | \u2603);
                    for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
                        this.field_76714_f.set(\u2603 + \u2603, false);
                    }
                    this.func_76712_a(\u2603, byArray, n3);
                } else {
                    this.field_76719_c.seek(this.field_76719_c.length());
                    \u2603 = this.field_76714_f.size();
                    for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
                        this.field_76719_c.write(field_76720_a);
                        this.field_76714_f.add(false);
                    }
                    this.field_76715_g += 4096 * \u2603;
                    this.func_76712_a(\u2603, byArray, n3);
                    this.func_76711_a(n, n2, \u2603 << 8 | \u2603);
                }
            }
            this.func_76713_b(n, n2, (int)(Util.func_211179_d() / 1000L));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void func_76712_a(int n, byte[] byArray, int n2) throws IOException {
        this.field_76719_c.seek(n * 4096);
        this.field_76719_c.writeInt(n2 + 1);
        this.field_76719_c.writeByte(2);
        this.field_76719_c.write(byArray, 0, n2);
    }

    private boolean func_76705_d(int n, int n2) {
        return n < 0 || n >= 32 || n2 < 0 || n2 >= 32;
    }

    private int func_76707_e(int n, int n2) {
        return this.field_76716_d[n + n2 * 32];
    }

    public boolean func_76709_c(int n, int n2) {
        return this.func_76707_e(n, n2) != 0;
    }

    private void func_76711_a(int n, int n2, int n3) throws IOException {
        this.field_76716_d[n + n2 * 32] = n3;
        this.field_76719_c.seek((n + n2 * 32) * 4);
        this.field_76719_c.writeInt(n3);
    }

    private void func_76713_b(int n, int n2, int n3) throws IOException {
        this.field_76717_e[n + n2 * 32] = n3;
        this.field_76719_c.seek(4096 + (n + n2 * 32) * 4);
        this.field_76719_c.writeInt(n3);
    }

    public void func_76708_c() throws IOException {
        if (this.field_76719_c != null) {
            this.field_76719_c.close();
        }
    }

    class ChunkBuffer
    extends ByteArrayOutputStream {
        private final int field_76722_b;
        private final int field_76723_c;

        public ChunkBuffer(int n, int n2) {
            super(8096);
            this.field_76722_b = n;
            this.field_76723_c = n2;
        }

        @Override
        public void close() {
            RegionFile.this.func_76706_a(this.field_76722_b, this.field_76723_c, this.buf, this.count);
        }
    }
}

