/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.BitSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFalling;
import net.minecraft.init.Blocks;
import net.minecraft.util.ExpiringMap;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IChunkGenSettings;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.carver.WorldCarverWrapper;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;

public abstract class AbstractChunkGenerator<C extends IChunkGenSettings>
implements IChunkGenerator<C> {
    protected final IWorld field_202095_a;
    protected final long field_202096_b;
    protected final BiomeProvider field_202097_c;
    protected final Map<Structure<? extends IFeatureConfig>, Long2ObjectMap<StructureStart>> field_203227_d = Maps.newHashMap();
    protected final Map<Structure<? extends IFeatureConfig>, Long2ObjectMap<LongSet>> field_203228_e = Maps.newHashMap();

    public AbstractChunkGenerator(IWorld iWorld, BiomeProvider biomeProvider) {
        this.field_202095_a = iWorld;
        this.field_202096_b = iWorld.func_72905_C();
        this.field_202097_c = biomeProvider;
    }

    @Override
    public void func_202091_a(WorldGenRegion worldGenRegion, GenerationStage.Carving carving) {
        SharedSeedRandom sharedSeedRandom = new SharedSeedRandom(this.field_202096_b);
        int \u26032 = 8;
        int \u26033 = worldGenRegion.func_201679_a();
        int \u26034 = worldGenRegion.func_201680_b();
        BitSet \u26035 = worldGenRegion.func_72964_e(\u26033, \u26034).func_205749_a(carving);
        for (int i = \u26033 - 8; i <= \u26033 + 8; ++i) {
            for (\u2603 = \u26034 - 8; \u2603 <= \u26034 + 8; ++\u2603) {
                List<WorldCarverWrapper<?>> list = worldGenRegion.func_72863_F().func_201711_g().func_202090_b().func_180300_a(new BlockPos(i * 16, 0, \u2603 * 16), null).func_203603_a(carving);
                ListIterator<WorldCarverWrapper<?>> \u26036 = list.listIterator();
                while (\u26036.hasNext()) {
                    int n = \u26036.nextIndex();
                    WorldCarverWrapper<?> \u26037 = \u26036.next();
                    sharedSeedRandom.func_202425_c(worldGenRegion.func_201672_e().func_72905_C() + (long)n, i, \u2603);
                    if (!\u26037.func_212246_a((IBlockReader)worldGenRegion, (Random)sharedSeedRandom, i, \u2603, IFeatureConfig.field_202429_e)) continue;
                    \u26037.func_202522_a((IWorld)worldGenRegion, (Random)sharedSeedRandom, i, \u2603, \u26033, \u26034, \u26035, IFeatureConfig.field_202429_e);
                }
            }
        }
    }

    @Override
    @Nullable
    public BlockPos func_211403_a(World world, String string, BlockPos blockPos, int n, boolean bl) {
        Structure<?> structure = Feature.field_202300_at.get(string.toLowerCase(Locale.ROOT));
        if (structure != null) {
            return structure.func_211405_a(world, this, blockPos, n, bl);
        }
        return null;
    }

    protected void func_205472_a(IChunk iChunk, Random random) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int \u26032 = iChunk.func_76632_l().func_180334_c();
        int \u26033 = iChunk.func_76632_l().func_180333_d();
        for (BlockPos blockPos : BlockPos.func_191532_a(\u26032, 0, \u26033, \u26032 + 16, 0, \u26033 + 16)) {
            for (int i = 4; i >= 0; --i) {
                if (i > random.nextInt(5)) continue;
                iChunk.func_177436_a(mutableBlockPos.func_181079_c(blockPos.func_177958_n(), i, blockPos.func_177952_p()), Blocks.field_150357_h.func_176223_P(), false);
            }
        }
    }

    @Override
    public void func_202092_b(WorldGenRegion worldGenRegion) {
        BlockFalling.field_149832_M = true;
        int n = worldGenRegion.func_201679_a();
        \u2603 = worldGenRegion.func_201680_b();
        \u2603 = n * 16;
        \u2603 = \u2603 * 16;
        BlockPos \u26032 = new BlockPos(\u2603, 0, \u2603);
        Biome \u26033 = worldGenRegion.func_72964_e(n + 1, \u2603 + 1).func_201590_e()[0];
        SharedSeedRandom \u26034 = new SharedSeedRandom();
        long \u26035 = \u26034.func_202424_a(worldGenRegion.func_72905_C(), \u2603, \u2603);
        for (GenerationStage.Decoration decoration : GenerationStage.Decoration.values()) {
            \u26033.func_203608_a(decoration, this, worldGenRegion, \u26035, \u26034, \u26032);
        }
        BlockFalling.field_149832_M = false;
    }

    public void func_205471_a(IChunk iChunk, Biome[] biomeArray, SharedSeedRandom sharedSeedRandom, int n) {
        double d = 0.03125;
        ChunkPos \u26032 = iChunk.func_76632_l();
        int \u26033 = \u26032.func_180334_c();
        int \u26034 = \u26032.func_180333_d();
        double[] \u26035 = this.func_205473_a(\u26032.field_77276_a, \u26032.field_77275_b);
        for (int i = 0; i < 16; ++i) {
            for (\u2603 = 0; \u2603 < 16; ++\u2603) {
                \u2603 = \u26033 + i;
                \u2603 = \u26034 + \u2603;
                \u2603 = iChunk.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, i, \u2603) + 1;
                biomeArray[\u2603 * 16 + i].func_206854_a(sharedSeedRandom, iChunk, \u2603, \u2603, \u2603, \u26035[\u2603 * 16 + i], this.func_201496_a_().func_205532_l(), this.func_201496_a_().func_205533_m(), n, this.field_202095_a.func_72905_C());
            }
        }
    }

    @Override
    public abstract C func_201496_a_();

    public abstract double[] func_205473_a(int var1, int var2);

    @Override
    public boolean func_202094_a(Biome biome, Structure<? extends IFeatureConfig> structure) {
        return biome.func_201858_a(structure);
    }

    @Override
    @Nullable
    public IFeatureConfig func_202087_b(Biome biome, Structure<? extends IFeatureConfig> structure) {
        return biome.func_201857_b(structure);
    }

    @Override
    public BiomeProvider func_202090_b() {
        return this.field_202097_c;
    }

    @Override
    public long func_202089_c() {
        return this.field_202096_b;
    }

    @Override
    public Long2ObjectMap<StructureStart> func_203224_a(Structure<? extends IFeatureConfig> structure2) {
        return this.field_203227_d.computeIfAbsent(structure2, structure -> Long2ObjectMaps.synchronize(new ExpiringMap(8192, 10000)));
    }

    @Override
    public Long2ObjectMap<LongSet> func_203223_b(Structure<? extends IFeatureConfig> structure2) {
        return this.field_203228_e.computeIfAbsent(structure2, structure -> Long2ObjectMaps.synchronize(new ExpiringMap(8192, 10000)));
    }

    @Override
    public int func_207511_e() {
        return 256;
    }
}

