/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.structure.StructureIO;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTableList;

public class EndCityPieces {
    private static final PlacementSettings field_186202_b = new PlacementSettings().func_186222_a(true);
    private static final PlacementSettings field_186203_c = new PlacementSettings().func_186222_a(true).func_186225_a(Blocks.field_150350_a);
    private static final IGenerator field_186204_d = new IGenerator(){

        @Override
        public void func_186184_a() {
        }

        @Override
        public boolean func_191086_a(TemplateManager templateManager, int n, CityTemplate cityTemplate, BlockPos blockPos, List<StructurePiece> list, Random random) {
            if (n > 8) {
                return false;
            }
            Rotation rotation = cityTemplate.field_186177_b.func_186215_c();
            CityTemplate \u26032 = EndCityPieces.func_189935_b(list, EndCityPieces.func_191090_b(templateManager, cityTemplate, blockPos, "base_floor", rotation, true));
            int \u26033 = random.nextInt(3);
            if (\u26033 == 0) {
                \u26032 = EndCityPieces.func_189935_b(list, EndCityPieces.func_191090_b(templateManager, \u26032, new BlockPos(-1, 4, -1), "base_roof", rotation, true));
            } else if (\u26033 == 1) {
                \u26032 = EndCityPieces.func_189935_b(list, EndCityPieces.func_191090_b(templateManager, \u26032, new BlockPos(-1, 0, -1), "second_floor_2", rotation, false));
                \u26032 = EndCityPieces.func_189935_b(list, EndCityPieces.func_191090_b(templateManager, \u26032, new BlockPos(-1, 8, -1), "second_roof", rotation, false));
                EndCityPieces.func_191088_b(templateManager, field_186206_f, n + 1, \u26032, null, list, random);
            } else if (\u26033 == 2) {
                \u26032 = EndCityPieces.func_189935_b(list, EndCityPieces.func_191090_b(templateManager, \u26032, new BlockPos(-1, 0, -1), "second_floor_2", rotation, false));
                \u26032 = EndCityPieces.func_189935_b(list, EndCityPieces.func_191090_b(templateManager, \u26032, new BlockPos(-1, 4, -1), "third_floor_2", rotation, false));
                \u26032 = EndCityPieces.func_189935_b(list, EndCityPieces.func_191090_b(templateManager, \u26032, new BlockPos(-1, 8, -1), "third_roof", rotation, true));
                EndCityPieces.func_191088_b(templateManager, field_186206_f, n + 1, \u26032, null, list, random);
            }
            return true;
        }
    };
    private static final List<Tuple<Rotation, BlockPos>> field_186205_e = Lists.newArrayList((Object[])new Tuple[]{new Tuple<Rotation, BlockPos>(Rotation.NONE, new BlockPos(1, -1, 0)), new Tuple<Rotation, BlockPos>(Rotation.CLOCKWISE_90, new BlockPos(6, -1, 1)), new Tuple<Rotation, BlockPos>(Rotation.COUNTERCLOCKWISE_90, new BlockPos(0, -1, 5)), new Tuple<Rotation, BlockPos>(Rotation.CLOCKWISE_180, new BlockPos(5, -1, 6))});
    private static final IGenerator field_186206_f = new IGenerator(){

        @Override
        public void func_186184_a() {
        }

        @Override
        public boolean func_191086_a(TemplateManager templateManager, int n2, CityTemplate cityTemplate, BlockPos blockPos, List<StructurePiece> list2, Random random) {
            int n2;
            Rotation rotation = cityTemplate.field_186177_b.func_186215_c();
            CityTemplate \u26032 = cityTemplate;
            \u26032 = EndCityPieces.func_189935_b(list2, EndCityPieces.func_191090_b(templateManager, \u26032, new BlockPos(3 + random.nextInt(2), -3, 3 + random.nextInt(2)), "tower_base", rotation, true));
            \u26032 = EndCityPieces.func_189935_b(list2, EndCityPieces.func_191090_b(templateManager, \u26032, new BlockPos(0, 7, 0), "tower_piece", rotation, true));
            CityTemplate \u26033 = random.nextInt(3) == 0 ? \u26032 : null;
            int \u26034 = 1 + random.nextInt(3);
            for (int i = 0; i < \u26034; ++i) {
                \u26032 = EndCityPieces.func_189935_b(list2, EndCityPieces.func_191090_b(templateManager, \u26032, new BlockPos(0, 4, 0), "tower_piece", rotation, true));
                if (i >= \u26034 - 1 || !random.nextBoolean()) continue;
                \u26033 = \u26032;
            }
            if (\u26033 != null) {
                List<StructurePiece> list2;
                for (Tuple tuple : field_186205_e) {
                    if (!random.nextBoolean()) continue;
                    CityTemplate cityTemplate2 = EndCityPieces.func_189935_b(list2, EndCityPieces.func_191090_b(templateManager, \u26033, (BlockPos)tuple.func_76340_b(), "bridge_end", rotation.func_185830_a((Rotation)((Object)tuple.func_76341_a())), true));
                    EndCityPieces.func_191088_b(templateManager, field_186207_g, n2 + 1, cityTemplate2, null, list2, random);
                }
                \u26032 = EndCityPieces.func_189935_b(list2, EndCityPieces.func_191090_b(templateManager, \u26032, new BlockPos(-1, 4, -1), "tower_top", rotation, true));
            } else if (n2 == 7) {
                \u26032 = EndCityPieces.func_189935_b(list2, EndCityPieces.func_191090_b(templateManager, \u26032, new BlockPos(-1, 4, -1), "tower_top", rotation, true));
            } else {
                return EndCityPieces.func_191088_b(templateManager, field_186209_i, n2 + 1, \u26032, null, list2, random);
            }
            return true;
        }
    };
    private static final IGenerator field_186207_g = new IGenerator(){
        public boolean field_186186_a;

        @Override
        public void func_186184_a() {
            this.field_186186_a = false;
        }

        @Override
        public boolean func_191086_a(TemplateManager templateManager, int n, CityTemplate cityTemplate, BlockPos blockPos, List<StructurePiece> list, Random random2) {
            Random random2;
            Rotation rotation = cityTemplate.field_186177_b.func_186215_c();
            int \u26032 = random2.nextInt(4) + 1;
            CityTemplate \u26033 = EndCityPieces.func_189935_b(list, EndCityPieces.func_191090_b(templateManager, cityTemplate, new BlockPos(0, 0, -4), "bridge_piece", rotation, true));
            \u26033.field_74886_g = -1;
            int \u26034 = 0;
            for (int i = 0; i < \u26032; ++i) {
                if (random2.nextBoolean()) {
                    \u26033 = EndCityPieces.func_189935_b(list, EndCityPieces.func_191090_b(templateManager, \u26033, new BlockPos(0, \u26034, -4), "bridge_piece", rotation, true));
                    \u26034 = 0;
                    continue;
                }
                \u26033 = random2.nextBoolean() ? EndCityPieces.func_189935_b(list, EndCityPieces.func_191090_b(templateManager, \u26033, new BlockPos(0, \u26034, -4), "bridge_steep_stairs", rotation, true)) : EndCityPieces.func_189935_b(list, EndCityPieces.func_191090_b(templateManager, \u26033, new BlockPos(0, \u26034, -8), "bridge_gentle_stairs", rotation, true));
                \u26034 = 4;
            }
            if (this.field_186186_a || random2.nextInt(10 - n) != 0) {
                if (!EndCityPieces.func_191088_b(templateManager, field_186204_d, n + 1, \u26033, new BlockPos(-3, \u26034 + 1, -11), list, random2)) {
                    return false;
                }
            } else {
                EndCityPieces.func_189935_b(list, EndCityPieces.func_191090_b(templateManager, \u26033, new BlockPos(-8 + random2.nextInt(8), \u26034, -70 + random2.nextInt(10)), "ship", rotation, true));
                this.field_186186_a = true;
            }
            \u26033 = EndCityPieces.func_189935_b(list, EndCityPieces.func_191090_b(templateManager, \u26033, new BlockPos(4, \u26034, 0), "bridge_end", rotation.func_185830_a(Rotation.CLOCKWISE_180), true));
            \u26033.field_74886_g = -1;
            return true;
        }
    };
    private static final List<Tuple<Rotation, BlockPos>> field_186208_h = Lists.newArrayList((Object[])new Tuple[]{new Tuple<Rotation, BlockPos>(Rotation.NONE, new BlockPos(4, -1, 0)), new Tuple<Rotation, BlockPos>(Rotation.CLOCKWISE_90, new BlockPos(12, -1, 4)), new Tuple<Rotation, BlockPos>(Rotation.COUNTERCLOCKWISE_90, new BlockPos(0, -1, 8)), new Tuple<Rotation, BlockPos>(Rotation.CLOCKWISE_180, new BlockPos(8, -1, 12))});
    private static final IGenerator field_186209_i = new IGenerator(){

        @Override
        public void func_186184_a() {
        }

        @Override
        public boolean func_191086_a(TemplateManager templateManager, int n, CityTemplate cityTemplate, BlockPos blockPos, List<StructurePiece> list2, Random random) {
            List<StructurePiece> list2;
            Rotation rotation = cityTemplate.field_186177_b.func_186215_c();
            CityTemplate \u26032 = EndCityPieces.func_189935_b(list2, EndCityPieces.func_191090_b(templateManager, cityTemplate, new BlockPos(-3, 4, -3), "fat_tower_base", rotation, true));
            \u26032 = EndCityPieces.func_189935_b(list2, EndCityPieces.func_191090_b(templateManager, \u26032, new BlockPos(0, 4, 0), "fat_tower_middle", rotation, true));
            for (int i = 0; i < 2 && random.nextInt(3) != 0; ++i) {
                \u26032 = EndCityPieces.func_189935_b(list2, EndCityPieces.func_191090_b(templateManager, \u26032, new BlockPos(0, 8, 0), "fat_tower_middle", rotation, true));
                for (Tuple tuple : field_186208_h) {
                    if (!random.nextBoolean()) continue;
                    CityTemplate cityTemplate2 = EndCityPieces.func_189935_b(list2, EndCityPieces.func_191090_b(templateManager, \u26032, (BlockPos)tuple.func_76340_b(), "bridge_end", rotation.func_185830_a((Rotation)((Object)tuple.func_76341_a())), true));
                    EndCityPieces.func_191088_b(templateManager, field_186207_g, n + 1, cityTemplate2, null, list2, random);
                }
            }
            \u26032 = EndCityPieces.func_189935_b(list2, EndCityPieces.func_191090_b(templateManager, \u26032, new BlockPos(-2, 8, -2), "fat_tower_top", rotation, true));
            return true;
        }
    };

    public static void func_186200_a() {
        StructureIO.func_143031_a(CityTemplate.class, "ECP");
    }

    private static CityTemplate func_191090_b(TemplateManager templateManager, CityTemplate cityTemplate, BlockPos blockPos, String string, Rotation rotation, boolean bl) {
        CityTemplate cityTemplate2 = new CityTemplate(templateManager, string, cityTemplate.field_186178_c, rotation, bl);
        BlockPos \u26032 = cityTemplate.field_186176_a.func_186262_a(cityTemplate.field_186177_b, blockPos, cityTemplate2.field_186177_b, BlockPos.field_177992_a);
        cityTemplate2.func_181138_a(\u26032.func_177958_n(), \u26032.func_177956_o(), \u26032.func_177952_p());
        return cityTemplate2;
    }

    public static void func_191087_a(TemplateManager templateManager, BlockPos blockPos, Rotation rotation, List<StructurePiece> list, Random random) {
        field_186209_i.func_186184_a();
        field_186204_d.func_186184_a();
        field_186207_g.func_186184_a();
        field_186206_f.func_186184_a();
        CityTemplate cityTemplate = EndCityPieces.func_189935_b(list, new CityTemplate(templateManager, "base_floor", blockPos, rotation, true));
        cityTemplate = EndCityPieces.func_189935_b(list, EndCityPieces.func_191090_b(templateManager, cityTemplate, new BlockPos(-1, 0, -1), "second_floor_1", rotation, false));
        cityTemplate = EndCityPieces.func_189935_b(list, EndCityPieces.func_191090_b(templateManager, cityTemplate, new BlockPos(-1, 4, -1), "third_floor_1", rotation, false));
        cityTemplate = EndCityPieces.func_189935_b(list, EndCityPieces.func_191090_b(templateManager, cityTemplate, new BlockPos(-1, 8, -1), "third_roof", rotation, true));
        EndCityPieces.func_191088_b(templateManager, field_186206_f, 1, cityTemplate, null, list, random);
    }

    private static CityTemplate func_189935_b(List<StructurePiece> list, CityTemplate cityTemplate) {
        list.add(cityTemplate);
        return cityTemplate;
    }

    private static boolean func_191088_b(TemplateManager templateManager, IGenerator iGenerator, int n, CityTemplate cityTemplate, BlockPos blockPos, List<StructurePiece> list, Random random) {
        if (n > 8) {
            return false;
        }
        ArrayList arrayList = Lists.newArrayList();
        if (iGenerator.func_191086_a(templateManager, n, cityTemplate, blockPos, arrayList, random)) {
            boolean bl = false;
            int \u26032 = random.nextInt();
            for (StructurePiece structurePiece : arrayList) {
                structurePiece.field_74886_g = \u26032;
                \u2603 = StructurePiece.func_74883_a(list, structurePiece.func_74874_b());
                if (\u2603 == null || \u2603.field_74886_g == cityTemplate.field_74886_g) continue;
                bl = true;
                break;
            }
            if (!bl) {
                list.addAll(arrayList);
                return true;
            }
        }
        return false;
    }

    static interface IGenerator {
        public void func_186184_a();

        public boolean func_191086_a(TemplateManager var1, int var2, CityTemplate var3, BlockPos var4, List<StructurePiece> var5, Random var6);
    }

    public static class CityTemplate
    extends TemplateStructurePiece {
        private String field_186181_d;
        private Rotation field_186182_e;
        private boolean field_186183_f;

        public CityTemplate() {
        }

        public CityTemplate(TemplateManager templateManager, String string, BlockPos blockPos, Rotation rotation, boolean bl) {
            super(0);
            this.field_186181_d = string;
            this.field_186178_c = blockPos;
            this.field_186182_e = rotation;
            this.field_186183_f = bl;
            this.func_191085_a(templateManager);
        }

        private void func_191085_a(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(new ResourceLocation("end_city/" + this.field_186181_d));
            PlacementSettings \u26032 = (this.field_186183_f ? field_186202_b : field_186203_c).func_186217_a().func_186220_a(this.field_186182_e);
            this.func_186173_a(template, this.field_186178_c, \u26032);
        }

        @Override
        protected void func_143012_a(NBTTagCompound nBTTagCompound) {
            super.func_143012_a(nBTTagCompound);
            nBTTagCompound.func_74778_a("Template", this.field_186181_d);
            nBTTagCompound.func_74778_a("Rot", this.field_186182_e.name());
            nBTTagCompound.func_74757_a("OW", this.field_186183_f);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nBTTagCompound, TemplateManager templateManager) {
            super.func_143011_b(nBTTagCompound, templateManager);
            this.field_186181_d = nBTTagCompound.func_74779_i("Template");
            this.field_186182_e = Rotation.valueOf(nBTTagCompound.func_74779_i("Rot"));
            this.field_186183_f = nBTTagCompound.func_74767_n("OW");
            this.func_191085_a(templateManager);
        }

        @Override
        protected void func_186175_a(String string2, BlockPos blockPos, IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox) {
            String string2;
            if (string2.startsWith("Chest")) {
                BlockPos blockPos2 = blockPos.func_177977_b();
                if (mutableBoundingBox.func_175898_b(blockPos2)) {
                    TileEntityLockableLoot.func_195479_a(iWorld, random, blockPos2, LootTableList.field_186421_c);
                }
            } else if (string2.startsWith("Sentry")) {
                EntityShulker entityShulker = new EntityShulker(iWorld.func_201672_e());
                entityShulker.func_70107_b((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5);
                entityShulker.func_184694_g(blockPos);
                iWorld.func_72838_d(entityShulker);
            } else if (string2.startsWith("Elytra")) {
                EntityItemFrame entityItemFrame = new EntityItemFrame(iWorld.func_201672_e(), blockPos, this.field_186182_e.func_185831_a(EnumFacing.SOUTH));
                entityItemFrame.func_82334_a(new ItemStack(Items.field_185160_cR));
                iWorld.func_72838_d(entityItemFrame);
            }
        }
    }
}

