/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.init.Biomes;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.IChunkGenSettings;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.StrongholdConfig;
import net.minecraft.world.gen.feature.structure.StrongholdPieces;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;

public class StrongholdStructure
extends Structure<StrongholdConfig> {
    private boolean field_75056_f;
    private ChunkPos[] field_75057_g;
    private long field_202387_av;

    @Override
    protected boolean func_202372_a(IChunkGenerator<?> iChunkGenerator, Random random, int n, int n2) {
        if (this.field_202387_av != iChunkGenerator.func_202089_c()) {
            this.func_202386_c();
        }
        if (!this.field_75056_f) {
            this.func_202385_a(iChunkGenerator);
            this.field_75056_f = true;
        }
        for (ChunkPos chunkPos : this.field_75057_g) {
            if (n != chunkPos.field_77276_a || n2 != chunkPos.field_77275_b) continue;
            return true;
        }
        return false;
    }

    private void func_202386_c() {
        this.field_75056_f = false;
        this.field_75057_g = null;
    }

    @Override
    protected boolean func_202365_a(IWorld iWorld) {
        return iWorld.func_72912_H().func_76089_r();
    }

    @Override
    protected StructureStart func_202369_a(IWorld iWorld, IChunkGenerator<?> iChunkGenerator, SharedSeedRandom sharedSeedRandom, int n, int n2) {
        Biome biome = iChunkGenerator.func_202090_b().func_180300_a(new BlockPos((n << 4) + 9, 0, (n2 << 4) + 9), Biomes.field_180279_ad);
        int \u26032 = 0;
        Start \u26033 = new Start(iWorld, sharedSeedRandom, n, n2, biome, \u26032++);
        while (\u26033.func_186161_c().isEmpty() || ((StrongholdPieces.Stairs2)\u26033.func_186161_c().get((int)0)).field_75025_b == null) {
            \u26033 = new Start(iWorld, sharedSeedRandom, n, n2, biome, \u26032++);
        }
        return \u26033;
    }

    @Override
    protected String func_143025_a() {
        return "Stronghold";
    }

    @Override
    public int func_202367_b() {
        return 8;
    }

    @Override
    @Nullable
    public BlockPos func_211405_a(World world, IChunkGenerator<? extends IChunkGenSettings> iChunkGenerator, BlockPos blockPos, int n, boolean bl) {
        if (!iChunkGenerator.func_202090_b().func_205004_a(this)) {
            return null;
        }
        if (this.field_202387_av != world.func_72905_C()) {
            this.func_202386_c();
        }
        if (!this.field_75056_f) {
            this.func_202385_a(iChunkGenerator);
            this.field_75056_f = true;
        }
        BlockPos \u26034 = null;
        BlockPos.MutableBlockPos \u26032 = new BlockPos.MutableBlockPos(0, 0, 0);
        double \u26033 = Double.MAX_VALUE;
        for (ChunkPos chunkPos : this.field_75057_g) {
            \u26032.func_181079_c((chunkPos.field_77276_a << 4) + 8, 32, (chunkPos.field_77275_b << 4) + 8);
            double d = \u26032.func_177951_i(blockPos);
            if (\u26034 == null) {
                \u26034 = new BlockPos(\u26032);
                \u26033 = d;
                continue;
            }
            if (!(d < \u26033)) continue;
            \u26034 = new BlockPos(\u26032);
            \u26033 = d;
        }
        return \u26034;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void func_202385_a(IChunkGenerator<?> iChunkGenerator2) {
        IChunkGenerator<?> iChunkGenerator2;
        this.field_202387_av = iChunkGenerator2.func_202089_c();
        ArrayList arrayList = Lists.newArrayList();
        for (Biome biome : IRegistry.field_212624_m) {
            if (biome == null || !iChunkGenerator2.func_202094_a(biome, Feature.field_202335_m)) continue;
            arrayList.add(biome);
        }
        int \u26032 = iChunkGenerator2.func_201496_a_().func_202172_d();
        int \u26033 = iChunkGenerator2.func_201496_a_().func_202176_e();
        int \u26034 = iChunkGenerator2.func_201496_a_().func_202175_f();
        this.field_75057_g = new ChunkPos[\u26033];
        int \u26035 = 0;
        Long2ObjectMap<StructureStart> long2ObjectMap = \u2603 = iChunkGenerator2.func_203224_a(this);
        synchronized (long2ObjectMap) {
            for (StructureStart structureStart : \u2603.values()) {
                if (\u26035 >= this.field_75057_g.length) continue;
                this.field_75057_g[\u26035++] = new ChunkPos(structureStart.func_143019_e(), structureStart.func_143018_f());
            }
        }
        Random random = new Random();
        random.setSeed(iChunkGenerator2.func_202089_c());
        double \u26036 = random.nextDouble() * Math.PI * 2.0;
        int \u26037 = \u2603.size();
        if (\u26037 < this.field_75057_g.length) {
            int \u260311 = 0;
            \u2603 = 0;
            for (\u2603 = 0; \u2603 < this.field_75057_g.length; ++\u2603) {
                double d = (double)(4 * \u26032 + \u26032 * \u2603 * 6) + (random.nextDouble() - 0.5) * ((double)\u26032 * 2.5);
                int \u26038 = (int)Math.round(Math.cos(\u26036) * d);
                int \u26039 = (int)Math.round(Math.sin(\u26036) * d);
                BlockPos \u260310 = iChunkGenerator2.func_202090_b().func_180630_a((\u26038 << 4) + 8, (\u26039 << 4) + 8, 112, arrayList, random);
                if (\u260310 != null) {
                    \u26038 = \u260310.func_177958_n() >> 4;
                    \u26039 = \u260310.func_177952_p() >> 4;
                }
                if (\u2603 >= \u26037) {
                    this.field_75057_g[\u2603] = new ChunkPos(\u26038, \u26039);
                }
                \u26036 += Math.PI * 2 / (double)\u26034;
                if (++\u260311 != \u26034) continue;
                \u260311 = 0;
                \u26034 += 2 * \u26034 / (++\u2603 + 1);
                \u26034 = Math.min(\u26034, this.field_75057_g.length - \u2603);
                \u26036 += random.nextDouble() * Math.PI * 2.0;
            }
        }
    }

    public static class Start
    extends StructureStart {
        public Start() {
        }

        public Start(IWorld iWorld, SharedSeedRandom sharedSeedRandom, int n, int n2, Biome biome, int n3) {
            super(n, n2, biome, sharedSeedRandom, iWorld.func_72905_C() + (long)n3);
            StrongholdPieces.func_75198_a();
            StrongholdPieces.Stairs2 stairs2 = new StrongholdPieces.Stairs2(0, (Random)sharedSeedRandom, (n << 4) + 2, (n2 << 4) + 2);
            this.field_75075_a.add(stairs2);
            stairs2.func_74861_a(stairs2, this.field_75075_a, sharedSeedRandom);
            List<StructurePiece> \u26032 = stairs2.field_75026_c;
            while (!\u26032.isEmpty()) {
                int n4 = sharedSeedRandom.nextInt(\u26032.size());
                StructurePiece \u26033 = \u26032.remove(n4);
                \u26033.func_74861_a(stairs2, this.field_75075_a, sharedSeedRandom);
            }
            this.func_202500_a(iWorld);
            this.func_75067_a(iWorld, sharedSeedRandom, 10);
        }
    }
}

