/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Biomes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.structure.StructureIO;
import net.minecraft.world.gen.feature.structure.StructurePiece;

public abstract class StructureStart {
    protected final List<StructurePiece> field_75075_a = Lists.newArrayList();
    protected MutableBoundingBox field_75074_b;
    protected int field_143024_c;
    protected int field_143023_d;
    private Biome field_202505_e;
    private int field_212688_f;

    public StructureStart() {
    }

    public StructureStart(int n, int n2, Biome biome, SharedSeedRandom sharedSeedRandom, long l) {
        this.field_143024_c = n;
        this.field_143023_d = n2;
        this.field_202505_e = biome;
        sharedSeedRandom.func_202425_c(l, this.field_143024_c, this.field_143023_d);
    }

    public MutableBoundingBox func_75071_a() {
        return this.field_75074_b;
    }

    public List<StructurePiece> func_186161_c() {
        return this.field_75075_a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_75068_a(IWorld iWorld2, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
        List<StructurePiece> list = this.field_75075_a;
        synchronized (list) {
            IWorld iWorld2;
            Iterator<StructurePiece> iterator = this.field_75075_a.iterator();
            while (iterator.hasNext()) {
                StructurePiece structurePiece = iterator.next();
                if (!structurePiece.func_74874_b().func_78884_a(mutableBoundingBox) || structurePiece.func_74875_a(iWorld2, random, mutableBoundingBox, chunkPos)) continue;
                iterator.remove();
            }
            this.func_202500_a(iWorld2);
        }
    }

    protected void func_202500_a(IBlockReader iBlockReader) {
        this.field_75074_b = MutableBoundingBox.func_78887_a();
        for (StructurePiece structurePiece : this.field_75075_a) {
            this.field_75074_b.func_78888_b(structurePiece.func_74874_b());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NBTTagCompound func_143021_a(int n, int n2) {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        if (!this.func_75069_d()) {
            nBTTagCompound.func_74778_a("id", "INVALID");
            return nBTTagCompound;
        }
        nBTTagCompound.func_74778_a("id", StructureIO.func_143033_a(this));
        nBTTagCompound.func_74778_a("biome", IRegistry.field_212624_m.func_177774_c(this.field_202505_e).toString());
        nBTTagCompound.func_74768_a("ChunkX", n);
        nBTTagCompound.func_74768_a("ChunkZ", n2);
        nBTTagCompound.func_74768_a("references", this.field_212688_f);
        nBTTagCompound.func_74782_a("BB", this.field_75074_b.func_151535_h());
        NBTTagList \u26032 = new NBTTagList();
        List<StructurePiece> list = this.field_75075_a;
        synchronized (list) {
            for (StructurePiece structurePiece : this.field_75075_a) {
                \u26032.add(structurePiece.func_143010_b());
            }
        }
        nBTTagCompound.func_74782_a("Children", \u26032);
        this.func_143022_a(nBTTagCompound);
        return nBTTagCompound;
    }

    public void func_143022_a(NBTTagCompound nBTTagCompound) {
    }

    public void func_143020_a(IWorld iWorld, NBTTagCompound nBTTagCompound2) {
        NBTTagCompound nBTTagCompound2;
        this.field_143024_c = nBTTagCompound2.func_74762_e("ChunkX");
        this.field_143023_d = nBTTagCompound2.func_74762_e("ChunkZ");
        this.field_212688_f = nBTTagCompound2.func_74762_e("references");
        Biome biome = this.field_202505_e = nBTTagCompound2.func_74764_b("biome") ? IRegistry.field_212624_m.func_212608_b(new ResourceLocation(nBTTagCompound2.func_74779_i("biome"))) : iWorld.func_72863_F().func_201711_g().func_202090_b().func_180300_a(new BlockPos((this.field_143024_c << 4) + 9, 0, (this.field_143023_d << 4) + 9), Biomes.field_76772_c);
        if (nBTTagCompound2.func_74764_b("BB")) {
            this.field_75074_b = new MutableBoundingBox(nBTTagCompound2.func_74759_k("BB"));
        }
        NBTTagList nBTTagList = nBTTagCompound2.func_150295_c("Children", 10);
        for (int i = 0; i < nBTTagList.size(); ++i) {
            this.field_75075_a.add(StructureIO.func_143032_b(nBTTagList.func_150305_b(i), iWorld));
        }
        this.func_143017_b(nBTTagCompound2);
    }

    public void func_143017_b(NBTTagCompound nBTTagCompound) {
    }

    protected void func_75067_a(IWorldReaderBase iWorldReaderBase, Random random, int n) {
        \u2603 = iWorldReaderBase.func_181545_F() - n;
        \u2603 = this.field_75074_b.func_78882_c() + 1;
        if (\u2603 < \u2603) {
            \u2603 += random.nextInt(\u2603 - \u2603);
        }
        \u2603 = \u2603 - this.field_75074_b.field_78894_e;
        this.field_75074_b.func_78886_a(0, \u2603, 0);
        for (StructurePiece structurePiece : this.field_75075_a) {
            structurePiece.func_181138_a(0, \u2603, 0);
        }
    }

    protected void func_75070_a(IBlockReader iBlockReader, Random random, int n, int n2) {
        \u2603 = n2 - n + 1 - this.field_75074_b.func_78882_c();
        \u2603 = \u2603 > 1 ? n + random.nextInt(\u2603) : n;
        \u2603 = \u2603 - this.field_75074_b.field_78895_b;
        this.field_75074_b.func_78886_a(0, \u2603, 0);
        for (StructurePiece structurePiece : this.field_75075_a) {
            structurePiece.func_181138_a(0, \u2603, 0);
        }
    }

    public boolean func_75069_d() {
        return true;
    }

    public void func_175787_b(ChunkPos chunkPos) {
    }

    public int func_143019_e() {
        return this.field_143024_c;
    }

    public int func_143018_f() {
        return this.field_143023_d;
    }

    public BlockPos func_204294_a() {
        return new BlockPos(this.field_143024_c << 4, 0, this.field_143023_d << 4);
    }

    public boolean func_212687_g() {
        return this.field_212688_f < this.func_212686_i();
    }

    public void func_212685_h() {
        ++this.field_212688_f;
    }

    protected int func_212686_i() {
        return 1;
    }
}

