/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.entity.EntityType;
import net.minecraft.init.Biomes;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.structure.ScatteredStructure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.SwampHutConfig;
import net.minecraft.world.gen.feature.structure.SwampHutPiece;

public class SwampHutStructure
extends ScatteredStructure<SwampHutConfig> {
    private static final List<Biome.SpawnListEntry> field_202384_d = Lists.newArrayList((Object[])new Biome.SpawnListEntry[]{new Biome.SpawnListEntry(EntityType.field_200759_ay, 1, 1, 1)});

    @Override
    protected String func_143025_a() {
        return "Swamp_Hut";
    }

    @Override
    public int func_202367_b() {
        return 3;
    }

    @Override
    protected StructureStart func_202369_a(IWorld iWorld, IChunkGenerator<?> iChunkGenerator, SharedSeedRandom sharedSeedRandom, int n, int n2) {
        Biome biome = iChunkGenerator.func_202090_b().func_180300_a(new BlockPos((n << 4) + 9, 0, (n2 << 4) + 9), Biomes.field_76772_c);
        return new Start(iWorld, sharedSeedRandom, n, n2, biome);
    }

    @Override
    protected int func_202382_c() {
        return 14357620;
    }

    @Override
    public List<Biome.SpawnListEntry> func_202279_e() {
        return field_202384_d;
    }

    public boolean func_202383_b(IWorld iWorld, BlockPos blockPos) {
        StructureStart structureStart = this.func_202364_a(iWorld, blockPos);
        if (structureStart == field_202376_c || !(structureStart instanceof Start) || structureStart.func_186161_c().isEmpty()) {
            return false;
        }
        StructurePiece \u26032 = structureStart.func_186161_c().get(0);
        return \u26032 instanceof SwampHutPiece;
    }

    public static class Start
    extends StructureStart {
        public Start() {
        }

        public Start(IWorld iWorld, SharedSeedRandom sharedSeedRandom, int n, int n2, Biome biome) {
            super(n, n2, biome, sharedSeedRandom, iWorld.func_72905_C());
            SwampHutPiece swampHutPiece = new SwampHutPiece(sharedSeedRandom, n * 16, n2 * 16);
            this.field_75075_a.add(swampHutPiece);
            this.func_202500_a(iWorld);
        }
    }
}

