/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.UpgradeData;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.WoodlandMansionConfig;
import net.minecraft.world.gen.feature.structure.WoodlandMansionPieces;

public class WoodlandMansionStructure
extends Structure<WoodlandMansionConfig> {
    @Override
    protected ChunkPos func_211744_a(IChunkGenerator<?> iChunkGenerator, Random random, int n, int n2, int n3, int n4) {
        \u2603 = iChunkGenerator.func_201496_a_().func_202179_i();
        \u2603 = iChunkGenerator.func_201496_a_().func_211726_q();
        \u2603 = n + \u2603 * n3;
        \u2603 = n2 + \u2603 * n4;
        \u2603 = \u2603 < 0 ? \u2603 - \u2603 + 1 : \u2603;
        \u2603 = \u2603 < 0 ? \u2603 - \u2603 + 1 : \u2603;
        \u2603 = \u2603 / \u2603;
        \u2603 = \u2603 / \u2603;
        ((SharedSeedRandom)random).func_202427_a(iChunkGenerator.func_202089_c(), \u2603, \u2603, 10387319);
        \u2603 *= \u2603;
        \u2603 *= \u2603;
        return new ChunkPos(\u2603 += (random.nextInt(\u2603 - \u2603) + random.nextInt(\u2603 - \u2603)) / 2, \u2603 += (random.nextInt(\u2603 - \u2603) + random.nextInt(\u2603 - \u2603)) / 2);
    }

    @Override
    protected boolean func_202372_a(IChunkGenerator<?> iChunkGenerator, Random random, int n, int n2) {
        ChunkPos chunkPos = this.func_211744_a(iChunkGenerator, random, n, n2, 0, 0);
        if (n == chunkPos.field_77276_a && n2 == chunkPos.field_77275_b) {
            Set<Biome> set = iChunkGenerator.func_202090_b().func_201538_a(n * 16 + 9, n2 * 16 + 9, 32);
            for (Biome biome : set) {
                if (iChunkGenerator.func_202094_a(biome, Feature.field_202330_h)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean func_202365_a(IWorld iWorld) {
        return iWorld.func_72912_H().func_76089_r();
    }

    @Override
    protected StructureStart func_202369_a(IWorld iWorld, IChunkGenerator<?> iChunkGenerator, SharedSeedRandom sharedSeedRandom, int n, int n2) {
        Biome biome = iChunkGenerator.func_202090_b().func_180300_a(new BlockPos((n << 4) + 9, 0, (n2 << 4) + 9), Biomes.field_180279_ad);
        return new Start(iWorld, iChunkGenerator, sharedSeedRandom, n, n2, biome);
    }

    @Override
    protected String func_143025_a() {
        return "Mansion";
    }

    @Override
    public int func_202367_b() {
        return 8;
    }

    public static class Start
    extends StructureStart {
        private boolean field_191093_c;

        public Start() {
        }

        public Start(IWorld iWorld, IChunkGenerator<?> iChunkGenerator, SharedSeedRandom sharedSeedRandom, int n, int n2, Biome biome) {
            super(n, n2, biome, sharedSeedRandom, iWorld.func_72905_C());
            Rotation rotation = Rotation.values()[sharedSeedRandom.nextInt(Rotation.values().length)];
            int \u26032 = 5;
            int \u26033 = 5;
            if (rotation == Rotation.CLOCKWISE_90) {
                \u26032 = -5;
            } else if (rotation == Rotation.CLOCKWISE_180) {
                \u26032 = -5;
                \u26033 = -5;
            } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                \u26033 = -5;
            }
            ChunkPrimer \u26034 = new ChunkPrimer(new ChunkPos(n, n2), UpgradeData.field_196994_a);
            iChunkGenerator.func_202088_a(\u26034);
            int \u26035 = \u26034.func_201576_a(Heightmap.Type.MOTION_BLOCKING, 7, 7);
            int \u26036 = \u26034.func_201576_a(Heightmap.Type.MOTION_BLOCKING, 7, 7 + \u26033);
            int \u26037 = \u26034.func_201576_a(Heightmap.Type.MOTION_BLOCKING, 7 + \u26032, 7);
            int \u26038 = \u26034.func_201576_a(Heightmap.Type.MOTION_BLOCKING, 7 + \u26032, 7 + \u26033);
            int \u26039 = Math.min(Math.min(\u26035, \u26036), Math.min(\u26037, \u26038));
            if (\u26039 < 60) {
                this.field_191093_c = false;
                return;
            }
            BlockPos \u260310 = new BlockPos(n * 16 + 8, \u26039 + 1, n2 * 16 + 8);
            LinkedList \u260311 = Lists.newLinkedList();
            WoodlandMansionPieces.func_191152_a(iWorld.func_72860_G().func_186340_h(), \u260310, rotation, \u260311, sharedSeedRandom);
            this.field_75075_a.addAll(\u260311);
            this.func_202500_a(iWorld);
            this.field_191093_c = true;
        }

        @Override
        public void func_75068_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            super.func_75068_a(iWorld, random, mutableBoundingBox, chunkPos);
            int n = this.field_75074_b.field_78895_b;
            for (\u2603 = mutableBoundingBox.field_78897_a; \u2603 <= mutableBoundingBox.field_78893_d; ++\u2603) {
                for (\u2603 = mutableBoundingBox.field_78896_c; \u2603 <= mutableBoundingBox.field_78892_f; ++\u2603) {
                    BlockPos blockPos = new BlockPos(\u2603, n, \u2603);
                    if (iWorld.func_175623_d(blockPos) || !this.field_75074_b.func_175898_b(blockPos)) continue;
                    boolean \u26032 = false;
                    for (Object object : this.field_75075_a) {
                        if (!((StructurePiece)object).func_74874_b().func_175898_b(blockPos)) continue;
                        \u26032 = true;
                        break;
                    }
                    if (!\u26032) continue;
                    for (int i = n - 1; i > 1 && (iWorld.func_175623_d((BlockPos)(object = new BlockPos(\u2603, i, \u2603))) || iWorld.func_180495_p((BlockPos)object).func_185904_a().func_76224_d()); --i) {
                        iWorld.func_180501_a((BlockPos)object, Blocks.field_150347_e.func_176223_P(), 2);
                    }
                }
            }
        }

        @Override
        public boolean func_75069_d() {
            return this.field_191093_c;
        }
    }
}

