/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraft.client.AnvilConverterException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraft.world.storage.WorldSummary;

public interface ISaveFormat {
    public static final DateTimeFormatter field_197716_d = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('_').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral('-').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral('-').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();

    default public long func_197713_h(String string) throws IOException {
        final Path path = this.func_197714_g(string);
        String \u26032 = LocalDateTime.now().format(field_197716_d) + "_" + string;
        int \u26033 = 0;
        \u2603 = this.func_197712_e();
        try {
            Files.createDirectories(Files.exists(\u2603, new LinkOption[0]) ? \u2603.toRealPath(new LinkOption[0]) : \u2603, new FileAttribute[0]);
        }
        catch (IOException \u26034) {
            throw new RuntimeException(\u26034);
        }
        while (Files.exists(\u2603 = \u2603.resolve(\u26032 + (\u26033++ > 0 ? "_" + \u26033 : "") + ".zip"), new LinkOption[0])) {
        }
        try (final ZipOutputStream \u26035 = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(\u2603.toFile())));){
            \u2603 = Paths.get(string, new String[0]);
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path2, BasicFileAttributes basicFileAttributes) throws IOException {
                    String string = \u2603.resolve(path.relativize(path2)).toString();
                    ZipEntry \u26032 = new ZipEntry(string);
                    \u26035.putNextEntry(\u26032);
                    com.google.common.io.Files.asByteSource((File)path2.toFile()).copyTo((OutputStream)\u26035);
                    \u26035.closeEntry();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                    return this.visitFile((Path)object, basicFileAttributes);
                }
            });
            \u26035.close();
        }
        return Files.size(\u2603);
    }

    public String func_207741_a();

    public ISaveHandler func_197715_a(String var1, @Nullable MinecraftServer var2);

    public List<WorldSummary> func_75799_b() throws AnvilConverterException;

    public void func_75800_d();

    @Nullable
    public WorldInfo func_75803_c(String var1);

    public boolean func_207742_d(String var1);

    public boolean func_75802_e(String var1);

    public void func_75806_a(String var1, String var2);

    public boolean func_207743_a(String var1);

    public boolean func_75801_b(String var1);

    public boolean func_75805_a(String var1, IProgressUpdate var2);

    public boolean func_90033_f(String var1);

    public File func_186352_b(String var1, String var2);

    public Path func_197714_g(String var1);

    public Path func_197712_e();
}

