/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.storage.MapDecoration;

public class MapBanner {
    private final BlockPos field_204306_a;
    private final EnumDyeColor field_204307_b;
    @Nullable
    private final ITextComponent field_204308_c;

    public MapBanner(BlockPos blockPos, EnumDyeColor enumDyeColor, @Nullable ITextComponent iTextComponent) {
        this.field_204306_a = blockPos;
        this.field_204307_b = enumDyeColor;
        this.field_204308_c = iTextComponent;
    }

    public static MapBanner func_204300_a(NBTTagCompound nBTTagCompound) {
        BlockPos blockPos = NBTUtil.func_186861_c(nBTTagCompound.func_74775_l("Pos"));
        EnumDyeColor \u26032 = EnumDyeColor.func_204271_a(nBTTagCompound.func_74779_i("Color"));
        ITextComponent \u26033 = nBTTagCompound.func_74764_b("Name") ? ITextComponent.Serializer.func_150699_a(nBTTagCompound.func_74779_i("Name")) : null;
        return new MapBanner(blockPos, \u26032, \u26033);
    }

    @Nullable
    public static MapBanner func_204301_a(IBlockReader iBlockReader, BlockPos blockPos) {
        TileEntity tileEntity = iBlockReader.func_175625_s(blockPos);
        if (tileEntity instanceof TileEntityBanner) {
            TileEntityBanner tileEntityBanner = (TileEntityBanner)tileEntity;
            EnumDyeColor \u26032 = tileEntityBanner.func_195533_l(() -> iBlockReader.func_180495_p(blockPos));
            ITextComponent \u26033 = tileEntityBanner.func_145818_k_() ? tileEntityBanner.func_200201_e() : null;
            return new MapBanner(blockPos, \u26032, \u26033);
        }
        return null;
    }

    public BlockPos func_204304_a() {
        return this.field_204306_a;
    }

    public MapDecoration.Type func_204305_c() {
        switch (this.field_204307_b) {
            case WHITE: {
                return MapDecoration.Type.BANNER_WHITE;
            }
            case ORANGE: {
                return MapDecoration.Type.BANNER_ORANGE;
            }
            case MAGENTA: {
                return MapDecoration.Type.BANNER_MAGENTA;
            }
            case LIGHT_BLUE: {
                return MapDecoration.Type.BANNER_LIGHT_BLUE;
            }
            case YELLOW: {
                return MapDecoration.Type.BANNER_YELLOW;
            }
            case LIME: {
                return MapDecoration.Type.BANNER_LIME;
            }
            case PINK: {
                return MapDecoration.Type.BANNER_PINK;
            }
            case GRAY: {
                return MapDecoration.Type.BANNER_GRAY;
            }
            case LIGHT_GRAY: {
                return MapDecoration.Type.BANNER_LIGHT_GRAY;
            }
            case CYAN: {
                return MapDecoration.Type.BANNER_CYAN;
            }
            case PURPLE: {
                return MapDecoration.Type.BANNER_PURPLE;
            }
            case BLUE: {
                return MapDecoration.Type.BANNER_BLUE;
            }
            case BROWN: {
                return MapDecoration.Type.BANNER_BROWN;
            }
            case GREEN: {
                return MapDecoration.Type.BANNER_GREEN;
            }
            case RED: {
                return MapDecoration.Type.BANNER_RED;
            }
        }
        return MapDecoration.Type.BANNER_BLACK;
    }

    @Nullable
    public ITextComponent func_204302_d() {
        return this.field_204308_c;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MapBanner mapBanner = (MapBanner)object;
        return Objects.equals(this.field_204306_a, mapBanner.field_204306_a) && this.field_204307_b == mapBanner.field_204307_b && Objects.equals(this.field_204308_c, mapBanner.field_204308_c);
    }

    public int hashCode() {
        return Objects.hash(this.field_204306_a, this.field_204307_b, this.field_204308_c);
    }

    public NBTTagCompound func_204303_e() {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74782_a("Pos", NBTUtil.func_186859_a(this.field_204306_a));
        nBTTagCompound.func_74778_a("Color", this.field_204307_b.func_176762_d());
        if (this.field_204308_c != null) {
            nBTTagCompound.func_74778_a("Name", ITextComponent.Serializer.func_150696_a(this.field_204308_c));
        }
        return nBTTagCompound;
    }

    public String func_204299_f() {
        return "banner-" + this.field_204306_a.func_177958_n() + "," + this.field_204306_a.func_177956_o() + "," + this.field_204306_a.func_177952_p();
    }
}

