/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.google.common.collect.Lists;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixTypes;
import com.mojang.datafixers.DataFixer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.AnvilConverterException;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraft.world.storage.WorldSummary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SaveFormatOld
implements ISaveFormat {
    private static final Logger field_151479_b = LogManager.getLogger();
    protected final Path field_75808_a;
    protected final Path field_197717_b;
    protected final DataFixer field_186354_b;

    public SaveFormatOld(Path path, Path path2, DataFixer dataFixer) {
        this.field_186354_b = dataFixer;
        try {
            Files.createDirectories(Files.exists(path, new LinkOption[0]) ? path.toRealPath(new LinkOption[0]) : path, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.field_75808_a = path;
        this.field_197717_b = path2;
    }

    @Override
    public String func_207741_a() {
        return "Old Format";
    }

    @Override
    public List<WorldSummary> func_75799_b() throws AnvilConverterException {
        ArrayList arrayList = Lists.newArrayList();
        for (int i = 0; i < 5; ++i) {
            String string = "World" + (i + 1);
            WorldInfo \u26032 = this.func_75803_c(string);
            if (\u26032 == null) continue;
            arrayList.add(new WorldSummary(\u26032, string, "", \u26032.func_76092_g(), false));
        }
        return arrayList;
    }

    @Override
    public void func_75800_d() {
    }

    @Override
    @Nullable
    public WorldInfo func_75803_c(String string) {
        File file = new File(this.field_75808_a.toFile(), string);
        if (!file.exists()) {
            return null;
        }
        \u2603 = new File(file, "level.dat");
        if (\u2603.exists() && (\u2603 = SaveFormatOld.func_186353_a(\u2603, this.field_186354_b)) != null) {
            return \u2603;
        }
        \u2603 = new File(file, "level.dat_old");
        if (\u2603.exists()) {
            return SaveFormatOld.func_186353_a(\u2603, this.field_186354_b);
        }
        return null;
    }

    @Nullable
    public static WorldInfo func_186353_a(File file, DataFixer dataFixer) {
        try {
            NBTTagCompound nBTTagCompound = CompressedStreamTools.func_74796_a(new FileInputStream(file));
            \u2603 = nBTTagCompound.func_74775_l("Data");
            \u2603 = \u2603.func_150297_b("Player", 10) ? \u2603.func_74775_l("Player") : null;
            \u2603.func_82580_o("Player");
            int \u26032 = \u2603.func_150297_b("DataVersion", 99) ? \u2603.func_74762_e("DataVersion") : -1;
            return new WorldInfo(NBTUtil.func_210822_a(dataFixer, (DSL.TypeReference)DataFixTypes.LEVEL, \u2603, \u26032), dataFixer, \u26032, \u2603);
        }
        catch (Exception exception) {
            field_151479_b.error("Exception reading {}", (Object)file, (Object)exception);
            return null;
        }
    }

    @Override
    public void func_75806_a(String string, String string2) {
        File file = new File(this.field_75808_a.toFile(), string);
        if (!file.exists()) {
            return;
        }
        \u2603 = new File(file, "level.dat");
        if (\u2603.exists()) {
            try {
                NBTTagCompound nBTTagCompound = CompressedStreamTools.func_74796_a(new FileInputStream(\u2603));
                \u2603 = nBTTagCompound.func_74775_l("Data");
                \u2603.func_74778_a("LevelName", string2);
                CompressedStreamTools.func_74799_a(nBTTagCompound, new FileOutputStream(\u2603));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public boolean func_207742_d(String string) {
        File file = new File(this.field_75808_a.toFile(), string);
        if (file.exists()) {
            return false;
        }
        try {
            file.mkdir();
            file.delete();
        }
        catch (Throwable \u26032) {
            field_151479_b.warn("Couldn't make new level", \u26032);
            return false;
        }
        return true;
    }

    @Override
    public boolean func_75802_e(String string) {
        File file = new File(this.field_75808_a.toFile(), string);
        if (!file.exists()) {
            return true;
        }
        field_151479_b.info("Deleting level {}", (Object)string);
        for (int i = 1; i <= 5; ++i) {
            field_151479_b.info("Attempt {}...", (Object)i);
            if (SaveFormatOld.func_75807_a(file.listFiles())) break;
            field_151479_b.warn("Unsuccessful in deleting contents.");
            if (i >= 5) continue;
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return file.delete();
    }

    protected static boolean func_75807_a(File[] fileArray) {
        for (File file : fileArray) {
            field_151479_b.debug("Deleting {}", (Object)file);
            if (file.isDirectory() && !SaveFormatOld.func_75807_a(file.listFiles())) {
                field_151479_b.warn("Couldn't delete directory {}", (Object)file);
                return false;
            }
            if (file.delete()) continue;
            field_151479_b.warn("Couldn't delete file {}", (Object)file);
            return false;
        }
        return true;
    }

    @Override
    public ISaveHandler func_197715_a(String string, @Nullable MinecraftServer minecraftServer) {
        return new SaveHandler(this.field_75808_a.toFile(), string, minecraftServer, this.field_186354_b);
    }

    @Override
    public boolean func_207743_a(String string) {
        return false;
    }

    @Override
    public boolean func_75801_b(String string) {
        return false;
    }

    @Override
    public boolean func_75805_a(String string, IProgressUpdate iProgressUpdate) {
        return false;
    }

    @Override
    public boolean func_90033_f(String string) {
        return Files.isDirectory(this.field_75808_a.resolve(string), new LinkOption[0]);
    }

    @Override
    public File func_186352_b(String string, String string2) {
        return this.field_75808_a.resolve(string).resolve(string2).toFile();
    }

    @Override
    public Path func_197714_g(String string) {
        return this.field_75808_a.resolve(string);
    }

    @Override
    public Path func_197712_e() {
        return this.field_197717_b;
    }
}

