/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootTableManager
implements IResourceManagerReloadListener {
    private static final Logger field_186525_a = LogManager.getLogger();
    private static final Gson field_186526_b = new GsonBuilder().registerTypeAdapter(RandomValueRange.class, (Object)new RandomValueRange.Serializer()).registerTypeAdapter(LootPool.class, (Object)new LootPool.Serializer()).registerTypeAdapter(LootTable.class, (Object)new LootTable.Serializer()).registerTypeHierarchyAdapter(LootEntry.class, (Object)new LootEntry.Serializer()).registerTypeHierarchyAdapter(LootFunction.class, (Object)new LootFunctionManager.Serializer()).registerTypeHierarchyAdapter(LootCondition.class, (Object)new LootConditionManager.Serializer()).registerTypeHierarchyAdapter(LootContext.EntityTarget.class, (Object)new LootContext.EntityTarget.Serializer()).create();
    private final Map<ResourceLocation, LootTable> field_186527_c = Maps.newHashMap();
    public static final int field_195435_a = "loot_tables/".length();
    public static final int field_195436_b = ".json".length();

    public LootTable func_186521_a(ResourceLocation resourceLocation) {
        return this.field_186527_c.getOrDefault(resourceLocation, LootTable.field_186464_a);
    }

    @Override
    public void func_195410_a(IResourceManager iResourceManager) {
        this.field_186527_c.clear();
        for (ResourceLocation resourceLocation : iResourceManager.func_199003_a("loot_tables", string -> string.endsWith(".json"))) {
            String string2 = resourceLocation.func_110623_a();
            ResourceLocation \u26032 = new ResourceLocation(resourceLocation.func_110624_b(), string2.substring(field_195435_a, string2.length() - field_195436_b));
            try {
                IResource iResource = iResourceManager.func_199002_a(resourceLocation);
                Throwable throwable = null;
                try {
                    LootTable lootTable = JsonUtils.func_188178_a(field_186526_b, IOUtils.toString((InputStream)iResource.func_199027_b(), (Charset)StandardCharsets.UTF_8), LootTable.class);
                    if (lootTable == null) continue;
                    this.field_186527_c.put(\u26032, lootTable);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (iResource == null) continue;
                    if (throwable != null) {
                        try {
                            iResource.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    iResource.close();
                }
            }
            catch (Throwable throwable) {
                field_186525_a.error("Couldn't read loot table {} from {}", (Object)\u26032, (Object)resourceLocation, (Object)throwable);
            }
        }
    }
}

