/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot.functions;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.Map;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.EnchantRandomly;
import net.minecraft.world.storage.loot.functions.EnchantWithLevels;
import net.minecraft.world.storage.loot.functions.ExplorationMap;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootingEnchantBonus;
import net.minecraft.world.storage.loot.functions.SetAttributes;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetDamage;
import net.minecraft.world.storage.loot.functions.SetNBT;
import net.minecraft.world.storage.loot.functions.SetName;
import net.minecraft.world.storage.loot.functions.Smelt;

public class LootFunctionManager {
    private static final Map<ResourceLocation, LootFunction.Serializer<?>> field_186584_a = Maps.newHashMap();
    private static final Map<Class<? extends LootFunction>, LootFunction.Serializer<?>> field_186585_b = Maps.newHashMap();

    public static <T extends LootFunction> void func_186582_a(LootFunction.Serializer<? extends T> serializer) {
        ResourceLocation resourceLocation = serializer.func_186529_a();
        Class<T> \u26032 = serializer.func_186531_b();
        if (field_186584_a.containsKey(resourceLocation)) {
            throw new IllegalArgumentException("Can't re-register item function name " + resourceLocation);
        }
        if (field_186585_b.containsKey(\u26032)) {
            throw new IllegalArgumentException("Can't re-register item function class " + \u26032.getName());
        }
        field_186584_a.put(resourceLocation, serializer);
        field_186585_b.put(\u26032, serializer);
    }

    public static LootFunction.Serializer<?> func_186583_a(ResourceLocation resourceLocation) {
        LootFunction.Serializer<?> serializer = field_186584_a.get(resourceLocation);
        if (serializer == null) {
            throw new IllegalArgumentException("Unknown loot item function '" + resourceLocation + "'");
        }
        return serializer;
    }

    public static <T extends LootFunction> LootFunction.Serializer<T> func_186581_a(T t) {
        LootFunction.Serializer<?> serializer = field_186585_b.get(t.getClass());
        if (serializer == null) {
            throw new IllegalArgumentException("Unknown loot item function " + t);
        }
        return serializer;
    }

    static {
        LootFunctionManager.func_186582_a(new SetCount.Serializer());
        LootFunctionManager.func_186582_a(new EnchantWithLevels.Serializer());
        LootFunctionManager.func_186582_a(new EnchantRandomly.Serializer());
        LootFunctionManager.func_186582_a(new SetNBT.Serializer());
        LootFunctionManager.func_186582_a(new Smelt.Serializer());
        LootFunctionManager.func_186582_a(new LootingEnchantBonus.Serializer());
        LootFunctionManager.func_186582_a(new SetDamage.Serializer());
        LootFunctionManager.func_186582_a(new SetAttributes.Serializer());
        LootFunctionManager.func_186582_a(new SetName.Serializer());
        LootFunctionManager.func_186582_a(new ExplorationMap.Serializer());
    }

    public static class Serializer
    implements JsonDeserializer<LootFunction>,
    JsonSerializer<LootFunction> {
        public LootFunction deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject jsonObject = JsonUtils.func_151210_l(jsonElement, "function");
            ResourceLocation \u26032 = new ResourceLocation(JsonUtils.func_151200_h(jsonObject, "function"));
            try {
                LootFunction.Serializer<?> serializer = LootFunctionManager.func_186583_a(\u26032);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new JsonSyntaxException("Unknown function '" + \u26032 + "'");
            }
            return serializer.func_186530_b(jsonObject, jsonDeserializationContext, JsonUtils.func_188177_a(jsonObject, "conditions", new LootCondition[0], jsonDeserializationContext, LootCondition[].class));
        }

        public JsonElement serialize(LootFunction lootFunction, Type type, JsonSerializationContext jsonSerializationContext) {
            LootFunction.Serializer<LootFunction> serializer = LootFunctionManager.func_186581_a(lootFunction);
            JsonObject \u26032 = new JsonObject();
            serializer.func_186532_a(\u26032, lootFunction, jsonSerializationContext);
            \u26032.addProperty("function", serializer.func_186529_a().toString());
            if (lootFunction.func_186554_a() != null && lootFunction.func_186554_a().length > 0) {
                \u26032.add("conditions", jsonSerializationContext.serialize((Object)lootFunction.func_186554_a()));
            }
            return \u26032;
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.serialize((LootFunction)object, type, jsonSerializationContext);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

