/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot.functions;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SetAttributes
extends LootFunction {
    private static final Logger field_186560_a = LogManager.getLogger();
    private final Modifier[] field_186561_b;

    public SetAttributes(LootCondition[] lootConditionArray, Modifier[] modifierArray) {
        super(lootConditionArray);
        this.field_186561_b = modifierArray;
    }

    @Override
    public ItemStack func_186553_a(ItemStack itemStack, Random random, LootContext lootContext) {
        for (Modifier modifier : this.field_186561_b) {
            UUID uUID = modifier.field_186600_e;
            if (uUID == null) {
                uUID = UUID.randomUUID();
            }
            EntityEquipmentSlot \u26032 = modifier.field_186601_f[random.nextInt(modifier.field_186601_f.length)];
            itemStack.func_185129_a(modifier.field_186597_b, new AttributeModifier(uUID, modifier.field_186596_a, (double)modifier.field_186599_d.func_186507_b(random), modifier.field_186598_c), \u26032);
        }
        return itemStack;
    }

    static class Modifier {
        private final String field_186596_a;
        private final String field_186597_b;
        private final int field_186598_c;
        private final RandomValueRange field_186599_d;
        @Nullable
        private final UUID field_186600_e;
        private final EntityEquipmentSlot[] field_186601_f;

        private Modifier(String string, String string2, int n, RandomValueRange randomValueRange, EntityEquipmentSlot[] entityEquipmentSlotArray, @Nullable UUID uUID) {
            this.field_186596_a = string;
            this.field_186597_b = string2;
            this.field_186598_c = n;
            this.field_186599_d = randomValueRange;
            this.field_186600_e = uUID;
            this.field_186601_f = entityEquipmentSlotArray;
        }

        public JsonObject func_186592_a(JsonSerializationContext jsonSerializationContext) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("name", this.field_186596_a);
            jsonObject.addProperty("attribute", this.field_186597_b);
            jsonObject.addProperty("operation", Modifier.func_186594_a(this.field_186598_c));
            jsonObject.add("amount", jsonSerializationContext.serialize((Object)this.field_186599_d));
            if (this.field_186600_e != null) {
                jsonObject.addProperty("id", this.field_186600_e.toString());
            }
            if (this.field_186601_f.length == 1) {
                jsonObject.addProperty("slot", this.field_186601_f[0].func_188450_d());
            } else {
                JsonArray jsonArray = new JsonArray();
                for (EntityEquipmentSlot entityEquipmentSlot : this.field_186601_f) {
                    jsonArray.add((JsonElement)new JsonPrimitive(entityEquipmentSlot.func_188450_d()));
                }
                jsonObject.add("slot", (JsonElement)jsonArray);
            }
            return jsonObject;
        }

        public static Modifier func_186586_a(JsonObject jsonObject2, JsonDeserializationContext jsonDeserializationContext) {
            Object object;
            JsonObject jsonObject2;
            EntityEquipmentSlot[] \u26035;
            String string = JsonUtils.func_151200_h(jsonObject2, "name");
            \u2603 = JsonUtils.func_151200_h(jsonObject2, "attribute");
            int \u26032 = Modifier.func_186595_a(JsonUtils.func_151200_h(jsonObject2, "operation"));
            RandomValueRange \u26033 = JsonUtils.func_188174_a(jsonObject2, "amount", jsonDeserializationContext, RandomValueRange.class);
            UUID \u26034 = null;
            if (JsonUtils.func_151205_a(jsonObject2, "slot")) {
                \u26035 = new EntityEquipmentSlot[]{EntityEquipmentSlot.func_188451_a(JsonUtils.func_151200_h(jsonObject2, "slot"))};
            } else if (JsonUtils.func_151202_d(jsonObject2, "slot")) {
                object = JsonUtils.func_151214_t(jsonObject2, "slot");
                \u26035 = new EntityEquipmentSlot[object.size()];
                int \u26036 = 0;
                for (JsonElement jsonElement : object) {
                    \u26035[\u26036++] = EntityEquipmentSlot.func_188451_a(JsonUtils.func_151206_a(jsonElement, "slot"));
                }
                if (\u26035.length == 0) {
                    throw new JsonSyntaxException("Invalid attribute modifier slot; must contain at least one entry.");
                }
            } else {
                throw new JsonSyntaxException("Invalid or missing attribute modifier slot; must be either string or array of strings.");
            }
            if (jsonObject2.has("id")) {
                object = JsonUtils.func_151200_h(jsonObject2, "id");
                try {
                    \u26034 = UUID.fromString((String)object);
                }
                catch (IllegalArgumentException \u26037) {
                    throw new JsonSyntaxException("Invalid attribute modifier id '" + (String)object + "' (must be UUID format, with dashes)");
                }
            }
            return new Modifier(string, \u2603, \u26032, \u26033, \u26035, \u26034);
        }

        private static String func_186594_a(int n) {
            switch (n) {
                case 0: {
                    return "addition";
                }
                case 1: {
                    return "multiply_base";
                }
                case 2: {
                    return "multiply_total";
                }
            }
            throw new IllegalArgumentException("Unknown operation " + n);
        }

        private static int func_186595_a(String string) {
            if ("addition".equals(string)) {
                return 0;
            }
            if ("multiply_base".equals(string)) {
                return 1;
            }
            if ("multiply_total".equals(string)) {
                return 2;
            }
            throw new JsonSyntaxException("Unknown attribute modifier operation " + string);
        }
    }

    public static class Serializer
    extends LootFunction.Serializer<SetAttributes> {
        public Serializer() {
            super(new ResourceLocation("set_attributes"), SetAttributes.class);
        }

        @Override
        public void func_186532_a(JsonObject jsonObject2, SetAttributes setAttributes, JsonSerializationContext jsonSerializationContext) {
            JsonObject jsonObject2;
            JsonArray jsonArray = new JsonArray();
            for (Modifier modifier : setAttributes.field_186561_b) {
                jsonArray.add((JsonElement)modifier.func_186592_a(jsonSerializationContext));
            }
            jsonObject2.add("modifiers", (JsonElement)jsonArray);
        }

        @Override
        public SetAttributes func_186530_b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootCondition[] lootConditionArray2) {
            LootCondition[] lootConditionArray2;
            JsonArray jsonArray = JsonUtils.func_151214_t(jsonObject, "modifiers");
            Modifier[] \u26032 = new Modifier[jsonArray.size()];
            int \u26033 = 0;
            for (JsonElement jsonElement : jsonArray) {
                \u26032[\u26033++] = Modifier.func_186586_a(JsonUtils.func_151210_l(jsonElement, "modifier"), jsonDeserializationContext);
            }
            if (\u26032.length == 0) {
                throw new JsonSyntaxException("Invalid attribute modifiers array; cannot be empty");
            }
            return new SetAttributes(lootConditionArray2, \u26032);
        }

        @Override
        public /* synthetic */ LootFunction func_186530_b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootCondition[] lootConditionArray) {
            return this.func_186530_b(jsonObject, jsonDeserializationContext, lootConditionArray);
        }
    }
}

