/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class BlockCocoa
extends BlockHorizontal
implements IGrowable {
    public static final IntegerProperty field_176501_a = BlockStateProperties.field_208167_T;
    protected static final VoxelShape[] field_185535_b = new VoxelShape[]{Block.func_208617_a(11.0, 7.0, 6.0, 15.0, 12.0, 10.0), Block.func_208617_a(9.0, 5.0, 5.0, 15.0, 12.0, 11.0), Block.func_208617_a(7.0, 3.0, 4.0, 15.0, 12.0, 12.0)};
    protected static final VoxelShape[] field_185536_c = new VoxelShape[]{Block.func_208617_a(1.0, 7.0, 6.0, 5.0, 12.0, 10.0), Block.func_208617_a(1.0, 5.0, 5.0, 7.0, 12.0, 11.0), Block.func_208617_a(1.0, 3.0, 4.0, 9.0, 12.0, 12.0)};
    protected static final VoxelShape[] field_185537_d = new VoxelShape[]{Block.func_208617_a(6.0, 7.0, 1.0, 10.0, 12.0, 5.0), Block.func_208617_a(5.0, 5.0, 1.0, 11.0, 12.0, 7.0), Block.func_208617_a(4.0, 3.0, 1.0, 12.0, 12.0, 9.0)};
    protected static final VoxelShape[] field_185538_e = new VoxelShape[]{Block.func_208617_a(6.0, 7.0, 11.0, 10.0, 12.0, 15.0), Block.func_208617_a(5.0, 5.0, 9.0, 11.0, 12.0, 15.0), Block.func_208617_a(4.0, 3.0, 7.0, 12.0, 12.0, 15.0)};

    public BlockCocoa(Block.Properties builder) {
        super(builder);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_185512_D, (Comparable)((Object)EnumFacing.NORTH))).func_206870_a((IProperty)field_176501_a, Integer.valueOf(0)));
    }

    public void func_196267_b(IBlockState state, World worldIn, BlockPos pos, Random random) {
        int i = (Integer)state.func_177229_b((IProperty)field_176501_a);
        if (i < 2 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (worldIn.field_73012_v.nextInt(5) == 0 ? 1 : 0) != 0)) {
            worldIn.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)field_176501_a, Integer.valueOf(i + 1)), 2);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state);
        }
    }

    public boolean func_196260_a(IBlockState state, IWorldReaderBase worldIn, BlockPos pos) {
        Block block = worldIn.func_180495_p(pos.func_177972_a((EnumFacing)((Object)state.func_177229_b((IProperty)field_185512_D)))).func_177230_c();
        return block.func_203417_a(BlockTags.field_203289_r);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        int i = (Integer)state.func_177229_b((IProperty)field_176501_a);
        switch ((EnumFacing)((Object)state.func_177229_b((IProperty)field_185512_D))) {
            case SOUTH: {
                return field_185538_e[i];
            }
            default: {
                return field_185537_d[i];
            }
            case WEST: {
                return field_185536_c[i];
            }
            case EAST: 
        }
        return field_185535_b[i];
    }

    @Nullable
    public IBlockState func_196258_a(BlockItemUseContext context) {
        IBlockState iblockstate = this.func_176223_P();
        World iworldreaderbase = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        for (EnumFacing enumfacing : context.func_196009_e()) {
            if (!enumfacing.func_176740_k().func_176722_c() || !(iblockstate = (IBlockState)iblockstate.func_206870_a((IProperty)field_185512_D, (Comparable)((Object)enumfacing))).func_196955_c(iworldreaderbase, blockpos)) continue;
            return iblockstate;
        }
        return null;
    }

    public IBlockState func_196271_a(IBlockState stateIn, EnumFacing facing, IBlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing == stateIn.func_177229_b((IProperty)field_185512_D) && !stateIn.func_196955_c(worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_196255_a(IBlockState state, World worldIn, BlockPos pos, float chancePerItem, int fortune) {
        super.func_196255_a(state, worldIn, pos, chancePerItem, fortune);
    }

    public void getDrops(IBlockState state, NonNullList<ItemStack> drops, World world, BlockPos pos, int fortune) {
        super.getDrops(state, drops, world, pos, fortune);
        int i = (Integer)state.func_177229_b((IProperty)field_176501_a);
        int j = 1;
        if (i >= 2) {
            j = 3;
        }
        for (int k = 0; k < j; ++k) {
            drops.add((Object)new ItemStack(Items.field_196130_bo));
        }
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(Items.field_196130_bo);
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((IProperty)field_176501_a) < 2;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        worldIn.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)field_176501_a, Integer.valueOf((Integer)state.func_177229_b((IProperty)field_176501_a) + 1)), 2);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_185512_D, field_176501_a});
    }

    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

