/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.Particles;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IShearable;

public class BlockLeaves
extends Block
implements IShearable {
    public static final IntegerProperty field_208494_a = BlockStateProperties.field_208514_aa;
    public static final BooleanProperty field_208495_b = BlockStateProperties.field_208515_s;
    protected static boolean field_196478_c;

    public BlockLeaves(Block.Properties builder) {
        super(builder);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_208494_a, Integer.valueOf(7))).func_206870_a((IProperty)field_208495_b, Boolean.valueOf(false)));
    }

    @Override
    public boolean func_149653_t(IBlockState p_149653_1_) {
        return (Integer)p_149653_1_.func_177229_b((IProperty)field_208494_a) == 7 && (Boolean)p_149653_1_.func_177229_b((IProperty)field_208495_b) == false;
    }

    @Override
    public void func_196265_a(IBlockState state, World worldIn, BlockPos pos, Random random) {
        if (!((Boolean)state.func_177229_b((IProperty)field_208495_b)).booleanValue() && (Integer)state.func_177229_b((IProperty)field_208494_a) == 7) {
            state.func_196949_c(worldIn, pos, 0);
            worldIn.func_175698_g(pos);
        }
    }

    @Override
    public void func_196267_b(IBlockState state, World worldIn, BlockPos pos, Random random) {
        worldIn.func_180501_a(pos, BlockLeaves.func_208493_b(state, worldIn, pos), 3);
    }

    @Override
    public int func_200011_d(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1;
    }

    @Override
    public IBlockState func_196271_a(IBlockState stateIn, EnumFacing facing, IBlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        int i = BlockLeaves.func_208492_w(facingState) + 1;
        if (i != 1 || (Integer)stateIn.func_177229_b((IProperty)field_208494_a) != i) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return stateIn;
    }

    private static IBlockState func_208493_b(IBlockState p_208493_0_, IWorld p_208493_1_, BlockPos p_208493_2_) {
        int i = 7;
        try (BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();){
            for (EnumFacing enumfacing : EnumFacing.values()) {
                blockpos$pooledmutableblockpos.func_189533_g((Vec3i)p_208493_2_).func_189536_c(enumfacing);
                i = Math.min(i, BlockLeaves.func_208492_w(p_208493_1_.func_180495_p((BlockPos)blockpos$pooledmutableblockpos)) + 1);
                if (i != 1) continue;
                break;
            }
        }
        return (IBlockState)p_208493_0_.func_206870_a((IProperty)field_208494_a, Integer.valueOf(i));
    }

    private static int func_208492_w(IBlockState neighbor) {
        if (BlockTags.field_200031_h.func_199685_a_(neighbor.func_177230_c())) {
            return 0;
        }
        return neighbor.func_177230_c() instanceof BlockLeaves ? (Integer)neighbor.func_177229_b((IProperty)field_208494_a) : 7;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (worldIn.func_175727_C(pos.func_177984_a()) && !worldIn.func_180495_p(pos.func_177977_b()).func_185896_q() && rand.nextInt(15) == 1) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (double)pos.func_177956_o() - 0.05;
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            worldIn.func_195594_a((IParticleData)Particles.field_197618_k, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public int func_196264_a(IBlockState state, Random random) {
        return random.nextInt(20) == 0 ? 1 : 0;
    }

    @Override
    public IItemProvider func_199769_a(IBlockState state, World worldIn, BlockPos pos, int fortune) {
        Block block = state.func_177230_c();
        if (block == Blocks.field_196642_W) {
            return Blocks.field_196674_t;
        }
        if (block == Blocks.field_196645_X) {
            return Blocks.field_196675_u;
        }
        if (block == Blocks.field_196647_Y) {
            return Blocks.field_196676_v;
        }
        if (block == Blocks.field_196648_Z) {
            return Blocks.field_196678_w;
        }
        if (block == Blocks.field_196572_aa) {
            return Blocks.field_196679_x;
        }
        return block == Blocks.field_196574_ab ? Blocks.field_196680_y : Blocks.field_196674_t;
    }

    @Override
    public void func_196255_a(IBlockState state, World worldIn, BlockPos pos, float chancePerItem, int fortune) {
        super.func_196255_a(state, worldIn, pos, chancePerItem, fortune);
    }

    public void getDrops(IBlockState state, NonNullList<ItemStack> drops, World worldIn, BlockPos pos, int fortune) {
        ItemStack drop;
        int i = this.func_196472_i(state);
        if (fortune > 0 && (i -= 2 << fortune) < 10) {
            i = 10;
        }
        if (worldIn.field_73012_v.nextInt(i) == 0 && !(drop = new ItemStack(this.func_199769_a(state, worldIn, pos, fortune))).func_190926_b()) {
            drops.add((Object)drop);
        }
        i = 200;
        if (fortune > 0 && (i -= 10 << fortune) < 40) {
            i = 40;
        }
        this.captureDrops(true);
        this.func_196474_a(worldIn, pos, state, i);
        drops.addAll(this.captureDrops(false));
    }

    protected void func_196474_a(World p_196474_1_, BlockPos p_196474_2_, IBlockState p_196474_3_, int p_196474_4_) {
        if ((p_196474_3_.func_177230_c() == Blocks.field_196642_W || p_196474_3_.func_177230_c() == Blocks.field_196574_ab) && p_196474_1_.field_73012_v.nextInt(p_196474_4_) == 0) {
            BlockLeaves.func_180635_a(p_196474_1_, p_196474_2_, new ItemStack(Items.field_151034_e));
        }
    }

    protected int func_196472_i(IBlockState p_196472_1_) {
        return p_196472_1_.func_177230_c() == Blocks.field_196648_Z ? 40 : 20;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void func_196475_b(boolean fancy) {
        field_196478_c = fancy;
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return field_196478_c ? BlockRenderLayer.CUTOUT_MIPPED : BlockRenderLayer.SOLID;
    }

    @Override
    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    @Override
    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_208494_a, field_208495_b});
    }

    @Override
    public IBlockState func_196258_a(BlockItemUseContext context) {
        return BlockLeaves.func_208493_b((IBlockState)this.func_176223_P().func_206870_a((IProperty)field_208495_b, Boolean.valueOf(true)), context.func_195991_k(), context.func_195995_a());
    }

    public List<ItemStack> onSheared(@Nonnull ItemStack item, IWorld world, BlockPos pos, int fortune) {
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11);
        return Arrays.asList(new ItemStack(this));
    }
}

