/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.cache.LoadingCache;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.init.Blocks;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class BlockPortal
extends Block {
    public static final EnumProperty<EnumFacing.Axis> field_176550_a = BlockStateProperties.field_208199_z;
    protected static final VoxelShape field_185683_b = Block.func_208617_a(0.0, 0.0, 6.0, 16.0, 16.0, 10.0);
    protected static final VoxelShape field_185684_c = Block.func_208617_a(6.0, 0.0, 0.0, 10.0, 16.0, 16.0);

    public BlockPortal(Block.Properties builder) {
        super(builder);
        this.func_180632_j((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_176550_a, (Comparable)((Object)EnumFacing.Axis.X)));
    }

    @Override
    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        switch ((EnumFacing.Axis)((Object)state.func_177229_b((IProperty)field_176550_a))) {
            case Z: {
                return field_185684_c;
            }
        }
        return field_185683_b;
    }

    @Override
    public void func_196267_b(IBlockState state, World worldIn, BlockPos pos, Random random) {
        if (worldIn.field_73011_w.func_76569_d() && worldIn.func_82736_K().func_82766_b("doMobSpawning") && random.nextInt(2000) < worldIn.func_175659_aa().func_151525_a()) {
            EntityPigZombie entity;
            int i = pos.func_177956_o();
            BlockPos blockpos = pos;
            while (!worldIn.func_180495_p(blockpos).func_185896_q() && blockpos.func_177956_o() > 0) {
                blockpos = blockpos.func_177977_b();
            }
            if (i > 0 && !worldIn.func_180495_p(blockpos.func_177984_a()).func_185915_l() && (entity = EntityType.field_200785_Y.func_208050_a(worldIn, null, null, null, blockpos.func_177984_a(), false, false)) != null) {
                entity.field_71088_bW = entity.func_82147_ab();
            }
        }
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176548_d(IWorld worldIn, BlockPos pos) {
        Size blockportal$size = this.func_201816_b(worldIn, pos);
        if (blockportal$size != null && !ForgeEventFactory.onTrySpawnPortal((IWorld)worldIn, (BlockPos)pos, (Size)blockportal$size)) {
            blockportal$size.func_150859_c();
            return true;
        }
        return false;
    }

    @Nullable
    public Size func_201816_b(IWorld p_201816_1_, BlockPos p_201816_2_) {
        Size blockportal$size = new Size(p_201816_1_, p_201816_2_, EnumFacing.Axis.X);
        if (blockportal$size.func_150860_b() && blockportal$size.field_150864_e == 0) {
            return blockportal$size;
        }
        Size blockportal$size1 = new Size(p_201816_1_, p_201816_2_, EnumFacing.Axis.Z);
        return blockportal$size1.func_150860_b() && blockportal$size1.field_150864_e == 0 ? blockportal$size1 : null;
    }

    @Override
    public IBlockState func_196271_a(IBlockState stateIn, EnumFacing facing, IBlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        EnumFacing.Axis enumfacing$axis = facing.func_176740_k();
        EnumFacing.Axis enumfacing$axis1 = (EnumFacing.Axis)((Object)stateIn.func_177229_b((IProperty)field_176550_a));
        boolean flag = enumfacing$axis1 != enumfacing$axis && enumfacing$axis.func_176722_c();
        return !flag && facingState.func_177230_c() != this && !new Size(worldIn, currentPos, enumfacing$axis1).func_208508_f() ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    public int func_196264_a(IBlockState state, Random random) {
        return 0;
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    public void func_196262_a(IBlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!entityIn.func_184218_aH() && !entityIn.func_184207_aI() && entityIn.func_184222_aU()) {
            entityIn.func_181015_d(pos);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(100) == 0) {
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187810_eg, SoundCategory.BLOCKS, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (float)pos.func_177956_o() + rand.nextFloat();
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
            int j = rand.nextInt(2) * 2 - 1;
            if (worldIn.func_180495_p(pos.func_177976_e()).func_177230_c() != this && worldIn.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
                d0 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
                d3 = rand.nextFloat() * 2.0f * (float)j;
            } else {
                d2 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)j;
                d5 = rand.nextFloat() * 2.0f * (float)j;
            }
            worldIn.func_195594_a((IParticleData)Particles.field_197599_J, d0, d1, d2, d3, d4, d5);
        }
    }

    @Override
    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, IBlockState state) {
        return ItemStack.field_190927_a;
    }

    @Override
    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((EnumFacing.Axis)((Object)state.func_177229_b((IProperty)field_176550_a))) {
                    case Z: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176550_a, (Comparable)((Object)EnumFacing.Axis.X));
                    }
                    case X: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176550_a, (Comparable)((Object)EnumFacing.Axis.Z));
                    }
                }
                return state;
            }
        }
        return state;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_176550_a});
    }

    public BlockPattern.PatternHelper func_181089_f(IWorld worldIn, BlockPos p_181089_2_) {
        EnumFacing.Axis enumfacing$axis = EnumFacing.Axis.Z;
        Size blockportal$size = new Size(worldIn, p_181089_2_, EnumFacing.Axis.X);
        LoadingCache loadingcache = BlockPattern.func_181627_a((IWorldReaderBase)worldIn, (boolean)true);
        if (!blockportal$size.func_150860_b()) {
            enumfacing$axis = EnumFacing.Axis.X;
            blockportal$size = new Size(worldIn, p_181089_2_, EnumFacing.Axis.Z);
        }
        if (!blockportal$size.func_150860_b()) {
            return new BlockPattern.PatternHelper(p_181089_2_, EnumFacing.NORTH, EnumFacing.UP, loadingcache, 1, 1, 1);
        }
        int[] aint = new int[EnumFacing.AxisDirection.values().length];
        EnumFacing enumfacing = blockportal$size.field_150866_c.func_176735_f();
        BlockPos blockpos = blockportal$size.field_150861_f.func_177981_b(blockportal$size.func_181100_a() - 1);
        for (EnumFacing.AxisDirection enumfacing$axisdirection : EnumFacing.AxisDirection.values()) {
            BlockPattern.PatternHelper blockpattern$patternhelper = new BlockPattern.PatternHelper(enumfacing.func_176743_c() == enumfacing$axisdirection ? blockpos : blockpos.func_177967_a(blockportal$size.field_150866_c, blockportal$size.func_181101_b() - 1), EnumFacing.func_181076_a(enumfacing$axisdirection, enumfacing$axis), EnumFacing.UP, loadingcache, blockportal$size.func_181101_b(), blockportal$size.func_181100_a(), 1);
            for (int i = 0; i < blockportal$size.func_181101_b(); ++i) {
                for (int j = 0; j < blockportal$size.func_181100_a(); ++j) {
                    BlockWorldState blockworldstate = blockpattern$patternhelper.func_177670_a(i, j, 1);
                    if (blockworldstate.func_177509_a().func_196958_f()) continue;
                    int n = enumfacing$axisdirection.ordinal();
                    aint[n] = aint[n] + 1;
                }
            }
        }
        EnumFacing.AxisDirection enumfacing$axisdirection1 = EnumFacing.AxisDirection.POSITIVE;
        for (EnumFacing.AxisDirection enumfacing$axisdirection2 : EnumFacing.AxisDirection.values()) {
            if (aint[enumfacing$axisdirection2.ordinal()] >= aint[enumfacing$axisdirection1.ordinal()]) continue;
            enumfacing$axisdirection1 = enumfacing$axisdirection2;
        }
        return new BlockPattern.PatternHelper(enumfacing.func_176743_c() == enumfacing$axisdirection1 ? blockpos : blockpos.func_177967_a(blockportal$size.field_150866_c, blockportal$size.func_181101_b() - 1), EnumFacing.func_181076_a(enumfacing$axisdirection1, enumfacing$axis), EnumFacing.UP, loadingcache, blockportal$size.func_181101_b(), blockportal$size.func_181100_a(), 1);
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public static class Size {
        private final IWorld field_150867_a;
        private final EnumFacing.Axis field_150865_b;
        private final EnumFacing field_150866_c;
        private final EnumFacing field_150863_d;
        private int field_150864_e;
        private BlockPos field_150861_f;
        private int field_150862_g;
        private int field_150868_h;

        public Size(IWorld p_i48740_1_, BlockPos p_i48740_2_, EnumFacing.Axis p_i48740_3_) {
            this.field_150867_a = p_i48740_1_;
            this.field_150865_b = p_i48740_3_;
            if (p_i48740_3_ == EnumFacing.Axis.X) {
                this.field_150863_d = EnumFacing.EAST;
                this.field_150866_c = EnumFacing.WEST;
            } else {
                this.field_150863_d = EnumFacing.NORTH;
                this.field_150866_c = EnumFacing.SOUTH;
            }
            BlockPos blockpos = p_i48740_2_;
            while (p_i48740_2_.func_177956_o() > blockpos.func_177956_o() - 21 && p_i48740_2_.func_177956_o() > 0 && this.func_196900_a(p_i48740_1_.func_180495_p(p_i48740_2_.func_177977_b()))) {
                p_i48740_2_ = p_i48740_2_.func_177977_b();
            }
            int i = this.func_180120_a(p_i48740_2_, this.field_150863_d) - 1;
            if (i >= 0) {
                this.field_150861_f = p_i48740_2_.func_177967_a(this.field_150863_d, i);
                this.field_150868_h = this.func_180120_a(this.field_150861_f, this.field_150866_c);
                if (this.field_150868_h < 2 || this.field_150868_h > 21) {
                    this.field_150861_f = null;
                    this.field_150868_h = 0;
                }
            }
            if (this.field_150861_f != null) {
                this.field_150862_g = this.func_150858_a();
            }
        }

        protected int func_180120_a(BlockPos p_180120_1_, EnumFacing p_180120_2_) {
            BlockPos blockpos;
            int i;
            for (i = 0; i < 22 && this.func_196900_a(this.field_150867_a.func_180495_p(blockpos = p_180120_1_.func_177967_a(p_180120_2_, i))) && this.field_150867_a.func_180495_p(blockpos.func_177977_b()).func_177230_c() == Blocks.field_150343_Z; ++i) {
            }
            Block block = this.field_150867_a.func_180495_p(p_180120_1_.func_177967_a(p_180120_2_, i)).func_177230_c();
            return block == Blocks.field_150343_Z ? i : 0;
        }

        public int func_181100_a() {
            return this.field_150862_g;
        }

        public int func_181101_b() {
            return this.field_150868_h;
        }

        protected int func_150858_a() {
            this.field_150862_g = 0;
            block0: while (this.field_150862_g < 21) {
                for (int i = 0; i < this.field_150868_h; ++i) {
                    BlockPos blockpos = this.field_150861_f.func_177967_a(this.field_150866_c, i).func_177981_b(this.field_150862_g);
                    IBlockState iblockstate = this.field_150867_a.func_180495_p(blockpos);
                    if (!this.func_196900_a(iblockstate)) break block0;
                    Block block = iblockstate.func_177230_c();
                    if (block == Blocks.field_150427_aO) {
                        ++this.field_150864_e;
                    }
                    if (i == 0 ? (block = this.field_150867_a.func_180495_p(blockpos.func_177972_a(this.field_150863_d)).func_177230_c()) != Blocks.field_150343_Z : i == this.field_150868_h - 1 && (block = this.field_150867_a.func_180495_p(blockpos.func_177972_a(this.field_150866_c)).func_177230_c()) != Blocks.field_150343_Z) break block0;
                }
                ++this.field_150862_g;
            }
            for (int j = 0; j < this.field_150868_h; ++j) {
                if (this.field_150867_a.func_180495_p(this.field_150861_f.func_177967_a(this.field_150866_c, j).func_177981_b(this.field_150862_g)).func_177230_c() == Blocks.field_150343_Z) continue;
                this.field_150862_g = 0;
                break;
            }
            if (this.field_150862_g <= 21 && this.field_150862_g >= 3) {
                return this.field_150862_g;
            }
            this.field_150861_f = null;
            this.field_150868_h = 0;
            this.field_150862_g = 0;
            return 0;
        }

        protected boolean func_196900_a(IBlockState p_196900_1_) {
            Block block = p_196900_1_.func_177230_c();
            return p_196900_1_.func_196958_f() || block == Blocks.field_150480_ab || block == Blocks.field_150427_aO;
        }

        public boolean func_150860_b() {
            return this.field_150861_f != null && this.field_150868_h >= 2 && this.field_150868_h <= 21 && this.field_150862_g >= 3 && this.field_150862_g <= 21;
        }

        public void func_150859_c() {
            for (int i = 0; i < this.field_150868_h; ++i) {
                BlockPos blockpos = this.field_150861_f.func_177967_a(this.field_150866_c, i);
                for (int j = 0; j < this.field_150862_g; ++j) {
                    this.field_150867_a.func_180501_a(blockpos.func_177981_b(j), (IBlockState)Blocks.field_150427_aO.func_176223_P().func_206870_a((IProperty)field_176550_a, (Comparable)((Object)this.field_150865_b)), 18);
                }
            }
        }

        private boolean func_196899_f() {
            return this.field_150864_e >= this.field_150868_h * this.field_150862_g;
        }

        public boolean func_208508_f() {
            return this.func_150860_b() && this.func_196899_f();
        }
    }
}

