/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class BlockRedstoneDiode
extends BlockHorizontal {
    protected static final VoxelShape field_196347_b = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 2.0, 16.0);
    public static final BooleanProperty field_196348_c = BlockStateProperties.field_208194_u;

    protected BlockRedstoneDiode(Block.Properties builder) {
        super(builder);
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return field_196347_b;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_196260_a(IBlockState state, IWorldReaderBase worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_185896_q() || worldIn.func_180495_p(pos.func_177977_b()).func_193401_d((IBlockReader)worldIn, pos.func_177977_b(), EnumFacing.UP) == BlockFaceShape.SOLID;
    }

    public void func_196267_b(IBlockState state, World worldIn, BlockPos pos, Random random) {
        if (!this.func_176405_b(worldIn, pos, state)) {
            boolean flag = (Boolean)state.func_177229_b((IProperty)field_196348_c);
            boolean flag1 = this.func_176404_e(worldIn, pos, state);
            if (flag && !flag1) {
                worldIn.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)field_196348_c, Boolean.valueOf(false)), 2);
            } else if (!flag) {
                worldIn.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)field_196348_c, Boolean.valueOf(true)), 2);
                if (!flag1) {
                    worldIn.func_205220_G_().func_205362_a(pos, (Object)this, this.func_196346_i(state), TickPriority.HIGH);
                }
            }
        }
    }

    public int func_176211_b(IBlockState blockState, IBlockReader blockAccess, BlockPos pos, EnumFacing side) {
        return blockState.func_185911_a(blockAccess, pos, side);
    }

    public int func_180656_a(IBlockState blockState, IBlockReader blockAccess, BlockPos pos, EnumFacing side) {
        if (!((Boolean)blockState.func_177229_b((IProperty)field_196348_c)).booleanValue()) {
            return 0;
        }
        return blockState.func_177229_b((IProperty)field_185512_D) == side ? this.func_176408_a(blockAccess, pos, blockState) : 0;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (state.func_196955_c(worldIn, pos)) {
            this.func_176398_g(worldIn, pos, state);
        } else {
            state.func_196949_c(worldIn, pos, 0);
            worldIn.func_175698_g(pos);
            for (EnumFacing enumfacing : EnumFacing.values()) {
                worldIn.func_195593_d(pos.func_177972_a(enumfacing), (Block)((Object)this));
            }
        }
    }

    protected void func_176398_g(World worldIn, BlockPos pos, IBlockState state) {
        boolean flag1;
        boolean flag;
        if (!this.func_176405_b(worldIn, pos, state) && (flag = ((Boolean)state.func_177229_b((IProperty)field_196348_c)).booleanValue()) != (flag1 = this.func_176404_e(worldIn, pos, state)) && !worldIn.func_205220_G_().func_205361_b(pos, (Object)this)) {
            TickPriority tickpriority = TickPriority.HIGH;
            if (this.func_176402_i((IBlockReader)worldIn, pos, state)) {
                tickpriority = TickPriority.EXTREMELY_HIGH;
            } else if (flag) {
                tickpriority = TickPriority.VERY_HIGH;
            }
            worldIn.func_205220_G_().func_205362_a(pos, (Object)this, this.func_196346_i(state), tickpriority);
        }
    }

    public boolean func_176405_b(IWorldReaderBase worldIn, BlockPos pos, IBlockState state) {
        return false;
    }

    protected boolean func_176404_e(World worldIn, BlockPos pos, IBlockState state) {
        return this.func_176397_f(worldIn, pos, state) > 0;
    }

    protected int func_176397_f(World worldIn, BlockPos pos, IBlockState state) {
        EnumFacing enumfacing = (EnumFacing)((Object)state.func_177229_b((IProperty)field_185512_D));
        BlockPos blockpos = pos.func_177972_a(enumfacing);
        int i = worldIn.func_175651_c(blockpos, enumfacing);
        if (i >= 15) {
            return i;
        }
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        return Math.max(i, iblockstate.func_177230_c() == Blocks.field_150488_af ? (Integer)iblockstate.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O) : 0);
    }

    protected int func_176407_c(IWorldReaderBase worldIn, BlockPos pos, IBlockState state) {
        EnumFacing enumfacing = (EnumFacing)((Object)state.func_177229_b((IProperty)field_185512_D));
        EnumFacing enumfacing1 = enumfacing.func_176746_e();
        EnumFacing enumfacing2 = enumfacing.func_176735_f();
        return Math.max(this.func_176401_c(worldIn, pos.func_177972_a(enumfacing1), enumfacing1), this.func_176401_c(worldIn, pos.func_177972_a(enumfacing2), enumfacing2));
    }

    protected int func_176401_c(IWorldReaderBase worldIn, BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (this.func_185545_A(iblockstate)) {
            if (block == Blocks.field_150451_bX) {
                return 15;
            }
            return block == Blocks.field_150488_af ? ((Integer)iblockstate.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O)).intValue() : worldIn.func_175627_a(pos, side);
        }
        return 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public IBlockState func_196258_a(BlockItemUseContext context) {
        return (IBlockState)this.func_176223_P().func_206870_a((IProperty)field_185512_D, (Comparable)((Object)context.func_195992_f().func_176734_d()));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (this.func_176404_e(worldIn, pos, state)) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 1);
        }
    }

    public void func_196259_b(IBlockState state, World worldIn, BlockPos pos, IBlockState oldState) {
        this.func_176400_h(worldIn, pos, state);
    }

    public void func_196243_a(IBlockState state, World worldIn, BlockPos pos, IBlockState newState, boolean isMoving) {
        if (!isMoving && state.func_177230_c() != newState.func_177230_c()) {
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
            this.func_211326_a(worldIn, pos);
            this.func_176400_h(worldIn, pos, state);
        }
    }

    protected void func_211326_a(World p_211326_1_, BlockPos p_211326_2_) {
    }

    protected void func_176400_h(World worldIn, BlockPos pos, IBlockState state) {
        EnumFacing enumfacing = (EnumFacing)((Object)state.func_177229_b((IProperty)field_185512_D));
        BlockPos blockpos = pos.func_177972_a(enumfacing.func_176734_d());
        if (ForgeEventFactory.onNeighborNotify((World)worldIn, (BlockPos)pos, (IBlockState)worldIn.func_180495_p(pos), EnumSet.of(enumfacing.func_176734_d()), (boolean)false).isCanceled()) {
            return;
        }
        worldIn.func_190524_a(blockpos, (Block)((Object)this), pos);
        worldIn.func_175695_a(blockpos, (Block)((Object)this), enumfacing);
    }

    protected boolean func_185545_A(IBlockState state) {
        return state.func_185897_m();
    }

    protected int func_176408_a(IBlockReader worldIn, BlockPos pos, IBlockState state) {
        return 15;
    }

    public static boolean func_185546_B(IBlockState state) {
        return state.func_177230_c() instanceof BlockRedstoneDiode;
    }

    public boolean func_176402_i(IBlockReader worldIn, BlockPos pos, IBlockState state) {
        EnumFacing enumfacing = ((EnumFacing)((Object)state.func_177229_b((IProperty)field_185512_D))).func_176734_d();
        IBlockState iblockstate = worldIn.func_180495_p(pos.func_177972_a(enumfacing));
        return BlockRedstoneDiode.func_185546_B(iblockstate) && iblockstate.func_177229_b((IProperty)field_185512_D) != enumfacing;
    }

    protected abstract int func_196346_i(IBlockState var1);

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_200124_e(IBlockState state) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }
}

