/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiControls;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ArrayUtils;

@OnlyIn(value=Dist.CLIENT)
public class GuiKeyBindingList
extends GuiListExtended<Entry> {
    private final GuiControls field_148191_k;
    private final Minecraft field_148189_l;
    private int field_148188_n;

    public GuiKeyBindingList(GuiControls controls, Minecraft mcIn) {
        super(mcIn, controls.field_146294_l + 45, controls.field_146295_m, 63, controls.field_146295_m - 32, 20);
        this.field_148191_k = controls;
        this.field_148189_l = mcIn;
        KeyBinding[] akeybinding = (KeyBinding[])ArrayUtils.clone((Object[])mcIn.field_71474_y.field_74324_K);
        Arrays.sort(akeybinding);
        String s = null;
        for (KeyBinding keybinding : akeybinding) {
            int i;
            String s1 = keybinding.func_151466_e();
            if (!s1.equals(s)) {
                s = s1;
                this.func_195085_a(new CategoryEntry(s1));
            }
            if ((i = mcIn.field_71466_p.func_78256_a(I18n.func_135052_a(keybinding.func_151464_g(), new Object[0]))) > this.field_148188_n) {
                this.field_148188_n = i;
            }
            this.func_195085_a(new KeyEntry(keybinding));
        }
    }

    protected int func_148137_d() {
        return super.func_148137_d() + 35;
    }

    public int func_148139_c() {
        return super.func_148139_c() + 32;
    }

    @OnlyIn(value=Dist.CLIENT)
    public class KeyEntry
    extends Entry {
        private final KeyBinding field_148282_b;
        private final String field_148283_c;
        private final GuiButton field_148280_d;
        private final GuiButton field_148281_e;

        private KeyEntry(final KeyBinding name) {
            this.field_148282_b = name;
            this.field_148283_c = I18n.func_135052_a(name.func_151464_g(), new Object[0]);
            this.field_148280_d = new GuiButton(0, 0, 0, 95, 20, I18n.func_135052_a(name.func_197978_k(), new Object[0])){

                @Override
                public void func_194829_a(double mouseX, double mouseY) {
                    ((GuiKeyBindingList)GuiKeyBindingList.this).field_148191_k.field_146491_f = name;
                }
            };
            this.field_148281_e = new GuiButton(0, 0, 0, 50, 20, I18n.func_135052_a("controls.reset", new Object[0])){

                @Override
                public void func_194829_a(double mouseX, double mouseY) {
                    KeyEntry.this.field_148282_b.setToDefault();
                    ((GuiKeyBindingList)GuiKeyBindingList.this).field_148189_l.field_71474_y.func_198014_a(name, name.func_197977_i());
                    KeyBinding.func_74508_b();
                }
            };
        }

        public void func_194999_a(int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
            int i = this.func_195001_c();
            int j = this.func_195002_d();
            boolean flag = ((GuiKeyBindingList)GuiKeyBindingList.this).field_148191_k.field_146491_f == this.field_148282_b;
            ((GuiKeyBindingList)GuiKeyBindingList.this).field_148189_l.field_71466_p.func_211126_b(this.field_148283_c, (float)(j + 90 - GuiKeyBindingList.this.field_148188_n), (float)(i + entryHeight / 2 - ((GuiKeyBindingList)GuiKeyBindingList.this).field_148189_l.field_71466_p.field_78288_b / 2), 0xFFFFFF);
            this.field_148281_e.field_146128_h = j + 210;
            this.field_148281_e.field_146129_i = i;
            this.field_148281_e.field_146124_l = !this.field_148282_b.func_197985_l();
            this.field_148281_e.func_194828_a(mouseX, mouseY, partialTicks);
            this.field_148280_d.field_146128_h = j + 105;
            this.field_148280_d.field_146129_i = i;
            this.field_148280_d.field_146126_j = this.field_148282_b.func_197978_k();
            boolean flag1 = false;
            boolean keyCodeModifierConflict = true;
            if (!this.field_148282_b.func_197986_j()) {
                for (KeyBinding keybinding : ((GuiKeyBindingList)GuiKeyBindingList.this).field_148189_l.field_71474_y.field_74324_K) {
                    if (keybinding == this.field_148282_b || !this.field_148282_b.func_197983_b(keybinding)) continue;
                    flag1 = true;
                    keyCodeModifierConflict &= keybinding.hasKeyCodeModifierConflict(this.field_148282_b);
                }
            }
            if (flag) {
                this.field_148280_d.field_146126_j = TextFormatting.WHITE + "> " + TextFormatting.YELLOW + this.field_148280_d.field_146126_j + TextFormatting.WHITE + " <";
            } else if (flag1) {
                this.field_148280_d.field_146126_j = (keyCodeModifierConflict ? TextFormatting.GOLD : TextFormatting.RED) + this.field_148280_d.field_146126_j;
            }
            this.field_148280_d.func_194828_a(mouseX, mouseY, partialTicks);
        }

        public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            if (this.field_148280_d.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_)) {
                return true;
            }
            return this.field_148281_e.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        }

        public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
            return this.field_148280_d.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_) || this.field_148281_e.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Entry
    extends GuiListExtended.IGuiListEntry<Entry> {
    }

    @OnlyIn(value=Dist.CLIENT)
    public class CategoryEntry
    extends Entry {
        private final String field_148285_b;
        private final int field_148286_c;

        public CategoryEntry(String name) {
            this.field_148285_b = I18n.func_135052_a(name, new Object[0]);
            this.field_148286_c = ((GuiKeyBindingList)GuiKeyBindingList.this).field_148189_l.field_71466_p.func_78256_a(this.field_148285_b);
        }

        public void func_194999_a(int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
            ((GuiKeyBindingList)GuiKeyBindingList.this).field_148189_l.field_71466_p.func_211126_b(this.field_148285_b, (float)(((GuiKeyBindingList)GuiKeyBindingList.this).field_148189_l.field_71462_r.field_146294_l / 2 - this.field_148286_c / 2), (float)(this.func_195001_c() + entryHeight - ((GuiKeyBindingList)GuiKeyBindingList.this).field_148189_l.field_71466_p.field_78288_b - 1), 0xFFFFFF);
        }
    }
}

