/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiEventHandler;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.InputMappings;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public abstract class GuiScreen
extends GuiEventHandler
implements GuiYesNoCallback {
    private static final Logger field_175287_a = LogManager.getLogger();
    private static final Set<String> field_175284_f = Sets.newHashSet((Object[])new String[]{"http", "https"});
    protected final List<IGuiEventListener> field_195124_j = Lists.newArrayList();
    public Minecraft field_146297_k;
    protected ItemRenderer field_146296_j;
    public int field_146294_l;
    public int field_146295_m;
    protected final List<GuiButton> field_146292_n = Lists.newArrayList();
    protected final List<GuiLabel> field_146293_o = Lists.newArrayList();
    public boolean field_146291_p;
    protected FontRenderer field_146289_q;
    private URI field_175286_t;

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            this.field_146292_n.get(i).func_194828_a(mouseX, mouseY, partialTicks);
        }
        for (int j = 0; j < this.field_146293_o.size(); ++j) {
            this.field_146293_o.get(j).func_194997_a(mouseX, mouseY, partialTicks);
        }
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256 && this.func_195120_Y_()) {
            this.func_195122_V_();
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean func_195120_Y_() {
        return true;
    }

    public void func_195122_V_() {
        this.field_146297_k.func_147108_a(null);
    }

    protected <T extends GuiButton> T func_189646_b(T buttonIn) {
        this.field_146292_n.add(buttonIn);
        this.field_195124_j.add(buttonIn);
        return buttonIn;
    }

    protected void func_146285_a(ItemStack stack, int x, int y) {
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        GuiUtils.preItemToolTip((ItemStack)stack);
        this.drawHoveringText(this.func_191927_a(stack), x, y, font == null ? this.field_146289_q : font);
        GuiUtils.postItemToolTip();
    }

    public List<String> func_191927_a(ItemStack p_191927_1_) {
        List<ITextComponent> list = p_191927_1_.func_82840_a(this.field_146297_k.field_71439_g, (ITooltipFlag)(this.field_146297_k.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        ArrayList list1 = Lists.newArrayList();
        for (ITextComponent itextcomponent : list) {
            list1.add(itextcomponent.func_150254_d());
        }
        return list1;
    }

    public void func_146279_a(String text, int x, int y) {
        this.func_146283_a(Arrays.asList(text), x, y);
    }

    public void func_146283_a(List<String> textLines, int x, int y) {
        this.drawHoveringText(textLines, x, y, this.field_146289_q);
    }

    public void drawHoveringText(List<String> textLines, int x, int y, FontRenderer font) {
        GuiUtils.drawHoveringText(textLines, (int)x, (int)y, (int)this.field_146294_l, (int)this.field_146295_m, (int)-1, (FontRenderer)font);
    }

    protected void func_175272_a(ITextComponent component, int x, int y) {
        if (component != null && component.func_150256_b().func_150210_i() != null) {
            HoverEvent hoverevent = component.func_150256_b().func_150210_i();
            if (hoverevent.func_150701_a() == HoverEvent.Action.SHOW_ITEM) {
                ItemStack itemstack = ItemStack.field_190927_a;
                try {
                    NBTTagCompound inbtbase = JsonToNBT.func_180713_a((String)hoverevent.func_150702_b().getString());
                    if (inbtbase instanceof NBTTagCompound) {
                        itemstack = ItemStack.func_199557_a(inbtbase);
                    }
                }
                catch (CommandSyntaxException inbtbase) {
                    // empty catch block
                }
                if (itemstack.func_190926_b()) {
                    this.func_146279_a(TextFormatting.RED + "Invalid Item!", x, y);
                } else {
                    this.func_146285_a(itemstack, x, y);
                }
            } else if (hoverevent.func_150701_a() == HoverEvent.Action.SHOW_ENTITY) {
                if (this.field_146297_k.field_71474_y.field_82882_x) {
                    try {
                        NBTTagCompound nbttagcompound = JsonToNBT.func_180713_a((String)hoverevent.func_150702_b().getString());
                        ArrayList list = Lists.newArrayList();
                        ITextComponent itextcomponent = ITextComponent.Serializer.func_150699_a((String)nbttagcompound.func_74779_i("name"));
                        if (itextcomponent != null) {
                            list.add(itextcomponent.func_150254_d());
                        }
                        if (nbttagcompound.func_150297_b("type", 8)) {
                            String s = nbttagcompound.func_74779_i("type");
                            list.add("Type: " + s);
                        }
                        list.add(nbttagcompound.func_74779_i("id"));
                        this.func_146283_a(list, x, y);
                    }
                    catch (JsonSyntaxException | CommandSyntaxException var9) {
                        this.func_146279_a(TextFormatting.RED + "Invalid Entity!", x, y);
                    }
                }
            } else if (hoverevent.func_150701_a() == HoverEvent.Action.SHOW_TEXT) {
                this.func_146283_a(this.field_146297_k.field_71466_p.func_78271_c(hoverevent.func_150702_b().func_150254_d(), Math.max(this.field_146294_l / 2, 200)), x, y);
            }
            GlStateManager.func_179140_f();
        }
    }

    protected void func_175274_a(String newChatText, boolean shouldOverwrite) {
    }

    public boolean func_175276_a(ITextComponent component) {
        if (component == null) {
            return false;
        }
        ClickEvent clickevent = component.func_150256_b().func_150235_h();
        if (GuiScreen.func_146272_n()) {
            if (component.func_150256_b().func_179986_j() != null) {
                this.func_175274_a(component.func_150256_b().func_179986_j(), false);
            }
        } else if (clickevent != null) {
            block19: {
                if (clickevent.func_150669_a() == ClickEvent.Action.OPEN_URL) {
                    if (!this.field_146297_k.field_71474_y.field_74359_p) {
                        return false;
                    }
                    try {
                        URI uri = new URI(clickevent.func_150668_b());
                        String s = uri.getScheme();
                        if (s == null) {
                            throw new URISyntaxException(clickevent.func_150668_b(), "Missing protocol");
                        }
                        if (!field_175284_f.contains(s.toLowerCase(Locale.ROOT))) {
                            throw new URISyntaxException(clickevent.func_150668_b(), "Unsupported protocol: " + s.toLowerCase(Locale.ROOT));
                        }
                        if (this.field_146297_k.field_71474_y.field_74358_q) {
                            this.field_175286_t = uri;
                            this.field_146297_k.func_147108_a((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)this, clickevent.func_150668_b(), 31102009, false));
                            break block19;
                        }
                        this.func_175282_a(uri);
                    }
                    catch (URISyntaxException urisyntaxexception) {
                        field_175287_a.error("Can't open url for {}", (Object)clickevent, (Object)urisyntaxexception);
                    }
                } else if (clickevent.func_150669_a() == ClickEvent.Action.OPEN_FILE) {
                    URI uri1 = new File(clickevent.func_150668_b()).toURI();
                    this.func_175282_a(uri1);
                } else if (clickevent.func_150669_a() == ClickEvent.Action.SUGGEST_COMMAND) {
                    this.func_175274_a(clickevent.func_150668_b(), true);
                } else if (clickevent.func_150669_a() == ClickEvent.Action.RUN_COMMAND) {
                    this.func_175281_b(clickevent.func_150668_b(), false);
                } else {
                    field_175287_a.error("Don't know how to handle {}", (Object)clickevent);
                }
            }
            return true;
        }
        return false;
    }

    public void func_175275_f(String msg) {
        this.func_175281_b(msg, true);
    }

    public void func_175281_b(String msg, boolean addToChat) {
        if ((msg = ForgeEventFactory.onClientSendMessage((String)msg)).isEmpty()) {
            return;
        }
        if (addToChat) {
            this.field_146297_k.field_71456_v.func_146158_b().func_146239_a(msg);
        }
        this.field_146297_k.field_71439_g.func_71165_d(msg);
    }

    public void func_146280_a(Minecraft mc, int width, int height) {
        this.field_146297_k = mc;
        this.field_146296_j = mc.func_175599_af();
        this.field_146289_q = mc.field_71466_p;
        this.field_146294_l = width;
        this.field_146295_m = height;
        Consumer<GuiButton> remove = b -> {
            this.field_146292_n.remove(b);
            this.field_195124_j.remove(b);
        };
        if (!MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.InitGuiEvent.Pre(this, this.field_146292_n, this::func_189646_b, remove))) {
            this.field_146292_n.clear();
            this.field_195124_j.clear();
            this.func_73866_w_();
        }
        MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.InitGuiEvent.Post(this, this.field_146292_n, this::func_189646_b, remove));
    }

    public List<? extends IGuiEventListener> func_195074_b() {
        return this.field_195124_j;
    }

    protected void func_73866_w_() {
        this.field_195124_j.addAll(this.field_146293_o);
    }

    public void func_73876_c() {
    }

    public void func_146281_b() {
    }

    public void func_146276_q_() {
        this.func_146270_b(0);
    }

    public void func_146270_b(int tint) {
        if (this.field_146297_k.field_71441_e != null) {
            this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, -1072689136, -804253680);
            MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.BackgroundDrawnEvent(this));
        } else {
            this.func_146278_c(tint);
        }
    }

    public void func_146278_c(int tint) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179106_n();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        this.field_146297_k.func_110434_K().func_110577_a(field_110325_k);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f = 32.0f;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b(0.0, this.field_146295_m, 0.0).func_187315_a(0.0, (float)this.field_146295_m / 32.0f + (float)tint).func_181669_b(64, 64, 64, 255).func_181675_d();
        bufferbuilder.func_181662_b(this.field_146294_l, this.field_146295_m, 0.0).func_187315_a((float)this.field_146294_l / 32.0f, (float)this.field_146295_m / 32.0f + (float)tint).func_181669_b(64, 64, 64, 255).func_181675_d();
        bufferbuilder.func_181662_b(this.field_146294_l, 0.0, 0.0).func_187315_a((float)this.field_146294_l / 32.0f, tint).func_181669_b(64, 64, 64, 255).func_181675_d();
        bufferbuilder.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, tint).func_181669_b(64, 64, 64, 255).func_181675_d();
        tessellator.func_78381_a();
        MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.BackgroundDrawnEvent(this));
    }

    public boolean func_73868_f() {
        return true;
    }

    public void confirmResult(boolean p_confirmResult_1_, int p_confirmResult_2_) {
        if (p_confirmResult_2_ == 31102009) {
            if (p_confirmResult_1_) {
                this.func_175282_a(this.field_175286_t);
            }
            this.field_175286_t = null;
            this.field_146297_k.func_147108_a(this);
        }
    }

    private void func_175282_a(URI url) {
        Util.func_110647_a().func_195642_a(url);
    }

    public static boolean func_146271_m() {
        if (Minecraft.field_142025_a) {
            return InputMappings.func_197956_a((int)343) || InputMappings.func_197956_a((int)347);
        }
        return InputMappings.func_197956_a((int)341) || InputMappings.func_197956_a((int)345);
    }

    public static boolean func_146272_n() {
        return InputMappings.func_197956_a((int)340) || InputMappings.func_197956_a((int)344);
    }

    public static boolean func_175283_s() {
        return InputMappings.func_197956_a((int)342) || InputMappings.func_197956_a((int)346);
    }

    public static boolean func_175277_d(int keyID) {
        return keyID == 88 && GuiScreen.func_146271_m() && !GuiScreen.func_146272_n() && !GuiScreen.func_175283_s();
    }

    public static boolean func_175279_e(int keyID) {
        return keyID == 86 && GuiScreen.func_146271_m() && !GuiScreen.func_146272_n() && !GuiScreen.func_175283_s();
    }

    public static boolean func_175280_f(int keyID) {
        return keyID == 67 && GuiScreen.func_146271_m() && !GuiScreen.func_146272_n() && !GuiScreen.func_175283_s();
    }

    public static boolean func_175278_g(int keyID) {
        return keyID == 65 && GuiScreen.func_146271_m() && !GuiScreen.func_146272_n() && !GuiScreen.func_175283_s();
    }

    public void func_175273_b(Minecraft mcIn, int w, int h) {
        this.func_146280_a(mcIn, w, h);
    }

    public static void func_195121_a(Runnable runnable, String description, String screenName) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, description);
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Affected screen");
            crashreportcategory.func_189529_a("Screen name", (ICrashReportDetail<String>)((ICrashReportDetail)() -> screenName));
            throw new ReportedException(crashreport);
        }
    }
}

