/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import net.minecraft.block.Block;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.block.BlockStructure;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.util.RecipeBookClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.ClickType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketClickWindow;
import net.minecraft.network.play.client.CPacketCreativeInventoryAction;
import net.minecraft.network.play.client.CPacketEnchantItem;
import net.minecraft.network.play.client.CPacketHeldItemChange;
import net.minecraft.network.play.client.CPacketPickItem;
import net.minecraft.network.play.client.CPacketPlaceRecipe;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.client.CPacketPlayerTryUseItem;
import net.minecraft.network.play.client.CPacketPlayerTryUseItemOnBlock;
import net.minecraft.network.play.client.CPacketUseEntity;
import net.minecraft.stats.StatisticsManager;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public class PlayerControllerMP {
    private final Minecraft field_78776_a;
    private final NetHandlerPlayClient field_78774_b;
    private BlockPos field_178895_c = new BlockPos(-1, -1, -1);
    private ItemStack field_85183_f = ItemStack.field_190927_a;
    private float field_78770_f;
    private float field_78780_h;
    private int field_78781_i;
    private boolean field_78778_j;
    private GameType field_78779_k = GameType.SURVIVAL;
    private int field_78777_l;

    public PlayerControllerMP(Minecraft mcIn, NetHandlerPlayClient netHandler) {
        this.field_78776_a = mcIn;
        this.field_78774_b = netHandler;
    }

    public static void func_178891_a(Minecraft mcIn, PlayerControllerMP playerController, BlockPos pos, EnumFacing facing) {
        if (!mcIn.field_71441_e.func_175719_a(mcIn.field_71439_g, pos, facing)) {
            playerController.func_187103_a(pos);
        }
    }

    public void func_78748_a(EntityPlayer player) {
        this.field_78779_k.func_77147_a(player.field_71075_bZ);
    }

    public void func_78746_a(GameType type) {
        this.field_78779_k = type;
        this.field_78779_k.func_77147_a(this.field_78776_a.field_71439_g.field_71075_bZ);
    }

    public void func_78745_b(EntityPlayer playerIn) {
        playerIn.field_70177_z = -180.0f;
    }

    public boolean func_78755_b() {
        return this.field_78779_k.func_77144_e();
    }

    public boolean func_187103_a(BlockPos pos) {
        boolean flag;
        if (this.field_78779_k.func_82752_c()) {
            if (this.field_78779_k == GameType.SPECTATOR) {
                return false;
            }
            if (!this.field_78776_a.field_71439_g.func_175142_cm()) {
                ItemStack itemstack = this.field_78776_a.field_71439_g.func_184614_ca();
                if (itemstack.func_190926_b()) {
                    return false;
                }
                BlockWorldState blockworldstate = new BlockWorldState((IWorldReaderBase)this.field_78776_a.field_71441_e, pos, false);
                if (!itemstack.func_206848_a(this.field_78776_a.field_71441_e.func_205772_D(), blockworldstate)) {
                    return false;
                }
            }
        }
        if (this.field_78776_a.field_71439_g.func_184614_ca().onBlockStartBreak(pos, this.field_78776_a.field_71439_g)) {
            return false;
        }
        WorldClient world = this.field_78776_a.field_71441_e;
        IBlockState iblockstate = world.func_180495_p(pos);
        if (!this.field_78776_a.field_71439_g.func_184614_ca().func_77973_b().func_195938_a(iblockstate, world, pos, this.field_78776_a.field_71439_g)) {
            return false;
        }
        Block block = iblockstate.func_177230_c();
        if ((block instanceof BlockCommandBlock || block instanceof BlockStructure) && !this.field_78776_a.field_71439_g.func_195070_dx()) {
            return false;
        }
        if (iblockstate.func_196958_f()) {
            return false;
        }
        IFluidState ifluidstate = world.func_204610_c(pos);
        this.field_178895_c = new BlockPos(this.field_178895_c.func_177958_n(), -1, this.field_178895_c.func_177952_p());
        if (!this.field_78779_k.func_77145_d()) {
            ItemStack itemstack1 = this.field_78776_a.field_71439_g.func_184614_ca();
            ItemStack copyBeforeUse = itemstack1.func_77946_l();
            if (!itemstack1.func_190926_b()) {
                itemstack1.func_179548_a(world, iblockstate, pos, this.field_78776_a.field_71439_g);
                if (itemstack1.func_190926_b()) {
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)this.field_78776_a.field_71439_g, (ItemStack)copyBeforeUse, (EnumHand)EnumHand.MAIN_HAND);
                    this.field_78776_a.field_71439_g.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                }
            }
        }
        if (flag = iblockstate.removedByPlayer(world, pos, this.field_78776_a.field_71439_g, false, ifluidstate)) {
            block.func_176206_d(world, pos, iblockstate);
        }
        return flag;
    }

    public boolean func_180511_b(BlockPos loc, EnumFacing face) {
        if (this.field_78779_k.func_82752_c()) {
            if (this.field_78779_k == GameType.SPECTATOR) {
                return false;
            }
            if (!this.field_78776_a.field_71439_g.func_175142_cm()) {
                ItemStack itemstack = this.field_78776_a.field_71439_g.func_184614_ca();
                if (itemstack.func_190926_b()) {
                    return false;
                }
                BlockWorldState blockworldstate = new BlockWorldState((IWorldReaderBase)this.field_78776_a.field_71441_e, loc, false);
                if (!itemstack.func_206848_a(this.field_78776_a.field_71441_e.func_205772_D(), blockworldstate)) {
                    return false;
                }
            }
        }
        if (!this.field_78776_a.field_71441_e.func_175723_af().func_177746_a(loc)) {
            return false;
        }
        if (this.field_78779_k.func_77145_d()) {
            this.field_78776_a.func_193032_ao().func_193294_a(this.field_78776_a.field_71441_e, loc, this.field_78776_a.field_71441_e.func_180495_p(loc), 1.0f);
            this.field_78774_b.func_147297_a((Packet<?>)new CPacketPlayerDigging(CPacketPlayerDigging.Action.START_DESTROY_BLOCK, loc, face));
            if (!ForgeHooks.onLeftClickBlock((EntityPlayer)this.field_78776_a.field_71439_g, (BlockPos)loc, (EnumFacing)face, (Vec3d)ForgeHooks.rayTraceEyeHitVec((EntityLivingBase)this.field_78776_a.field_71439_g, (double)(this.func_78757_d() + 1.0f))).isCanceled()) {
                PlayerControllerMP.func_178891_a(this.field_78776_a, this, loc, face);
            }
            this.field_78781_i = 5;
        } else if (!this.field_78778_j || !this.func_178893_a(loc)) {
            boolean flag;
            if (this.field_78778_j) {
                this.field_78774_b.func_147297_a((Packet<?>)new CPacketPlayerDigging(CPacketPlayerDigging.Action.ABORT_DESTROY_BLOCK, this.field_178895_c, face));
            }
            PlayerInteractEvent.LeftClickBlock event = ForgeHooks.onLeftClickBlock((EntityPlayer)this.field_78776_a.field_71439_g, (BlockPos)loc, (EnumFacing)face, (Vec3d)ForgeHooks.rayTraceEyeHitVec((EntityLivingBase)this.field_78776_a.field_71439_g, (double)(this.func_78757_d() + 1.0f)));
            IBlockState iblockstate = this.field_78776_a.field_71441_e.func_180495_p(loc);
            this.field_78776_a.func_193032_ao().func_193294_a(this.field_78776_a.field_71441_e, loc, iblockstate, 0.0f);
            this.field_78774_b.func_147297_a((Packet<?>)new CPacketPlayerDigging(CPacketPlayerDigging.Action.START_DESTROY_BLOCK, loc, face));
            boolean bl = flag = !iblockstate.func_196958_f();
            if (flag && this.field_78770_f == 0.0f && event.getUseBlock() != Event.Result.DENY) {
                iblockstate.func_196942_a(this.field_78776_a.field_71441_e, loc, this.field_78776_a.field_71439_g);
            }
            if (event.getUseItem() == Event.Result.DENY) {
                return true;
            }
            if (flag && iblockstate.func_185903_a(this.field_78776_a.field_71439_g, (IBlockReader)this.field_78776_a.field_71439_g.field_70170_p, loc) >= 1.0f) {
                this.func_187103_a(loc);
            } else {
                this.field_78778_j = true;
                this.field_178895_c = loc;
                this.field_85183_f = this.field_78776_a.field_71439_g.func_184614_ca();
                this.field_78770_f = 0.0f;
                this.field_78780_h = 0.0f;
                this.field_78776_a.field_71441_e.func_175715_c(this.field_78776_a.field_71439_g.func_145782_y(), this.field_178895_c, (int)(this.field_78770_f * 10.0f) - 1);
            }
        }
        return true;
    }

    public void func_78767_c() {
        if (this.field_78778_j) {
            this.field_78776_a.func_193032_ao().func_193294_a(this.field_78776_a.field_71441_e, this.field_178895_c, this.field_78776_a.field_71441_e.func_180495_p(this.field_178895_c), -1.0f);
            this.field_78774_b.func_147297_a((Packet<?>)new CPacketPlayerDigging(CPacketPlayerDigging.Action.ABORT_DESTROY_BLOCK, this.field_178895_c, EnumFacing.DOWN));
            this.field_78778_j = false;
            this.field_78770_f = 0.0f;
            this.field_78776_a.field_71441_e.func_175715_c(this.field_78776_a.field_71439_g.func_145782_y(), this.field_178895_c, -1);
            this.field_78776_a.field_71439_g.func_184821_cY();
        }
    }

    public boolean func_180512_c(BlockPos posBlock, EnumFacing directionFacing) {
        this.func_78750_j();
        if (this.field_78781_i > 0) {
            --this.field_78781_i;
            return true;
        }
        if (this.field_78779_k.func_77145_d() && this.field_78776_a.field_71441_e.func_175723_af().func_177746_a(posBlock)) {
            this.field_78781_i = 5;
            this.field_78776_a.func_193032_ao().func_193294_a(this.field_78776_a.field_71441_e, posBlock, this.field_78776_a.field_71441_e.func_180495_p(posBlock), 1.0f);
            this.field_78774_b.func_147297_a((Packet<?>)new CPacketPlayerDigging(CPacketPlayerDigging.Action.START_DESTROY_BLOCK, posBlock, directionFacing));
            PlayerControllerMP.func_178891_a(this.field_78776_a, this, posBlock, directionFacing);
            return true;
        }
        if (this.func_178893_a(posBlock)) {
            IBlockState iblockstate = this.field_78776_a.field_71441_e.func_180495_p(posBlock);
            Block block = iblockstate.func_177230_c();
            if (iblockstate.func_196958_f()) {
                this.field_78778_j = false;
                return false;
            }
            this.field_78770_f += iblockstate.func_185903_a(this.field_78776_a.field_71439_g, (IBlockReader)this.field_78776_a.field_71439_g.field_70170_p, posBlock);
            if (this.field_78780_h % 4.0f == 0.0f) {
                SoundType soundtype = iblockstate.getSoundType(this.field_78776_a.field_71441_e, posBlock, this.field_78776_a.field_71439_g);
                this.field_78776_a.func_147118_V().func_147682_a((ISound)new SimpleSound(soundtype.func_185846_f(), SoundCategory.NEUTRAL, (soundtype.func_185843_a() + 1.0f) / 8.0f, soundtype.func_185847_b() * 0.5f, posBlock));
            }
            this.field_78780_h += 1.0f;
            this.field_78776_a.func_193032_ao().func_193294_a(this.field_78776_a.field_71441_e, posBlock, iblockstate, MathHelper.func_76131_a((float)this.field_78770_f, (float)0.0f, (float)1.0f));
            if (this.field_78770_f >= 1.0f) {
                this.field_78778_j = false;
                this.field_78774_b.func_147297_a((Packet<?>)new CPacketPlayerDigging(CPacketPlayerDigging.Action.STOP_DESTROY_BLOCK, posBlock, directionFacing));
                this.func_187103_a(posBlock);
                this.field_78770_f = 0.0f;
                this.field_78780_h = 0.0f;
                this.field_78781_i = 5;
            }
            this.field_78776_a.field_71441_e.func_175715_c(this.field_78776_a.field_71439_g.func_145782_y(), this.field_178895_c, (int)(this.field_78770_f * 10.0f) - 1);
            return true;
        }
        return this.func_180511_b(posBlock, directionFacing);
    }

    public float func_78757_d() {
        float attrib = (float)this.field_78776_a.field_71439_g.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        return this.field_78779_k.func_77145_d() ? attrib : attrib - 0.5f;
    }

    public void func_78765_e() {
        this.func_78750_j();
        if (this.field_78774_b.func_147298_b().func_150724_d()) {
            this.field_78774_b.func_147298_b().func_74428_b();
        } else {
            this.field_78774_b.func_147298_b().func_179293_l();
        }
    }

    private boolean func_178893_a(BlockPos pos) {
        boolean flag;
        ItemStack itemstack = this.field_78776_a.field_71439_g.func_184614_ca();
        boolean bl = flag = this.field_85183_f.func_190926_b() && itemstack.func_190926_b();
        if (!this.field_85183_f.func_190926_b() && !itemstack.func_190926_b()) {
            flag = !this.field_85183_f.shouldCauseBlockBreakReset(itemstack);
        }
        return pos.equals((Object)this.field_178895_c) && flag;
    }

    private void func_78750_j() {
        int i = this.field_78776_a.field_71439_g.field_71071_by.field_70461_c;
        if (i != this.field_78777_l) {
            this.field_78777_l = i;
            this.field_78774_b.func_147297_a((Packet<?>)new CPacketHeldItemChange(this.field_78777_l));
        }
    }

    public EnumActionResult func_187099_a(EntityPlayerSP player, WorldClient worldIn, BlockPos pos, EnumFacing direction, Vec3d vec, EnumHand hand) {
        boolean flag1;
        this.func_78750_j();
        if (!this.field_78776_a.field_71441_e.func_175723_af().func_177746_a(pos)) {
            return EnumActionResult.FAIL;
        }
        ItemStack itemstack = player.func_184586_b(hand);
        float f = (float)(vec.field_72450_a - (double)pos.func_177958_n());
        float f1 = (float)(vec.field_72448_b - (double)pos.func_177956_o());
        float f2 = (float)(vec.field_72449_c - (double)pos.func_177952_p());
        PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((EntityPlayer)player, (EnumHand)hand, (BlockPos)pos, (EnumFacing)direction, (Vec3d)ForgeHooks.rayTraceEyeHitVec((EntityLivingBase)player, (double)(this.func_78757_d() + 1.0f)));
        if (event.isCanceled()) {
            this.field_78774_b.func_147297_a((Packet<?>)new CPacketPlayerTryUseItemOnBlock(pos, direction, hand, f, f1, f2));
            return event.getCancellationResult();
        }
        if (this.field_78779_k == GameType.SPECTATOR) {
            this.field_78774_b.func_147297_a((Packet<?>)new CPacketPlayerTryUseItemOnBlock(pos, direction, hand, f, f1, f2));
            return EnumActionResult.SUCCESS;
        }
        EnumActionResult ret = itemstack.onItemUseFirst(new ItemUseContext((EntityPlayer)player, player.func_184586_b(hand), pos, direction, f, f1, f2));
        if (ret != EnumActionResult.PASS) {
            this.field_78774_b.func_147297_a((Packet<?>)new CPacketPlayerTryUseItemOnBlock(pos, direction, hand, f, f1, f2));
            return ret;
        }
        boolean flag = !player.func_184614_ca().doesSneakBypassUse(worldIn, pos, player) || !player.func_184592_cb().doesSneakBypassUse(worldIn, pos, player);
        boolean bl = flag1 = player.func_70093_af() && flag;
        if ((!flag1 || event.getUseBlock() == Event.Result.ALLOW) && event.getUseBlock() != Event.Result.DENY && worldIn.func_180495_p(pos).func_196943_a(worldIn, pos, player, hand, direction, f, f1, f2)) {
            this.field_78774_b.func_147297_a((Packet<?>)new CPacketPlayerTryUseItemOnBlock(pos, direction, hand, f, f1, f2));
            return EnumActionResult.SUCCESS;
        }
        if (event.getUseItem() != Event.Result.DENY) {
            this.field_78774_b.func_147297_a((Packet<?>)new CPacketPlayerTryUseItemOnBlock(pos, direction, hand, f, f1, f2));
            if (!itemstack.func_190926_b() && !player.func_184811_cZ().func_185141_a(itemstack.func_77973_b())) {
                EnumActionResult enumactionresult;
                ItemUseContext itemusecontext = new ItemUseContext((EntityPlayer)player, player.func_184586_b(hand), pos, direction, f, f1, f2);
                if (this.field_78779_k.func_77145_d()) {
                    int i = itemstack.func_190916_E();
                    enumactionresult = itemstack.func_196084_a(itemusecontext);
                    itemstack.func_190920_e(i);
                } else {
                    ItemStack copyForUse = itemstack.func_77946_l();
                    enumactionresult = itemstack.func_196084_a(itemusecontext);
                    if (itemstack.func_190926_b()) {
                        ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)copyForUse, (EnumHand)hand);
                    }
                }
                return enumactionresult;
            }
            return EnumActionResult.PASS;
        }
        return EnumActionResult.PASS;
    }

    public EnumActionResult func_187101_a(EntityPlayer player, World worldIn, EnumHand hand) {
        if (this.field_78779_k == GameType.SPECTATOR) {
            return EnumActionResult.PASS;
        }
        this.func_78750_j();
        this.field_78774_b.func_147297_a((Packet<?>)new CPacketPlayerTryUseItem(hand));
        ItemStack itemstack = player.func_184586_b(hand);
        if (player.func_184811_cZ().func_185141_a(itemstack.func_77973_b())) {
            return EnumActionResult.PASS;
        }
        EnumActionResult cancelResult = ForgeHooks.onItemRightClick((EntityPlayer)player, (EnumHand)hand);
        if (cancelResult != null) {
            return cancelResult;
        }
        int i = itemstack.func_190916_E();
        ActionResult<ItemStack> actionresult = itemstack.func_77957_a(worldIn, player, hand);
        ItemStack itemstack1 = actionresult.func_188398_b();
        if (itemstack1 != itemstack || itemstack1.func_190916_E() != i) {
            player.func_184611_a(hand, itemstack1);
            if (itemstack1.func_190926_b()) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)itemstack, (EnumHand)hand);
            }
        }
        return actionresult.func_188397_a();
    }

    public EntityPlayerSP func_199681_a(World p_199681_1_, StatisticsManager p_199681_2_, RecipeBookClient p_199681_3_) {
        return new EntityPlayerSP(this.field_78776_a, p_199681_1_, this.field_78774_b, p_199681_2_, p_199681_3_);
    }

    public void func_78764_a(EntityPlayer playerIn, Entity targetEntity) {
        this.func_78750_j();
        this.field_78774_b.func_147297_a((Packet<?>)new CPacketUseEntity(targetEntity));
        if (this.field_78779_k != GameType.SPECTATOR) {
            playerIn.func_71059_n(targetEntity);
            playerIn.func_184821_cY();
        }
    }

    public EnumActionResult func_187097_a(EntityPlayer player, Entity target, EnumHand hand) {
        this.func_78750_j();
        this.field_78774_b.func_147297_a((Packet<?>)new CPacketUseEntity(target, hand));
        if (this.field_78779_k == GameType.SPECTATOR) {
            return EnumActionResult.PASS;
        }
        EnumActionResult cancelResult = ForgeHooks.onInteractEntity((EntityPlayer)player, (Entity)target, (EnumHand)hand);
        if (cancelResult != null) {
            return cancelResult;
        }
        return this.field_78779_k == GameType.SPECTATOR ? EnumActionResult.PASS : player.func_190775_a(target, hand);
    }

    public EnumActionResult func_187102_a(EntityPlayer player, Entity target, RayTraceResult ray, EnumHand hand) {
        this.func_78750_j();
        Vec3d vec3d = new Vec3d(ray.field_72307_f.field_72450_a - target.field_70165_t, ray.field_72307_f.field_72448_b - target.field_70163_u, ray.field_72307_f.field_72449_c - target.field_70161_v);
        this.field_78774_b.func_147297_a((Packet<?>)new CPacketUseEntity(target, hand, vec3d));
        if (this.field_78779_k == GameType.SPECTATOR) {
            return EnumActionResult.PASS;
        }
        EnumActionResult cancelResult = ForgeHooks.onInteractEntityAt((EntityPlayer)player, (Entity)target, (RayTraceResult)ray, (EnumHand)hand);
        if (cancelResult != null) {
            return cancelResult;
        }
        return this.field_78779_k == GameType.SPECTATOR ? EnumActionResult.PASS : target.func_184199_a(player, vec3d, hand);
    }

    public ItemStack func_187098_a(int windowId, int slotId, int mouseButton, ClickType type, EntityPlayer player) {
        short short1 = player.field_71070_bA.func_75136_a(player.field_71071_by);
        ItemStack itemstack = player.field_71070_bA.func_184996_a(slotId, mouseButton, type, player);
        this.field_78774_b.func_147297_a(new CPacketClickWindow(windowId, slotId, mouseButton, type, itemstack, short1));
        return itemstack;
    }

    public void func_203413_a(int p_203413_1_, IRecipe p_203413_2_, boolean p_203413_3_) {
        this.field_78774_b.func_147297_a((Packet<?>)new CPacketPlaceRecipe(p_203413_1_, p_203413_2_, p_203413_3_));
    }

    public void func_78756_a(int windowID, int button) {
        this.field_78774_b.func_147297_a((Packet<?>)new CPacketEnchantItem(windowID, button));
    }

    public void func_78761_a(ItemStack itemStackIn, int slotId) {
        if (this.field_78779_k.func_77145_d()) {
            this.field_78774_b.func_147297_a(new CPacketCreativeInventoryAction(slotId, itemStackIn));
        }
    }

    public void func_78752_a(ItemStack itemStackIn) {
        if (this.field_78779_k.func_77145_d() && !itemStackIn.func_190926_b()) {
            this.field_78774_b.func_147297_a(new CPacketCreativeInventoryAction(-1, itemStackIn));
        }
    }

    public void func_78766_c(EntityPlayer playerIn) {
        this.func_78750_j();
        this.field_78774_b.func_147297_a((Packet<?>)new CPacketPlayerDigging(CPacketPlayerDigging.Action.RELEASE_USE_ITEM, BlockPos.field_177992_a, EnumFacing.DOWN));
        playerIn.func_184597_cx();
    }

    public boolean func_78763_f() {
        return this.field_78779_k.func_77144_e();
    }

    public boolean func_78762_g() {
        return !this.field_78779_k.func_77145_d();
    }

    public boolean func_78758_h() {
        return this.field_78779_k.func_77145_d();
    }

    public boolean func_78749_i() {
        return this.field_78779_k.func_77145_d();
    }

    public boolean func_110738_j() {
        return this.field_78776_a.field_71439_g.func_184218_aH() && this.field_78776_a.field_71439_g.func_184187_bx() instanceof AbstractHorse;
    }

    public boolean func_178887_k() {
        return this.field_78779_k == GameType.SPECTATOR;
    }

    public GameType func_178889_l() {
        return this.field_78779_k;
    }

    public boolean func_181040_m() {
        return this.field_78778_j;
    }

    public void func_187100_a(int index) {
        this.field_78774_b.func_147297_a((Packet<?>)new CPacketPickItem(index));
    }
}

