/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.network;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.exceptions.InvalidCredentialsException;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiDisconnected;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenRealmsProxy;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.network.EnumConnectionState;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.login.INetHandlerLoginClient;
import net.minecraft.network.login.client.CPacketCustomPayloadLogin;
import net.minecraft.network.login.client.CPacketEncryptionResponse;
import net.minecraft.network.login.server.SPacketCustomPayloadLogin;
import net.minecraft.network.login.server.SPacketDisconnectLogin;
import net.minecraft.network.login.server.SPacketEnableCompression;
import net.minecraft.network.login.server.SPacketEncryptionRequest;
import net.minecraft.network.login.server.SPacketLoginSuccess;
import net.minecraft.realms.DisconnectedRealmsScreen;
import net.minecraft.util.CryptManager;
import net.minecraft.util.HttpUtil;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.ICustomPacket;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class NetHandlerLoginClient
implements INetHandlerLoginClient {
    private static final Logger field_147396_a = LogManager.getLogger();
    private final Minecraft field_147394_b;
    @Nullable
    private final GuiScreen field_147395_c;
    private final Consumer<ITextComponent> field_209525_d;
    private final NetworkManager field_147393_d;
    private GameProfile field_175091_e;

    public NetHandlerLoginClient(NetworkManager p_i49527_1_, Minecraft p_i49527_2_, @Nullable GuiScreen p_i49527_3_, Consumer<ITextComponent> p_i49527_4_) {
        this.field_147393_d = p_i49527_1_;
        this.field_147394_b = p_i49527_2_;
        this.field_147395_c = p_i49527_3_;
        this.field_209525_d = p_i49527_4_;
    }

    public void func_147389_a(SPacketEncryptionRequest packetIn) {
        SecretKey secretkey = CryptManager.func_75890_a();
        PublicKey publickey = packetIn.func_149608_d();
        String s = new BigInteger(CryptManager.func_75895_a((String)packetIn.func_149609_c(), (PublicKey)publickey, (SecretKey)secretkey)).toString(16);
        CPacketEncryptionResponse cpacketencryptionresponse = new CPacketEncryptionResponse(secretkey, publickey, packetIn.func_149607_e());
        this.field_209525_d.accept((ITextComponent)new TextComponentTranslation("connect.authorizing", new Object[0]));
        HttpUtil.field_180193_a.submit(() -> {
            ITextComponent itextcomponent = this.func_209522_a(s);
            if (itextcomponent != null) {
                if (this.field_147394_b.func_147104_D() == null || !this.field_147394_b.func_147104_D().func_181041_d()) {
                    this.field_147393_d.func_150718_a(itextcomponent);
                    return;
                }
                field_147396_a.warn(itextcomponent.getString());
            }
            this.field_209525_d.accept((ITextComponent)new TextComponentTranslation("connect.encrypting", new Object[0]));
            this.field_147393_d.func_201058_a((Packet<?>)cpacketencryptionresponse, (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)p_209523_2_ -> this.field_147393_d.func_150727_a(secretkey)));
        });
    }

    @Nullable
    private ITextComponent func_209522_a(String p_209522_1_) {
        try {
            this.func_147391_c().joinServer(this.field_147394_b.func_110432_I().func_148256_e(), this.field_147394_b.func_110432_I().func_148254_d(), p_209522_1_);
            return null;
        }
        catch (AuthenticationUnavailableException var3) {
            return new TextComponentTranslation("disconnect.loginFailedInfo", new Object[]{new TextComponentTranslation("disconnect.loginFailedInfo.serversUnavailable", new Object[0])});
        }
        catch (InvalidCredentialsException var4) {
            return new TextComponentTranslation("disconnect.loginFailedInfo", new Object[]{new TextComponentTranslation("disconnect.loginFailedInfo.invalidSession", new Object[0])});
        }
        catch (AuthenticationException authenticationexception) {
            return new TextComponentTranslation("disconnect.loginFailedInfo", authenticationexception.getMessage());
        }
    }

    private MinecraftSessionService func_147391_c() {
        return this.field_147394_b.func_152347_ac();
    }

    public void func_147390_a(SPacketLoginSuccess packetIn) {
        this.field_209525_d.accept((ITextComponent)new TextComponentTranslation("connect.joining", new Object[0]));
        this.field_175091_e = packetIn.func_179730_a();
        this.field_147393_d.func_150723_a(EnumConnectionState.PLAY);
        NetworkHooks.handleClientLoginSuccess((NetworkManager)this.field_147393_d);
        this.field_147393_d.func_150719_a((INetHandler)new NetHandlerPlayClient(this.field_147394_b, this.field_147395_c, this.field_147393_d, this.field_175091_e));
    }

    public void func_147231_a(ITextComponent reason) {
        if (this.field_147395_c != null && this.field_147395_c instanceof GuiScreenRealmsProxy) {
            this.field_147394_b.func_147108_a((GuiScreen)new DisconnectedRealmsScreen(((GuiScreenRealmsProxy)this.field_147395_c).func_154321_a(), "connect.failed", reason).getProxy());
        } else {
            this.field_147394_b.func_147108_a((GuiScreen)new GuiDisconnected(this.field_147395_c, "connect.failed", reason));
        }
    }

    public void func_147388_a(SPacketDisconnectLogin packetIn) {
        this.field_147393_d.func_150718_a(packetIn.func_149603_c());
    }

    public void func_180464_a(SPacketEnableCompression packetIn) {
        if (!this.field_147393_d.func_150731_c()) {
            this.field_147393_d.func_179289_a(packetIn.func_179731_a());
        }
    }

    public void func_209521_a(SPacketCustomPayloadLogin p_209521_1_) {
        if (NetworkHooks.onCustomPayload((ICustomPacket)p_209521_1_, (NetworkManager)this.field_147393_d)) {
            return;
        }
        this.field_209525_d.accept((ITextComponent)new TextComponentTranslation("connect.negotiating", new Object[0]));
        this.field_147393_d.func_179290_a(new CPacketCustomPayloadLogin(p_209521_1_.func_209918_a(), null));
    }
}

